/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.diskstore;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskStoreAttributes;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreImplProxy;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.ExportDiskRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.snapshot.GFSnapshot;
import com.gemstone.gemfire.internal.util.ArraySortedCollection;
import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerMember;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshot;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GFXDDiskStoreImpl
extends DiskStoreImplProxy {
    private String stringDelimiter = "\"";
    private List listOfStats = new ArrayList();

    GFXDDiskStoreImpl(Cache cache, String name, DiskStoreAttributes props, boolean ownedByRegion, InternalRegionArguments internalRegionArgs, boolean offline, boolean upgradeVersionOnly, boolean offlineValidating, boolean offlineCompacting, boolean needsOplogs) {
        super(cache, name, props, ownedByRegion, internalRegionArgs, offline, upgradeVersionOnly, offlineValidating, offlineCompacting, needsOplogs);
    }

    private static DiskStoreImpl createForOffline(String dsName, File[] dsDirs, boolean offlineCompacting, boolean offlineValidate, boolean upgradeVersionOnly, long maxOplogSize, boolean needsOplogs) throws Exception {
        if (dsDirs == null) {
            dsDirs = new File[]{new File("")};
        }
        Properties props = new Properties();
        props.setProperty("locators", "");
        props.setProperty("mcast-port", "0");
        props.setProperty("cache-xml-file", "");
        if (!TRACE_RECOVERY) {
            props.setProperty("log-level", "warning");
        }
        InternalDistributedSystem ds = GemFireCacheImpl.getInstance().getDistributedSystem();
        offlineDS = ds;
        GemFireCacheImpl c = GemFireCacheImpl.getInstance();
        offlineCache = c;
        DiskStoreFactory dsf = c.createDiskStoreFactory();
        dsf.setDiskDirs(dsDirs);
        if (offlineCompacting && maxOplogSize != -1L) {
            dsf.setMaxOplogSize(maxOplogSize);
        }
        GFXDDiskStoreImpl dsi = new GFXDDiskStoreImpl((Cache)c, dsName, ((DiskStoreFactoryImpl)dsf).getDiskStoreAttributes(), false, null, true, upgradeVersionOnly, offlineValidate, offlineCompacting, needsOplogs);
        c.addDiskStore((DiskStoreImpl)dsi);
        return dsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GFXDSnapshotExportStat> exportOfflineSnapshotXD(String dsName, File[] dsDirs, File out, boolean forceKRFRecovery, String stringDelimiter) throws Exception {
        try (GFXDDiskStoreImpl dsi = null;){
            dsi = (GFXDDiskStoreImpl)GFXDDiskStoreImpl.createForOfflineXD(dsName, dsDirs);
            dsi.setStringDelimiter(stringDelimiter);
            if (forceKRFRecovery) {
                dsi.exportSnapshotUsingKRF(dsName, out);
            } else {
                dsi.exportSnapshot(dsName, out, false);
            }
        }
        if (dsi != null) {
            return dsi.getListOfStats();
        }
        return new ArrayList<GFXDSnapshotExportStat>();
    }

    protected void exportSnapshotUsingKRF(String name, File out) throws IOException {
        this.setForceKRFRecovery(true);
        this.setDataExtractionKrfRecovery(true);
        for (DiskRegionView drv : this.getKnown()) {
            this.scheduleForRecovery((DiskRecoveryStore)((PlaceHolderDiskRegion)drv));
        }
        try {
            this.recoverRegionsThatAreReady(false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        HashMap<String, ArrayList<PlaceHolderDiskRegion>> regions = new HashMap<String, ArrayList<PlaceHolderDiskRegion>>();
        for (DiskRegionView diskRegionView : this.getKnown()) {
            PlaceHolderDiskRegion ph = (PlaceHolderDiskRegion)diskRegionView;
            String regionName = diskRegionView.isBucket() ? ph.getPrName() : diskRegionView.getName();
            ArrayList<PlaceHolderDiskRegion> views = (ArrayList<PlaceHolderDiskRegion>)regions.get(regionName);
            if (views == null) {
                views = new ArrayList<PlaceHolderDiskRegion>();
                regions.put(regionName, views);
            }
            views.add(ph);
        }
        for (Map.Entry entry : regions.entrySet()) {
            for (DiskRegionView drv : (List)entry.getValue()) {
                GFXDSnapshotExportStat stat = new GFXDSnapshotExportStat(drv);
                this.listOfStats.add(stat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportSnapshot(String name, File out, boolean coelesceBuckets) throws IOException {
        HashMap<String, GFSnapshot.SnapshotWriter> regions = new HashMap<String, GFSnapshot.SnapshotWriter>();
        try {
            for (DiskRegionView drv : this.getKnown()) {
                GFSnapshot.SnapshotWriter writer;
                String lookupName;
                boolean isHDFSQueue = false;
                PlaceHolderDiskRegion ph = (PlaceHolderDiskRegion)drv;
                String regionName = drv.isBucket() ? ph.getPrName() : drv.getName();
                String string = lookupName = drv.isBucket() ? regionName + drv.getName() : regionName;
                if (regionName.startsWith("/AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE") || regionName.contains("/AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE")) {
                    isHDFSQueue = true;
                }
                if (isHDFSQueue) {
                    lookupName = regionName = regionName.replaceAll("AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE", "GF_QUEUE");
                }
                if ((writer = (GFSnapshot.SnapshotWriter)regions.get(lookupName)) == null) {
                    RegionViewInfoPerMember regionInfoView;
                    File f = null;
                    String fname = lookupName.substring(1).replace('/', '-');
                    f = new File(out, "snapshot-" + name + "-" + fname);
                    writer = this.createGFSnapshotWriter(f, lookupName, regionInfoView = new RegionViewInfoPerMember(drv));
                    if (writer == null) {
                        if (!f.exists() || f.delete()) continue;
                        GemFireXDDataExtractorImpl.logInfo("Unable to delete unused file:" + f.getAbsolutePath());
                        continue;
                    }
                    regions.put(lookupName, writer);
                }
                final GFSnapshot.SnapshotWriter theWriter = writer;
                this.scheduleForRecovery((DiskRecoveryStore)new ExportDiskRegion((DiskStoreImpl)this, drv, new ExportDiskRegion.ExportWriter(){

                    public void writeBatch(Map<Object, DiskEntry.RecoveredEntry> entries) throws IOException {
                        for (Map.Entry<Object, DiskEntry.RecoveredEntry> re : entries.entrySet()) {
                            Object key = re.getKey();
                            Object value = re.getValue().getValue();
                            theWriter.snapshotEntry(key, value, re.getValue().getVersionTag(), re.getValue().getLastModifiedTime());
                        }
                    }
                }));
            }
            try {
                this.recoverRegionsThatAreReady(false);
            }
            catch (NullPointerException e) {
                StringBuffer buffer = new StringBuffer("Unable to recover the following tables, possibly due to a missing .drf file:\n");
                for (String regionName : regions.keySet()) {
                    buffer.append(regionName);
                    buffer.append("\n");
                }
                GemFireXDDataExtractorImpl.logSevere(buffer.toString());
            }
        }
        finally {
            for (GFSnapshot.SnapshotWriter writer : regions.values()) {
                try {
                    writer.snapshotComplete();
                }
                catch (IOException e) {
                    GemFireXDDataExtractorImpl.logSevere(e.getMessage());
                }
            }
        }
    }

    public static int getDiskStoreSizeInMB(String dsName, File[] dsDirs) throws Exception {
        int[] diskDirSizes;
        int size = 0;
        GFXDDiskStoreImpl dsi = (GFXDDiskStoreImpl)GFXDDiskStoreImpl.createForOfflineXD(dsName, dsDirs);
        for (int diskDirSize : diskDirSizes = dsi.getDiskDirSizes()) {
            size += diskDirSize;
        }
        return size;
    }

    private static DiskStoreImpl createForOfflineXD(String dsName, File[] dsDirs) throws Exception {
        return GFXDDiskStoreImpl.createForOffline(dsName, dsDirs, false, false, false, 0L, false);
    }

    protected GFSnapshot.SnapshotWriter createGFSnapshotWriter(File f, String regionName, RegionViewInfoPerMember regionViewInfo) throws IOException {
        return GFXDSnapshot.create(f, regionName, this.listOfStats, regionViewInfo, this.stringDelimiter);
    }

    public List<GFXDSnapshotExportStat> getListOfStats() {
        return this.listOfStats;
    }

    public void setStringDelimiter(String stringDelimiter) {
        this.stringDelimiter = stringDelimiter;
    }

    public static void closeDiskStoreFiles(DiskStoreImpl diskStore) {
        DiskStoreImplProxy.closeDiskStoreFiles((DiskStoreImpl)diskStore);
    }

    public static class DiskSavyIterator
    implements Iterator<DistributedRegion.DiskEntryPage> {
        ArraySortedCollection diskMap;
        Iterator<Object> iterator;
        Map<DiskRegionView, Integer> drvToIdMap = new HashMap<DiskRegionView, Integer>();
        Map<Integer, DiskRegionView> idToDrvMap = new HashMap<Integer, DiskRegionView>();

        private DiskSavyIterator() {
        }

        public DiskRegionView getDrv(int drvId) {
            return this.idToDrvMap.get(drvId);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DistributedRegion.DiskEntryPage next() {
            return (DistributedRegion.DiskEntryPage)this.iterator.next();
        }

        @Override
        public void remove() {
        }

        public void clear() {
            this.diskMap.clear();
            this.drvToIdMap.clear();
            this.idToDrvMap.clear();
        }

        public static DiskSavyIterator getDiskSavyIterator(Collection<DiskRegionView> regions) {
            int numEntries = 0;
            DiskSavyIterator diskSavyIterator = new DiskSavyIterator();
            int drvId = 0;
            for (DiskRegionView drv : regions) {
                int recoveredEntryCount = drv.getRecoveredEntryCount();
                if (recoveredEntryCount <= 0) continue;
                if (diskSavyIterator.drvToIdMap.get(drv) == null) {
                    diskSavyIterator.drvToIdMap.put(drv, ++drvId);
                    diskSavyIterator.idToDrvMap.put(new Integer(drvId), drv);
                }
                numEntries += recoveredEntryCount;
            }
            diskSavyIterator.diskMap = new ArraySortedCollection((Comparator)new DistributedRegion.DiskEntryPage.DEPComparator(), null, null, numEntries, 0L);
            Set<DiskRegionView> diskRegions = diskSavyIterator.drvToIdMap.keySet();
            for (DiskRegionView diskRegion : diskRegions) {
                Collection regionEntries = diskRegion.getRecoveredEntryMap().regionEntries();
                for (RegionEntry re : regionEntries) {
                    if (!(re instanceof DiskEntry)) continue;
                    DiskEntry de = (DiskEntry)re;
                    DistributedRegion.DiskPosition dp = new DistributedRegion.DiskPosition();
                    DiskId did = de.getDiskId();
                    dp.setPosition(did.getOplogId(), did.getOffsetInOplog());
                    diskSavyIterator.diskMap.add((Object)new DistributedRegion.DiskEntryPage(dp, re, null));
                }
                regionEntries.clear();
            }
            diskSavyIterator.iterator = diskSavyIterator.diskMap.iterator();
            return diskSavyIterator;
        }
    }
}

