/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Undoable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ContainerBasicOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ContainerOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ContainerUndoOperation
extends ContainerBasicOperation
implements Compensation {
    private transient ContainerOperation undoOp;

    public ContainerUndoOperation(RawContainerHandle hdl, ContainerOperation op) throws StandardException {
        super(hdl);
        this.undoOp = op;
    }

    public ContainerUndoOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public int getTypeFormatId() {
        return 107;
    }

    @Override
    public void setUndoOp(Undoable op) {
        SanityManager.ASSERT((boolean)(op instanceof ContainerOperation));
        this.undoOp = (ContainerOperation)op;
    }

    @Override
    public final void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        SanityManager.ASSERT((this.containerHdl != null ? 1 : 0) != 0, (String)"clr has null containerHdl");
        this.undoOp.undoMe(xact, this.containerHdl, instant, in);
        this.releaseResource(xact);
    }

    @Override
    public void releaseResource(Transaction xact) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(xact);
        }
        super.releaseResource(xact);
    }

    @Override
    public int group() {
        return super.group() | 4 | 0x100;
    }
}

