/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.RecordId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;

public class HeapRowLocation
extends DataType
implements RowLocation {
    private long pageno;
    private int recid;
    private RecordHandle rh;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(HeapRowLocation.class);
    private static final int RECORD_HANDLE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(RecordId.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.rh) {
            sz += RECORD_HANDLE_MEMORY_USAGE;
        }
        return sz;
    }

    @Override
    public String getTypeName() {
        return "RowLocation";
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) {
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new HeapRowLocation();
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public Object cloneObject() {
        return this.getClone();
    }

    @Override
    public DataValueDescriptor getClone() {
        return new HeapRowLocation(this);
    }

    @Override
    public DataValueDescriptor recycle() {
        this.pageno = 0L;
        this.recid = 0;
        this.rh = null;
        return this;
    }

    @Override
    public int getLength() {
        return 10;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) {
        int result = this.compare(other);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Unexpected operation");
        return false;
    }

    @Override
    public int compare(DataValueDescriptor other) {
        SanityManager.ASSERT((boolean)(other instanceof HeapRowLocation));
        HeapRowLocation arg = (HeapRowLocation)other;
        long myPage = this.pageno;
        long otherPage = arg.pageno;
        if (myPage < otherPage) {
            return -1;
        }
        if (myPage > otherPage) {
            return 1;
        }
        int myRecordId = this.recid;
        int otherRecordId = arg.recid;
        if (myRecordId == otherRecordId) {
            return 0;
        }
        if (myRecordId < otherRecordId) {
            return -1;
        }
        return 1;
    }

    HeapRowLocation(RecordHandle rh) {
        this.setFrom(rh);
    }

    public HeapRowLocation() {
        this.pageno = 0L;
        this.recid = 0;
    }

    private HeapRowLocation(HeapRowLocation other) {
        this.pageno = other.pageno;
        this.recid = other.recid;
        this.rh = other.rh;
    }

    public RecordHandle getRecordHandle(ContainerHandle ch) throws StandardException {
        if (this.rh != null) {
            return this.rh;
        }
        this.rh = ch.makeRecordHandle(this.pageno, this.recid);
        return this.rh;
    }

    void setFrom(RecordHandle rh) {
        this.pageno = rh.getPageNumber();
        this.recid = rh.getId();
        this.rh = rh;
    }

    @Override
    public int getTypeFormatId() {
        return 90;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.pageno);
        CompressedNumber.writeInt(out, this.recid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pageno = CompressedNumber.readLong(in);
        this.recid = CompressedNumber.readInt(in);
        this.rh = null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.pageno = in.readCompressedLong();
        this.recid = in.readCompressedInt();
        this.rh = null;
    }

    @Override
    public void restoreToNull() {
        SanityManager.THROWASSERT((String)"HeapRowLocation is never null");
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) {
        SanityManager.THROWASSERT((String)"SHOULD NOT BE CALLED");
    }

    @Override
    public boolean equals(Object ref) {
        if (ref instanceof HeapRowLocation) {
            HeapRowLocation other = (HeapRowLocation)ref;
            return this.pageno == other.pageno && this.recid == other.recid;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.pageno ^ this.recid;
    }

    public String toString() {
        String string = "(" + this.pageno + "," + this.recid + ")";
        return string;
    }

    @Override
    public int getBucketID() {
        throw new IllegalStateException("HeapRowLocation:getBucketID: method should not get invoked");
    }

    @Override
    public Object getKey() {
        throw new IllegalStateException("HeapRowLocation:getKey: method should not get invoked");
    }

    @Override
    public Object getKeyCopy() {
        throw new IllegalStateException("HeapRowLocation:getKeyCopy: method should not get invoked");
    }

    @Override
    public Object getRawKey() {
        throw new IllegalStateException("HeapRowLocation:getKey: method should not get invoked");
    }

    @Override
    public RegionEntry getRegionEntry() {
        throw new IllegalStateException("HeapRowLocation:getRegionEntry: method should not get invoked");
    }

    @Override
    public RegionEntry getUnderlyingRegionEntry() {
        throw new IllegalStateException("HeapRowLocation:getUnderlyingRegionEntry: method should not get invoked");
    }

    @Override
    public Object getValue(GemFireContainer baseContainer) {
        throw new IllegalStateException("HeapRowLocation:getValue: method should not get invoked");
    }

    @Override
    public Object getValueWithoutFaultIn(GemFireContainer baseContainer) {
        throw new IllegalStateException("HeapRowLocation:getValueWithoutFaultIn: method should not get invoked");
    }

    @Override
    public ExecRow getRow(GemFireContainer baseContainer) throws StandardException {
        throw new IllegalStateException("HeapRowLocation:getRow: method should not get invoked");
    }

    @Override
    public ExecRow getRowWithoutFaultIn(GemFireContainer baseContainer) throws StandardException {
        throw new IllegalStateException("HeapRowLocation:getRowWithoutFaultIn: method should not get invoked");
    }

    @Override
    public ExtraTableInfo getTableInfo(GemFireContainer baseContainer) {
        throw new IllegalStateException("HeapRowLocation#getTableInfo: method should not be invoked");
    }

    @Override
    public boolean isDestroyedOrRemoved() {
        throw new IllegalStateException("HeapRowLocation#isRemovedOrDestroyed: method should not be invoked");
    }

    @Override
    public boolean isUpdateInProgress() {
        throw new IllegalStateException("HeapRowLocation#isRemovedOrDestroyed: method should not be invoked");
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public TXId getTXId() {
        return null;
    }

    @Override
    public Object getValueWithoutFaultInOrOffHeapEntry(LocalRegion owner) {
        throw new IllegalStateException("HeapRowLocation:getValueWithoutFaultIn: method should not get invoked");
    }

    @Override
    public Object getValueOrOffHeapEntry(LocalRegion owner) {
        throw new IllegalStateException("HeapRowLocation:getValueWithoutFaultIn: method should not get invoked");
    }

    @Override
    public Object getRawValue() {
        throw new IllegalStateException("HeapRowLocation:getValueWithoutFaultIn: method should not get invoked");
    }

    @Override
    public void markDeleteFromIndexInProgress() {
    }

    @Override
    public void unmarkDeleteFromIndexInProgress() {
    }

    @Override
    public boolean useRowLocationForIndexKey() {
        return true;
    }

    @Override
    public void endIndexKeyUpdate() {
    }
}

