/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Hashtable;
import java.util.Properties;

public class TableScanResultSet
extends ScanResultSet
implements CursorResultSet,
Cloneable,
OffHeapResourceHolder {
    protected ScanController scanController;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo dcoci;
    protected StaticCompiledOpenConglomInfo scoci;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    public Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected int[] indexCols;
    public int rowsPerRead;
    private RowLocation rlTemplate;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    protected long rowsThisScan;
    private long estimatedRowCount;
    protected Hashtable past2FutureTbl;
    protected TemporaryRowHolder futureForUpdateRows;
    protected TemporaryRowHolderResultSet futureRowResultSet;
    protected ExecRow lastCursorKey;
    private ExecRow sparseRow;
    private FormatableBitSet sparseRowMap;
    protected final OHAddressCache ohAddressCache;
    protected final String regionName;
    public String nonQualPreds;
    protected static final byte MASK_SCAN_CONTROLLER_OPENED = 1;
    protected static final byte MASK_IS_KEYED = 2;
    protected static final byte MASK_FIRST_SCAN = 4;
    protected static final byte MASK_RUN_TIME_STATS_ON = 8;
    protected static final byte MASK_FOR_UPDATE = 16;
    protected static final byte MASK_SAME_START_STOP_POS = 32;
    protected static final byte MASK_NEXT_DONE = 64;
    protected static final short MASK_IS_CONSTRAINT = 128;
    protected static final short MASK_COARSER_LOCK = 256;
    protected static final short MASK_ONE_ROW_SCAN = 512;
    protected static final short MASK_SKIP_FUTURE_ROW_HOLDER = 1024;
    protected static final short MASK_SOURCE_DRAINED = 2048;
    protected static final short MASK_CURRENT_ROW_PRESCANNED = 4096;
    protected static final short MASK_COMPARE_TO_LAST_KEY = 8192;
    protected static final short MASK_QUALIFY = 16384;
    protected static final int MASK_CURRENT_ROW_IS_VALID = 32768;
    protected static final int MASK_SCAN_REPOSITIONED = 65536;
    protected int varflags = GemFireXDUtils.set(0, 4);
    protected final byte finalFlags;
    protected static final byte MASK_SUPPORTS_MOVE_TO_NEXT_KEY = 1;
    protected static final byte MASK_ADD_REGION_AND_KEY = 2;
    protected static final byte MASK_ADD_KEY_FOR_SELECT_FOR_UPDATE = 4;
    protected static final byte MASK_IS_REPLICATE = 8;
    protected static final byte MASK_DELAY_SCAN_OPENING = 16;
    protected static final byte MASK_OPTIMIZE_FOR_OFFHEAP = 32;
    protected static final byte MASK_INDEX_ACCESSES_BASE_TABLE = 64;
    protected static final byte MASK_HEAP_SCAN = -128;

    @Override
    public boolean isReplicateIfSetOpSupported() {
        return this.isReplicate();
    }

    TableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean delayScanOpening, boolean optimizeForOffHeap, boolean indexAccesesBaseTable, boolean supportsMoveToNextKey, String nonQualPreds) throws StandardException {
        this(conglomId, scoci, activation, (ExecRow)resultRowAllocator.invoke(activation), resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem != -1 ? (FormatableBitSet)activation.getSavedObject(colRefItem) : null, indexColItem, lockMode, tableLocked, isolationLevel, rowsPerRead, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost, delayScanOpening, optimizeForOffHeap, indexAccesesBaseTable, supportsMoveToNextKey, nonQualPreds);
    }

    TableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, ExecRow candidate, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, FormatableBitSet accessedCols, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean delayScanOpening, boolean optimizeForOffHeap, boolean indexAccesBaseTable, boolean supportsMoveToNextKey, String nonQualPreds) throws StandardException {
        super(activation, resultSetNumber, candidate, lockMode, tableLocked, isolationLevel, accessedCols, optimizerEstimatedRowCount, optimizerEstimatedCost);
        byte finalBoolFlags = 0;
        this.conglomId = conglomId;
        this.scoci = scoci;
        finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)16, delayScanOpening);
        finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)32, optimizeForOffHeap);
        finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)64, indexAccesBaseTable);
        if (((MemConglomerate)scoci).getType() == 0) {
            finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)-128);
        }
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"table scan must get activation context");
        SanityManager.ASSERT((resultRowAllocator != null ? 1 : 0) != 0, (String)"table scan must get row allocator");
        if (sameStartStopPosition) {
            SanityManager.ASSERT((stopKeyGetter == null ? 1 : 0) != 0, (String)"stopKeyGetter expected to be null when sameStartStopPosition is true");
        }
        this.resultRowAllocator = resultRowAllocator;
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.setFlag(32, sameStartStopPosition);
        this.qualifiers = qualifiers;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.setFlag(128, isConstraint);
        this.setFlag(16, forUpdate);
        this.rowsPerRead = rowsPerRead;
        this.setFlag(512, oneRowScan);
        if (indexColItem != -1) {
            this.indexCols = (int[])activation.getSavedObject(indexColItem);
        }
        if (this.indexCols != null) {
            activation.setForUpdateIndexScan(this);
        }
        this.initLocalTXState();
        this.setRuntimeStats(this.lcc.getRunTimeStatisticsMode());
        finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)2, this.activation.isSpecialCaseOuterJoin());
        finalBoolFlags = this.activation.getFunctionContext() != null ? GemFireXDUtils.set(finalBoolFlags, (byte)4, this.activation.needKeysForSelectForUpdate()) : GemFireXDUtils.set(finalBoolFlags, (byte)4, false);
        GemFireContainer gfc = ((MemConglomerate)scoci).getGemFireContainer();
        if (gfc != null) {
            if (gfc.getBaseContainer() != null) {
                gfc = gfc.getBaseContainer();
            }
            this.regionName = gfc.getQualifiedTableName();
            finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)8, !gfc.isPartitioned());
        } else {
            this.regionName = null;
            finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)8, false);
        }
        this.setFlag(16384, true);
        this.setFlag(32768, false);
        this.setFlag(65536, false);
        finalBoolFlags = GemFireXDUtils.set(finalBoolFlags, (byte)1, supportsMoveToNextKey);
        this.nonQualPreds = nonQualPreds;
        this.recordConstructorTime();
        this.finalFlags = finalBoolFlags;
        this.ohAddressCache = this.createOHAddressCache();
    }

    @Override
    public void openCore() throws StandardException {
        this.registerWithGemFireTransaction(this);
        if (!this.delayScanOpening()) {
            this.basicOpenCore();
        }
    }

    public void basicOpenCore() throws StandardException {
        long lbeginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"TableScanResultSet already open");
        this.isOpen = true;
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.dcoci == null) {
            this.dcoci = tc.getDynamicCompiledConglomInfo(this.conglomId);
        }
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition()) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (this.firstScan()) {
            this.openScanController(tc);
            this.setIsKeyed(this.scanController.isKeyed());
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.setScanControllerOpened(false);
        } else if (!this.firstScan()) {
            this.openScanController(tc);
        }
        if (this.forUpdate() && this.isKeyed()) {
            this.activation.setIndexScanController(this.scanController);
            this.activation.setIndexConglomerateNumber(this.conglomId);
        }
        this.setFirstScan(false);
        ++this.numOpens;
        this.setFlag(64, false);
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(lbeginTime);
        }
    }

    protected void openScanController(TransactionController tc) throws StandardException {
        this.openScanController(tc, null);
    }

    protected void openScanController(TransactionController tc, DataValueDescriptor probeValue) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (probeValue != null) {
            startPositionRow[0] = probeValue;
            if (!this.sameStartStopPosition()) {
                stopPositionRow[0] = probeValue;
            }
        }
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (tc == null) {
            tc = this.activation.getTransactionController();
        }
        int openMode = 0;
        if (this.forUpdate()) {
            openMode = 4;
            if (this.activation.isCursorActivation()) {
                openMode |= 0x1000;
            }
        }
        this.scanController = tc.openCompiledScan(this.activation.getResultSetHoldability(), openMode, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator, this.scoci, this.dcoci, this.activation);
        this.setScanControllerOpened(true);
        this.rowsThisScan = 0L;
        this.estimatedRowCount = this.scanController.getEstimatedRowCount();
        this.activation.informOfRowCount(this, this.estimatedRowCount);
        if (this.scanController instanceof MemHeapScanController && ((MemHeapScanController)this.scanController).getGemFireContainer().isOffHeap()) {
            ((MemHeapScanController)this.scanController).setOffHeapOwner(this);
        }
    }

    protected void reopenScanController() throws StandardException {
        this.reopenScanController(null);
    }

    protected void reopenScanController(DataValueDescriptor probeValue) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (probeValue != null) {
            startPositionRow[0] = probeValue;
            if (!this.sameStartStopPosition()) {
                stopPositionRow[0] = probeValue;
            }
        } else {
            this.rowsThisScan = 0L;
        }
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        this.scanController.reopenScan(startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator, this.activation);
        if (this.scanController instanceof MemHeapScanController && ((MemHeapScanController)this.scanController).getGemFireContainer().isOffHeap()) {
            ((MemHeapScanController)this.scanController).setOffHeapOwner(this);
        }
        this.setScanControllerOpened(true);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.registerWithGemFireTransaction(this);
        if (!this.delayScanOpening()) {
            this.basicReopenCore();
        }
    }

    public void basicReopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"TableScanResultSet not open, cannot reopen");
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition()) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.setScanControllerOpened(false);
        } else if (this.scanController == null) {
            this.openScanController(null);
        } else {
            this.reopenScanController();
        }
        ++this.numOpens;
        this.releasePreviousByteSource();
        this.setFlag(64, false);
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    private void getSparseRowAndMap() throws StandardException {
        int colPos;
        int i;
        int numCols = 1;
        for (i = 0; i < this.indexCols.length; ++i) {
            int n = colPos = this.indexCols[i] > 0 ? this.indexCols[i] : -this.indexCols[i];
            if (colPos <= numCols) continue;
            numCols = colPos;
        }
        this.sparseRow = new ValueRow(numCols);
        this.sparseRowMap = new FormatableBitSet(numCols);
        for (i = 0; i < this.indexCols.length; ++i) {
            if (!this.accessedCols.get(i)) continue;
            colPos = this.indexCols[i] > 0 ? this.indexCols[i] : -this.indexCols[i];
            this.sparseRow.setColumn(colPos, this.candidate.getColumn(i + 1));
            this.sparseRowMap.set(colPos - 1);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.delayScanOpening()) {
            if (!this.isOpen && this.numOpens == 0) {
                this.basicOpenCore();
            } else if (!this.isOpen) {
                this.basicReopenCore();
            }
        }
        this.checkCancellationFlag();
        if (this.currentRow == null || this.scanRepositioned()) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed());
        }
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        ExecRow result = null;
        RowLocation rl = null;
        TXState localTXState = this.localTXState;
        if (this.futureForUpdateRows != null) {
            this.setFlag(4096, false);
            if (!this.skipFutureRowHolder()) {
                ExecRow ridRow;
                if (this.futureRowResultSet == null) {
                    this.futureRowResultSet = (TemporaryRowHolderResultSet)this.futureForUpdateRows.getResultSet();
                    this.futureRowResultSet.openCore();
                }
                if ((ridRow = this.futureRowResultSet.getNextRowCore()) != null) {
                    this.futureRowResultSet.deleteCurrentRow();
                    rl = (RowLocation)ridRow.getColumn(1);
                    ConglomerateController baseCC = this.activation.getHeapConglomerateController();
                    if (this.sparseRow == null) {
                        this.getSparseRowAndMap();
                    }
                    if ((rl = baseCC.fetch(rl, this.sparseRow, this.sparseRowMap, false)) != null) {
                        ridRow.setColumn(1, rl);
                    }
                    RowLocation rl2 = (RowLocation)rl.getClone();
                    this.currentRow.setColumn(this.currentRow.nColumns(), rl2);
                    this.candidate.setColumn(this.candidate.nColumns(), rl2);
                    result = this.currentRow;
                    this.setFlag(4096, true);
                } else if (this.sourceDrained()) {
                    this.setFlag(4096, true);
                    this.currentRow = null;
                }
                if (this.currentRowPrescanned()) {
                    this.setCurrentRow(result);
                    this.setRegionAndKeyInfo(result);
                    if (localTXState != null && this.isTopResultSet && this.forUpdate() && rl != null) {
                        this.upgradeReadLockToWrite(rl, null);
                    }
                    if (this.statisticsTimingOn) {
                        this.nextTime += this.getElapsedNanos(this.beginTime);
                    }
                    return result;
                }
            }
        }
        if (this.isOpen && !this.nextDone()) {
            this.setFlag(64, this.oneRowScan());
            if (this.scanControllerOpened()) {
                boolean moreRows;
                while (moreRows = this.scanController.fetchNext(this.candidate)) {
                    RowLocation rowLoc;
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.sameStartStopPosition() && this.skipRow(this.candidate)) {
                        ++this.rowsFiltered;
                        this.filteredRowLocationPostRead(localTXState);
                        continue;
                    }
                    if (this.past2FutureTbl != null && this.past2FutureTbl.get(rowLoc = (RowLocation)this.currentRow.getLastColumn()) != null) {
                        this.past2FutureTbl.remove(rowLoc);
                        continue;
                    }
                    if (this.candidate instanceof IndexRow) {
                        this.currentRow.setColumn(this.currentRow.nColumns(), this.candidate.getLastColumn());
                    }
                    rl = this.scanController.getCurrentRowLocation();
                    result = this.currentRow;
                    break;
                }
                if (!moreRows) {
                    this.setRowCountIfPossible(this.rowsThisScan);
                    this.currentRow = null;
                }
            }
        }
        this.setCurrentRow(result);
        this.setRegionAndKeyInfo(result);
        if (localTXState != null && this.isTopResultSet && this.forUpdate() && rl != null) {
            this.upgradeReadLockToWrite(rl, null);
        }
        this.setFlag(32768, true);
        this.setFlag(65536, false);
        this.setFlag(16384, true);
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            ConglomerateController borrowedBaseCC;
            this.clearCurrentRow();
            if (this.scanController != null) {
                if (this.runTimeStatisticsOn()) {
                    this.scanProperties = this.getScanProperties();
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.scanController.close();
                this.scanController = null;
                this.activation.clearIndexScanInfo();
            }
            this.setScanControllerOpened(false);
            this.startPosition = null;
            this.stopPosition = null;
            this.releasePreviousByteSource();
            super.close(cleanupOnError);
            if (this.indexCols != null && (borrowedBaseCC = this.activation.getHeapConglomerateController()) != null) {
                borrowedBaseCC.close();
                this.activation.clearHeapConglomerateController();
            }
            if (this.futureRowResultSet != null) {
                this.futureRowResultSet.close(cleanupOnError);
            }
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of TableScanResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time;
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (!this.scanControllerOpened()) {
            return null;
        }
        return this.scanController.getCurrentRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow result;
        block7: {
            result = null;
            SanityManager.ASSERT((boolean)this.isOpen, (String)"TSRS expected to be open");
            if (this.currentRowPrescanned()) {
                return this.currentRow;
            }
            try {
                if (this.currentRow == null || !this.currentRowIsValid() || !this.scanControllerOpened() || this.qualify() && this.scanController.isCurrentPositionDeleted() || this.qualify() && !this.scanController.doesCurrentPositionQualify()) {
                    return null;
                }
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("XSAM5.S")) break block7;
                se = StandardException.newException("24000");
                throw se;
            }
        }
        result = (ExecRow)this.resultRowAllocator.invoke(this.activation);
        this.currentRow = this.getCompactRow(result, this.accessedCols, this.isKeyed());
        try {
            this.scanController.fetchWithoutQualify(result);
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XSAM6.S")) {
                return null;
            }
            throw se;
        }
        this.setCurrentRow(result);
        this.setRegionAndKeyInfo(result);
        return this.currentRow;
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
        if (!this.isKeyed()) {
            this.setFlag(32768, this.scanController.positionAtRowLocation(rl));
        }
        this.setFlag(16384, false);
        this.setFlag(65536, true);
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition()) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int searchOperator, GeneratedMethod positionGetter, ExecIndexRow positioner) {
        String idt = "";
        String output = "";
        if (positionGetter == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        if (positioner == null) {
            try {
                positioner = (ExecIndexRow)positionGetter.invoke(this.activation);
            }
            catch (StandardException e) {
                if (e.getSQLState() == "38000") {
                    return "\t" + MessageService.getTextMessage("42Z38.U");
                }
                return "\t" + MessageService.getTextMessage("42Z39.U", e.toString());
            }
        }
        if (positioner == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        String searchOp = null;
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unknown search operator " + searchOperator));
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        output = output + "\t" + MessageService.getTextMessage("42Z40.U", searchOp, String.valueOf(positioner.nColumns())) + "\n";
        output = output + "\t" + MessageService.getTextMessage("42Z41.U") + "\n";
        for (int position = 0; position < positioner.nColumns(); ++position) {
            if (!positioner.areNullsOrdered(position)) continue;
            output = output + position + " ";
        }
        return output + "\n";
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.scanController != null) {
                this.scanController.getScanInfo().getAllScanInfo(this.scanProperties);
                this.setFlag(256, this.scanController.isTableLocked() && this.lockMode == 6);
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 3;
    }

    protected final void setRowCountIfPossible(long rowsThisScan) throws StandardException {
        if (!(this.scanController.isKeyed() || this.qualifiers != null && this.qualifiers.length != 0 || this.forUpdate())) {
            long diff = rowsThisScan - this.estimatedRowCount;
            long tenPerCent = this.estimatedRowCount / 10L;
            if (diff < 0L) {
                diff = -diff;
            }
            if (diff > tenPerCent) {
                this.scanController.setEstimatedRowCount(rowsThisScan);
            }
        }
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return false;
    }

    @Override
    public final boolean isForUpdate() {
        return (this.varflags & 0x10) != 0;
    }

    public Object clone() {
        Object clo = null;
        try {
            clo = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clo;
    }

    protected final void setRegionAndKeyInfo(ExecRow currRow) throws StandardException {
        if (currRow != null) {
            if (GemFireXDUtils.TraceOuterJoin) {
                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("TableScanResultSet::setRak: current row: " + currRow + ", addRegionAndKey = " + this.addRegionAndKey() + ", region name = " + this.regionName + ", isreplicate = " + this.isReplicate() + " TableScanResultSet object is: " + System.identityHashCode(this) + " activation is: " + System.identityHashCode(this.activation)));
            }
            if (this.addRegionAndKey() || this.addKeyForSelectForUpdate()) {
                RowLocation baseRowLocation = this.getRowLocation();
                if (baseRowLocation == null) {
                    return;
                }
                Object currBaseKey = baseRowLocation.getKeyCopy();
                if (this.addRegionAndKey()) {
                    assert (!this.addKeyForSelectForUpdate());
                    currRow.clearAllRegionAndKeyInfo();
                    currRow.addRegionAndKey(new RegionAndKey(this.regionName, currBaseKey, this.isReplicate()));
                } else if (this.addKeyForSelectForUpdate()) {
                    currRow.clearAllRegionAndKeyInfo();
                    currRow.addRegionAndKey(new RegionAndKey(null, currBaseKey, this.isReplicate()));
                }
                if (GemFireXDUtils.TraceOuterJoin) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("TableScanResultSet::setRak: current row rak: " + currRow.getAllRegionAndKeyInfo() + " for " + ArrayUtils.objectRefString((Object)currRow)));
                }
            }
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        if (this.scanControllerOpened()) {
            this.scanController.upgradeCurrentRowLocationLockToWrite();
        }
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (localTXState != null && this.scanControllerOpened()) {
            this.scanController.releaseCurrentRowLocationReadLock();
        }
        if (this.ohAddressCache != null && this.isHeapScan()) {
            this.releaseByteSource(0);
        }
    }

    @Override
    public void releasePreviousByteSource() {
        if ((this.finalFlags & 0x20) != 0) {
            this.releaseByteSource(0);
        }
    }

    protected final boolean isHeapScan() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)-128);
    }

    @Override
    public int getScanKeyGroupID() {
        if (this.scanControllerOpened()) {
            return this.scanController.getScanKeyGroupID();
        }
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    protected final TemporaryRowHolder getFutureForUpdateRows() {
        return this.futureForUpdateRows;
    }

    @Override
    protected final TemporaryRowHolderResultSet getFutureRowResultSet() {
        return this.futureRowResultSet;
    }

    @Override
    protected final void setFutureRowResultSet(TemporaryRowHolderResultSet futureRowResultSet) {
        this.futureRowResultSet = futureRowResultSet;
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        boolean isSuccess = context.setNested();
        super.buildQueryPlan(builder, context);
        String lockString = null;
        lockString = this.forUpdate() ? MessageService.getTextMessage("42Z82.U") : (this.isolationLevel == 3 ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
        String lockGran = PlanUtils.getLockGranularityCode(lockString);
        String scantype = null;
        String scanObjectType = null;
        String detail = null;
        String scanObjectName = null;
        String startPosition = null;
        String stopPosition = null;
        if (this.indexName != null) {
            if (this.isConstraint()) {
                scantype = "CONSTRAINTSCAN";
                scanObjectType = "C";
                detail = "C: " + this.indexName;
                GemFireContainer gfc = ((MemConglomerate)this.scoci).getGemFireContainer();
                scanObjectName = gfc != null ? gfc.getQualifiedTableName() : "HASH SCAN:" + this.tableName;
                detail = this.nonQualPreds != null ? "WHERE : " + this.nonQualPreds : null;
            } else {
                scantype = "INDEXSCAN";
                scanObjectType = "I";
                detail = "";
                if (!((MemIndex)this.scoci).caseSensitive()) {
                    detail = detail + "(Case Insensitive) ";
                }
                scanObjectName = this.indexName;
                if (this.nonQualPreds != null) {
                    detail = detail + "WHERE : " + this.nonQualPreds;
                }
            }
            startPosition = this.startPositionString;
            if (startPosition == null) {
                startPosition = this.printStartPosition();
            }
            if ((stopPosition = this.stopPositionString) == null) {
                stopPosition = this.printStopPosition();
            }
        } else {
            scantype = "TABLESCAN";
            scanObjectType = "T";
            detail = "T: " + this.tableName;
            scanObjectName = this.regionName;
        }
        PlanUtils.xmlAttribute(builder, "scan_object_type", scanObjectType);
        PlanUtils.xmlAttribute(builder, "scan_object", scanObjectName);
        PlanUtils.xmlAttribute(builder, "start_position", startPosition);
        PlanUtils.xmlAttribute(builder, "stop_position", stopPosition);
        PlanUtils.xmlAttribute(builder, "extra_qualifiers", TableScanResultSet.printQualifiers(this.qualifiers, false));
        PlanUtils.xmlAttribute(builder, "isolation_level", PlanUtils.getIsolationLevelCode(this.isolationLevel));
        PlanUtils.xmlAttribute(builder, "lock_mode", lockString);
        PlanUtils.xmlAttribute(builder, "lock_granurality", lockGran);
        PlanUtils.xmlAttribute(builder, "node_details", detail);
        if (this.userSuppliedOptimizerOverrides != null) {
            PlanUtils.xmlAttribute(builder, "optimizer_overrides", this.userSuppliedOptimizerOverrides);
        }
        if (!isSuccess) {
            return builder;
        }
        PlanUtils.xmlTermTag(builder, context, scantype);
        this.endBuildQueryPlan(builder, context.pushContext());
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        if (this.scanController instanceof SortedMap2IndexScanController) {
            SortedMap2IndexScanController sc = (SortedMap2IndexScanController)this.scanController;
            return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, sc, sc.getCurrentKey(), sc.getCurrentNodeVersion(), this);
        }
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, this);
    }

    protected void endBuildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        Properties scanProps = this.getScanProperties();
        PlanUtils.xmlBeginTag(builder, context, "ScanProperties");
        PlanUtils.extractScanProps(builder, scanProps);
        PlanUtils.xmlAttribute(builder, "fetch_size", this.rowsPerRead);
        PlanUtils.xmlTermTag(builder, context, "SCAN-PROPERTIES", true);
    }

    private final void setFlag(int MASK, boolean isOn) {
        this.varflags = GemFireXDUtils.set(this.varflags, MASK, isOn);
    }

    protected final void setScanControllerOpened(boolean isOpened) {
        this.varflags = GemFireXDUtils.set(this.varflags, 1, isOpened);
    }

    protected final boolean scanControllerOpened() {
        return GemFireXDUtils.isSet(this.varflags, 1);
    }

    protected final void setIsKeyed(boolean isKeyed) {
        this.varflags = GemFireXDUtils.set(this.varflags, 2, isKeyed);
    }

    protected final boolean isKeyed() {
        return GemFireXDUtils.isSet(this.varflags, 2);
    }

    protected final void setFirstScan(boolean isFirstScan) {
        this.varflags = GemFireXDUtils.set(this.varflags, 4, isFirstScan);
    }

    protected final boolean firstScan() {
        return GemFireXDUtils.isSet(this.varflags, 4);
    }

    protected final void setRuntimeStats(boolean isRuntimeStatsOn) {
        this.varflags = GemFireXDUtils.set(this.varflags, 8, isRuntimeStatsOn);
    }

    protected final boolean runTimeStatisticsOn() {
        return GemFireXDUtils.isSet(this.varflags, 8);
    }

    public final boolean forUpdate() {
        return GemFireXDUtils.isSet(this.varflags, 16);
    }

    protected final boolean sameStartStopPosition() {
        return GemFireXDUtils.isSet(this.varflags, 32);
    }

    private final boolean nextDone() {
        return GemFireXDUtils.isSet(this.varflags, 64);
    }

    public final boolean isConstraint() {
        return GemFireXDUtils.isSet(this.varflags, 128);
    }

    public final boolean coarserLock() {
        return GemFireXDUtils.isSet(this.varflags, 256);
    }

    public final boolean oneRowScan() {
        return GemFireXDUtils.isSet(this.varflags, 512);
    }

    protected final void setSkipFutureRowHolder(boolean skip) {
        this.varflags = GemFireXDUtils.set(this.varflags, 1024, skip);
    }

    protected final boolean skipFutureRowHolder() {
        return GemFireXDUtils.isSet(this.varflags, 1024);
    }

    protected final void setSourceDrained(boolean drained) {
        this.varflags = GemFireXDUtils.set(this.varflags, 2048, drained);
    }

    @Override
    protected final boolean sourceDrained() {
        return GemFireXDUtils.isSet(this.varflags, 2048);
    }

    protected final boolean currentRowPrescanned() {
        return GemFireXDUtils.isSet(this.varflags, 4096);
    }

    protected final void setCompareToLastKey(boolean compared) {
        this.varflags = GemFireXDUtils.set(this.varflags, 8192, compared);
    }

    protected final boolean compareToLastKey() {
        return GemFireXDUtils.isSet(this.varflags, 8192);
    }

    private final boolean qualify() {
        return GemFireXDUtils.isSet(this.varflags, 16384);
    }

    private final boolean currentRowIsValid() {
        return GemFireXDUtils.isSet(this.varflags, 32768);
    }

    private final boolean scanRepositioned() {
        return GemFireXDUtils.isSet(this.varflags, 65536);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)1);
    }

    protected final boolean addRegionAndKey() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)2);
    }

    protected final boolean addKeyForSelectForUpdate() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)4);
    }

    protected final boolean isReplicate() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)8);
    }

    protected final boolean delayScanOpening() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)16);
    }

    @Override
    public final boolean optimizedForOffHeap() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)32);
    }

    protected final boolean indexAccessesBaseTable() {
        return GemFireXDUtils.isSet(this.finalFlags, (byte)64);
    }

    public final void release() {
        if (this.ohAddressCache != null) {
            this.ohAddressCache.release();
        }
    }

    @Override
    public final void addByteSource(OffHeapByteSource byteSource) {
        if (byteSource != null) {
            this.ohAddressCache.put(byteSource.getMemoryAddress());
        } else {
            this.ohAddressCache.put(0L);
        }
    }

    @Override
    public final void registerWithGemFireTransaction(OffHeapResourceHolder owner) {
        if (this.ohAddressCache != null) {
            ((GemFireTransaction)this.lcc.getTransactionExecute()).registerOffHeapResourceHolder(owner);
        }
    }

    @Override
    public final void releaseByteSource(int positionFromEnd) {
        if (this.ohAddressCache != null) {
            this.ohAddressCache.releaseByteSource(positionFromEnd);
        }
    }

    protected final boolean isOHAddressCacheNeeded() {
        GemFireContainer gfc = ((MemConglomerate)this.scoci).getGemFireContainer();
        int memConglomType = ((MemConglomerate)this.scoci).getType();
        if (memConglomType == 0) {
            return gfc.isOffHeap();
        }
        if (memConglomType == 1 || memConglomType == 3) {
            if (this.indexAccessesBaseTable()) {
                if (gfc != null) {
                    if (gfc.getBaseContainer() != null) {
                        gfc = gfc.getBaseContainer();
                    }
                } else {
                    gfc = ((MemIndex)this.scoci).getBaseContainer();
                }
                if (gfc != null) {
                    return gfc.isOffHeap();
                }
            } else {
                return false;
            }
        }
        return false;
    }

    protected OHAddressCache createOHAddressCache() {
        if (this.isOHAddressCacheNeeded()) {
            if (this.optimizedForOffHeap()) {
                return new SingleOHAddressCache();
            }
            return GemFireTransaction.createOHAddressCache();
        }
        return null;
    }

    public static final class SingleOHAddressCache
    implements OHAddressCache {
        private long address = 0L;

        @Override
        public void put(long address) {
            if (this.address != 0L) {
                throw new IllegalStateException("Cached address =" + this.address + " is unreleased");
            }
            this.address = address;
        }

        @Override
        public void releaseByteSource(int position) {
            this.release();
        }

        public void release() {
            if (this.address != 0L) {
                SimpleMemoryAllocatorImpl.Chunk.release((long)this.address, (boolean)true);
                this.address = 0L;
            }
        }
    }
}

