/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class RowCountResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    final NoPutResultSet source;
    private final boolean runTimeStatsOn;
    private long offset;
    private long fetchFirst;
    private final GeneratedMethod offsetMethod;
    private final GeneratedMethod fetchFirstMethod;
    private boolean virginal;
    private long rowsFetched;

    RowCountResultSet(NoPutResultSet s, Activation a, int resultSetNumber, GeneratedMethod offsetMethod, GeneratedMethod fetchFirstMethod, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.offsetMethod = offsetMethod;
        this.fetchFirstMethod = fetchFirstMethod;
        this.source = s;
        this.virginal = true;
        this.rowsFetched = 0L;
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeOffsetAndFetchLimit() throws StandardException {
        long fetchFirst;
        if (this.offsetMethod != null) {
            DataValueDescriptor offVal = (DataValueDescriptor)this.offsetMethod.invoke(this.activation);
            if (!offVal.isNotNull().getBoolean()) throw StandardException.newException("2201Z", "OFFSET");
            this.offset = offVal.getLong();
            if (this.offset < 0L) {
                throw StandardException.newException("2201X", Long.toString(this.offset));
            }
            this.offset = offVal.getLong();
        } else {
            this.offset = 0L;
        }
        if (this.fetchFirstMethod != null) {
            DataValueDescriptor fetchFirstVal = (DataValueDescriptor)this.fetchFirstMethod.invoke(this.activation);
            if (!fetchFirstVal.isNotNull().getBoolean()) throw StandardException.newException("2201Z", "FETCH FIRST/NEXT");
            this.fetchFirst = fetchFirstVal.getLong();
            if (this.fetchFirst < 1L) {
                throw StandardException.newException("2201W", Long.toString(this.fetchFirst));
            }
        }
        if (this.getLanguageConnectionContext().isConnectionForRemote() && this.activation.getFunctionContext() != null && !((RegionExecutorMessage)this.activation.getFunctionContext()).allTablesAreReplicatedOnRemote()) {
            if (this.fetchFirst != -1L) {
                this.fetchFirst += this.offset;
            }
            this.offset = 0L;
        }
        if ((fetchFirst = this.fetchFirst) <= 0L) return;
        this.source.setMaxSortingLimit(this.offset <= 0L ? fetchFirst : fetchFirst + this.offset);
    }

    @Override
    public void openCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        this.initializeOffsetAndFetchLimit();
        this.source.openCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"RowCountResultSet not open, cannot reopen");
        this.isOpen = true;
        this.initializeOffsetAndFetchLimit();
        this.source.reopenCore();
        this.rowsFetched = 0L;
        this.virginal = true;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.virginal) {
            if (this.offset > 0L) {
                this.virginal = false;
                long offsetCtr = this.offset;
                TXState localTXState = this.initLocalTXState();
                while ((result = this.source.getNextRowCore()) != null && --offsetCtr >= 0L) {
                    ++this.rowsFiltered;
                    this.filteredRowLocationPostRead(localTXState);
                }
            } else {
                result = this.fetchFirstMethod != null && this.rowsFetched >= this.fetchFirst ? null : this.source.getNextRowCore();
            }
        } else {
            result = this.fetchFirstMethod != null && this.rowsFetched >= this.fetchFirst ? null : this.source.getNextRowCore();
        }
        if (result != null) {
            ++this.rowsFetched;
            ++this.rowsSeen;
        }
        this.setCurrentRow(result);
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
        }
        return result;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of RowCountResultSet repeated");
        }
        this.virginal = true;
        this.rowsFetched = 0L;
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public final void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
        this.source.clearCurrentRow();
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getCurrentRow();
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public ProjectRestrictResultSet getUnderlyingProjectRestrictRS() {
        if (this.source instanceof ProjectRestrictResultSet) {
            return (ProjectRestrictResultSet)this.source;
        }
        return null;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.source.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "ROW-COUNT");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

