/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.StatementUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericRIChecker;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;

public class ReferencedKeyRIChecker
extends GenericRIChecker {
    ReferencedKeyRIChecker(TransactionController tc, FKInfo fkinfo) throws StandardException {
        super(tc, fkinfo);
        if (this.fkInfo.type != 2) {
            SanityManager.THROWASSERT((String)("invalid type " + this.fkInfo.type + " for a ReferencedKeyRIChecker"));
        }
    }

    @Override
    void doCheck(ExecRow row, boolean restrictCheckOnly) throws StandardException {
        if (this.isAnyFieldNull(row)) {
            return;
        }
        for (int i = 0; i < this.fkInfo.fkConglomNumbers.length; ++i) {
            if (restrictCheckOnly && this.fkInfo.raRules[i] != 1) continue;
            ScanController scan = this.getScanController(this.fkInfo.fkConglomNumbers[i], this.fkScocis[i], this.fkDcocis[i], row);
            if (scan.next()) {
                this.close();
                StandardException se = StandardException.newException("23503", this.fkInfo.fkConstraintNames[i], (Object)this.fkInfo.tableName, (Object)StatementUtil.typeName(this.fkInfo.stmtType), (Object)RowUtil.toString(row, this.fkInfo.colArray));
                throw se;
            }
            scan.next();
        }
    }
}

