/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInfo;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedByteCode;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import java.lang.reflect.InvocationTargetException;

public abstract class LoadedGeneratedClass
implements GeneratedClass {
    private final ClassInfo ci;
    private final int classLoaderVersion;

    public LoadedGeneratedClass(ClassFactory cf, Class jvmClass) {
        this.ci = new ClassInfo(jvmClass);
        this.classLoaderVersion = cf.getClassLoaderVersion();
    }

    @Override
    public String getName() {
        return this.ci.getClassName();
    }

    @Override
    public Object newInstance(LanguageConnectionContext context, boolean addToLCC, ExecPreparedStatement eps) throws StandardException {
        Throwable t;
        try {
            GeneratedByteCode ni = (GeneratedByteCode)this.ci.getNewInstance();
            ni.initFromContext(context, addToLCC, eps);
            ni.setGC(this);
            ni.postConstructor();
            return ni;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        catch (InvocationTargetException ite) {
            t = ite;
        }
        catch (LinkageError le) {
            t = le;
        }
        throw StandardException.newException("XBCM2.S", t, (Object)this.getName());
    }

    @Override
    public final int getClassLoaderVersion() {
        return this.classLoaderVersion;
    }

    protected Class getJVMClass() {
        return this.ci.getClassObject();
    }
}

