/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticUtil;
import com.pivotal.gemfirexd.internal.iapi.services.diag.Diagnosticable;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.locks.Lock;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockControl;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class D_LockControl
implements Diagnosticable {
    protected LockControl control;

    @Override
    public void init(Object obj) {
        this.control = (LockControl)obj;
    }

    @Override
    public String diag() throws StandardException {
        List granted;
        StringBuilder sb = new StringBuilder(1024);
        sb.append("LockControl:\n  granted list: ");
        int i = 0;
        Lock firstGrant = this.control.getFirstGrant();
        if (firstGrant != null) {
            sb.append("\n    g[" + i + "]:" + DiagnosticUtil.toDiagString(firstGrant));
            ++i;
        }
        if ((granted = this.control.getGranted()) != null) {
            Iterator dli = granted.iterator();
            while (dli.hasNext()) {
                sb.append("\n    g[" + i + "]:" + DiagnosticUtil.toDiagString(dli.next()));
                ++i;
            }
        }
        sb.append("\n  waiting list:");
        List waiting = this.control.getWaiting();
        int num_waiting = 0;
        if (waiting != null) {
            Iterator dli = waiting.iterator();
            while (dli.hasNext()) {
                sb.append("\n    w[" + num_waiting + "]:" + DiagnosticUtil.toDiagString(dli.next()));
                ++num_waiting;
            }
        }
        if (num_waiting == 0) {
            sb.append("    no waiting locks.");
        }
        return sb.toString();
    }

    @Override
    public void diag_detail(Properties prop) {
    }

    static void debugLock(String type, CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier, int timeout) {
        SanityManager.DEBUG((String)"LockTrace", (String)(type + D_LockControl.debugLockString(compatibilitySpace, group, ref, qualifier, timeout)));
    }

    static void debugLock(String type, CompatibilitySpace compatibilitySpace, Object group) {
        SanityManager.DEBUG((String)"LockTrace", (String)(type + D_LockControl.debugLockString(compatibilitySpace, group)));
    }

    static void debugLock(String type, CompatibilitySpace compatibilitySpace, Object group, Lockable ref) {
        SanityManager.DEBUG((String)"LockTrace", (String)(type + D_LockControl.debugLockString(compatibilitySpace, group, ref)));
    }

    static String debugLockString(CompatibilitySpace compatibilitySpace, Object group) {
        StringBuilder sb = new StringBuilder("");
        D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
        D_LockControl.debugAppendObject(sb, " Group=", group);
        D_LockControl.debugAddThreadInfo(sb);
        return sb.toString();
    }

    static String debugLockString(CompatibilitySpace compatibilitySpace, Object group, Lockable ref) {
        StringBuilder sb = new StringBuilder("");
        D_LockControl.debugAppendObject(sb, " Lockable ", ref);
        D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
        D_LockControl.debugAppendObject(sb, " Group=", group);
        D_LockControl.debugAddThreadInfo(sb);
        return sb.toString();
    }

    static String debugLockString(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier, int timeout) {
        StringBuilder sb = new StringBuilder("");
        D_LockControl.debugAppendObject(sb, " Lockable ", ref);
        D_LockControl.debugAppendObject(sb, " Qualifier=", qualifier);
        D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
        D_LockControl.debugAppendObject(sb, " Group=", group);
        if (timeout >= 0) {
            sb.append(" Timeout(ms)=");
            sb.append(timeout);
        }
        D_LockControl.debugAddThreadInfo(sb);
        return sb.toString();
    }

    static void debugAddThreadInfo(StringBuilder sb) {
        if (SanityManager.DEBUG_ON((String)"LockTraceAddThreadInfo")) {
            D_LockControl.debugAppendObject(sb, " Thread=", Thread.currentThread());
        }
    }

    static void debugAppendObject(StringBuilder sb, String desc, Object item) {
        sb.append(desc);
        if (item != null) {
            sb.append(item.toString());
        } else {
            sb.append("<null>");
        }
    }
}

