/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc.authentication;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.gemstone.gemfire.security.AuthInitialize;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.Authenticator;
import com.pivotal.gemfirexd.auth.callback.CredentialInitializer;
import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.SecurityUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.BasicAuthenticationServiceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.JNDIAuthenticationService;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;

public abstract class AuthenticationServiceBase
implements AuthenticationService,
ModuleControl,
ModuleSupportable,
PropertySetCallback,
AuthInitialize,
Authenticator {
    private final Properties bootCredentials = new Properties();
    private Properties bootProperties;
    private boolean isPeerAuthenticationService = false;
    protected UserAuthenticator authenticationScheme;
    private AccessFactory store;
    private LogWriterI18n securitylogger;
    public static final String AuthenticationTrace = "TraceAuthentication";
    public static final String factoryMethodForGFEAuth = ".getPeerAuthenticationService";
    private static AuthenticationServiceBase peerAuthenticationService;
    private volatile boolean isShuttingDown = false;
    public static final String ID_PATTERN_NEW_SCHEME_V3 = "v33b60";
    public static final String ID_PATTERN_NEW_SCHEME_V2 = "v23b60";
    public static final String ID_PATTERN_NEW_SCHEME_V1 = "3b60";
    public static final String ID_PATTERN_LDAP_SCHEME_V1 = "v13b607k2j6";
    protected static final int SECMEC_USRSSBPWD = 8;
    public static final int MAGICLEN_NEWENCRYPT_SCHEME = 44;
    public static final String maskedvalue = "******";
    public static final String val = "_!_-p-h-_!_";

    protected void setAuthenticationService(UserAuthenticator aScheme) {
        this.authenticationScheme = aScheme;
        SanityManager.ASSERT((this.authenticationScheme != null ? 1 : 0) != 0, (String)"There is no authentication scheme for that service!");
        if (GemFireXDUtils.TraceAuthentication) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println("Authentication Service: [" + this.toString() + "]");
            iDbgStream.println("Authentication Scheme : [" + this.authenticationScheme.toString() + "]");
        }
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        this.bootCredentials.clear();
        this.store = (AccessFactory)Monitor.getServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        PropertyFactory pf = (PropertyFactory)Monitor.getServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory");
        if (pf != null) {
            pf.addPropertySetNotification(this);
        }
        if (this.isPeerAuthenticationService && !(this instanceof NoneAuthenticationServiceImpl) && this.requireAuthentication(properties)) {
            String thisClass = this.getClass().getName();
            properties.put("gemfire.security-peer-auth-init", thisClass + factoryMethodForGFEAuth);
            properties.put("gemfire.security-peer-authenticator", thisClass + factoryMethodForGFEAuth);
            Properties transformed = SecurityUtils.transformGFXDToGemFireProperties(properties);
            properties.putAll((Map<?, ?>)transformed);
            this.isShuttingDown = false;
        }
        this.bootProperties = properties;
    }

    @Override
    public void stop() {
        this.bootCredentials.clear();
    }

    @Override
    public String authenticate(String databaseName, Properties userInfo) throws SQLException {
        StackTraceElement[] stack;
        for (StackTraceElement e : stack = Thread.currentThread().getStackTrace()) {
            GemFireXDQueryObserver observer;
            String className = e.getClassName();
            String methodName = e.getMethodName();
            if ((!className.equals(GfxdConnectionWrapper.class.getName()) || !methodName.equals("createConnection")) && (!className.equals(GemFireXDUtils.class.getName()) || !methodName.equals("createNewInternalConnection"))) continue;
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)"Skipping authentication for peer or internal connection");
            }
            if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
                observer.memberConnectionAuthenticationSkipped(true);
            }
            return null;
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.userConnectionAuthenticationSkipped(false);
        }
        if (userInfo == null) {
            return "No user/password provided";
        }
        if (!this.isPeerAuthenticationService && userInfo.getProperty("gemfirexd.__rt.fabricapi") != null) {
            return null;
        }
        String userName = userInfo.getProperty("user");
        String string = userName = userName == null ? userInfo.getProperty("UserName") : userName;
        if (userName != null) {
            try {
                userName = IdUtil.getUserAuthorizationId(userName);
            }
            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
        }
        if (userName != null && userName.length() > 30) {
            return "User name '" + userName + "' exceeded maximum allowed length " + 30;
        }
        String retval = this.authenticationScheme.authenticateUser(userName, userInfo.getProperty("password"), databaseName, userInfo);
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("Authentication request determined user [" + userName + "] " + (retval == null ? " VALID " : " " + retval + " ")));
        }
        return retval;
    }

    public String getProperty(String key) {
        try {
            Properties props;
            String value = PropertyUtil.getServiceProperty(Misc.getMemStoreBootingNoThrow(), key, null);
            if (value == null && (props = this.bootProperties) != null) {
                value = props.getProperty(key);
            }
            return value;
        }
        catch (StandardException se) {
            if (Monitor.reportOn || GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("getProperty(" + key + ") received standard exception "), (Throwable)se);
            } else {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("AuthenticationServiceBase:getProperty(" + key + ") received standard exception: " + se.getMessage()));
            }
            return null;
        }
        catch (CancelException ce) {
            if (Monitor.reportOn || GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("getProperty(" + key + ") received cancel exception "), (Throwable)ce);
            } else {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("AuthenticationServiceBase:getProperty(" + key + ") received cancel exception: " + ce.getMessage()));
            }
            return null;
        }
    }

    public String getDatabaseProperty(String key) {
        try {
            return PropertyUtil.getDatabaseProperty(Misc.getMemStoreBooting(), key);
        }
        catch (StandardException se) {
            return null;
        }
        catch (CancelException ce) {
            return null;
        }
    }

    public String getSystemProperty(String key) {
        boolean dbOnly = false;
        dbOnly = Boolean.valueOf(this.getDatabaseProperty("gemfirexd.distributedsystem.propertiesOnly"));
        if (dbOnly) {
            return null;
        }
        return PropertyUtil.getSystemProperty(key);
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) {
        boolean isUserProp;
        boolean bl = isUserProp = key.startsWith("gemfirexd.user.") || key.startsWith("sqlfire.user.");
        if (GemFireXDUtils.TraceAuthentication) {
            if (isUserProp) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)(key + " recognized as database user & credentials will be stored."));
            } else {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)(key + " not recognized as a database user & therefore credentials won't be stored in GemFireXD."));
            }
        }
        return isUserProp;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) {
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.startsWith("gemfirexd.user.") && !key.startsWith("sqlfire.user.")) {
            return null;
        }
        String authService = (String)p.get("gemfirexd.auth-provider");
        if (authService != null && StringUtil.SQLEqualsIgnoreCase(authService, "LDAP")) {
            return null;
        }
        String userPassword = (String)((Object)value);
        if (userPassword != null) {
            userPassword = key.startsWith("sqlfire.user.") ? AuthenticationServiceBase.encryptPassword(key.substring("sqlfire.user.".length()), userPassword, false, false, true) : AuthenticationServiceBase.encryptPassword(key.substring("gemfirexd.user.".length()), userPassword, false, false, true);
        }
        return userPassword;
    }

    protected final boolean requireAuthentication(Properties properties) {
        String requireAuthentication = PropertyUtil.getPropertyFromSet(properties, "gemfirexd.authentication.required");
        return Boolean.valueOf(requireAuthentication);
    }

    public static String encryptPassword(String userName, String plainTxtUserPassword) throws StandardException {
        return AuthenticationServiceBase.encryptPassword(userName, plainTxtUserPassword, true, false, true);
    }

    public static boolean isEncrypted(String value) {
        return value.startsWith(ID_PATTERN_NEW_SCHEME_V3) && value.length() > ID_PATTERN_NEW_SCHEME_V3.length() || value.startsWith(ID_PATTERN_NEW_SCHEME_V2) && value.length() > ID_PATTERN_NEW_SCHEME_V2.length() || value.startsWith(ID_PATTERN_NEW_SCHEME_V1) && value.length() > ID_PATTERN_NEW_SCHEME_V1.length();
    }

    public static String encryptUserPassword(String userName, String plainTxtUserPassword, boolean forceEncrypt, boolean v2Encrypt, boolean v3Encrypt) throws SQLException {
        try {
            return AuthenticationServiceBase.encryptPassword(userName, plainTxtUserPassword, forceEncrypt, v2Encrypt, v3Encrypt);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    protected static String encryptPassword(String userName, String plainTxtUserPassword, boolean forceEncrypt, boolean v2Encrypt, boolean v3Encrypt) throws StandardException {
        if (plainTxtUserPassword == null) {
            return null;
        }
        if (!forceEncrypt && AuthenticationServiceBase.isEncrypted(plainTxtUserPassword)) {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("Skipping encryption as it must be encrypted from origin - " + plainTxtUserPassword));
            }
            return plainTxtUserPassword;
        }
        MessageDigest algorithm = null;
        String algoName = v3Encrypt ? "SHA-256" : "SHA-1";
        try {
            algorithm = MessageDigest.getInstance(algoName);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw StandardException.newException("XBCXC.S", (Object)algoName, (Object)"default");
        }
        algorithm.reset();
        byte[] bytePasswd = StringUtil.toHexByte(plainTxtUserPassword, 0, plainTxtUserPassword.length());
        if (v3Encrypt || v2Encrypt) {
            userName = userName == null || userName.length() == 0 ? "USER" : IdUtil.getUserAuthorizationId(userName);
            GemFireXDUtils.updateCipherKeyBytes(bytePasswd, userName.getBytes(ClientSharedData.UTF8));
        }
        algorithm.update(bytePasswd);
        byte[] encryptVal = algorithm.digest();
        String hexString = (v3Encrypt ? ID_PATTERN_NEW_SCHEME_V3 : (v2Encrypt ? ID_PATTERN_NEW_SCHEME_V2 : ID_PATTERN_NEW_SCHEME_V1)) + StringUtil.toHexString(encryptVal, 0, encryptVal.length);
        if (SanityManager.DEBUG_ON((String)"__PINT__")) {
            SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)(" encrypting with v2encrypt=" + v2Encrypt + plainTxtUserPassword + " to " + hexString), (Throwable)new Throwable());
        }
        return hexString;
    }

    protected String substitutePassword(String userName, String password, Properties info, boolean databaseUser) {
        MessageDigest messageDigest = null;
        String ID_PATTERN_NEW_SCHEME = ID_PATTERN_NEW_SCHEME_V1;
        byte[] SECMEC_USRSSBPWD_PWDSEQS = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] bytePasswd = null;
        byte[] userBytes = StringUtil.toHexByte(userName, 0, userName.length());
        SanityManager.ASSERT((info.getProperty("drdaSecTokenIn") != null && info.getProperty("drdaSecTokenOut") != null ? 1 : 0) != 0, (String)"Unexpected: Requester or server seed not available");
        String sourceSeedstr = info.getProperty("drdaSecTokenIn");
        String targetSeedstr = info.getProperty("drdaSecTokenOut");
        byte[] sourceSeed_ = StringUtil.fromHexString(sourceSeedstr, 0, sourceSeedstr.length());
        byte[] targetSeed_ = StringUtil.fromHexString(targetSeedstr, 0, targetSeedstr.length());
        String hexString = null;
        if (!databaseUser) {
            bytePasswd = StringUtil.toHexByte(password, 0, password.length());
            messageDigest.update(bytePasswd);
            byte[] encryptVal = messageDigest.digest();
            hexString = ID_PATTERN_NEW_SCHEME + StringUtil.toHexString(encryptVal, 0, encryptVal.length);
        } else {
            hexString = password;
        }
        messageDigest.update(userBytes);
        messageDigest.update(StringUtil.toHexByte(hexString, 0, hexString.length()));
        byte[] passwordToken = messageDigest.digest();
        messageDigest.update(passwordToken);
        messageDigest.update(targetSeed_);
        messageDigest.update(sourceSeed_);
        messageDigest.update(userBytes);
        messageDigest.update(SECMEC_USRSSBPWD_PWDSEQS);
        byte[] passwordSubstitute = messageDigest.digest();
        return StringUtil.toHexString(passwordSubstitute, 0, passwordSubstitute.length);
    }

    public static void setPeerAuthenticationService(AuthenticationServiceBase service) {
        peerAuthenticationService = service;
    }

    public static void setIsShuttingDown(boolean isClosing) {
        if (peerAuthenticationService != null) {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"security-warning:TraceAuthentication", (String)" Shutting down authentication module. ");
            }
            AuthenticationServiceBase.peerAuthenticationService.isShuttingDown = isClosing;
        }
    }

    public static void refreshAuthenticationServices(FabricDatabase serviceModule, AccessFactory accessfactory, PropertyFactory propertyfactory, Properties startParams) throws StandardException {
        AuthenticationServiceBase peerAuthService = peerAuthenticationService;
        peerAuthService.store = accessfactory;
        peerAuthService.securitylogger = Misc.getGemFireCache().getSecurityLoggerI18n();
        AuthenticationServiceBase localAuthService = (AuthenticationServiceBase)Monitor.findServiceModule(serviceModule, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "authentication");
        propertyfactory.addPropertySetNotification(localAuthService);
        localAuthService.store = accessfactory;
        localAuthService.securitylogger = peerAuthService.securitylogger;
        String authStatus = null;
        try {
            authStatus = peerAuthService.authenticate("gemfirexd", startParams);
        }
        catch (SQLException cause) {
            throw StandardException.newException("08004.C.1", (Throwable)cause, (Object)("Authentication failed with exception " + cause));
        }
        if (authStatus != null) {
            String userName = startParams.getProperty("user");
            userName = userName == null ? startParams.getProperty("UserName") : userName;
            String userDefinition = PropertyUtil.getSystemProperty("gemfirexd.__rt.system-user-id");
            if (userDefinition != null && PropertyUtil.getSystemProperty(userDefinition) == null) {
                PropertyUtil.clearSystemProperty(userDefinition);
                PropertyUtil.clearSystemProperty("gemfirexd.__rt.system-user-id");
            }
            if (peerAuthService.securitylogger.infoEnabled()) {
                peerAuthService.securitylogger.convertToLogWriter().info("Second phase authentication failed for user '" + userName + "': " + authStatus);
            }
            throw StandardException.newException("08004.C.1", (Throwable)new AuthenticationFailedException("Authentication failed for " + GemFireStore.getMyId() + ": " + authStatus), (Object)authStatus);
        }
    }

    public static void cleanupOnError(FabricDatabase fabricDatabase, GemFireStore memStore, PropertyFactory pf) {
        String userDefinition = PropertyUtil.getSystemProperty("gemfirexd.__rt.system-user-id");
        if (userDefinition != null) {
            PropertyUtil.clearSystemProperty(userDefinition);
            PropertyUtil.clearSystemProperty("gemfirexd.__rt.system-user-id");
        }
    }

    public static AuthenticationServiceBase getPeerAuthenticationService() {
        AuthenticationServiceBase peerAuthService = peerAuthenticationService;
        if (peerAuthService == null) {
            NoneAuthenticationServiceImpl noneAuthService = new NoneAuthenticationServiceImpl();
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"security-warning:TraceAuthentication", (String)" Using NONE authentication ... ");
            }
            peerAuthService = noneAuthService;
            peerAuthService.isPeerAuthenticationService = true;
        }
        if (peerAuthService == null || !Authenticator.class.isAssignableFrom(peerAuthService.getClass()) || !AuthInitialize.class.isAssignableFrom(peerAuthService.getClass())) {
            SanityManager.THROWASSERT((String)("AuthenticationService (" + peerAuthService.getClass() + ") is not compatible with GemFire interfaces "));
        }
        return peerAuthService;
    }

    public Properties getCredentials(Properties securityProps, DistributedMember server, boolean isPeer) throws AuthenticationFailedException {
        assert (isPeer == this.isPeerAuthenticationService) : this + " service shouldn't be used for something else other than peer authentication ";
        Properties credentials = null;
        if (this.authenticationScheme instanceof CredentialInitializer) {
            credentials = SecurityUtils.transformGemFireToGFXDProperties(securityProps);
            if (this.securitylogger != null && this.securitylogger.fineEnabled()) {
                StringPrintWriter spw = new StringPrintWriter();
                GemFireXDUtils.dumpProperties(securityProps, "transforming GemFire Properties ", AuthenticationTrace, true, (PrintWriter)spw);
                GemFireXDUtils.dumpProperties(credentials, " to GFXD Properties ", AuthenticationTrace, true, (PrintWriter)spw);
                this.securitylogger.fine(spw.toString());
            }
            try {
                credentials = ((CredentialInitializer)((Object)this.authenticationScheme)).getCredentials(credentials);
            }
            catch (Exception cause) {
                this.securitylogger.warning(LocalizedStrings.ONE_ARG, new Object[]{"Exception in acquiring credentials with authentication scheme: " + this.authenticationScheme}, (Throwable)cause);
                throw new AuthenticationFailedException("Error getting credentials: " + cause, (Throwable)cause);
            }
        } else {
            if (this.securitylogger != null) {
                this.securitylogger.warning(LocalizedStrings.Gfxd_AUTHENTICATION__NO_CREDENTIAL_INITIALIZER, (Object[])new String[]{CredentialInitializer.class.getCanonicalName(), SecurityUtils.GFXD_SEC_PREFIX, UserAuthenticator.class.getCanonicalName()});
            }
            credentials = SecurityUtils.trimOffGemFireProperties(securityProps);
        }
        if (credentials == null) {
            this.securitylogger.warning(LocalizedStrings.ONE_ARG, new Object[]{"Couldn't locate credentials with authentication scheme: " + this.authenticationScheme + securityProps});
            throw new AuthenticationFailedException("Null credentials not allowed");
        }
        GemFireXDUtils.dumpProperties(credentials, "authentication credentials", AuthenticationTrace, GemFireXDUtils.TraceAuthentication, null);
        if (this.bootCredentials.isEmpty()) {
            this.bootCredentials.putAll((Map<?, ?>)credentials);
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("AuthenticationServiceBase: storing boot credentials of size " + this.bootCredentials.size()));
            }
        }
        return credentials;
    }

    public void init(LogWriter systemLogger, LogWriter securityLogger) throws AuthenticationFailedException {
        if (this.securitylogger == null) {
            this.securitylogger = securityLogger.convertToLogWriterI18n();
        }
    }

    public void close() {
    }

    public Principal authenticate(Properties props, DistributedMember member) throws AuthenticationFailedException {
        if (this.isShuttingDown) {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"security-warning:TraceAuthentication", (String)"VM is shutting down, so skip authentication");
            }
            return null;
        }
        String authStatus = null;
        try {
            GemFireXDUtils.dumpProperties(props, "connection authentication for " + member + " with ", AuthenticationTrace, GemFireXDUtils.TraceAuthentication, null);
            authStatus = this.authenticate("gemfirexd", props);
        }
        catch (Throwable cause) {
            StringBuilder sb = new StringBuilder("Exception in getting credentials of user for ");
            sb.append(member).append(".");
            if (this.authenticationScheme instanceof BasicAuthenticationServiceImpl) {
                sb.append(GemFireXDUtils.dumpProperties(props, " Properties : ", AuthenticationTrace, true, (PrintWriter)new StringPrintWriter()).toString());
            }
            if (this.securitylogger != null) {
                sb.append(". Exception : ").append(cause);
                this.securitylogger.warning(LocalizedStrings.ONE_ARG, (Object)sb.toString(), cause);
            } else {
                sb.append(". Exception : ").append(cause);
                SanityManager.DEBUG_PRINT((String)"security-warning:TraceAuthentication", (String)sb.toString(), (Throwable)cause);
            }
            Misc.throwIfCacheNotClosed((RuntimeException)new AuthenticationFailedException("Authentication failed for " + member + " with " + cause, cause));
        }
        if (authStatus != null) {
            String val = "undefined value";
            String userName = props.getProperty("user");
            String string = userName = userName == null ? props.getProperty("UserName") : userName;
            if (userName != null) {
                try {
                    userName = IdUtil.getUserAuthorizationId(userName);
                }
                catch (StandardException se) {
                    throw new AuthenticationFailedException(se.getMessage());
                }
            }
            if (this.authenticationScheme instanceof BasicAuthenticationServiceImpl && (val = this.getSystemProperty("gemfirexd.user." + userName)) == null) {
                val = this.getSystemProperty("sqlfire.user." + userName);
            }
            if (val == null && member == null) {
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("user not found. initiating second phase authentication for " + userName));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Rejecting credentials of user '").append(userName).append("' for ").append(member).append(": ").append(authStatus).append(".");
                if (this.authenticationScheme instanceof BasicAuthenticationServiceImpl) {
                    sb.append(" User Definition in this member is ").append(val);
                }
                if (this.securitylogger != null) {
                    this.securitylogger.warning(LocalizedStrings.ONE_ARG, (Object)sb.toString());
                } else {
                    SanityManager.DEBUG_PRINT((String)"security-warning:TraceAuthentication", (String)sb.toString());
                }
                throw new AuthenticationFailedException(authStatus);
            }
        }
        return null;
    }

    public void init(Properties securityProps, LogWriter systemLogger, LogWriter securityLogger) throws AuthenticationFailedException {
    }

    public UserAuthenticator getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public Properties getBootCredentials() {
        GemFireXDUtils.dumpProperties(this.bootCredentials, "AuthenticationServiceBase: returning cached boot credentials", AuthenticationTrace, GemFireXDUtils.TraceAuthentication, null);
        return this.bootCredentials;
    }

    public boolean checkAndSetSchemeSupported(String identifier, Properties properties, String scheme) {
        String peerAuthenticationProvider;
        String authenticationProvider;
        if (Monitor.reportOn) {
            SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("Checking support for scheme " + scheme + " with service " + identifier));
        }
        if ((authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "auth-provider")) == null) {
            authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "gemfirexd.auth-provider");
        }
        if (authenticationProvider == null) {
            authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "sqlfire.auth-provider");
        }
        if ((peerAuthenticationProvider = PropertyUtil.getPropertyFromSet(properties, "server-auth-provider")) == null) {
            peerAuthenticationProvider = PropertyUtil.getPropertyFromSet(properties, "gemfirexd.server-auth-provider");
        }
        if (peerAuthenticationProvider == null) {
            peerAuthenticationProvider = PropertyUtil.getPropertyFromSet(properties, "sqlfire.server-auth-provider");
        }
        if (Monitor.reportOn) {
            SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)(identifier + " authenticationProvider=" + authenticationProvider + " peerAuthenticationProvider=" + peerAuthenticationProvider));
        }
        if (authenticationProvider != null && authenticationProvider.length() > 0 || peerAuthenticationProvider != null && peerAuthenticationProvider.length() > 0) {
            properties.setProperty("gemfirexd.authentication.required", Boolean.TRUE.toString());
        } else {
            properties.setProperty("gemfirexd.authentication.required", Boolean.FALSE.toString());
        }
        if ((peerAuthenticationProvider == null || peerAuthenticationProvider.length() == 0) && authenticationProvider != null && authenticationProvider.length() > 0) {
            if (Monitor.reportOn) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("inheriting peer.authentication from authentication service to " + authenticationProvider));
            }
            properties.setProperty("server-auth-provider", authenticationProvider);
            peerAuthenticationProvider = authenticationProvider;
        }
        if (authenticationProvider != null && authenticationProvider.length() > 0 && !StringUtil.SQLEqualsIgnoreCase(authenticationProvider, "NONE") && PropertyUtil.getPropertyFromSet(properties, "gemfirexd.sql-authorization") == null && PropertyUtil.getSystemProperty("gemfirexd.sql-authorization") == null) {
            SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("Enabling authorization for auth provider " + authenticationProvider));
            PropertyUtil.setSystemProperty("gemfirexd.sql-authorization", "true");
        }
        if (identifier.equals("authentication")) {
            if (authenticationProvider == null || authenticationProvider.length() <= 0 || !StringUtil.SQLEqualsIgnoreCase(authenticationProvider, scheme)) {
                if (Monitor.reportOn) {
                    SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("authentication is NOT enabled with " + scheme + " auth provider is " + authenticationProvider));
                }
                return false;
            }
            if (Monitor.reportOn) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("authentication is enabled with " + scheme));
            }
            return true;
        }
        if (identifier.equals("peer.authentication")) {
            this.isPeerAuthenticationService = true;
            if (peerAuthenticationProvider == null || peerAuthenticationProvider.length() <= 0 || !StringUtil.SQLEqualsIgnoreCase(peerAuthenticationProvider, scheme)) {
                return false;
            }
            if (Monitor.reportOn) {
                SanityManager.DEBUG_PRINT((String)AuthenticationTrace, (String)("peer.authentication is enabled with " + scheme));
            }
            return true;
        }
        return false;
    }

    public static final boolean isSecurityProperty(String key, String value, Properties promoteToSystemProperties) throws SQLException {
        boolean retval = false;
        if (key.equalsIgnoreCase("gemfirexd.authentication.required") || key.equalsIgnoreCase("gemfirexd.auth-provider") || key.equalsIgnoreCase("gemfirexd.server-auth-provider") || key.equalsIgnoreCase("sqlfire.auth-provider") || key.equalsIgnoreCase("sqlfire.server-auth-provider")) {
            retval = false;
        }
        if (key.equalsIgnoreCase("gemfirexd.sql-authorization") || key.equalsIgnoreCase("gemfirexd.authz-default-connection-mode") || key.equalsIgnoreCase("gemfirexd.authz-read-only-access-users") || key.equalsIgnoreCase("gemfirexd.authz-full-access-users") || key.equalsIgnoreCase("gemfirexd.distributedsystem.propertiesOnly")) {
            retval = true;
        }
        if (key.toLowerCase().startsWith("gemfirexd.user.")) {
            retval = false;
            if (!AuthenticationServiceBase.isEncrypted(value)) {
                value = AuthenticationServiceBase.encryptUserPassword(key.substring("gemfirexd.user.".length()), value, true, false, true);
            }
        } else if (key.toLowerCase().startsWith("sqlfire.user.")) {
            retval = false;
            if (!AuthenticationServiceBase.isEncrypted(value)) {
                value = AuthenticationServiceBase.encryptUserPassword(key.substring("sqlfire.user.".length()), value, true, false, true);
            }
        } else if (key.equalsIgnoreCase("auth-provider")) {
            promoteToSystemProperties.setProperty("gemfirexd.authentication.required", "true");
            key = "gemfirexd.auth-provider";
            retval = false;
        } else if (key.equalsIgnoreCase("server-auth-provider")) {
            promoteToSystemProperties.setProperty("gemfirexd.authentication.required", "true");
            key = "gemfirexd.server-auth-provider";
            retval = false;
        }
        if (retval) {
            promoteToSystemProperties.setProperty(key, value);
        }
        return retval;
    }

    public static final Object maskProperty(String key, Object value) {
        if ((key = key.toLowerCase()).startsWith("gemfirexd.__rt.")) {
            return val;
        }
        if (key.startsWith("gemfirexd.user.") || key.startsWith("sqlfire.user.") || key.contains("password") || key.equals("gemfirexd.auth-ldap-search-pw") || key.equals("java.naming.security.credentials")) {
            return maskedvalue;
        }
        if ((key.contains("authenticator") || key.contains("auth-init")) && value != null) {
            if (NoneAuthenticationServiceImpl.AUTHFACTORYMETHOD.equals(value)) {
                return "NONE";
            }
            if (BasicAuthenticationServiceImpl.AUTHFACTORYMETHOD.equals(value)) {
                return "BUILTIN";
            }
            if (JNDIAuthenticationService.AUTHFACTORYMETHOD.equals(value)) {
                return "LDAP";
            }
        }
        return value;
    }

    public static final boolean isAuthenticationBUILTIN(AuthenticationService[] otherService) {
        FabricDatabase database = Misc.getMemStoreBooting().getDatabase();
        AuthenticationServiceBase authService = (AuthenticationServiceBase)Monitor.findServiceModule(database, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "peer.authentication");
        SanityManager.ASSERT((authService != null ? 1 : 0) != 0, (String)" couldn't find authentication service");
        if (authService instanceof BasicAuthenticationServiceImpl) {
            return true;
        }
        if ((authService == null || authService instanceof NoneAuthenticationServiceImpl) && (authService = (AuthenticationServiceBase)Monitor.findServiceModule(database, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "authentication")) instanceof BasicAuthenticationServiceImpl) {
            return true;
        }
        if (otherService != null) {
            otherService[0] = authService;
        }
        return false;
    }

    public static final void validateUserPassword(String user, String password, boolean passwordOptional) throws SQLException {
        StandardException se = null;
        if (user == null) {
            se = StandardException.newException("08001.C.7");
        } else if (!passwordOptional && password == null) {
            se = StandardException.newException("08001.C.8");
        } else if (PropertyUtil.whereSet(user, null) == 0) {
            se = StandardException.newException("28503", user);
        }
        if (se != null) {
            throw PublicAPI.wrapStandardException(se);
        }
    }
}

