/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class BinaryToRawStream
extends FilterInputStream {
    private int length;
    private Object parent;

    BinaryToRawStream(InputStream in, Object parent) throws IOException {
        super(in);
        this.parent = parent;
        int bl = in.read();
        if (bl == -1) {
            throw new EOFException();
        }
        if ((bl & 0x80) != 0) {
            if (bl == 192) {
                int v1 = in.read();
                int v2 = in.read();
                int v3 = in.read();
                int v4 = in.read();
                if (v1 == -1 || v2 == -1 || v3 == -1 || v4 == -1) {
                    throw new EOFException();
                }
                this.length = (v1 & 0xFF) << 24 | (v2 & 0xFF) << 16 | (v3 & 0xFF) << 8 | v4 & 0xFF;
            } else if (bl == 160) {
                int v1 = in.read();
                int v2 = in.read();
                if (v1 == -1 || v2 == -1) {
                    throw new EOFException();
                }
                this.length = ((v1 & 0xFF) << 8) + (v2 & 0xFF);
            } else {
                this.length = bl & 0x1F;
            }
        } else {
            int v2 = in.read();
            int v3 = in.read();
            int v4 = in.read();
            if (v2 == -1 || v3 == -1 || v4 == -1) {
                throw new EOFException();
            }
            int lenInBits = (bl & 0xFF) << 24 | (v2 & 0xFF) << 16 | (v3 & 0xFF) << 8 | v4 & 0xFF;
            this.length = lenInBits / 8;
            if (lenInBits % 8 != 0) {
                ++this.length;
            }
            if (this.length == 0) {
                this.length = -1;
            }
        }
    }

    int getLength() {
        return this.length;
    }
}

