/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.io;

import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import com.pivotal.gemfirexd.internal.io.StorageFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.File;
import java.io.IOException;

abstract class BaseStorageFactory
implements StorageFactory {
    String home;
    protected StorageFile tempDir;
    protected String tempDirPath;
    protected String dataDirectory;
    protected String separatedDataDirectory;
    protected String uniqueName;
    protected String canonicalName;
    private static final String TEMP_DIR_PREFIX = "derbytmp_";

    BaseStorageFactory() {
    }

    @Override
    public void init(String home, String databaseName, String tempDirName, String uniqueName) throws IOException {
        if (databaseName != null) {
            this.dataDirectory = databaseName;
            this.separatedDataDirectory = databaseName + this.getSeparator();
        }
        this.home = home;
        this.uniqueName = uniqueName;
        this.tempDirPath = tempDirName;
        this.doInit();
    }

    abstract void doInit() throws IOException;

    @Override
    public void shutdown() {
    }

    @Override
    public String getCanonicalName() throws IOException {
        return this.canonicalName;
    }

    @Override
    public StorageFile newStorageFile(String path) {
        if (path != null && this.tempDirPath != null && path.startsWith(this.tempDirPath)) {
            return new DirFile(path);
        }
        return this.newPersistentFile(path);
    }

    @Override
    public StorageFile newStorageFile(String directoryName, String fileName) {
        if (directoryName == null) {
            return this.newStorageFile(fileName);
        }
        if (this.tempDirPath != null && directoryName.startsWith(this.tempDirPath)) {
            return new DirFile(directoryName, fileName);
        }
        return this.newPersistentFile(directoryName, fileName);
    }

    @Override
    public StorageFile newStorageFile(StorageFile directoryName, String fileName) {
        if (directoryName == null) {
            return this.newStorageFile(fileName);
        }
        if (fileName == null) {
            return directoryName;
        }
        if (this.tempDirPath != null && directoryName.getPath().startsWith(this.tempDirPath)) {
            return new DirFile((DirFile)directoryName, fileName);
        }
        return this.newPersistentFile(directoryName, fileName);
    }

    abstract StorageFile newPersistentFile(String var1);

    abstract StorageFile newPersistentFile(String var1, String var2);

    abstract StorageFile newPersistentFile(StorageFile var1, String var2);

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public StorageFile getTempDir() {
        return this.tempDir;
    }

    @Override
    public boolean isFast() {
        return false;
    }

    @Override
    public boolean isReadOnlyDatabase() {
        return true;
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }

    void createTempDir() throws IOException {
        if (this.uniqueName == null) {
            return;
        }
        this.tempDir = this.tempDirPath != null ? new DirFile(this.tempDirPath, TEMP_DIR_PREFIX.concat(this.uniqueName)) : (this.isReadOnlyDatabase() ? new DirFile(this.readOnlyTempRoot(), TEMP_DIR_PREFIX.concat(this.uniqueName)) : new DirFile(this.canonicalName, "tmp"));
        this.tempDir.deleteAll();
        this.tempDir.mkdirs();
        this.tempDirPath = this.tempDir.getPath();
    }

    private String readOnlyTempRoot() throws IOException {
        File temp = File.createTempFile("derby", "tmp");
        String parent = temp.getParent();
        temp.delete();
        return parent;
    }

    @Override
    public int getStorageFactoryVersion() {
        return 1;
    }

    @Override
    public StorageFile createTemporaryFile(String prefix, String suffix) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix, new File(this.getTempDir().getPath()));
        return this.newStorageFile(this.getTempDir(), tmpFile.getName());
    }
}

