/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.spark.unsafe.Platform;

public final class SQLBoolean
extends DataType
implements BooleanDataValue {
    static final int BOOLEAN_LENGTH = 1;
    private static final SQLBoolean BOOLEAN_TRUE = new SQLBoolean(true);
    private static final SQLBoolean BOOLEAN_FALSE = new SQLBoolean(false);
    static final SQLBoolean UNKNOWN = new SQLBoolean();
    private static final int BASE_MEMORY_USAGE;
    private boolean value;
    private boolean isnull;
    private boolean immutable;

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    private static int makeInt(boolean b) {
        return b ? 1 : 0;
    }

    @Override
    public byte getByte() {
        return (byte)SQLBoolean.makeInt(this.value);
    }

    @Override
    public short getShort() {
        return (short)SQLBoolean.makeInt(this.value);
    }

    @Override
    public int getInt() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public long getLong() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public float getFloat() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public double getDouble() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public int typeToBigDecimal() {
        return -5;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public final String getTypeName() {
        return "BOOLEAN";
    }

    @Override
    public DataValueDescriptor recycle() {
        if (this.immutable) {
            return new SQLBoolean();
        }
        return super.recycle();
    }

    @Override
    public int getTypeFormatId() {
        return 77;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeBoolean(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = in.readBoolean();
        this.isnull = false;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = in.readBoolean();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = false;
        this.isnull = true;
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return 1;
            }
            if (!otherNull) {
                return -1;
            }
            return 0;
        }
        boolean otherValue = false;
        boolean thisValue = this.getBoolean();
        if (thisValue == (otherValue = other.getBoolean())) {
            return 0;
        }
        if (thisValue && !otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLBoolean(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBoolean();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getBoolean(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -7);
            return;
        }
        ps.setBoolean(position, this.value);
    }

    public SQLBoolean() {
        this.isnull = true;
    }

    public SQLBoolean(boolean val) {
        this.value = val;
    }

    public SQLBoolean(Boolean obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    private SQLBoolean(boolean val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    @Override
    public void setValue(boolean theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(Boolean theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.value = false;
            this.isnull = true;
        } else {
            this.value = theValue;
            this.isnull = false;
        }
    }

    @Override
    public void setValue(byte theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    @Override
    public void setValue(short theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0L;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0.0f;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0.0;
        this.isnull = false;
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        if (bigDecimal == null) {
            this.value = false;
            this.isnull = true;
        } else {
            DataValueDescriptor tempDecimal = NumberDataType.ZERO_DECIMAL.getNewNull();
            tempDecimal.setBigDecimal(bigDecimal);
            this.value = NumberDataType.ZERO_DECIMAL.compare(tempDecimal) != 0;
            this.isnull = false;
        }
    }

    @Override
    public void setValue(byte[] theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        if (theValue != null) {
            this.isnull = false;
            int length = theValue.length;
            for (int i = 0; i < length; ++i) {
                if (theValue[i] == 0) continue;
                this.value = true;
                return;
            }
        } else {
            this.isnull = true;
        }
        this.value = false;
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.value = false;
            this.isnull = true;
        } else {
            this.value = SQLBoolean.getBoolean(theValue);
            this.isnull = false;
            this.isnull = false;
        }
    }

    private void setValueCore(Number theValue) {
        SanityManager.ASSERT((!this.immutable ? 1 : 0) != 0, (String)"Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.isnull = true;
            this.value = false;
        } else {
            this.value = theValue.intValue() != 0;
            this.isnull = false;
        }
    }

    @Override
    void setObject(Object theValue) {
        this.setValue((Boolean)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getBoolean());
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getBoolean() == right.getBoolean());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getBoolean() != right.getBoolean());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, !leftBoolean && rightBoolean);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, leftBoolean && !rightBoolean);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, !leftBoolean || rightBoolean);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, leftBoolean || !rightBoolean);
    }

    @Override
    public BooleanDataValue and(BooleanDataValue otherValue) {
        if (this.equals(false) || otherValue.equals(false)) {
            return BOOLEAN_FALSE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)otherValue, this.getBoolean() && otherValue.getBoolean());
    }

    @Override
    public BooleanDataValue or(BooleanDataValue otherValue) {
        if (this.equals(true) || otherValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)otherValue, this.getBoolean() || otherValue.getBoolean());
    }

    @Override
    public BooleanDataValue is(BooleanDataValue otherValue) {
        if (this.equals(true) && otherValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        if (this.equals(false) && otherValue.equals(false)) {
            return BOOLEAN_TRUE;
        }
        if (this.isNull() && otherValue.isNull()) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    @Override
    public BooleanDataValue isNot(BooleanDataValue otherValue) {
        BooleanDataValue isValue = this.is(otherValue);
        if (isValue.equals(true)) {
            return BOOLEAN_FALSE;
        }
        return BOOLEAN_TRUE;
    }

    @Override
    public BooleanDataValue throwExceptionIfFalse(String sqlState, String tableName, String constraintName) throws StandardException {
        if (!this.isNull() && !this.value) {
            throw StandardException.newException(sqlState, (Object)tableName, (Object)constraintName);
        }
        return this;
    }

    @Override
    public int typePrecedence() {
        return 130;
    }

    public static SQLBoolean truthValue(DataValueDescriptor leftOperand, DataValueDescriptor rightOperand, boolean truth) {
        if (leftOperand.isNull() || rightOperand.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        if (truth) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(DataValueDescriptor leftOperand, DataValueDescriptor rightOperand, Boolean truth) {
        if (leftOperand.isNull() || rightOperand.isNull() || truth == null) {
            return SQLBoolean.unknownTruthValue();
        }
        if (truth == Boolean.TRUE) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(boolean value) {
        if (value) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean unknownTruthValue() {
        return UNKNOWN;
    }

    public static SQLBoolean falseTruthValue() {
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean trueTruthValue() {
        return BOOLEAN_TRUE;
    }

    @Override
    public boolean equals(boolean val) {
        if (this.isNull()) {
            return false;
        }
        return this.value == val;
    }

    @Override
    public BooleanDataValue getImmutable() {
        if (this.isNull()) {
            return UNKNOWN;
        }
        return this.value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.isNull()) {
            return -1;
        }
        return this.value ? 1 : 0;
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            out.writeBoolean(this.value);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.value = dis.readBoolean();
        this.isnull = false;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeBoolean(this.value);
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        outBytes[offset] = this.value ? (byte)1 : 0;
        return 1;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        assert (columnWidth == 1) : columnWidth;
        this.value = inBytes[offset] == 1;
        this.isnull = false;
        return 1;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        assert (columnWidth == 1) : columnWidth;
        this.value = Platform.getByte(null, (long)memOffset) == 1;
        this.isnull = false;
        return 1;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        return ResolverUtils.addByteToBucketHash((byte)(this.value ? (byte)1 : 0), (int)hash, (int)this.getTypeFormatId());
    }

    public static boolean getBoolean(String theValue) throws StandardException {
        String cleanedValue = theValue.trim();
        if (cleanedValue.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (cleanedValue.equalsIgnoreCase("FALSE")) {
            return false;
        }
        if (cleanedValue.length() == 1) {
            switch (cleanedValue.charAt(0)) {
                case '0': {
                    return false;
                }
                case '1': {
                    return true;
                }
            }
            throw StandardException.newException("22018", (Object)"BOOLEAN", (Object)null);
        }
        throw StandardException.newException("22018", (Object)"BOOLEAN", (Object)null);
    }

    static final boolean getAsBoolean(byte[] inBytes, int offset) {
        return inBytes[offset] == 1;
    }

    static final boolean getAsBoolean(UnsafeWrapper unsafe, long memOffset) {
        return unsafe.getByte(memOffset) == 1;
    }

    @Override
    public byte getTypeId() {
        return 53;
    }

    static {
        SQLBoolean.BOOLEAN_TRUE.immutable = true;
        SQLBoolean.BOOLEAN_FALSE.immutable = true;
        SQLBoolean.UNKNOWN.immutable = true;
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBoolean.class);
    }
}

