/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.db.DatabaseContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.io.RegisteredFormatIds;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BitDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.JSON;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.RefDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBlob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongVarbit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLRef;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarbit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapRowLocation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Properties;

abstract class DataValueFactoryImpl
implements DataValueFactory,
ModuleControl {
    LocaleFinder localeFinder;
    private Locale databaseLocale;
    private RuleBasedCollator collatorForCharacterTypes;

    DataValueFactoryImpl() {
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void boot(boolean create, Properties properties) throws StandardException {
        int collationType;
        String userDefinedCollation;
        DataValueDescriptor decimalImplementation;
        TypeId.decimalImplementation = decimalImplementation = this.getNullDecimal(null);
        RegisteredFormatIds.TwoByte[200] = decimalImplementation.getClass().getName();
        if (NumberDataType.ZERO_DECIMAL == null) {
            decimalImplementation = decimalImplementation.getNewNull();
            decimalImplementation.setValue(0L);
            NumberDataType.ZERO_DECIMAL = decimalImplementation;
        }
        FabricDatabase database = (FabricDatabase)properties.get(FabricDatabase.PROPERTY_NAME);
        this.databaseLocale = database.getLocale();
        if (create && (userDefinedCollation = properties.getProperty("collation")) != null && (collationType = DataTypeDescriptor.getCollationType(userDefinedCollation)) != 0) {
            if (collationType >= 1 && collationType < 5) {
                int strength = collationType - 2;
                this.collatorForCharacterTypes = this.verifyCollatorSupport(strength);
            } else {
                throw StandardException.newException("XBM03.D", userDefinedCollation);
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public NumberDataValue getDataValue(int value) {
        return new SQLInteger(value);
    }

    @Override
    public NumberDataValue getDataValue(int value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Integer value) {
        if (value != null) {
            return new SQLInteger((int)value);
        }
        return new SQLInteger();
    }

    @Override
    public NumberDataValue getDataValue(Integer value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(char value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(short value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLSmallint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Short value) {
        if (value != null) {
            return new SQLSmallint(value);
        }
        return new SQLSmallint();
    }

    @Override
    public NumberDataValue getDataValue(Short value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(byte value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTinyint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Byte value) {
        if (value != null) {
            return new SQLTinyint(value);
        }
        return new SQLTinyint();
    }

    @Override
    public NumberDataValue getDataValue(Byte value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(long value) {
        return new SQLLongint(value);
    }

    @Override
    public NumberDataValue getDataValue(long value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Long value) {
        if (value != null) {
            return new SQLLongint((long)value);
        }
        return new SQLLongint();
    }

    @Override
    public NumberDataValue getDataValue(Long value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(float value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLReal(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Float value) throws StandardException {
        if (value != null) {
            return new SQLReal(value.floatValue());
        }
        return new SQLReal();
    }

    @Override
    public NumberDataValue getDataValue(Float value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(double value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDouble(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Double value) throws StandardException {
        if (value != null) {
            return new SQLDouble((double)value);
        }
        return new SQLDouble();
    }

    @Override
    public NumberDataValue getDataValue(Double value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public final NumberDataValue getDecimalDataValue(Number value) throws StandardException {
        NumberDataValue ndv = this.getNullDecimal(null);
        ndv.setValue(value);
        return ndv;
    }

    @Override
    public final NumberDataValue getDecimalDataValue(Number value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDecimalDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public final NumberDataValue getDecimalDataValue(String value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDecimalDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BooleanDataValue getDataValue(boolean value) {
        return new SQLBoolean(value);
    }

    @Override
    public BooleanDataValue getDataValue(boolean value, BooleanDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBoolean(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BooleanDataValue getDataValue(Boolean value) {
        if (value != null) {
            return new SQLBoolean((boolean)value);
        }
        return new SQLBoolean();
    }

    @Override
    public BooleanDataValue getDataValue(Boolean value, BooleanDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BooleanDataValue getDataValue(BooleanDataValue value) {
        if (value != null) {
            return value;
        }
        return new SQLBoolean();
    }

    @Override
    public BitDataValue getBitDataValue(byte[] value) throws StandardException {
        return new SQLBit(value);
    }

    @Override
    public BitDataValue getBitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBit(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getVarbitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLVarbit(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getLongVarbitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongVarbit(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getBlobDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBlob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getBlobDataValue(Blob value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBlob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getCharDataValue(String value) {
        return new SQLChar(value);
    }

    @Override
    public StringDataValue getCharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLChar(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getCharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getCharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLChar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getVarcharDataValue(String value) {
        return new SQLVarchar(value);
    }

    @Override
    public StringDataValue getVarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLVarchar(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getVarcharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getVarcharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLVarchar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getLongvarcharDataValue(String value) {
        return new SQLLongvarchar(value);
    }

    @Override
    public StringDataValue getLongvarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongvarchar(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getLongvarcharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getLongvarcharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLLongvarchar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getClobDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLClob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getClobDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getClobDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getJSONDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new JSON(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getJSONDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        return this.getJSONDataValue(value, previous);
    }

    @Override
    public DateTimeDataValue getDataValue(Date value) throws StandardException {
        return new SQLDate(value);
    }

    @Override
    public DateTimeDataValue getDataValue(Date value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDate(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDataValue(Time value) throws StandardException {
        return new SQLTime(value);
    }

    @Override
    public DateTimeDataValue getDataValue(Time value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTime(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDataValue(Timestamp value) throws StandardException {
        return new SQLTimestamp(value);
    }

    @Override
    public DateTimeDataValue getDataValue(Timestamp value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTimestamp(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDate(DataValueDescriptor operand) throws StandardException {
        return SQLDate.computeDateFunction(operand, this);
    }

    @Override
    public DateTimeDataValue getTimestamp(DataValueDescriptor operand) throws StandardException {
        return SQLTimestamp.computeTimestampFunction(operand, this);
    }

    @Override
    public DateTimeDataValue getTimestamp(DataValueDescriptor date, DataValueDescriptor time) throws StandardException {
        return new SQLTimestamp(date, time);
    }

    @Override
    public UserDataValue getDataValue(Object value) {
        return new UserType(value);
    }

    @Override
    public UserDataValue getDataValue(Object value, UserDataValue previous) {
        if (previous == null) {
            return new UserType(value);
        }
        ((UserType)previous).setValue(value);
        return previous;
    }

    @Override
    public RefDataValue getDataValue(RowLocation value, RefDataValue previous) {
        if (previous == null) {
            return new SQLRef(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getNullInteger(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLInteger();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullShort(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLSmallint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullLong(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLLongint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullByte(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLTinyint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullFloat(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLReal();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullDouble(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLDouble();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BooleanDataValue getNullBoolean(BooleanDataValue dataValue) {
        if (dataValue == null) {
            return new SQLBoolean();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullBit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return this.getBitDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullVarbit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLVarbit();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullLongVarbit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLLongVarbit();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullBlob(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLBlob();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullChar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getCharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullChar(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLChar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullVarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getVarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullVarchar(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLVarchar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullLongvarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getLongvarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullLongvarchar(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLLongvarchar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullClob(StringDataValue dataValue) {
        if (dataValue == null) {
            return new SQLClob();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullClob(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullJSON(StringDataValue dataValue) {
        if (dataValue == null) {
            return new JSON();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullJSON(StringDataValue previous, int collationType) throws StandardException {
        return this.getNullJSON(null);
    }

    @Override
    public UserDataValue getNullObject(UserDataValue dataValue) {
        if (dataValue == null) {
            return this.getDataValue((Object)null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public RefDataValue getNullRef(RefDataValue dataValue) {
        if (dataValue == null) {
            return new SQLRef();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getNullDate(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return this.getDataValue((Date)null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)"Could not get a null date.", (Throwable)se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getNullTime(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return this.getDataValue((Time)null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)"Could not get a null time.", (Throwable)se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getNullTimestamp(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return this.getDataValue((Timestamp)null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)"Could not get a null timestamp.", (Throwable)se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getDateValue(String dateStr, boolean isJdbcEscape) throws StandardException {
        return new SQLDate(dateStr, isJdbcEscape, this.getLocaleFinder());
    }

    @Override
    public DateTimeDataValue getTimeValue(String timeStr, boolean isJdbcEscape) throws StandardException {
        return new SQLTime(timeStr, isJdbcEscape, this.getLocaleFinder());
    }

    @Override
    public DateTimeDataValue getTimestampValue(String timestampStr, boolean isJdbcEscape) throws StandardException {
        return new SQLTimestamp(timestampStr, isJdbcEscape, this.getLocaleFinder());
    }

    @Override
    public XMLDataValue getXMLDataValue(XMLDataValue previous) throws StandardException {
        return this.getNullXML(previous);
    }

    @Override
    public XMLDataValue getNullXML(XMLDataValue dataValue) {
        if (dataValue == null) {
            return new XML();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public RuleBasedCollator getCharacterCollator(int collationType) throws StandardException {
        if (collationType == 0) {
            return null;
        }
        if (this.collatorForCharacterTypes == null) {
            int strength = collationType - 2;
            this.collatorForCharacterTypes = this.verifyCollatorSupport(strength);
            return this.collatorForCharacterTypes;
        }
        return this.collatorForCharacterTypes;
    }

    private RuleBasedCollator verifyCollatorSupport(int strength) throws StandardException {
        Locale[] availLocales = Collator.getAvailableLocales();
        boolean localeFound = false;
        for (int i = 0; i < availLocales.length; ++i) {
            if (!availLocales[i].equals(this.databaseLocale)) continue;
            localeFound = true;
            break;
        }
        if (!localeFound) {
            throw StandardException.newException("XBM04.D", this.databaseLocale != null ? this.databaseLocale.toString() : "null");
        }
        RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance(this.databaseLocale);
        if (strength != -1) {
            collator.setStrength(strength);
        }
        return collator;
    }

    @Override
    public DataValueDescriptor getNull(int formatId, int collationType) throws StandardException {
        if (formatId == 200) {
            return this.getNullDecimal(null);
        }
        DataValueDescriptor returnDVD = DataValueFactoryImpl.getNullDVDWithUCS_BASICcollation(formatId);
        if (collationType == 0) {
            return returnDVD;
        }
        if (returnDVD instanceof StringDataValue) {
            return ((StringDataValue)returnDVD).getValue(this.getCharacterCollator(collationType));
        }
        return returnDVD;
    }

    public static DataValueDescriptor getNullDVDWithUCS_BASICcollation(int formatId) {
        switch (formatId) {
            case 87: {
                return new SQLBit();
            }
            case 77: {
                return new SQLBoolean();
            }
            case 78: {
                return new SQLChar();
            }
            case 298: {
                return new SQLDate();
            }
            case 79: {
                return new SQLDouble();
            }
            case 80: {
                return new SQLInteger();
            }
            case 84: {
                return new SQLLongint();
            }
            case 81: {
                return new SQLReal();
            }
            case 82: {
                return new SQLRef();
            }
            case 83: {
                return new SQLSmallint();
            }
            case 299: {
                return new SQLTime();
            }
            case 31: {
                return new SQLTimestamp();
            }
            case 199: {
                return new SQLTinyint();
            }
            case 85: {
                return new SQLVarchar();
            }
            case 235: {
                return new SQLLongvarchar();
            }
            case 88: {
                return new SQLVarbit();
            }
            case 234: {
                return new SQLLongVarbit();
            }
            case 266: {
                return new UserType();
            }
            case 443: {
                return new SQLBlob();
            }
            case 447: {
                return new SQLClob();
            }
            case 478: {
                return new JSON();
            }
            case 458: {
                return new XML();
            }
            case 90: {
                return new HeapRowLocation();
            }
            case 96: {
                return DUMMY;
            }
        }
        return null;
    }

    private LocaleFinder getLocaleFinder() {
        DatabaseContext dc;
        if (this.localeFinder == null && (dc = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = dc.getDatabase();
        }
        return this.localeFinder;
    }

    @Override
    public UserDataValue getNullDVDSet(UserDataValue dataValue) {
        if (dataValue != null && !DVDSet.class.isInstance(dataValue)) {
            SanityManager.THROWASSERT((String)("UserDataValue is not of DVDList type " + dataValue.getClass().getName()));
        }
        if (dataValue == null) {
            return new DVDSet(6);
        }
        dataValue.setToNull();
        return dataValue;
    }
}

