/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

public class RoleDescriptor
extends TupleDescriptor {
    private final UUID uuid;
    private final String roleName;
    private final String grantee;
    private final String grantor;
    private boolean withAdminOption;
    private final boolean isDef;

    RoleDescriptor(DataDictionary dd, UUID uuid, String roleName, String grantee, String grantor, boolean withAdminOption, boolean isDef) {
        super(dd);
        this.uuid = uuid;
        this.roleName = roleName;
        this.grantee = grantee;
        this.grantor = grantor;
        this.withAdminOption = withAdminOption;
        this.isDef = isDef;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public boolean isDef() {
        return this.isDef;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isWithAdminOption() {
        return this.withAdminOption;
    }

    public void setWithAdminOption(boolean b) {
        this.withAdminOption = b;
    }

    public String toString() {
        return "uuid: " + this.uuid + "\nroleName: " + this.roleName + "\ngrantor: " + this.grantor + "\ngrantee: " + this.grantee + "\nwithadminoption: " + this.withAdminOption + "\nisDef: " + this.isDef + "\n";
    }

    @Override
    public String getDescriptorType() {
        return "Role";
    }

    @Override
    public String getDescriptorName() {
        return this.roleName + " " + this.grantor + " " + this.grantee;
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.dropRoleDescriptor(this.roleName, this.grantee, this.grantor, tc);
    }
}

