/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.VersionedDataSerializable;
import com.gemstone.gemfire.internal.shared.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SnappyRegionStats
implements VersionedDataSerializable {
    private boolean isColumnTable = false;
    private String tableName;
    private long rowCount = 0L;
    private long sizeInMemory = 0L;
    private long totalSize = 0L;
    private boolean isReplicatedTable = false;
    private int bucketCount;
    private static Version[] serializationVersions = new Version[]{Version.STORE_162};

    public SnappyRegionStats() {
    }

    public SnappyRegionStats(String tableName) {
        this.tableName = tableName;
    }

    public SnappyRegionStats(String tableName, long totalSize, long sizeInMemory, long rowCount, boolean isColumnTable, boolean isReplicatedTable, int bucketCount) {
        this.tableName = tableName;
        this.totalSize = totalSize;
        this.sizeInMemory = sizeInMemory;
        this.rowCount = rowCount;
        this.isColumnTable = isColumnTable;
        this.isReplicatedTable = isReplicatedTable;
        this.bucketCount = bucketCount;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isColumnTable() {
        return this.isColumnTable;
    }

    public boolean isReplicatedTable() {
        return this.isReplicatedTable;
    }

    public void setReplicatedTable(boolean replicatedTable) {
        this.isReplicatedTable = replicatedTable;
    }

    public void setColumnTable(boolean columnTable) {
        this.isColumnTable = columnTable;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getSizeInMemory() {
        return this.sizeInMemory;
    }

    public void setSizeInMemory(long sizeInMemory) {
        this.sizeInMemory = sizeInMemory;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public void setBucketCount(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    public SnappyRegionStats getCombinedStats(SnappyRegionStats stats) {
        String tableName = this.isColumnTable ? stats.tableName : this.tableName;
        SnappyRegionStats combinedStats = new SnappyRegionStats(tableName);
        if (this.isReplicatedTable()) {
            combinedStats.setRowCount(stats.rowCount);
        } else {
            combinedStats.setRowCount(stats.rowCount + this.rowCount);
        }
        combinedStats.setSizeInMemory(stats.sizeInMemory + this.sizeInMemory);
        combinedStats.setTotalSize(stats.totalSize + this.totalSize);
        combinedStats.setColumnTable(this.isColumnTable || stats.isColumnTable);
        combinedStats.setReplicatedTable(this.isReplicatedTable());
        combinedStats.setBucketCount(this.bucketCount);
        return combinedStats;
    }

    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    public void toDataPre_STORE_1_6_2_0(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.tableName, (DataOutput)out);
        out.writeLong(this.totalSize);
        out.writeLong(this.sizeInMemory);
        out.writeLong(this.rowCount);
        out.writeBoolean(this.isColumnTable);
        out.writeBoolean(this.isReplicatedTable);
    }

    public void toData(DataOutput out) throws IOException {
        this.toDataPre_STORE_1_6_2_0(out);
        out.writeInt(this.bucketCount);
    }

    public void fromDataPre_STORE_1_6_2_0(DataInput in) throws IOException {
        this.tableName = DataSerializer.readString((DataInput)in);
        this.totalSize = in.readLong();
        this.sizeInMemory = in.readLong();
        this.rowCount = in.readLong();
        this.isColumnTable = in.readBoolean();
        this.isReplicatedTable = in.readBoolean();
    }

    public void fromData(DataInput in) throws IOException {
        this.fromDataPre_STORE_1_6_2_0(in);
        this.bucketCount = in.readInt();
    }

    public String toString() {
        return "RegionStats for " + this.tableName + ": totalSize=" + this.totalSize + " sizeInMemory=" + this.sizeInMemory + " rowCount=" + this.rowCount + " isColumnTable=" + this.isColumnTable + " isReplicatedTable=" + this.isReplicatedTable + " bucketCount=" + this.bucketCount;
    }
}

