/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.pivotal.gemfirexd.internal.engine.ui.MemberStatistics;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyUtils;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.buffer.CircularFifoBuffer;

public class ClusterStatistics {
    private int totalCPUCores = 0;
    private final CircularFifoBuffer timeLine = new CircularFifoBuffer(180);
    private final CircularFifoBuffer cpuUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer jvmUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer heapUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer heapStoragePoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer heapExecutionPoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer offHeapUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer offHeapStoragePoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer offHeapExecutionPoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer aggrMemoryUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer diskStoreDiskSpaceTrend = new CircularFifoBuffer(180);
    public static final int TREND_TIMELINE = 0;
    public static final int TREND_CPU_USAGE = 1;
    public static final int TREND_JVM_HEAP_USAGE = 2;
    public static final int TREND_HEAP_USAGE = 3;
    public static final int TREND_HEAP_STORAGE_USAGE = 4;
    public static final int TREND_HEAP_EXECUTION_USAGE = 5;
    public static final int TREND_OFFHEAP_USAGE = 6;
    public static final int TREND_OFFHEAP_STORAGE_USAGE = 7;
    public static final int TREND_OFFHEAP_EXECUTION_USAGE = 8;
    public static final int TREND_AGGR_MEMORY_USAGE = 9;
    public static final int TREND_DISKSTORE_DISKSPACE_USAGE = 10;

    private ClusterStatistics() {
    }

    public static ClusterStatistics getInstance() {
        return SingletonHelper.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterStatistics(Map<String, MemberStatistics> memberStatsMap) {
        long lastMemberUpdatedTime = 0L;
        long sumJvmUsedMemory = 0L;
        long sumHeapStoragePoolUsed = 0L;
        long sumHeapExecutionPoolUsed = 0L;
        long sumHeapMemoryUsed = 0L;
        long sumOffHeapStoragePoolUsed = 0L;
        long sumOffHeapExecutionPoolUsed = 0L;
        long sumOffHeapMemoryUsed = 0L;
        long sumDiskStoreDiskSpace = 0L;
        HashSet<String> hostsListForCPUUsage = new HashSet<String>();
        HashSet<String> hostsListForCPUCores = new HashSet<String>();
        int totalCpuActive = 0;
        int cpuCount = 0;
        this.totalCPUCores = 0;
        for (MemberStatistics ms : memberStatsMap.values()) {
            lastMemberUpdatedTime = ms.getLastUpdatedOn();
            String host = ms.getHost();
            if (!hostsListForCPUCores.contains(host)) {
                hostsListForCPUCores.add(host);
                this.totalCPUCores += ms.getCores();
            }
            if (!hostsListForCPUUsage.contains(host) && !ms.isLocator()) {
                hostsListForCPUUsage.add(host);
                totalCpuActive += ms.getCpuActive();
                ++cpuCount;
            }
            sumJvmUsedMemory += ms.getJvmUsedMemory();
            sumHeapStoragePoolUsed += ms.getHeapStoragePoolUsed();
            sumHeapExecutionPoolUsed += ms.getHeapExecutionPoolUsed();
            sumHeapMemoryUsed += ms.getHeapMemoryUsed();
            sumOffHeapStoragePoolUsed += ms.getOffHeapStoragePoolUsed();
            sumOffHeapExecutionPoolUsed += ms.getOffHeapExecutionPoolUsed();
            sumOffHeapMemoryUsed += ms.getOffHeapMemoryUsed();
            sumDiskStoreDiskSpace += ms.getDiskStoreDiskSpace();
        }
        long sumAggrMemoryUsed = sumHeapMemoryUsed + sumOffHeapMemoryUsed;
        CircularFifoBuffer circularFifoBuffer = this.timeLine;
        synchronized (circularFifoBuffer) {
            this.timeLine.add((Object)lastMemberUpdatedTime);
        }
        circularFifoBuffer = this.cpuUsageTrend;
        synchronized (circularFifoBuffer) {
            this.cpuUsageTrend.add((Object)(totalCpuActive / cpuCount));
        }
        circularFifoBuffer = this.jvmUsageTrend;
        synchronized (circularFifoBuffer) {
            this.jvmUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumJvmUsedMemory, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.heapStoragePoolUsageTrend;
        synchronized (circularFifoBuffer) {
            this.heapStoragePoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumHeapStoragePoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.heapExecutionPoolUsageTrend;
        synchronized (circularFifoBuffer) {
            this.heapExecutionPoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumHeapExecutionPoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.heapUsageTrend;
        synchronized (circularFifoBuffer) {
            this.heapUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumHeapMemoryUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.offHeapStoragePoolUsageTrend;
        synchronized (circularFifoBuffer) {
            this.offHeapStoragePoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumOffHeapStoragePoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.offHeapExecutionPoolUsageTrend;
        synchronized (circularFifoBuffer) {
            this.offHeapExecutionPoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumOffHeapExecutionPoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.offHeapUsageTrend;
        synchronized (circularFifoBuffer) {
            this.offHeapUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumOffHeapMemoryUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.aggrMemoryUsageTrend;
        synchronized (circularFifoBuffer) {
            this.aggrMemoryUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumAggrMemoryUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer = this.diskStoreDiskSpaceTrend;
        synchronized (circularFifoBuffer) {
            this.diskStoreDiskSpaceTrend.add((Object)SnappyUtils.bytesToGivenUnits(sumDiskStoreDiskSpace, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
    }

    public int getTotalCPUCores() {
        return this.totalCPUCores;
    }

    public Object[] getUsageTrends(int trendType) {
        Object[] returnArray = null;
        switch (trendType) {
            case 0: {
                returnArray = this.timeLine.toArray();
                break;
            }
            case 1: {
                returnArray = this.cpuUsageTrend.toArray();
                break;
            }
            case 2: {
                returnArray = this.jvmUsageTrend.toArray();
                break;
            }
            case 3: {
                returnArray = this.heapUsageTrend.toArray();
                break;
            }
            case 4: {
                returnArray = this.heapStoragePoolUsageTrend.toArray();
                break;
            }
            case 5: {
                returnArray = this.heapExecutionPoolUsageTrend.toArray();
                break;
            }
            case 6: {
                returnArray = this.offHeapUsageTrend.toArray();
                break;
            }
            case 7: {
                returnArray = this.offHeapStoragePoolUsageTrend.toArray();
                break;
            }
            case 8: {
                returnArray = this.offHeapExecutionPoolUsageTrend.toArray();
                break;
            }
            case 9: {
                returnArray = this.aggrMemoryUsageTrend.toArray();
                break;
            }
            case 10: {
                returnArray = this.diskStoreDiskSpaceTrend.toArray();
            }
        }
        return returnArray;
    }

    private static class SingletonHelper {
        private static final ClusterStatistics INSTANCE = new ClusterStatistics();

        private SingletonHelper() {
        }
    }
}

