/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CustomEvictionAttributes;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.PartitionedRegionDistributionException;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheMap;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.ExternalTableMetaData;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalDataView;
import com.gemstone.gemfire.internal.cache.InternalPartitionResolver;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.SortedIndexContainer;
import com.gemstone.gemfire.internal.cache.SortedIndexKey;
import com.gemstone.gemfire.internal.cache.TXEntry;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VMIdAdvisor;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.PREntriesIterator;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgumentImpl;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSet;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.gemstone.gemfire.internal.snappy.StoreCallbacks;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.key.IndexKeyComparator;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemInsertOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemUpdateOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexInsertOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheListener;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdEvictionCriteria;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ContainsKeyBulkExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ContainsUniqueKeyBulkExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.locks.AbstractGfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.DefaultGfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraIndexInfo;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireRegionSizeResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.IdentityValueManager;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactExecRowWithLobs;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.ExtractingIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.GlobalIndexCacheWithInMemoryMap;
import com.pivotal.gemfirexd.internal.engine.store.GlobalIndexCacheWithLocalRegion;
import com.pivotal.gemfirexd.internal.engine.store.IndexStats;
import com.pivotal.gemfirexd.internal.engine.store.OffHeapCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.OffHeapCompactExecRowWithLobs;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowEncoder;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.entry.GfxdTXEntryState;
import com.pivotal.gemfirexd.internal.engine.store.entry.HDFSSplitIteratorWrapper;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.SpaceInfo;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.tools.sizer.ObjectSizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class GemFireContainer
extends AbstractGfxdLockable
implements ContainerHandle,
SortedIndexContainer {
    private static final int BYTEARRAY_STORE = 1;
    private static final int DDINDEX = 2;
    private static final int HAS_BUCKET_ROWLOC = 4;
    private static final int FOR_PRIMARY_KEY = 8;
    private static final int FOR_SYSTABLES = 32;
    private static final int FOR_APPTABLE = 64;
    private static final int FOR_APPTABLE_OR_GLOBAL_INDEX = 128;
    private static final int IS_OVERFLOW = 256;
    private static final int HAS_AUTO_GENERATED_COLUMNS = 512;
    public static final String COLON_SEPERATOR = ":";
    private LocalRegion region;
    private RegionAttributes<?, ?> regionAttributes;
    private InternalRegionArguments iargs;
    private ConcurrentSkipListMap<Object, Object> skipListMap;
    private int containerFlags;
    private final String schemaName;
    private final String tableName;
    private final String qualifiedName;
    private String uuid;
    private final ContainerKey id;
    private final ContainerKey baseId;
    private long ddlId;
    private final int[] baseColumnPositions;
    private final GemFireContainer baseContainer;
    private volatile long rowSize;
    private MemConglomerate conglom;
    private boolean isUniqueIndex;
    private ExecRow templateRow;
    private ExtraTableInfo tableInfo;
    private DistributionDescriptor distributionDesc;
    private final RowEncoder encoder;
    boolean hasLobs;
    private int schemaVersion;
    public RowFormatter singleSchema;
    private ExtraTableInfo tableInfoOnRecovery;
    private int schemaVersionOnRecovery;
    private final ArrayList<ExtraTableInfo> oldTableInfos;
    private final ExtraIndexInfo indexInfo;
    private final IndexKeyComparator comparator;
    private final GFContainerLocking locking;
    private Properties properties;
    private volatile boolean isIndexInitialized;
    private volatile boolean hasLoaderAnywhere;
    private final boolean CACHE_GLOBAL_INDEX = SystemProperties.getServerInstance().getBoolean("cacheGlobalIndex", false);
    private final boolean CACHE_GLOBAL_INDEX_IN_MAP = SystemProperties.getServerInstance().getBoolean("cacheGlobalIndexINMap", false);
    private CacheMap globalIndexMap;
    private AtomicReference<ExternalTableMetaData> externalTableMetaData = new AtomicReference<Object>(null);
    private final IndexStats stats;
    private long previousNumRows = 0L;
    private boolean indexTraceOnForThisTable;
    private static final short MAX_COUNTER = 1000;
    private short counter = (short)1000;
    private StoreCallbacks callback = CallbackFactoryProvider.getStoreCallbacks();
    final ObjectSizer sizer = ObjectSizer.getInstance(false);
    long intialAccounting = 0L;
    private AtomicLong sizeAccountedByIndex = new AtomicLong(0L);
    private int currenrOverhead = 0;
    private long totalRows = 0L;
    private AtomicLong numOperations = new AtomicLong(0L);

    public GemFireContainer(ContainerKey id, Properties properties) throws StandardException {
        GemFireTransaction tran;
        this.id = id;
        this.baseId = (ContainerKey)properties.get("baseConglomerateId");
        Object baseCols = properties.get(GfxdConstants.PROPERTY_INDEX_BASE_COL_POS);
        this.baseColumnPositions = baseCols != null ? (int[])((int[])baseCols).clone() : null;
        this.containerFlags = 0;
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        String[] outName = new String[2];
        GemFireContainer.prepareContainerName(id.getContainerId(), properties, lcc, outName);
        this.schemaName = outName[0];
        this.tableName = outName[1];
        this.tableInfo = this.getExtraTableInfo(properties, this.schemaName);
        GemFireStore memStore = Misc.getMemStore();
        GemFireCacheImpl gfCache = memStore.getGemFireCache();
        GemFireTransaction gemFireTransaction = tran = lcc != null ? (GemFireTransaction)lcc.getTransactionExecute() : null;
        if (this.baseId != null) {
            this.baseContainer = memStore.getContainer(this.baseId);
            String baseContainerName = this.baseContainer != null ? this.baseContainer.getQualifiedTableName() : null;
            this.qualifiedName = Misc.getFullTableName(this.schemaName, this.tableName, lcc) + COLON_SEPERATOR + "base-table" + COLON_SEPERATOR + baseContainerName;
            String value = properties.getProperty(GfxdConstants.PROPERTY_CONSTRAINT_TYPE, "-1");
            this.setFlag(8, Integer.parseInt(value) == 2);
        } else {
            this.baseContainer = null;
            this.qualifiedName = Misc.getFullTableName(this.schemaName, this.tableName, lcc);
        }
        this.initUUID(lcc, tran);
        this.setTraceLock();
        this.locking = GemFireContainer.getContainerLockingPolicy(properties, this.schemaName, this.tableName, this.qualifiedName, this.baseId, this);
        String propVal = properties.getProperty("ddIndex");
        if (propVal != null) {
            this.setFlag(2, Boolean.parseBoolean(propVal));
        }
        this.comparator = (IndexKeyComparator)properties.get("indexComparator");
        if (this.comparator != null) {
            DiskStoreImpl store;
            String diskStoreName;
            assert (this.baseId != null) : "expected non-null baseId for local index" + this.qualifiedName;
            this.indexInfo = (ExtraIndexInfo)properties.get("extraIndexInfo");
            if (this.baseContainer.isCandidateForByteArrayStore()) {
                this.indexInfo.initRowFormatter(this.baseColumnPositions, this.baseContainer, (TableDescriptor)properties.get(GfxdConstants.PROPERTY_INDEX_BASE_TABLE_DESC));
                this.skipListMap = new ConcurrentSkipListMap((Comparator)this.comparator, true, true, CompactCompositeIndexKey.getNodeFactory());
            } else {
                this.skipListMap = new ConcurrentSkipListMap((Comparator)this.comparator, true, true);
            }
            this.region = null;
            this.singleSchema = this.baseContainer.getCurrentRowFormatter();
            this.oldTableInfos = null;
            this.stats = this.baseContainer.isApplicationTable() && !Misc.isSnappyHiveMetaTable(this.getSchemaName()) ? new IndexStats(gfCache.getDistributedSystem(), this.qualifiedName) : null;
            if (this.baseContainer.isApplicationTable() && this.baseContainer.regionAttributes.getDataPolicy().withPersistence() && (diskStoreName = this.baseContainer.regionAttributes.getDiskStoreName()) != null && (store = Misc.getGemFireCache().findDiskStore(diskStoreName)) != null) {
                store.writeIndexCreate(this.getUUID());
            }
            this.globalIndexMap = null;
            this.encoder = null;
            return;
        }
        this.stats = null;
        Region<?, ?> rootRegion = gfCache.getRegion(this.schemaName);
        if (rootRegion == null) {
            rootRegion = memStore.createSchemaRegion(this.schemaName, tran);
        }
        assert (rootRegion != null) : "Schema '" + this.schemaName + "' not found";
        this.properties = properties;
        String rowEncoderClass = properties.getProperty("TABLE_ROW_ENCODER_CLASS");
        if (rowEncoderClass != null) {
            try {
                this.encoder = (RowEncoder)ClassPathLoader.getLatest().forName(rowEncoderClass).newInstance();
            }
            catch (Exception e) {
                throw StandardException.newException("X0Z37.S", (Throwable)e, (Object)this.qualifiedName);
            }
        } else {
            this.encoder = null;
        }
        this.regionAttributes = (RegionAttributes)properties.get("GEMFIRE_REGION_ATTRIBUTES");
        this.indexInfo = null;
        this.schemaVersion = 1;
        this.singleSchema = this.getCurrentRowFormatter();
        this.oldTableInfos = new ArrayList();
        this.initTableFlags();
    }

    public void incPointStats() {
        if (this.stats != null) {
            this.stats.incPointLookupStats();
        }
    }

    public void incRangeScanStats() {
        if (this.stats != null) {
            this.stats.incScanStats();
        }
    }

    public void invalidateHiveMetaData() {
        this.externalTableMetaData.set(null);
    }

    public ExternalTableMetaData fetchHiveMetaData(boolean refresh) {
        ExternalTableMetaData metaData;
        if (refresh || (metaData = this.externalTableMetaData.get()) == null) {
            String schemaName = this.schemaName;
            String tableName = this.tableName;
            if (this.isColumnStore()) {
                String fullName = GemFireContainer.getRowBufferTableName(this.qualifiedName);
                int schemaIndex = fullName.indexOf(46);
                schemaName = fullName.substring(0, schemaIndex);
                tableName = fullName.substring(schemaIndex + 1);
            }
            ExternalCatalog extcat = Misc.getMemStore().getExistingExternalCatalog();
            this.externalTableMetaData.compareAndSet(null, extcat.getHiveTableMetaData(schemaName, tableName, true));
            if (this.isPartitioned()) {
                metaData = this.externalTableMetaData.get();
                if (metaData == null) {
                    return null;
                }
                ((PartitionedRegion)this.region).setColumnBatchSizes(metaData.columnBatchSize, metaData.columnMaxDeltaRows, 200);
                return metaData;
            }
            return this.externalTableMetaData.get();
        }
        return metaData;
    }

    public static String getRowBufferTableName(String columnBatchTableName) {
        String tableName = columnBatchTableName.replace("SNAPPYSYS_INTERNAL____", "");
        return tableName.substring(0, tableName.length() - "_COLUMN_STORE_".length());
    }

    public boolean cachesGlobalIndex() {
        return this.globalIndexMap != null;
    }

    public CacheMap getGlobalIndexCache() {
        return this.globalIndexMap;
    }

    public void setLoaderInstalled(boolean flag) {
        this.hasLoaderAnywhere = flag;
    }

    public final boolean getHasLoaderAnywhere() {
        return this.hasLoaderAnywhere;
    }

    private ExtraTableInfo getExtraTableInfo(Properties properties, String schemaName) {
        if (this.id.getSegmentId() == -1L) {
            if (!"SESSION".equals(schemaName)) {
                Assert.fail((Object)("Expected schemaName for temporary table to be SESSION but got " + schemaName));
            }
            return null;
        }
        return (ExtraTableInfo)properties.get("GFXD_DATATYPEDESCRIPTORS");
    }

    private void setFlag(int mask) {
        this.containerFlags = GemFireXDUtils.set(this.containerFlags, mask);
    }

    private void setFlag(int mask, boolean on) {
        this.containerFlags = GemFireXDUtils.set(this.containerFlags, mask, on);
    }

    public void initialize(Properties properties, GfxdIndexManager indexManager, GemFireTransaction tran, ColumnDescriptorList cdl) throws StandardException {
        CustomEvictionAttributes ceAttrs;
        LanguageConnectionContext lcc;
        boolean byteArrayStore;
        GemFireCacheImpl gfCache = Misc.getGemFireCache();
        LogWriterI18n logger = gfCache.getLogger().convertToLogWriterI18n();
        if (this.baseId == null && this.isCandidateForByteArrayStore()) {
            byteArrayStore = true;
        } else {
            byteArrayStore = false;
            if ("SYSTABLES".equals(this.tableName)) {
                this.setFlag(32);
            }
        }
        if (byteArrayStore) {
            this.setFlag(1);
            this.tableInfo.initRowFormatter(this);
        } else {
            ValueRow row;
            int nCols;
            DataValueDescriptor[] template = (DataValueDescriptor[])properties.get("GEMFIRE_TEMPLATE_ROW");
            if (template[(nCols = template.length) - 1] instanceof RowLocation) {
                row = new ValueRow(--nCols);
                for (int i = 0; i < nCols; ++i) {
                    row.setColumn(i + 1, template[i]);
                }
            } else {
                row = new ValueRow(nCols);
                row.setRowArray(template);
            }
            this.templateRow = row.getNewNullRow();
            this.singleSchema = null;
        }
        if (this.comparator != null) {
            return;
        }
        Region rootRegion = gfCache.getRegion(this.schemaName);
        RegionAttributes rattrs = (RegionAttributes)properties.get("GEMFIRE_REGION_ATTRIBUTES");
        LocalRegion rgn = null;
        try {
            PartitionAttributesImpl pattrs = (PartitionAttributesImpl)rattrs.getPartitionAttributes();
            if (pattrs != null) {
                pattrs.validateAttributes();
                pattrs.validateWhenAllAttributesAreSet(false);
                if (indexManager != null && pattrs.getLocalMaxMemory() != 0) {
                    indexManager.initialize(tran, true, false);
                }
            } else if (indexManager != null) {
                indexManager.initialize(tran, false, !rattrs.getDataPolicy().withStorage());
            }
            lcc = tran != null ? tran.getLanguageConnectionContext() : Misc.getLanguageConnectionContext();
            this.initUUID(lcc, tran);
            AttributesFactory.validateAttributes((RegionAttributes)rattrs);
            this.iargs = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setIndexUpdater((IndexUpdater)indexManager).setUserAttribute((Object)this).setKeyRequiresRegionContext(this.regionKeyRequiresRegionContext()).setUsedForIndex(this.isGlobalIndex()).setUUID(this.ddlId);
            if (rattrs.getScope().isLocal()) {
                this.iargs.setIsUsedForMetaRegion(true);
            }
            if (logger.fineEnabled()) {
                logger.fine("This container's " + this.toString() + " byteArrayStore=" + byteArrayStore + " id=" + this.ddlId + " attributes=" + rattrs);
            }
            boolean skipRegionInitialization = lcc != null && lcc.skipRegionInitialization();
            try {
                rgn = (LocalRegion)((LocalRegion)rootRegion).createSubregion(this.tableName, rattrs, this.iargs, skipRegionInitialization);
                LocalRegion.clearInitializingRegion();
                if (!skipRegionInitialization) {
                    this.initNumRows(rgn);
                    this.iargs = null;
                }
            }
            catch (TimeoutException e) {
                throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
            }
            catch (IOException e) {
                throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
            }
            catch (ClassNotFoundException e) {
                throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
            }
        }
        catch (RegionExistsException ex) {
            throw StandardException.newException("X0Y32.S", "Table", (Object)this.tableName, (Object)"Schema", (Object)this.schemaName);
        }
        catch (IllegalStateException ex) {
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.toString());
        }
        this.region = rgn;
        assert (this.region != null);
        this.regionAttributes = this.region.getAttributes();
        this.initTableFlags();
        if (rgn.getCustomEvictionAttributes() != null && (ceAttrs = rgn.getCustomEvictionAttributes()).getCriteria() instanceof GfxdEvictionCriteria) {
            ((GfxdEvictionCriteria)ceAttrs.getCriteria()).initialize(this, lcc);
        }
        this.setFlag(512, this.isByteArrayStore() && !this.isPrimaryKeyBased() || cdl != null && cdl.hasAutoIncrementAlways());
    }

    private long getDDLId(LanguageConnectionContext lcc, GemFireTransaction tran) {
        if (tran != null) {
            return tran.getDDLId();
        }
        if (lcc != null) {
            return ((GemFireTransaction)lcc.getTransactionExecute()).getDDLId();
        }
        return 0L;
    }

    private void initUUID(LanguageConnectionContext lcc, GemFireTransaction tran) {
        this.ddlId = this.getDDLId(lcc, tran);
        this.uuid = Misc.getFullTableName(this.schemaName, this.tableName, lcc) + COLON_SEPERATOR + this.ddlId;
    }

    public final void preInitializeRegion() throws StandardException {
        this.region.preInitialize(this.iargs);
    }

    public final void initializeRegion() throws StandardException {
        try {
            VMIdAdvisor uuidAdvisor;
            ((LocalRegion)this.region.getParentRegion()).initialize(this.region, this.iargs);
            if (this.isPartitioned()) {
                this.region.invokeUUIDPostInitialize();
            }
            if (this.hasAutoGeneratedCols() && (uuidAdvisor = this.region.getUUIDAdvisor()) != null && !Misc.isSnappyHiveMetaTable(this.getSchemaName())) {
                SanityManager.DEBUG_PRINT((String)"info:", (String)("Initializing UUID advisor " + uuidAdvisor));
                uuidAdvisor.handshake();
            }
            this.iargs = null;
        }
        catch (TimeoutException e) {
            throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
        }
        catch (IOException e) {
            throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
        }
        catch (ClassNotFoundException e) {
            throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
        }
    }

    public void initNumRows(LocalRegion r) {
        if (r.getPartitionAttributes() != null) {
            PartitionedRegion pr = (PartitionedRegion)r;
            if (pr.getDataStore() != null) {
                this.previousNumRows = pr.isHDFSReadWriteRegion() ? -1L : (long)pr.entryCountEstimate(null, pr.getDataStore().getAllLocalBucketIds(), false);
            }
        } else {
            this.previousNumRows = r.size();
        }
        if (r.getConcurrencyChecksEnabled()) {
            SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("Concurrency checks enabled for table " + this.getQualifiedTableName()));
        }
    }

    public static GemFireContainer getGemFireContainer(TableDescriptor td, GemFireTransaction tran) throws StandardException {
        assert (td != null) : "Expected non-null TableDescriptor for GemFireContainer#getGemFireContainer";
        MemConglomerate conglom = tran.findExistingConglomerate(td.getHeapConglomerateId());
        GemFireContainer container = conglom.getGemFireContainer();
        assert (container != null) : "Expected non-null GemFireContainer for TableDescriptor: " + td;
        return container;
    }

    public GfxdIndexManager setup(TableDescriptor td, DataDictionary dd, LanguageConnectionContext lcc, GemFireTransaction tran, boolean hasFk, DistributionDescriptor distributionDesc, Activation activation, ColumnDescriptorList cdl) throws StandardException {
        GfxdIndexManager indexManager = null;
        this.refreshCachedInfo(td, distributionDesc, activation);
        if (!this.getSchemaName().equalsIgnoreCase("SYS")) {
            if (!this.isObjectStore()) {
                indexManager = GfxdIndexManager.newIndexManager(dd, td, this, lcc.getDatabase(), hasFk);
            }
            this.initialize(this.properties, indexManager, tran, cdl);
        }
        this.properties = null;
        return indexManager;
    }

    public void refreshCachedInfo(TableDescriptor td, DistributionDescriptor distributionDesc, Activation activation) throws StandardException {
        this.setDistributionDescriptor(distributionDesc);
        if (distributionDesc != null) {
            PartitionResolver pr;
            PartitionAttributes pattrs;
            RegionAttributes<?, ?> rattr = this.getRegionAttributes();
            CacheLoader ldr = rattr.getCacheLoader();
            if (ldr != null) {
                ((GfxdCacheLoader)ldr).setTableDetails(td);
            }
            if ((pattrs = rattr.getPartitionAttributes()) != null && (pr = rattr.getPartitionAttributes().getPartitionResolver()) instanceof GfxdPartitionResolver) {
                GfxdPartitionResolver spr = (GfxdPartitionResolver)pr;
                spr.setTableDetails(td, this);
                spr.updateDistributionDescriptor(distributionDesc);
                spr.setColumnInfo(td, activation);
            }
        }
        this.tableInfo.refreshCachedInfo(td, this);
    }

    public void setIndexInitialized() {
        this.isIndexInitialized = true;
    }

    public void setDistributionDescriptor(DistributionDescriptor desc) {
        this.distributionDesc = desc;
    }

    public final DistributionDescriptor getDistributionDescriptor() {
        return this.distributionDesc;
    }

    private static void prepareContainerName(long containerId, Properties props, LanguageConnectionContext lcc, String[] outName) {
        assert (outName != null && outName.length == 2) : "expected array of size 2 for output container name";
        String schemaName = props.getProperty(GfxdConstants.PROPERTY_SCHEMA_NAME);
        String tableName = props.getProperty(GfxdConstants.PROPERTY_TABLE_NAME);
        if (schemaName == null) {
            schemaName = Misc.getDefaultSchemaName(lcc);
            assert (Misc.getGemFireCache().getRegion(schemaName) != null) : "region for default schema should have been found";
        }
        if (tableName == null) {
            tableName = "{id}";
        }
        assert (tableName != null);
        tableName = tableName.replaceFirst("\\{id\\}", String.valueOf(containerId));
        outName[0] = schemaName;
        outName[1] = tableName;
    }

    private static GFContainerLocking getContainerLockingPolicy(Properties props, String schemaName, String tableName, String qualifiedName, ContainerKey baseId, GemFireContainer container) {
        if (baseId != null) {
            String propVal = props.getProperty("ddIndex");
            boolean ddIndex = propVal != null ? Boolean.parseBoolean(propVal) : false;
            if (!ddIndex && schemaName != null && schemaName.length() > 0) {
                GemFireContainer baseContainer = Misc.getMemStore().getContainer(baseId);
                assert (baseContainer != null) : "expected to find base container for index " + qualifiedName;
                return baseContainer.getLockingPolicy();
            }
            return null;
        }
        RegionAttributes rattrs = (RegionAttributes)props.get("GEMFIRE_REGION_ATTRIBUTES");
        if (rattrs == null) {
            AttributesFactory af = new AttributesFactory();
            af.setScope(Scope.LOCAL);
            af.setInitialCapacity(GemFireXDUtils.getDefaultInitialCapacity());
            af.setConcurrencyChecksEnabled(false);
            rattrs = af.create();
            props.put("GEMFIRE_REGION_ATTRIBUTES", rattrs);
        } else if ("SESSION".equals(schemaName) && !rattrs.getScope().isLocal()) {
            AttributesFactory af = new AttributesFactory(rattrs);
            af.setPartitionAttributes(null);
            af.setScope(Scope.LOCAL);
            af.setDataPolicy(DataPolicy.NORMAL);
            af.setInitialCapacity(GemFireXDUtils.getDefaultInitialCapacity());
            af.setConcurrencyChecksEnabled(false);
            rattrs = af.create();
            props.put("GEMFIRE_REGION_ATTRIBUTES", rattrs);
        } else if (!rattrs.getScope().isLocal()) {
            AbstractGfxdLockable lockable = container != null ? container : new DefaultGfxdLockable(qualifiedName, null);
            return new GFContainerLocking(lockable, false, container);
        }
        return null;
    }

    public static GFContainerLocking getContainerLockingPolicy(long containerId, Properties props, LanguageConnectionContext lcc) {
        String[] outName = new String[2];
        GemFireContainer.prepareContainerName(containerId, props, lcc, outName);
        ContainerKey baseId = (ContainerKey)props.get("baseConglomerateId");
        return GemFireContainer.getContainerLockingPolicy(props, outName[0], outName[1], Misc.getFullTableName(outName[0], outName[1], lcc), baseId, null);
    }

    public void setExtraTableInfo(ExtraTableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.schemaUpdated();
    }

    public void schemaUpdated() {
        if (this.oldTableInfos.isEmpty()) {
            this.singleSchema = this.getCurrentRowFormatter();
        }
    }

    public final boolean hasLobs() {
        return this.hasLobs;
    }

    public final boolean hasLobsInAnySchema() {
        if (this.hasLobs) {
            return true;
        }
        ArrayList<ExtraTableInfo> oldInfos = this.oldTableInfos;
        if (oldInfos != null) {
            int index = oldInfos.size();
            while (--index >= 0) {
                if (!oldInfos.get(index).getRowFormatter().hasLobs()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasLobsInAllSchema() {
        if (!this.hasLobs) {
            return false;
        }
        ArrayList<ExtraTableInfo> oldInfos = this.oldTableInfos;
        if (oldInfos != null) {
            int index = oldInfos.size();
            while (--index >= 0) {
                if (oldInfos.get(index).getRowFormatter().hasLobs()) continue;
                return false;
            }
        }
        return true;
    }

    public final ExtraTableInfo getExtraTableInfo() {
        return this.tableInfo;
    }

    private final ExtraTableInfo getExtraTableInfoForMultiSchema(byte[] rowBytes) {
        int schemaVersion = RowFormatter.readVersion(rowBytes);
        if (this.isCurrentVersion(schemaVersion)) {
            return this.tableInfo;
        }
        if (schemaVersion != -1) {
            return this.oldTableInfos.get(schemaVersion - 1);
        }
        assert (this.tableInfoOnRecovery != null) : "unexpected null tableInfoOnRecovery for row=" + Arrays.toString(rowBytes);
        return this.tableInfoOnRecovery;
    }

    public final ExtraTableInfo getExtraTableInfo(byte[] rawRow) {
        if (this.singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return this.tableInfo;
        }
        if (rawRow == null) {
            return this.tableInfo;
        }
        return this.getExtraTableInfoForMultiSchema(rawRow);
    }

    private ExtraTableInfo getExtraTableInfoForMultiSchema(OffHeapByteSource rawRow) {
        long memAddr = rawRow.getUnsafeAddress();
        int schemaVersion = RowFormatter.readVersion(memAddr);
        if (this.isCurrentVersion(schemaVersion)) {
            return this.tableInfo;
        }
        if (schemaVersion != -1) {
            return this.oldTableInfos.get(schemaVersion - 1);
        }
        assert (this.tableInfoOnRecovery != null) : "unexpected null tableInfoOnRecovery for row=" + Arrays.toString(rawRow.getRowBytes());
        return this.tableInfoOnRecovery;
    }

    public final ExtraTableInfo getExtraTableInfo(OffHeapByteSource rawRow) {
        if (this.singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return this.tableInfo;
        }
        if (rawRow == null) {
            return this.tableInfo;
        }
        return this.getExtraTableInfoForMultiSchema(rawRow);
    }

    public final ExtraTableInfo getExtraTableInfo(Object rawRow) {
        if (this.singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion_(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return this.tableInfo;
        }
        if (rawRow == null) {
            return this.tableInfo;
        }
        Class<?> cls = rawRow.getClass();
        if (cls == byte[].class) {
            return this.getExtraTableInfoForMultiSchema((byte[])rawRow);
        }
        if (cls == byte[][].class) {
            return this.getExtraTableInfoForMultiSchema(((byte[][])rawRow)[0]);
        }
        if (OffHeapByteSource.isOffHeapBytesClass(cls)) {
            return this.getExtraTableInfoForMultiSchema((OffHeapByteSource)((Object)rawRow));
        }
        return this.tableInfo;
    }

    private final int readVersion(byte[] rowBytes) {
        if (rowBytes != null && this.isByteArrayStore()) {
            return RowFormatter.readVersion(rowBytes);
        }
        return this.schemaVersion;
    }

    private int readVersion(OffHeapByteSource rowBytes) {
        if (rowBytes != null && this.isByteArrayStore()) {
            return RowFormatter.readVersion(rowBytes.getUnsafeAddress());
        }
        return this.schemaVersion;
    }

    private final int readVersion_(Object rawRow) {
        if (rawRow == null) {
            return this.schemaVersion;
        }
        Class<?> cls = rawRow.getClass();
        if (cls == byte[].class) {
            return this.readVersion((byte[])rawRow);
        }
        if (cls == byte[][].class) {
            return this.readVersion(((byte[][])rawRow)[0]);
        }
        if (OffHeapByteSource.isOffHeapBytesClass(cls)) {
            return this.readVersion((OffHeapByteSource)((Object)rawRow));
        }
        return this.schemaVersion;
    }

    private final boolean isCurrentVersion(int version) {
        return version == this.schemaVersion || version == 0;
    }

    private final void checkSchemaChange() {
        if (this.oldTableInfos.size() != this.schemaVersion - 1) {
            GemFireXDUtils.throwAssert("unexpected mismatch of old TableInfos " + this.oldTableInfos + " and schemaVersion=" + this.schemaVersion);
        }
        if (!this.isByteArrayStore()) {
            GemFireXDUtils.throwAssert("unexpected call for table without byte array store");
        }
        this.waitForGatewayQueuesToFlush();
    }

    public final void scheduleAddColumn(ColumnDescriptor cd, LanguageConnectionContext lcc) throws StandardException {
        this.checkSchemaChange();
        this.tableInfo.refreshAtCommit(cd, -1, lcc);
    }

    public final void scheduleDropColumn(int columnPos, LanguageConnectionContext lcc) throws StandardException {
        this.checkSchemaChange();
        this.tableInfo.refreshAtCommit(null, columnPos, lcc);
        GfxdIndexManager indexManager = (GfxdIndexManager)this.getRegion().getIndexUpdater();
        if (indexManager != null) {
            indexManager.invalidateFor(columnPos, lcc);
        }
    }

    public final void schemaVersionChange(DataDictionary dd, TableDescriptor td, LanguageConnectionContext lcc) throws StandardException {
        this.tableInfo.setLatestSchema(false);
        this.oldTableInfos.add(this.tableInfo);
        ++this.schemaVersion;
        this.singleSchema = null;
        ExtraTableInfo.newExtraTableInfo(dd, td, lcc.getContextManager(), this.schemaVersion, this, true);
        if (this.isByteArrayStore()) {
            this.tableInfo.initRowFormatter(this);
        }
    }

    public final void addColumnAtCommit(ColumnDescriptor cd) {
        for (ExtraTableInfo tableInfo : this.oldTableInfos) {
            tableInfo.getRowFormatter().addColumn(cd);
        }
        if (this.tableInfoOnRecovery != null) {
            this.tableInfoOnRecovery.getRowFormatter().addColumn(cd);
        }
    }

    public final void dropColumnAtCommit(int columnPos) {
        for (ExtraTableInfo tableInfo : this.oldTableInfos) {
            tableInfo.getRowFormatter().dropColumn(columnPos);
        }
        if (this.tableInfoOnRecovery != null) {
            this.tableInfoOnRecovery.getRowFormatter().dropColumn(columnPos);
        }
    }

    public final void refreshLockingInfo() {
        if (this.locking != null) {
            this.locking.update(this);
        }
    }

    public final void initPre11SchemaVersionOnRecovery(DataDictionary dd, LanguageConnectionContext lcc) throws StandardException {
        TableDescriptor td = this.getTableDescriptor();
        this.tableInfoOnRecovery = ExtraTableInfo.newExtraTableInfo(dd, td, lcc.getContextManager(), -1, this, false);
        this.tableInfoOnRecovery.refreshCachedInfo(td, this);
        this.tableInfoOnRecovery.initRowFormatter(this);
        this.tableInfoOnRecovery.setLatestSchema(false);
        this.singleSchema = null;
        this.schemaVersionOnRecovery = this.schemaVersion;
        if (this.tableInfo != null) {
            this.tableInfo.setLatestSchema(false);
        }
    }

    public final int getPre11SchemaVersionOnRecovery() {
        return this.schemaVersionOnRecovery;
    }

    public final int getCurrentSchemaVersion() {
        if (this.isByteArrayStore()) {
            return this.schemaVersion;
        }
        return -1;
    }

    public final ExtraIndexInfo getExtraIndexInfo() {
        return this.indexInfo;
    }

    public final String getSchemaName() {
        return this.schemaName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getQualifiedTableName() {
        return this.qualifiedName;
    }

    public final String getUUID() {
        return this.uuid;
    }

    public Comparator<? super SortedIndexKey> getComparator() {
        IndexKeyComparator cmp = this.comparator;
        if (cmp != null) {
            return cmp;
        }
        throw new UnsupportedOperationException("getComparator: not a local index: " + this.toString());
    }

    public LocalRegion getBaseRegion() {
        if (this.baseContainer != null) {
            return this.baseContainer.getRegion();
        }
        throw new UnsupportedOperationException("getBaseRegion: not an index: " + this.toString());
    }

    public SortedIndexKey getIndexKey(byte[] indexKeyBytes, RegionEntry entry) {
        return new CompactCompositeIndexKey(this.getExtraIndexInfo(), indexKeyBytes);
    }

    public SortedIndexKey getIndexKey(Object val, RegionEntry entry) {
        try {
            return this.getLocalIndexKey(val, (Object)entry, false, false);
        }
        catch (StandardException se) {
            throw new IndexMaintenanceException((Throwable)se);
        }
    }

    public void insertIntoIndex(SortedIndexKey indexKey, RegionEntry entry, boolean isPutDML) {
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("GemFireContainer#insertIntoIndexes: index key = %s DiskEntry to be inserted = %s", entry);
        }
        try {
            SortedMap2IndexInsertOperation.doMe(null, null, this, indexKey, (RowLocation)entry, this.isUniqueIndex(), null, isPutDML);
        }
        catch (StandardException se) {
            throw new IndexMaintenanceException((Throwable)se);
        }
    }

    public void buildIndexFromSorted(Iterator<Map.Entry<SortedIndexKey, Object>> entryIterator) {
        this.skipListMap.buildFromSorted(entryIterator);
    }

    public void mergeValuesForNonUnique(SortedIndexKey mergeInto, SortedIndexKey mergeFrom) throws IndexMaintenanceException {
        Object result = mergeInto.getTransientValue();
        Object from = mergeFrom.getTransientValue();
        if (!this.isUniqueIndex) {
            Class<?> o2Class = from.getClass();
            SortedMap2IndexInsertOperation.InsertOrUpdateValue updater = SortedMap2IndexInsertOperation.insertOrUpdateValueForPut;
            if (o2Class == RowLocation[].class) {
                RowLocation[] rows;
                for (RowLocation rl : rows = (RowLocation[])from) {
                    result = updater.updateValue((Object)mergeInto, result, rl, this);
                }
                mergeInto.setTransientValue(result);
            } else if (o2Class == ConcurrentTHashSet.class) {
                ConcurrentTHashSet set = (ConcurrentTHashSet)from;
                for (Object o : set) {
                    result = updater.updateValue((Object)mergeInto, result, (RowLocation)o, this);
                }
                mergeInto.setTransientValue(result);
            } else {
                mergeInto.setTransientValue(updater.updateValue((Object)mergeInto, result, (RowLocation)from, this));
            }
        } else {
            throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newDuplicateKeyViolation("unique constraint", this.getQualifiedTableName(), "key=" + mergeInto + ", rows=" + ArrayUtils.objectString((Object)result), ArrayUtils.objectString((Object)from), null, null));
        }
    }

    public static GemFireContainer getContainerFromIdentityKey(String key) {
        int uuidIndex = key.lastIndexOf(58);
        String tableName = uuidIndex > 0 ? key.substring(0, uuidIndex) : key;
        return (GemFireContainer)Misc.getRegionForTableByPath(tableName, true).getUserAttribute();
    }

    public final int getNumColumns() {
        return this.tableInfo != null ? this.tableInfo.getRowFormatter().getNumColumns() : -1;
    }

    public final RowFormatter getCurrentRowFormatter() {
        return this.tableInfo != null ? this.tableInfo.getRowFormatter() : null;
    }

    private final RowFormatter getRowFormatterForMultiSchema(byte[] rowRow) {
        int schemaVersion = RowFormatter.readVersion(rowRow);
        if (this.isCurrentVersion(schemaVersion)) {
            return this.tableInfo.getRowFormatter();
        }
        if (schemaVersion != -1) {
            return this.oldTableInfos.get(schemaVersion - 1).getRowFormatter();
        }
        assert (this.tableInfoOnRecovery != null) : "unexpected null tableInfoOnRecovery for row=" + Arrays.toString(rowRow);
        return this.tableInfoOnRecovery.getRowFormatter();
    }

    public final RowFormatter getRowFormatter(byte[] rawRow) {
        RowFormatter singleSchema = this.singleSchema;
        if (singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return singleSchema;
        }
        if (!this.isByteArrayStore()) {
            return null;
        }
        if (rawRow == null) {
            return this.tableInfo.getRowFormatter();
        }
        return this.getRowFormatterForMultiSchema(rawRow);
    }

    public final RowFormatter getRowFormatter(byte[][] rawRow) {
        RowFormatter singleSchema = this.singleSchema;
        if (singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion(rawRow[0]))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return singleSchema;
        }
        if (!this.isByteArrayStore()) {
            return null;
        }
        if (rawRow == null || rawRow.length == 0) {
            return this.tableInfo.getRowFormatter();
        }
        return this.getRowFormatterForMultiSchema(rawRow[0]);
    }

    private RowFormatter getRowFormatterForMultiSchema(long memAddr, OffHeapByteSource rawRow) {
        int schemaVersion = RowFormatter.readVersion(memAddr);
        if (this.isCurrentVersion(schemaVersion)) {
            return this.tableInfo.getRowFormatter();
        }
        if (schemaVersion != -1) {
            return this.oldTableInfos.get(schemaVersion - 1).getRowFormatter();
        }
        assert (this.tableInfoOnRecovery != null) : "unexpected null tableInfoOnRecovery for row=" + Arrays.toString(rawRow.getRowBytes());
        return this.tableInfoOnRecovery.getRowFormatter();
    }

    public final RowFormatter getRowFormatter(OffHeapByteSource rawRow) {
        RowFormatter singleSchema = this.singleSchema;
        if (singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return singleSchema;
        }
        if (!this.isByteArrayStore()) {
            return null;
        }
        if (rawRow == null) {
            return this.tableInfo.getRowFormatter();
        }
        return this.getRowFormatterForMultiSchema(rawRow.getUnsafeAddress(), rawRow);
    }

    public final RowFormatter getRowFormatter(long memAddr, OffHeapByteSource rawRow) {
        RowFormatter singleSchema = this.singleSchema;
        if (singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return singleSchema;
        }
        if (!this.isByteArrayStore()) {
            return null;
        }
        return this.getRowFormatterForMultiSchema(memAddr, rawRow);
    }

    public final RowFormatter getRowFormatter(Object rawRow) {
        RowFormatter singleSchema = this.singleSchema;
        if (singleSchema != null) {
            int rowVersion;
            assert (this.isCurrentVersion(rowVersion = this.readVersion_(rawRow))) : "unexpected version in row=" + rowVersion + ", schemaVersion=" + this.schemaVersion;
            return singleSchema;
        }
        if (!this.isByteArrayStore()) {
            return null;
        }
        if (rawRow == null) {
            return this.tableInfo.getRowFormatter();
        }
        Class<?> cls = rawRow.getClass();
        if (cls == byte[].class) {
            return this.getRowFormatterForMultiSchema((byte[])rawRow);
        }
        if (cls == byte[][].class) {
            return this.getRowFormatterForMultiSchema(((byte[][])rawRow)[0]);
        }
        if (OffHeapByteSource.isOffHeapBytesClass(cls)) {
            OffHeapByteSource bs = (OffHeapByteSource)((Object)rawRow);
            return this.getRowFormatterForMultiSchema(bs.getUnsafeAddress(), bs);
        }
        return this.tableInfo.getRowFormatter();
    }

    public final RowFormatter getRowFormatter(OffHeapByteSource vbs, ExtraTableInfo tableInfo) {
        return tableInfo != null ? tableInfo.getRowFormatter(vbs) : this.getRowFormatter(vbs);
    }

    public final RowFormatter getRowFormatter(byte[] vbytes, ExtraTableInfo tableInfo) {
        return tableInfo != null ? tableInfo.getRowFormatter(vbytes) : this.getRowFormatter(vbytes);
    }

    public final RowFormatter getRowFormatter(int numCols) {
        if (this.isByteArrayStore()) {
            RowFormatter rf = this.tableInfo.getRowFormatter();
            ColumnDescriptor[] cdl = rf.columns;
            if (numCols == cdl.length) {
                return rf;
            }
            return new RowFormatter(cdl, numCols, this.schemaVersion, this, true);
        }
        return null;
    }

    public final RowFormatter getRowFormatter(FormatableBitSet validColumns) {
        if (this.isByteArrayStore()) {
            if (validColumns != null) {
                return new RowFormatter(this.tableInfo.getTableDescriptor().getColumnDescriptorList(), validColumns, this.schemaVersion, this);
            }
            return this.tableInfo.getRowFormatter();
        }
        return null;
    }

    public final RowFormatter getRowFormatter(int[] validColumns, TableDescriptor td, int schemaVersion, boolean isPrimaryKeyFormatter) {
        return new RowFormatter(td.getColumnDescriptorList(), validColumns, this.schemaName, this.tableName, schemaVersion, this, isPrimaryKeyFormatter);
    }

    public final RowFormatter getRowFormatter(ColumnQueryInfo[] cqi) {
        return new RowFormatter(cqi, this.schemaVersion, this);
    }

    public final void clear(LanguageConnectionContext lcc, GemFireTransaction tc) throws StandardException {
        if (this.skipListMap != null) {
            this.skipListMap.clear();
        } else if (this.region != null && !this.region.isDestroyed() && !Misc.initialDDLReplayInProgress()) {
            GfxdIndexManager indexManager;
            if (this.isPartitioned()) {
                PartitionedRegion pr = (PartitionedRegion)this.region;
                if (!lcc.isConnectionForRemote()) {
                    final AtomicBoolean locked = new AtomicBoolean();
                    final PartitionedRegion.RecoveryLock rl = ColocationHelper.getLeaderRegion((PartitionedRegion)pr).getRecoveryLock();
                    rl.lock();
                    locked.set(true);
                    tc.logAndDo(new MemOperation(null){

                        @Override
                        public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
                            if (GemFireXDUtils.TraceConglom) {
                                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Invoked localClear.RecoveryLock.unlock with locked=" + locked.get() + " for " + xact));
                            }
                            if (locked.compareAndSet(true, false)) {
                                try {
                                    rl.unlock();
                                }
                                catch (Exception e) {
                                    SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"GemFireContainer#clear: ignoring exception in bucket recovery lock release", (Throwable)e);
                                }
                            }
                        }

                        @Override
                        public boolean doAtCommitOrAbort() {
                            return true;
                        }

                        @Override
                        public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
                            return this;
                        }
                    });
                }
                pr.clearLocalPrimaries();
            } else if (this.region.getScope().isLocal() || !lcc.isConnectionForRemote()) {
                try {
                    this.region.clear();
                }
                catch (Exception e) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"GemFireContainer#clear: ignoring exception in region clear", (Throwable)e);
                }
            }
            if (!this.isGlobalIndex() && (indexManager = (GfxdIndexManager)this.region.getIndexUpdater()) != null) {
                for (GemFireContainer container : indexManager.getAllIndexes()) {
                    container.clear(lcc, tc);
                }
            }
            this.previousNumRows = 0L;
            this.removeIdentityRegionEntries(tc);
        }
    }

    public final int getTotalNumRows(LanguageConnectionContext lcc) throws StandardException {
        DataPolicy policy = this.regionAttributes.getDataPolicy();
        if (policy.withPartitioning() || this.regionAttributes.getScope().isLocal() || policy.withStorage()) {
            return this.region.size();
        }
        if (policy.withReplication() || !policy.withStorage()) {
            GemFireRegionSizeResultSet.RegionSizeMessage rmsg = new GemFireRegionSizeResultSet.RegionSizeMessage(this.region.getFullPath(), new GfxdSingleResultCollector(), this.region, null, lcc);
            try {
                Object result = rmsg.executeFunction();
                assert (result instanceof Integer);
                return (Integer)result;
            }
            catch (SQLException sqle) {
                throw Misc.wrapRemoteSQLException(sqle, sqle, null);
            }
        }
        throw GemFireXDRuntimeException.newRuntimeException("Unknown region type: " + this.region, null);
    }

    public final int getLocalNumRows(Set<Integer> bucketIds, boolean withSecondaries, boolean queryHDFS) throws StandardException {
        DataPolicy policy = this.regionAttributes.getDataPolicy();
        if (policy.withPartitioning()) {
            PartitionedRegion pr = (PartitionedRegion)this.region;
            pr.setQueryHDFS(queryHDFS);
            if (withSecondaries) {
                Set allBuckets = pr.getDataStore().getAllLocalBucketIds();
                if (GemFireXDUtils.TraceAggreg) {
                    Map bucketSizes = null;
                    if (pr.getDataStore() != null) {
                        bucketSizes = pr.getDataStore().getSizeLocallyForBuckets((Collection)allBuckets);
                    }
                    int size = 0;
                    if (bucketSizes != null) {
                        for (PartitionedRegion.SizeEntry entry : bucketSizes.values()) {
                            size += entry.getSize();
                        }
                        SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("witSecondaries=" + withSecondaries + " local buckets size determined with " + allBuckets.size() + " buckets as bucketIds=" + allBuckets + " as \n" + bucketSizes.size() + " bucket sizes as " + bucketSizes + " totaling to " + size));
                    }
                }
                return pr.entryCount(pr.getTXState(), allBuckets);
            }
            if (bucketIds != null) {
                if (GemFireXDUtils.TraceAggreg) {
                    Map bucketSizes = null;
                    if (pr.getDataStore() != null) {
                        bucketSizes = pr.getDataStore().getSizeLocallyForBuckets(bucketIds);
                    }
                    int size = 0;
                    if (bucketSizes != null) {
                        for (PartitionedRegion.SizeEntry entry : bucketSizes.values()) {
                            size += entry.getSize();
                        }
                        SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("Bucket Sizes determined with " + bucketIds.size() + " buckets as bucketIds=" + bucketIds + " as \n" + bucketSizes.size() + " bucket sizes as " + bucketSizes + " totalling to " + size));
                    }
                }
                return pr.entryCount(pr.getTXState(), bucketIds);
            }
            return pr.entryCount(pr.getTXState(), pr.getDataStore().getAllLocalPrimaryBucketIds());
        }
        if (policy.withReplication() || this.regionAttributes.getScope().isLocal()) {
            return this.region.size();
        }
        throw GemFireXDRuntimeException.newRuntimeException("Unknown region type: " + this.region, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void drop(GemFireTransaction tran) throws StandardException {
        try {
            if (this.baseContainer != null) {
                this.accountIndexMemory(false, true);
            }
            this.localDestroy(tran);
        }
        finally {
            GfxdIndexManager indexManager;
            LocalRegion r;
            ArrayList<ExtraTableInfo> oldInfos;
            ExtraTableInfo tableInfo = this.tableInfoOnRecovery;
            if (tableInfo != null) {
                tableInfo.drop(tran);
            }
            if ((oldInfos = this.oldTableInfos) != null && !oldInfos.isEmpty()) {
                for (ExtraTableInfo info : oldInfos) {
                    info.drop(tran);
                }
            }
            if ((tableInfo = this.tableInfo) != null) {
                tableInfo.drop(tran);
            }
            if ((r = this.region) != null && (indexManager = (GfxdIndexManager)r.getIndexUpdater()) != null) {
                indexManager.drop(tran);
            }
            if (this.skipListMap != null) {
                this.releaseIndexMemory();
            }
        }
    }

    final void localDestroy(GemFireTransaction tran) throws StandardException {
        LocalRegion region = this.region;
        if (this.skipListMap != null && this.baseContainer.isApplicationTable()) {
            LocalRegion baseRegion;
            this.skipListMap.clear();
            if (this.baseContainer.isApplicationTable() && (baseRegion = this.baseContainer.getRegion()) != null && baseRegion.getDataPolicy().withPersistence()) {
                DiskStoreImpl dsImpl = baseRegion.getDiskStore();
                if (dsImpl != null) {
                    if (GemFireXDUtils.TracePersistIndex) {
                        GfxdIndexManager.traceIndex("GemFireContainer::localDestroy  writing the delete index dif record for " + this.qualifiedName + " in " + dsImpl, new Object[0]);
                    }
                    dsImpl.writeIndexDelete(this.uuid);
                }
                if (this.stats != null) {
                    this.stats.close();
                }
            }
        } else if (region == null || region.isDestroyed()) {
            LanguageConnectionContext lcc;
            if ((region == null || !Misc.initialDDLReplayInProgress() && tran != null && (lcc = tran.getLanguageConnectionContext()) != null && !lcc.isConnectionForRemote()) && GemFireXDUtils.TraceDDLReplay) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("GemFireContainer#destroy: region [" + (region != null ? region.getFullPath() : "null") + "] for table '" + this.qualifiedName + "' already destroyed"));
                throw new RegionDestroyedException(this.toString(), this.qualifiedName);
            }
        } else if (region.isInitialized()) {
            this.waitForGatewayQueuesToFlush();
            if (this.regionAttributes.getDataPolicy().withPartitioning()) {
                LanguageConnectionContext lcc;
                if (!Misc.initialDDLReplayInProgress() && tran != null && (lcc = tran.getLanguageConnectionContext()) != null && !lcc.isConnectionForRemote()) {
                    region.destroyRegion(null);
                } else if (Misc.initialDDLReplayInProgress()) {
                    ((PartitionedRegion)region).localDestroyRegion(null, true);
                }
            } else {
                region.localDestroyRegion();
            }
            this.removeIdentityRegionEntries(tran);
        } else {
            region.cleanupFailedInitialization();
        }
        if (this.globalIndexMap != null) {
            this.globalIndexMap.destroyCache();
        }
        tran.getLockSpace().addToFreeResources(this);
    }

    public void removeIdentityRegionEntries(GemFireTransaction tran) {
        GemFireStore store;
        LocalRegion identityRgn;
        ExtraTableInfo tableInfo;
        LanguageConnectionContext lcc;
        if (!Misc.initialDDLReplayInProgress() && tran != null && (lcc = tran.getLanguageConnectionContext()) != null && !lcc.isConnectionForRemote() && (tableInfo = this.getExtraTableInfo()) != null && tableInfo.hasAutoGeneratedColumns() && (identityRgn = (store = Misc.getMemStore()).getIdentityRegion()) != null) {
            try {
                IdentityValueManager.GetIdentityValueMessage msg = new IdentityValueManager.GetIdentityValueMessage(identityRgn, this.getUUID(), 0L, 0L, lcc);
                msg.executeFunction();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void waitForGatewayQueuesToFlush() {
        LocalRegion region = this.getRegion();
        Set<GatewaySender> senders = this.getGatewaySenders(region);
        block2: for (GatewaySender s : senders) {
            AbstractGatewaySender sender = (AbstractGatewaySender)s;
            if (!sender.isRunning()) continue;
            RegionQueue senderQ = sender.getQueue();
            long end = System.currentTimeMillis() + (long)GfxdLockSet.MAX_LOCKWAIT_VAL;
            if (senderQ == null) continue;
            while (senderQ.size() != 0) {
                InterruptedException t = null;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    t = ie;
                }
                Misc.checkIfCacheClosing(t);
                if (System.currentTimeMillis() <= end && sender.isRunning()) continue;
                continue block2;
            }
        }
    }

    public Set<GatewaySender> getGatewaySenders(LocalRegion region) {
        THashSet tempSet = new THashSet();
        if (region.checkNotifyGatewaySender()) {
            Set allGatewaySenderIds = region.getAllGatewaySenderIds();
            for (Object s : region.getCache().getAllGatewaySenders()) {
                AbstractGatewaySender sender = (AbstractGatewaySender)s;
                if (sender.getId().startsWith("AsyncEventQueue_") || !allGatewaySenderIds.contains(sender.getId())) continue;
                tempSet.add((Object)sender);
            }
        }
        return tempSet;
    }

    public Set<AsyncEventQueue> getAsyncEventQueues(LocalRegion region) {
        THashSet tempSet = new THashSet();
        if (region.checkNotifyGatewaySender()) {
            Set allAsyncEventQueueIds = region.getAsyncEventQueueIds();
            for (Object q : region.getCache().getAsyncEventQueues()) {
                AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)q;
                if (asyncQueue.getId().startsWith("AsyncEventQueue_") || !allAsyncEventQueueIds.contains(asyncQueue.getId())) continue;
                tempSet.add((Object)asyncQueue);
            }
        }
        return tempSet;
    }

    public final boolean isInitialized() {
        if (this.region != null) {
            return this.region.isInitialized();
        }
        return this.isIndexInitialized;
    }

    public final LocalRegion getRegion() {
        return this.region;
    }

    public final boolean isAccessorForRegion() {
        LocalRegion r = this.region;
        if (r != null) {
            if (r.getPartitionAttributes() != null) {
                return r.getPartitionAttributes().getLocalMaxMemory() == 0;
            }
            return !r.getDataPolicy().withStorage();
        }
        return false;
    }

    public final RegionAttributes<?, ?> getRegionAttributes() {
        return this.regionAttributes;
    }

    public final ConcurrentSkipListMap<Object, Object> getSkipListMap() {
        return this.skipListMap;
    }

    public GfxdIndexManager getIndexManager() {
        LocalRegion r = this.region;
        if (r != null) {
            return (GfxdIndexManager)r.getIndexUpdater();
        }
        GemFireContainer c = this.baseContainer;
        if (c != null) {
            return c.getIndexManager();
        }
        return null;
    }

    public final TXStateInterface getActiveTXState(GemFireTransaction tr) {
        return tr != null && (this.containerFlags & 0x80) != 0 ? tr.getActiveTXState() : null;
    }

    public final Iterator<?> getEntrySetIterator(TXStateInterface tx, boolean primaryOnly, int scanType, boolean includeValues) {
        boolean isPR;
        boolean forUpdate = (scanType & 4) != 0;
        boolean globalScan = (scanType & 0x100000) != 0;
        boolean bl = isPR = this.regionAttributes.getPartitionAttributes() != null;
        if (globalScan && isPR) {
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIterator: In Global Scan block for container " + this));
            }
            return new PREntriesFullIterator((PartitionedRegion)this.region);
        }
        InternalDataView view = this.region.getDataView(tx);
        if (GemFireXDUtils.TraceConglomUpdate) {
            boolean isTXView = view instanceof TXStateInterface;
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIterator: Creating " + (isPR ? "Partitioned Region " : "Replicated Region ") + " based " + (isTXView ? "TX" : "non-TX") + " iterator for container " + this + (tx != null ? "; " + tx : "")));
        }
        return view.getLocalEntriesIterator((InternalRegionFunctionContext)null, primaryOnly, forUpdate, includeValues, this.region);
    }

    public final Iterator<?> getEntrySetIteratorForFunctionContext(InternalRegionFunctionContext context, GemFireTransaction tran, TXStateInterface tx, int scanType, boolean primaryOnly) {
        boolean forUpdate = (scanType & 4) != 0;
        InternalDataView view = this.region.getDataView(tx);
        if (GemFireXDUtils.TraceConglomUpdate) {
            boolean isPR = this.regionAttributes.getPartitionAttributes() != null;
            boolean isTXView = view instanceof TXStateInterface;
            Set bucketSet = context.getLocalBucketSet((Region)this.region);
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIterator: Creating " + (isPR ? "Partitioned Region " : "Replicated Region ") + " based " + (isTXView ? "TX" : "non-TX") + " iterator for container " + this + ", with bucketSet " + bucketSet + "; TX = " + tran));
        }
        return view.getLocalEntriesIterator(context, primaryOnly, forUpdate, true, this.region);
    }

    public final Iterator<?> getEntrySetIteratorForBucketSet(Set<Integer> bucketSet, GemFireTransaction tran, TXStateInterface tx, int scanType, boolean primaryOnly, boolean fetchRemote) {
        boolean forUpdate = (scanType & 4) != 0;
        InternalDataView view = this.region.getDataView(tx);
        if (GemFireXDUtils.TraceConglomUpdate) {
            boolean isPR = this.regionAttributes.getPartitionAttributes() != null;
            boolean isTXView = view instanceof TXStateInterface;
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIteratorForBucketSet: Creating " + (isPR ? "Partitioned Region " : "Replicated Region ") + " based " + (isTXView ? "TX" : "non-TX") + " iterator for container " + this + ", with bucketSet " + bucketSet + "; TX = " + tran));
        }
        return view.getLocalEntriesIterator(bucketSet, primaryOnly, forUpdate, true, this.region, fetchRemote);
    }

    public Iterator<?> getEntrySetIteratorHDFSSplit(Object hdfsSplit) {
        if (GemFireXDUtils.TraceConglomUpdate) {
            boolean isPR = this.regionAttributes.getPartitionAttributes() != null;
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIteratorHDFSSplit: Creating " + (isPR ? "Partitioned Region " : "Replicated Region ") + " based  iterator for container " + this + ", with split " + hdfsSplit));
        }
        return HDFSSplitIteratorWrapper.getIterator(this.region, hdfsSplit);
    }

    public static Iterator<?> getEntrySetIteratorForRegion(LocalRegion r) {
        boolean isPR;
        boolean bl = isPR = r.getAttributes().getPartitionAttributes() != null;
        if (isPR) {
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIterator: In Global Scan block for container " + r));
            }
            return new PREntriesFullIterator((PartitionedRegion)r);
        }
        InternalDataView view = r.getDataView((TXStateInterface)null);
        if (GemFireXDUtils.TraceConglomUpdate) {
            boolean isTXView = view instanceof TXStateInterface;
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer#getEntrySetIterator: Creating " + (isPR ? "Partitioned Region " : "Replicated Region ") + " based " + (isTXView ? "TX" : "non-TX") + " iterator for container " + r + "; "));
        }
        return view.getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, false, r);
    }

    public long getRowSize() {
        long sz;
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc != null) {
            boolean queryHDFS = lcc.getQueryHDFS();
            CompilerContext cc = (CompilerContext)lcc.getContextManager().getContext("CompilerContext");
            if (cc != null && this.regionAttributes.getDataPolicy().withPartitioning()) {
                if (cc.getHasQueryHDFS()) {
                    ((PartitionedRegion)this.region).setQueryHDFS(cc.getQueryHDFS());
                } else {
                    ((PartitionedRegion)this.region).setQueryHDFS(queryHDFS);
                }
            }
        }
        if ((sz = this.rowSize) > 0L) {
            return sz;
        }
        if (this.regionAttributes.getDataPolicy().withPartitioning()) {
            assert (this.region instanceof PartitionedRegion);
            PartitionedRegion pr = (PartitionedRegion)this.region;
            if (pr.getLocalMaxMemory() == 0) {
                return 0L;
            }
        }
        TXStateInterface tx = this.isApplicationTableOrGlobalIndex() ? TXManagerImpl.getCurrentTXState() : null;
        boolean primaryOnly = this.getRegion().isHDFSReadWriteRegion();
        Iterator<?> itr = this.getEntrySetIterator(tx, primaryOnly, 4, false);
        long newRowSize = 0L;
        while (itr.hasNext()) {
            try {
                Object val;
                RowLocation rl = (RowLocation)itr.next();
                Assert.assertTrue((rl != null ? 1 : 0) != 0, (Object)"unexpected null encountered");
                if (rl.isUpdateInProgress()) continue;
                if (this.isGlobalIndex() && (val = rl.getValueWithoutFaultIn(this)) != null) {
                    assert (val instanceof GlobalRowLocation);
                    return ((GlobalRowLocation)val).estimateMemoryUsage();
                }
                ExecRow row = rl.getRowWithoutFaultIn(this);
                if (row == null) continue;
                newRowSize = row.estimateRowSize();
                row.releaseByteSource();
                this.rowSize = newRowSize;
                break;
            }
            catch (StandardException standardException) {
            }
            catch (PrimaryBucketException primaryBucketException) {
            }
        }
        return newRowSize;
    }

    public Object insertRow(DataValueDescriptor[] row, GemFireTransaction tran, TXStateInterface tx, LanguageConnectionContext lcc, boolean isPutDML) throws StandardException {
        if (tran == null || !tran.needLogging()) {
            DataValueDescriptor[] val;
            Object regionKey;
            if (GemFireXDUtils.TraceConglomUpdate | GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: inserting row [" + RowUtil.toString(row) + "] [" + tx + "] in container: " + this.toString()));
            }
            if (this.isByteArrayStore()) {
                RowFormatter rf = this.tableInfo.getRowFormatter();
                CompactCompositeRegionKey cKey = null;
                int[] primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns();
                regionKey = this.getGeneratedKey(primaryKeyColumns);
                if (regionKey == null) {
                    cKey = new CompactCompositeRegionKey((OffHeapRegionEntry)null, this.tableInfo);
                    regionKey = cKey;
                }
                val = this.getPrimaryKeyBytesAndValue(row, rf, cKey, primaryKeyColumns);
            } else if (this.isObjectStore()) {
                Map.Entry<RegionKey, Object> entry = this.encoder.fromRow(row, this);
                regionKey = entry.getKey();
                val = entry.getValue();
            } else {
                DataValueDescriptor[] clone = (DataValueDescriptor[])row.clone();
                int[] primaryKeyColumns = GemFireXDUtils.getPrimaryKeyColumns(this.getTableDescriptor());
                for (int i = 0; i < row.length; ++i) {
                    clone[i] = row[i].getClone();
                    clone[i].setRegionContext(this.region);
                }
                regionKey = this.getGeneratedKey(primaryKeyColumns);
                if (regionKey == null) {
                    regionKey = this.getPrimaryKeyDVDs(primaryKeyColumns, clone);
                }
                val = clone;
            }
            Object routingObj = this.insert(regionKey, val, tx, lcc, false, isPutDML);
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null && routingObj != null) {
                observer.afterSingleRowInsert(routingObj);
            }
            if (lcc != null) {
                lcc.setContextObject(routingObj);
            }
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: inserted row [" + RowUtil.toString(row) + "] in container: " + this.toString()));
            }
            return regionKey;
        }
        MemInsertOperation op = new MemInsertOperation(this, row, null, null, false);
        tran.logAndDo(op);
        return op.getRegionKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ExecRow> bulkCheckForeignKeyContraints(GemFireTransaction tc, TXStateInterface tx, ExecRow[] er) throws StandardException {
        ArrayList<ExecRow> successList = null;
        GfxdIndexManager idxManager = (GfxdIndexManager)this.region.getIndexUpdater();
        Object[] fkInfo = (GfxdIndexManager.ForeignKeyInformation[])idxManager.getFKS();
        if (GemFireXDUtils.TraceConglomUpdate) {
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#bulkCheckForeignKeyContraints for region=" + this.region.getFullPath() + " FK info=" + Arrays.toString(fkInfo)));
        }
        if (fkInfo == null || fkInfo.length == 0) {
            return null;
        }
        TXManagerImpl txMgr = null;
        TXStateProxy proxy = null;
        try {
            if (tx != null && (proxy = tx.getProxy()) != tx) {
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GfxdIndexManager#checkForeignKeyConstraint:  setting proxy transaction: " + proxy + " in current thread replacing " + tx));
                }
                txMgr = tc.getTransactionManager();
                txMgr.masqueradeAs((TXStateInterface)proxy);
                tc.setActiveTXState((TXStateInterface)proxy, false);
            }
            for (int index = 0; index < fkInfo.length; ++index) {
                ExecRow[] rowsToBeInserted;
                Object fk = fkInfo[index];
                ForeignKeyConstraintDescriptor fkcd = ((GfxdIndexManager.ForeignKeyInformation)fk).getFkcd();
                if (!((GfxdIndexManager.ForeignKeyInformation)fk).getRefContainer().getRegion().getDataPolicy().withPartitioning()) continue;
                if (GemFireXDUtils.TraceConglomUpdate) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#bulkCheckForeignKeyContraints: bulk checks for parent reference container=" + ((GfxdIndexManager.ForeignKeyInformation)fk).getRefContainer() + "constraint descriptor=" + fkcd));
                }
                if (fkcd.getReferencedConstraint().getConstraintType() == 3) {
                    if (successList == null) {
                        successList = this.bulkCheckFkOnUniqueKeyColumns(((GfxdIndexManager.ForeignKeyInformation)fk).getRefContainer(), ((GfxdIndexManager.ForeignKeyInformation)fk).refIndex(), fkcd, ((GfxdIndexManager.ForeignKeyInformation)fk).getRefColsPartColsMap(), er, tc, (TXStateInterface)proxy);
                        continue;
                    }
                    rowsToBeInserted = new ExecRow[successList.size()];
                    successList.toArray(rowsToBeInserted);
                    successList = this.bulkCheckFkOnUniqueKeyColumns(((GfxdIndexManager.ForeignKeyInformation)fk).getRefContainer(), ((GfxdIndexManager.ForeignKeyInformation)fk).refIndex(), fkcd, ((GfxdIndexManager.ForeignKeyInformation)fk).getRefColsPartColsMap(), er, tc, (TXStateInterface)proxy);
                    continue;
                }
                if (successList == null) {
                    successList = this.bulkCheckFkOnPrimaryKeyColumns(((GfxdIndexManager.ForeignKeyInformation)fk).getRefContainer(), fkcd, (TXStateInterface)proxy, tc, er);
                    continue;
                }
                rowsToBeInserted = new ExecRow[successList.size()];
                successList.toArray(rowsToBeInserted);
                successList = this.bulkCheckFkOnPrimaryKeyColumns(((GfxdIndexManager.ForeignKeyInformation)fk).getRefContainer(), fkcd, (TXStateInterface)proxy, tc, rowsToBeInserted);
            }
        }
        finally {
            if (txMgr != null) {
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GfxdIndexManager#checkForeignKeyConstraint::  switching back to: " + tx + " in current thread instead of: " + proxy));
                }
                txMgr.masqueradeAs(tx);
                tc.setActiveTXState(tx, false);
            }
        }
        return successList;
    }

    private ArrayList<ExecRow> bulkCheckFkOnUniqueKeyColumns(GemFireContainer refContainer, GemFireContainer refIndex, ForeignKeyConstraintDescriptor fkCD, int[] refColsPartColsMap, ExecRow[] er, GemFireTransaction tc, TXStateInterface tx) throws StandardException {
        GfxdIndexManager idxManager = (GfxdIndexManager)this.region.getIndexUpdater();
        boolean localIndexLookup = false;
        LocalRegion refRegion = refContainer.getRegion();
        boolean isOnPR = refRegion.getDataPolicy().withPartitioning();
        HashMap<Object, List<ExecRow>> foreignKeysToExecRows = new HashMap<Object, List<ExecRow>>();
        ArrayList<ExecRow> successList = new ArrayList<ExecRow>();
        RegionExecutorMessage msg = null;
        GfxdPartitionResolver refResolver = null;
        try {
            int i;
            int j;
            ReferencedKeyConstraintDescriptor refCD = fkCD.getReferencedConstraint();
            int[] colPositionsInRefTable = refCD.getReferencedColumns();
            int[] colPositionsInThisTable = fkCD.getKeyColumns();
            if (isOnPR) {
                refResolver = (GfxdPartitionResolver)refRegion.getPartitionAttributes().getPartitionResolver();
                localIndexLookup = refIndex.isLocalIndex();
            } else {
                localIndexLookup = true;
            }
            DataValueDescriptor[] keys = null;
            DataValueDescriptor dvd = null;
            int len = colPositionsInThisTable.length;
            if (len > 1) {
                for (j = 0; j < er.length; ++j) {
                    boolean breakLoop = false;
                    keys = new DataValueDescriptor[len];
                    for (int i2 = 0; i2 < len && !breakLoop; ++i2) {
                        dvd = er[j].getColumn(colPositionsInThisTable[i2]);
                        if (dvd == null || dvd.isNull()) {
                            breakLoop = true;
                            keys = null;
                            continue;
                        }
                        keys[i2] = dvd;
                    }
                    if (keys == null) {
                        successList.add(er[j]);
                        continue;
                    }
                    if (refRegion == this.getRegion()) {
                        boolean selfSatisfied = true;
                        for (i = 0; i < len; ++i) {
                            if (idxManager.compareKeyToBytes(er[j], keys[i], colPositionsInRefTable[i], colPositionsInThisTable[i])) continue;
                            selfSatisfied = false;
                            break;
                        }
                        if (selfSatisfied) {
                            successList.add(er[j]);
                            continue;
                        }
                        this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, keys, er[j]);
                        continue;
                    }
                    this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, keys, er[j]);
                }
            } else {
                for (j = 0; j < er.length; ++j) {
                    dvd = er[j].getColumn(colPositionsInThisTable[0]);
                    if (dvd == null || dvd.isNull()) {
                        successList.add(er[j]);
                        continue;
                    }
                    if (refRegion == this.getRegion()) {
                        if (dvd.equals(er[j].getColumn(colPositionsInRefTable[0]))) {
                            successList.add(er[j]);
                            continue;
                        }
                        this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, dvd, er[j]);
                        continue;
                    }
                    this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, dvd, er[j]);
                }
            }
            Object[] foreignKeys2 = foreignKeysToExecRows.keySet().toArray();
            Object result = null;
            if (foreignKeys2 != null && foreignKeys2.length > 0) {
                if (!isOnPR) {
                    assert (false) : "Bulk fk checks not expected to be done on replicated parent region";
                    return null;
                }
                if (localIndexLookup) {
                    Object[] routingObjects = new Object[foreignKeys2.length];
                    if (len == 1) {
                        for (i = 0; i < foreignKeys2.length; ++i) {
                            routingObjects[i] = refResolver.getRoutingKeyForColumn((DataValueDescriptor)foreignKeys2[i]);
                        }
                    } else if (refColsPartColsMap == null) {
                        for (i = 0; i < foreignKeys2.length; ++i) {
                            routingObjects[i] = refResolver.getRoutingObjectsForPartitioningColumns((DataValueDescriptor[])foreignKeys2[i]);
                        }
                    } else {
                        for (i = 0; i < foreignKeys2.length; ++i) {
                            int partitioningColsCount = refResolver.getPartitioningColumnsCount();
                            keys = (DataValueDescriptor[])foreignKeys2[i];
                            DataValueDescriptor[] rkeys = new DataValueDescriptor[partitioningColsCount];
                            for (int j2 = 0; j2 < partitioningColsCount; ++j2) {
                                rkeys[j2] = keys[refColsPartColsMap[j2]];
                            }
                            routingObjects[i] = refResolver.getRoutingObjectsForPartitioningColumns(rkeys);
                        }
                    }
                    if (GemFireXDUtils.TraceConglomUpdate) {
                        SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#bulkCheckFkOnUniqueKeyColumns: sending ContainsUniqueKeyBulkExecutorMessage for local index look up parent reference region=" + refRegion));
                    }
                    msg = new ContainsUniqueKeyBulkExecutorMessage(refRegion, colPositionsInRefTable, foreignKeys2, routingObjects, tx, tc.getLanguageConnectionContext());
                    result = msg.executeFunction();
                    assert (result instanceof GfxdListResultCollector);
                    this.processResultOfBulkExecutorMessage(result, foreignKeysToExecRows, fkCD);
                } else {
                    LocalRegion globalIndexRegion = refIndex.getRegion();
                    if (globalIndexRegion == null) {
                        Assert.fail((Object)("unexpected null global index region for unique index on columns " + refCD.getColumnDescriptors() + " for parent table " + refCD.getTableDescriptor()));
                    }
                    Object[] routingObjects = new Object[foreignKeys2.length];
                    Object[] indexKeys = new Object[foreignKeys2.length];
                    boolean formCompositeKey = foreignKeys2[0] instanceof DataValueDescriptor[];
                    for (int i3 = 0; i3 < foreignKeys2.length; ++i3) {
                        if (formCompositeKey) {
                            indexKeys[i3] = new CompositeRegionKey((DataValueDescriptor[])foreignKeys2[i3]);
                            List l = (List)foreignKeysToExecRows.remove(foreignKeys2[i3]);
                            foreignKeysToExecRows.put(indexKeys[i3], l);
                        } else {
                            indexKeys[i3] = foreignKeys2[i3];
                        }
                        routingObjects[i3] = PartitionedRegionHelper.getHashKey((PartitionedRegion)((PartitionedRegion)globalIndexRegion), (Object)indexKeys[i3]);
                    }
                    if (GemFireXDUtils.TraceConglomUpdate) {
                        SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#bulkCheckFkOnUniqueKeyColumns: sending ContainsKeyBulkExecutorMessage for global index look upglobal index=" + globalIndexRegion));
                    }
                    msg = new ContainsKeyBulkExecutorMessage(globalIndexRegion, indexKeys, routingObjects, tx, tc.getLanguageConnectionContext());
                    result = msg.executeFunction();
                    assert (result instanceof GfxdListResultCollector);
                    this.processResultOfBulkExecutorMessage(result, foreignKeysToExecRows, fkCD);
                }
            }
            for (List l : foreignKeysToExecRows.values()) {
                successList.addAll(l);
            }
            return successList;
        }
        catch (SQLException sqle) {
            throw Misc.wrapRemoteSQLException(sqle, sqle, null);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (RuntimeException re) {
            Exception cause = idxManager.handleFKException(re);
            throw StandardException.newException("23503", cause, (Object)fkCD.getConstraintName(), (Object)this.getTableName(), (Object)"INSERT");
        }
    }

    private ArrayList<ExecRow> bulkCheckFkOnPrimaryKeyColumns(GemFireContainer refContainer, ForeignKeyConstraintDescriptor fkCd, TXStateInterface tx, GemFireTransaction tc, ExecRow[] er) throws StandardException {
        int i;
        boolean requiresGlobalIndex;
        GfxdPartitionResolver refResolver;
        GfxdIndexManager idxManager = (GfxdIndexManager)this.region.getIndexUpdater();
        LocalRegion refRegion = refContainer.getRegion();
        PartitionAttributes pattrs = refRegion.getPartitionAttributes();
        DataPolicy refDP = refRegion.getDataPolicy();
        int[] refCols = fkCd.getReferencedColumns();
        int[] colPositionsInThisTable = fkCd.getKeyColumns();
        HashMap<Object, List<ExecRow>> foreignKeysToExecRows = new HashMap<Object, List<ExecRow>>();
        ArrayList<ExecRow> successList = new ArrayList<ExecRow>();
        Object gfKey = null;
        boolean isOnReplicate = refDP.withReplication();
        assert (!isOnReplicate);
        if (pattrs != null) {
            refResolver = (GfxdPartitionResolver)pattrs.getPartitionResolver();
            requiresGlobalIndex = refResolver.requiresGlobalIndex();
        } else {
            refResolver = null;
            requiresGlobalIndex = false;
        }
        int size = refCols.length;
        if (size == 0) {
            GemFireXDUtils.throwAssert("foreign key constraint should not have zero columns: " + fkCd + "; for container: " + this);
        }
        if (requiresGlobalIndex) {
            if (size == 1) {
                for (i = 0; i < er.length; ++i) {
                    DataValueDescriptor key = er[i].getColumn(refCols[0]);
                    if (key == null || key.isNull()) {
                        successList.add(er[i]);
                        continue;
                    }
                    if (refRegion == this.getRegion()) {
                        if (key.equals(er[i].getColumn(colPositionsInThisTable[0]))) {
                            successList.add(er[i]);
                            continue;
                        }
                        this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, gfKey, er[i]);
                        continue;
                    }
                    gfKey = key;
                    this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, gfKey, er[i]);
                }
            } else {
                for (i = 0; i < er.length; ++i) {
                    DataValueDescriptor[] primaryKey = new DataValueDescriptor[size];
                    Boolean breakLoop = false;
                    for (int index = 0; index < size && !breakLoop.booleanValue(); ++index) {
                        DataValueDescriptor dvd = er[i].getColumn(refCols[index]);
                        if (dvd == null || dvd.isNull()) {
                            primaryKey = null;
                            breakLoop = true;
                            continue;
                        }
                        primaryKey[index] = dvd;
                    }
                    if (primaryKey == null) {
                        successList.add(er[i]);
                        continue;
                    }
                    if (refRegion == this.getRegion()) {
                        boolean selfSatisfied = true;
                        for (int k = 0; k < size; ++k) {
                            if (idxManager.compareKeyToBytes(er[i], primaryKey[k], colPositionsInThisTable[k], refCols[k])) continue;
                            selfSatisfied = false;
                            break;
                        }
                        if (selfSatisfied) {
                            successList.add(er[i]);
                            continue;
                        }
                        this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, gfKey, er[i]);
                        continue;
                    }
                    gfKey = new CompositeRegionKey(primaryKey);
                    this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, gfKey, er[i]);
                }
            }
        } else {
            for (i = 0; i < er.length; ++i) {
                gfKey = idxManager.getRefRegionKey(refContainer, refCols, fkCd, er[i], this.tableInfo);
                if (gfKey == null) {
                    successList.add(er[i]);
                    continue;
                }
                if (refRegion == this.getRegion()) {
                    RegionKey refKey = GemFireXDUtils.convertIntoGemFireRegionKey(er[i], this, this.tableInfo, null);
                    if (refKey != null && refKey.equals(gfKey)) {
                        successList.add(er[i]);
                        continue;
                    }
                    this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, gfKey, er[i]);
                    continue;
                }
                this.addEntryToFkToExecRowsMap(foreignKeysToExecRows, gfKey, er[i]);
            }
        }
        ContainsKeyBulkExecutorMessage bmsg = null;
        Object[] foreignKeys2 = foreignKeysToExecRows.keySet().toArray();
        try {
            if (refResolver != null && foreignKeys2 != null && foreignKeys2.length > 0) {
                int k;
                Object[] routingObjects = new Object[foreignKeys2.length];
                if (requiresGlobalIndex) {
                    for (k = 0; k < foreignKeys2.length; ++k) {
                        if (foreignKeys2[k] == null) continue;
                        refRegion = refResolver.getGlobalIndexContainer().getRegion();
                        routingObjects[k] = PartitionedRegionHelper.getHashKey((PartitionedRegion)((PartitionedRegion)refRegion), (Object)foreignKeys2[k]);
                    }
                } else {
                    for (k = 0; k < foreignKeys2.length; ++k) {
                        if (foreignKeys2[k] == null) continue;
                        routingObjects[k] = refResolver.getRoutingObject(foreignKeys2[k], null, (Region<?, ?>)refRegion);
                    }
                }
                if (GemFireXDUtils.TraceConglomUpdate) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#bulkCheckFkOnPrimaryKeyColumns sending ContainsKeyBulkExecutorMessage for " + (requiresGlobalIndex ? "global index:" : "local index on region:") + refRegion));
                }
                bmsg = new ContainsKeyBulkExecutorMessage(refRegion, foreignKeys2, routingObjects, tx, tc.getLanguageConnectionContext());
                Object result = bmsg.executeFunction();
                assert (result instanceof GfxdListResultCollector);
                this.processResultOfBulkExecutorMessage((GfxdListResultCollector)result, foreignKeysToExecRows, fkCd);
            }
            for (List l : foreignKeysToExecRows.values()) {
                successList.addAll(l);
            }
            return successList;
        }
        catch (SQLException sqle) {
            throw Misc.wrapRemoteSQLException(sqle, sqle, null);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (RuntimeException re) {
            Exception cause = idxManager.handleFKException(re);
            throw StandardException.newException("23503", cause, (Object)fkCd.getConstraintName(), (Object)this.getTableName(), (Object)"INSERT");
        }
    }

    private void addEntryToFkToExecRowsMap(Map<Object, List<ExecRow>> foreignKeysToExecRows, Object key, ExecRow er) {
        List<ExecRow> l = foreignKeysToExecRows.get(key);
        if (l == null) {
            l = new ArrayList<ExecRow>();
            foreignKeysToExecRows.put(key, l);
        }
        l.add(er);
    }

    private void processResultOfBulkExecutorMessage(GfxdListResultCollector result, Map<Object, List<ExecRow>> foreignKeysToExecRows, ForeignKeyConstraintDescriptor fkCD) throws StandardException {
        Object resultList = result.getResult();
        Iterator iterator = ((ArrayList)resultList).iterator();
        while (iterator.hasNext()) {
            Object oneResult = iterator.next();
            GfxdListResultCollector.ListResultCollectorValue l = (GfxdListResultCollector.ListResultCollectorValue)oneResult;
            BulkKeyLookupResult brs = (BulkKeyLookupResult)l.resultOfSingleExecution;
            if (brs.exists) continue;
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#processResultOfBulkExecutorMessage found a FK constraint violation for FK key info=" + brs));
            }
            ExecRow row = foreignKeysToExecRows.get(brs.gfKey).get(0);
            throw StandardException.newException("23503", null, (Object)fkCD.getConstraintName(), (Object)this.getTableName(), (Object)"INSERT", (Object)(row == null ? "(currentRow is null)" : com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(row, fkCD.getKeyColumns())));
        }
    }

    public ArrayList<Object> doBulkFkChecks(ArrayList<Object> rows, LanguageConnectionContext lcc, RowFormatter rf, TXStateInterface tx) throws StandardException {
        Object o;
        int i;
        boolean hasLobs;
        int numRows = rows.size();
        ArrayList<ExecRow> successList = null;
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        boolean byteArrayStore = this.isByteArrayStore();
        assert (rf != null);
        ExecRow[] er = new ExecRow[numRows];
        boolean bl = hasLobs = this.hasLobs && GemFireContainer.reallyHasLobs(rf);
        if (this.isOffHeap()) {
            for (i = 0; i < numRows; ++i) {
                o = rows.get(i);
                if (!byteArrayStore) continue;
                er[i] = hasLobs ? new OffHeapCompactExecRowWithLobs(o, rf) : new OffHeapCompactExecRow(o, rf);
            }
        } else {
            for (i = 0; i < numRows; ++i) {
                o = rows.get(i);
                if (!byteArrayStore) continue;
                er[i] = hasLobs ? new CompactExecRowWithLobs((byte[][])o, rf) : new CompactExecRow((byte[])o, rf);
            }
        }
        successList = this.bulkCheckForeignKeyContraints(tc, tx, er);
        ArrayList<Object> rowList = null;
        if (successList != null) {
            rowList = new ArrayList<Object>();
            for (ExecRow r : successList) {
                if (!byteArrayStore) continue;
                if (hasLobs) {
                    rowList.add(((AbstractCompactExecRow)r).getRowByteArrays());
                    continue;
                }
                rowList.add(((AbstractCompactExecRow)r).getRowBytes());
            }
        }
        return rowList;
    }

    public boolean canDoBulkFKChecks() {
        boolean doBulkChecks = false;
        GfxdIndexManager idxManager = (GfxdIndexManager)this.region.getIndexUpdater();
        if (idxManager == null) {
            return false;
        }
        GfxdIndexManager.ForeignKeyInformation[] fkInfoArray = (GfxdIndexManager.ForeignKeyInformation[])idxManager.getFKS();
        if (fkInfoArray == null || fkInfoArray.length == 0) {
            return false;
        }
        for (int index = 0; index < fkInfoArray.length; ++index) {
            GfxdIndexManager.ForeignKeyInformation fk = fkInfoArray[index];
            if (!fk.getRefContainer().getRegion().getDataPolicy().withPartitioning()) continue;
            doBulkChecks = true;
        }
        return doBulkChecks;
    }

    /*
     * WARNING - void declaration
     */
    public final void insertMultipleRows(ArrayList<Object> rows, TXStateInterface tx, LanguageConnectionContext lcc, boolean markPkBased, boolean isPutDML) throws StandardException {
        int[] primaryKeyColumns;
        RowFormatter rf;
        boolean bulkFkChecksEnabled;
        boolean skipConstraintChecks;
        boolean skipListeners;
        boolean possibleDuplicate;
        boolean byteArrayStore = this.isByteArrayStore();
        int numRows = rows.size();
        if (lcc != null) {
            possibleDuplicate = lcc.isPossibleDuplicate();
            skipListeners = lcc.isSkipListeners();
            skipConstraintChecks = lcc.isSkipConstraintChecks();
            if (skipConstraintChecks) {
                isPutDML = true;
            }
            bulkFkChecksEnabled = !skipConstraintChecks && lcc.bulkFkChecksEnabled();
        } else {
            possibleDuplicate = false;
            skipListeners = false;
            skipConstraintChecks = false;
            bulkFkChecksEnabled = false;
        }
        if (byteArrayStore) {
            rf = this.tableInfo.getRowFormatter();
            primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns();
        } else {
            rf = null;
            primaryKeyColumns = GemFireXDUtils.getPrimaryKeyColumns(this.getTableDescriptor());
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.insertMultipleRowsBeingInvoked(numRows);
            observer.invokeCacheCloseAtMultipleInsert();
        }
        if (GemFireXDUtils.TraceConglomUpdate | GemFireXDUtils.TraceQuery) {
            // empty if block
        }
        if (this.region.getDataPolicy() == DataPolicy.EMPTY && !this.region.getScope().isLocal() && ((DistributedRegion)this.region).noInitializedReplicate()) {
            throw StandardException.newException("X0Z08.S", "insert of rows into replicated table " + this.qualifiedName);
        }
        ArrayList<Object> rowList = null;
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        if (bulkFkChecksEnabled && byteArrayStore && !dsys.isLoner() && this.canDoBulkFKChecks()) {
            rowList = this.doBulkFkChecks(rows, lcc, rf, tx);
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GFC#insertMultipleRows: number of rows that can be iserted successfully after bulk fk checks=" + (rowList != null ? Integer.valueOf(rowList.size()) : "0")));
            }
        } else {
            bulkFkChecksEnabled = false;
            rowList = rows;
        }
        boolean noLobs = rf == null || !rf.hasLobs();
        LinkedHashMap<Object, void> toBeInsertedRows = new LinkedHashMap<Object, void>();
        Object[] callbackArgs = null;
        int j = 0;
        try {
            if (rowList != null) {
                for (Object object : rowList) {
                    void var22_24;
                    void oldObj;
                    Object regionKey;
                    if (byteArrayStore) {
                        regionKey = primaryKeyColumns == null ? this.getGeneratedKey() : new CompactCompositeRegionKey(noLobs ? (byte[])object : ((byte[][])object)[0], this.tableInfo);
                        Object routingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(this.region, regionKey, object);
                        Object sca = this.getCallbackArgument(routingObject, lcc, tx, false, false, markPkBased, skipListeners, bulkFkChecksEnabled, skipConstraintChecks);
                        if (sca != null) {
                            if (callbackArgs == null) {
                                callbackArgs = new Object[numRows];
                            }
                            callbackArgs[j++] = sca;
                        }
                    } else {
                        void var22_28;
                        DataValueDescriptor[] row = (DataValueDescriptor[])object;
                        if (this.isObjectStore()) {
                            Map.Entry<RegionKey, Object> entry = this.encoder.fromRow(row, this);
                            regionKey = entry.getKey();
                            Object object2 = entry.getValue();
                        } else {
                            for (int i = 0; i < row.length; ++i) {
                                row[i].setRegionContext(this.region);
                            }
                            regionKey = this.getGeneratedKey(primaryKeyColumns);
                            if (regionKey == null) {
                                regionKey = this.getPrimaryKeyDVDs(primaryKeyColumns, row);
                            }
                            DataValueDescriptor[] dataValueDescriptorArray = row;
                        }
                        Object routingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(this.region, regionKey, var22_28);
                        Object sca = this.getCallbackArgument(routingObject, lcc, tx, false, false, markPkBased, skipListeners, bulkFkChecksEnabled, skipConstraintChecks);
                        if (sca != null) {
                            if (callbackArgs == null) {
                                callbackArgs = new Object[numRows];
                            }
                            callbackArgs[j++] = sca;
                        }
                    }
                    if ((oldObj = toBeInsertedRows.put(regionKey, var22_24)) == null || isPutDML) continue;
                    throw new EntryExistsException(regionKey.toString(), (Object)oldObj);
                }
            }
            if (observer != null) {
                observer.putAllCalledWithMapSize(toBeInsertedRows.size());
            }
            DistributedPutAllOperation putAllOp = null;
            putAllOp = isPutDML ? this.region.newPutAllForPUTDmlOperation(toBeInsertedRows) : this.region.newPutAllOperation(toBeInsertedRows);
            if (putAllOp != null) {
                if (possibleDuplicate) {
                    putAllOp.getBaseEvent().setPossibleDuplicate(possibleDuplicate);
                }
                if (callbackArgs != null) {
                    putAllOp.setCallbackArgs(callbackArgs);
                }
                this.region.basicPutAll(toBeInsertedRows, putAllOp, null);
                if (observer != null && observer.throwPutAllPartialException()) {
                    PutAllPartialResultException.PutAllPartialResult putAllPartialResult = new PutAllPartialResultException.PutAllPartialResult(toBeInsertedRows.size());
                    putAllPartialResult.saveFailedKey(toBeInsertedRows.keySet().iterator().next(), (Exception)new PartitionedRegionStorageException(LocalizedStrings.PRHARRedundancyProvider_UNABLE_TO_FIND_ANY_MEMBERS_TO_HOST_A_BUCKET_IN_THE_PARTITIONED_REGION_0.toLocalizedString(new Object[]{PRHARedundancyProvider.INSUFFICIENT_STORES_MSG, "Partitioned Region name = " + this.region.getFullPath()})));
                    PutAllPartialResultException ppre = new PutAllPartialResultException(putAllPartialResult);
                    throw ppre;
                }
            }
        }
        catch (GemFireException gfeex) {
            void var22_32;
            Object var22_30 = null;
            for (Throwable t = gfeex; t != null; t = t.getCause()) {
                if (!(t instanceof EntryExistsException)) continue;
                EntryExistsException entryExistsException = (EntryExistsException)t;
                break;
            }
            if (var22_32 != null) {
                boolean isGlobalIndex = this.isGlobalIndex();
                if (!isGlobalIndex && possibleDuplicate) {
                    return;
                }
                String constraintType = isGlobalIndex ? "unique constraint" : "primary key constraint";
                String valueMessage = null;
                if (toBeInsertedRows != null) {
                    if (toBeInsertedRows.size() > 5) {
                        StringBuilder sb = new StringBuilder();
                        sb.append('[');
                        int num = 0;
                        for (Map.Entry e : toBeInsertedRows.entrySet()) {
                            sb.append(e.getKey()).append('=').append(e.getValue()).append(", ");
                            if (++num < 5) continue;
                            sb.append("...]");
                            break;
                        }
                        valueMessage = sb.toString();
                    } else {
                        valueMessage = ((Object)toBeInsertedRows).toString();
                    }
                }
                throw GemFireXDUtils.newDuplicateKeyViolation(constraintType, this.qualifiedName, valueMessage, (EntryExistsException)var22_32);
            }
            throw Misc.processGemFireException(gfeex, gfeex, "insert of keys " + toBeInsertedRows.keySet() + " into table " + this.qualifiedName, true);
        }
        catch (RuntimeException e) {
            throw this.processRuntimeException(e, "insert of keys " + toBeInsertedRows.keySet() + " into table " + this.qualifiedName);
        }
    }

    public void insert(Object key, Object value, boolean needsRoutingObject, GemFireTransaction tran, TXStateInterface tx, LanguageConnectionContext lcc, boolean isCacheLoaded, boolean isPutDML, boolean wasPutDML) throws StandardException {
        if (tran == null || !tran.needLogging()) {
            if (needsRoutingObject) {
                Object routingObj = this.insert(key, value, tx, lcc, isCacheLoaded, isPutDML);
                if (lcc != null) {
                    lcc.setContextObject(routingObj);
                }
            } else {
                this.insert(key, value, null, tx, lcc, isCacheLoaded, isPutDML, wasPutDML);
            }
        } else {
            MemInsertOperation op = new MemInsertOperation(this, null, key, value, isCacheLoaded);
            tran.logAndDo(op);
        }
    }

    public final long newUUIDForRegionKey() {
        long uuid = this.region.newUUID(false);
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer == null) {
            return uuid;
        }
        return observer.overrideUniqueID(uuid, true);
    }

    private Long getGeneratedKey() throws StandardException {
        try {
            return this.newUUIDForRegionKey();
        }
        catch (IllegalStateException ise) {
            throw StandardException.newException("X0Z13.S", (Throwable)ise, (Object)this.getQualifiedTableName());
        }
    }

    private Long getGeneratedKey(int[] primaryKeyColumns) throws StandardException {
        if (primaryKeyColumns == null) {
            return this.getGeneratedKey();
        }
        return null;
    }

    private Object getPrimaryKeyBytesAndValue(DataValueDescriptor[] row, RowFormatter rf, CompactCompositeRegionKey cKey, int[] primaryKeyColumns) throws StandardException {
        Object val;
        byte[] valBytes;
        if (!rf.hasLobs()) {
            valBytes = rf.generateBytes(row);
            if (cKey == null) {
                return valBytes;
            }
            val = valBytes;
        } else {
            byte[][] rowByteArrays = rf.generateByteArrays(row);
            if (cKey == null) {
                return rowByteArrays;
            }
            valBytes = rowByteArrays[0];
            val = rowByteArrays;
        }
        cKey.setValueBytes(valBytes);
        return val;
    }

    private Object getPrimaryKeyDVDs(int[] primaryKeyColumns, DataValueDescriptor[] clone) {
        assert (clone != null);
        int numCols = primaryKeyColumns.length;
        if (numCols == 1) {
            DataValueDescriptor key = clone[primaryKeyColumns[0] - 1];
            key.setRegionContext(this.region);
            return key;
        }
        DataValueDescriptor[] primaryKey = new DataValueDescriptor[numCols];
        for (int i = 0; i < numCols; ++i) {
            primaryKey[i] = clone[primaryKeyColumns[i] - 1];
            primaryKey[i].setRegionContext(this.region);
        }
        return new CompositeRegionKey(primaryKey);
    }

    private Object insert(Object key, Object value, TXStateInterface tx, LanguageConnectionContext lcc, boolean isCacheLoaded, boolean isPutDML) throws StandardException {
        assert (key != null && value != null);
        Object routingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(this.region, key, value);
        this.insert(key, value, routingObject, tx, lcc, isCacheLoaded, isPutDML, false);
        return routingObject;
    }

    private void insert(Object key, Object value, Object callbackArg, TXStateInterface tx, LanguageConnectionContext lcc, boolean isCacheLoaded, boolean isPutDML, boolean wasPutDML) throws StandardException {
        boolean skipConstraintChecks;
        boolean skipListeners;
        boolean isTrigger;
        boolean possibleDuplicate;
        if (lcc != null) {
            possibleDuplicate = lcc.isPossibleDuplicate();
            isTrigger = lcc.isTriggerBody();
            skipListeners = lcc.isSkipListeners();
            skipConstraintChecks = lcc.isSkipConstraintChecks();
            if (skipConstraintChecks) {
                isPutDML = true;
            }
        } else {
            possibleDuplicate = false;
            isTrigger = false;
            skipListeners = false;
            skipConstraintChecks = false;
        }
        try {
            if (this.region.getDataPolicy() == DataPolicy.EMPTY && !this.region.getScope().isLocal() && ((DistributedRegion)this.region).noInitializedReplicate()) {
                throw StandardException.newException("X0Z08.S", "insert of key " + key + " into replicated table " + this.qualifiedName);
            }
            Object sca = this.getCallbackArgument(callbackArg, lcc, tx, !isTrigger, isCacheLoaded, true, skipListeners, false, skipConstraintChecks);
            long startPut = CachePerfStats.getStatTime();
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: inserting key [" + key + "] value [" + value + "] [" + tx + "] in container: " + this.toString()));
            }
            if (possibleDuplicate && !this.isGlobalIndex()) {
                EntryEventImpl event = this.region.newUpdateEntryEvent(key, value, sca);
                event.setPossibleDuplicate(true);
                event.setTXState(tx);
                this.region.validatedPut(event, startPut);
            } else if (isPutDML) {
                EntryEventImpl event = this.region.newPutEntryEvent(key, value, sca);
                event.setTXState(tx);
                this.region.validatedPut(event, startPut);
            } else {
                EntryEventImpl event = this.region.newCreateEntryEvent(key, value, sca);
                event.setTXState(tx);
                this.region.validatedCreate(event, startPut);
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null) {
                    int bid = event.getBucketId();
                    observer.bucketIdcalculated(bid);
                }
            }
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: successfully inserted key [" + key + "] value [" + value + "] in container: " + this.toString()));
            }
        }
        catch (GemFireException gfeex) {
            EntryExistsException eee = null;
            for (Throwable t = gfeex; t != null; t = t.getCause()) {
                if (!(t instanceof EntryExistsException)) continue;
                eee = (EntryExistsException)t;
                break;
            }
            if (eee != null) {
                boolean isGlobalIndex = this.isGlobalIndex();
                if (!isGlobalIndex && possibleDuplicate) {
                    return;
                }
                String constraintType = isGlobalIndex && wasPutDML ? "Update of partitioning column not supported" : (isGlobalIndex ? "unique constraint" : "primary key constraint");
                if (isGlobalIndex && wasPutDML) {
                    throw GemFireXDUtils.newPutPartitionColumnViolation(constraintType, this.qualifiedName, eee.getLocalizedMessage(), eee.getOldValue(), value, eee);
                }
                throw GemFireXDUtils.newDuplicateKeyViolation(constraintType, this.qualifiedName, value, eee);
            }
            throw Misc.processGemFireException(gfeex, gfeex, "insert of key " + key + " into table " + this.qualifiedName, true);
        }
        catch (StandardException ex) {
            if (isCacheLoaded) {
                if (!"23505".equals(ex.getSQLState()) && !"23503".equals(ex.getSQLState())) {
                    throw ex;
                }
            }
            throw ex;
        }
        catch (RuntimeException e) {
            throw this.processRuntimeException(e, "insert of key " + key + " into table " + this.qualifiedName);
        }
    }

    private Object getCallbackArgument(Object callbackArg, LanguageConnectionContext lcc, TXStateInterface tx, boolean threadLocalType, boolean isCacheLoaded, boolean isPkBased, boolean skipListeners, boolean bulkFkChecksEnabled, boolean skipConstraintChecks) {
        if (this.isApplicationTable()) {
            GatewaySenderEventCallbackArgument gatewayCallbackArg;
            GfxdCallbackArgument sca = GemFireXDUtils.wrapCallbackArgs(callbackArg, lcc, tx != null, threadLocalType, isCacheLoaded, isPkBased, skipListeners, bulkFkChecksEnabled, skipConstraintChecks);
            GatewaySenderEventCallbackArgument gatewaySenderEventCallbackArgument = gatewayCallbackArg = lcc != null ? lcc.getGatewaySenderEventCallbackArg() : null;
            if (gatewayCallbackArg != null) {
                GatewaySenderEventCallbackArgumentImpl newCallbackArg = new GatewaySenderEventCallbackArgumentImpl((Object)sca, gatewayCallbackArg.getOriginatingDSId(), (Collection)gatewayCallbackArg.getRecipientDSIds(), true);
                sca = newCallbackArg;
            }
            return sca;
        }
        return null;
    }

    public void put(Object key, Object value, Object callbackArg) throws StandardException {
        try {
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: updating key [" + key + "] with value [" + value + "] callbackArg=" + callbackArg + ", in container: " + this.toString()));
            }
            this.region.put(key, value, callbackArg);
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: successfully updated key [" + key + "] with value [" + value + "] in container: " + this.toString()));
            }
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "put of key " + key + " into table " + this.qualifiedName, true);
        }
        catch (RuntimeException e) {
            throw this.processRuntimeException(e, "put of key " + key + " into table " + this.qualifiedName);
        }
    }

    public Object pkBasedDelete(Object key, GemFireTransaction tran, TXStateInterface tx, LanguageConnectionContext lcc) throws StandardException {
        assert (key instanceof Long || key instanceof RegionKey) : "key can only be of type long or RegionKey; found: " + key;
        Object routingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(this.region, key, null);
        if (tran == null || !tran.needLogging()) {
            return this.deleteFromContainer(key, routingObject, true, tx, lcc, false);
        }
        MemDeleteOperation op = new MemDeleteOperation(this, key, routingObject, true, false);
        tran.logAndDo(op);
        return op.getOldValue();
    }

    public Object delete(Object key, Object callbackArg, boolean isPkBased, GemFireTransaction tran, TXStateInterface tx, LanguageConnectionContext lcc, boolean doEvict) throws StandardException {
        if (tran == null || !tran.needLogging()) {
            return this.deleteFromContainer(key, callbackArg, isPkBased, tx, lcc, doEvict);
        }
        MemDeleteOperation op = new MemDeleteOperation(this, key, callbackArg, false, doEvict);
        tran.logAndDo(op);
        return op.getOldValue();
    }

    private Object deleteFromContainer(Object key, Object callbackArg, boolean isPkBased, TXStateInterface tx, LanguageConnectionContext lcc, boolean doEvict) throws StandardException {
        try {
            boolean skipConstraintChecks;
            boolean skipListeners;
            boolean possibleDuplicate;
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: deleting key [" + key + "] from container: " + this.toString() + " with callbackArg: " + callbackArg));
            }
            Object oldValue = null;
            if (lcc != null) {
                possibleDuplicate = lcc.isPossibleDuplicate();
                skipListeners = lcc.isSkipListeners();
                skipConstraintChecks = lcc.isSkipConstraintChecks();
            } else {
                possibleDuplicate = false;
                skipListeners = false;
                skipConstraintChecks = false;
            }
            boolean isTrigger = lcc != null && lcc.isTriggerBody();
            Object sca = this.getCallbackArgument(callbackArg, lcc, tx, !isTrigger, false, isPkBased, skipListeners, false, skipConstraintChecks);
            String strRepOfKeyBeingRemoved = null;
            if (GemFireXDUtils.TraceConglomUpdate) {
                strRepOfKeyBeingRemoved = key.toString();
            }
            EntryEventImpl event = this.region.newDestroyEntryEvent(key, sca);
            event.setPossibleDuplicate(possibleDuplicate);
            event.setTXState(tx);
            if (doEvict) {
                if (GemFireXDUtils.TraceConglomUpdate) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: evicting key [" + strRepOfKeyBeingRemoved + "] from container: " + this.toString() + " with callbackArg: " + callbackArg));
                }
                event.setOperation(Operation.CUSTOM_EVICT_DESTROY);
                event.setCustomEviction(true);
            }
            oldValue = this.region.validatedDestroy(key, event);
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: deleted key [" + strRepOfKeyBeingRemoved + "] from container: " + this.toString() + " with callbackArg: " + callbackArg));
            }
            return oldValue;
        }
        catch (GemFireException gfeex) {
            StandardException se;
            try {
                se = Misc.processGemFireException(gfeex, gfeex, "delete of key " + key + " from table " + this.qualifiedName, true);
            }
            catch (GemFireException ge) {
                throw ge;
            }
            catch (Exception ignore) {
                throw Misc.processGemFireException(gfeex, gfeex, "<none> could not log key name as key bytes from offheap could not be obtained as memory was already freed. table is " + this.qualifiedName, true);
            }
            throw se;
        }
        catch (RuntimeException e) {
            StandardException se;
            try {
                se = this.processRuntimeException(e, "delete of key " + key + " from table " + this.qualifiedName);
            }
            catch (Exception ignore) {
                throw this.processRuntimeException(e, "<none> could not log key name as key bytes from offheap could not be obtained as memory was already freed. table is " + this.qualifiedName);
            }
            throw se;
        }
    }

    public Object replacePartialRow(Object key, FormatableBitSet validColumns, DataValueDescriptor[] changedRow, Object callbackArg, GemFireTransaction tran, TXStateInterface tx, LanguageConnectionContext lcc, GemFireUpdateActivation.MultipleKeyValueHolder mkvh, boolean flushBatch) throws StandardException {
        if (tran == null || !tran.needLogging()) {
            return this.replacePartialRow(key, callbackArg, true, validColumns, changedRow, true, tx, lcc, mkvh, flushBatch);
        }
        MemUpdateOperation op = new MemUpdateOperation(this, changedRow, null, key, validColumns, -1, callbackArg);
        tran.logAndDo(op);
        return op.getOldValue();
    }

    public Object replacePartialRow(RegionEntry entry, FormatableBitSet validColumns, DataValueDescriptor[] changedRow, int bucketId, GemFireTransaction tran, TXStateInterface tx, LanguageConnectionContext lcc) throws StandardException {
        if (tran == null || !tran.needLogging()) {
            return this.replacePartialRowInContainer(entry, validColumns, changedRow, bucketId, tx, lcc);
        }
        MemUpdateOperation op = new MemUpdateOperation(this, changedRow, entry, entry.getKeyCopy(), validColumns, bucketId, null);
        tran.logAndDo(op);
        return op.getOldValue();
    }

    private Object replacePartialRow(Object key, Object callbackArg, boolean isPkBased, FormatableBitSet validColumns, DataValueDescriptor[] changedRow, boolean typeResolution, TXStateInterface tx, LanguageConnectionContext lcc, GemFireUpdateActivation.MultipleKeyValueHolder mkvh, boolean flushBatch) throws StandardException {
        assert (key instanceof Long || key instanceof RegionKey) : key.getClass().getName();
        try {
            boolean skipConstraintChecks;
            boolean skipListeners;
            boolean isTrigger;
            boolean possibleDuplicate;
            if (typeResolution && this.tableInfo != null) {
                DataValueDescriptor dvd;
                DataValueDescriptor origDVD;
                DataTypeDescriptor dtd;
                int column;
                RowFormatter rf = this.tableInfo.getRowFormatter();
                if (validColumns != null) {
                    column = validColumns.anySetBit();
                    while (column != -1) {
                        dtd = rf.getType(column + 1);
                        origDVD = changedRow[column];
                        if (origDVD != null && origDVD.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                            dvd = dtd.getNull();
                            dvd.setValue(origDVD);
                            changedRow[column] = dvd;
                        }
                        if (origDVD != null && dtd.getDVDTypeFormatId() == 78 && origDVD.getString() != null) {
                            ((SQLChar)origDVD).normalize(dtd, origDVD);
                        }
                        column = validColumns.anySetBit(column);
                    }
                } else {
                    for (column = 0; column < changedRow.length; ++column) {
                        dtd = rf.getType(column + 1);
                        origDVD = changedRow[column];
                        if (origDVD != null && origDVD.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
                            dvd = dtd.getNull();
                            dvd.setValue(origDVD);
                            changedRow[column] = dvd;
                        }
                        if (origDVD == null || origDVD.getTypeFormatId() != 78 || origDVD.getString() == null) continue;
                        ((SQLChar)origDVD).normalize(dtd, origDVD);
                    }
                }
            }
            SerializableDelta delta = new SerializableDelta(changedRow, validColumns);
            if (mkvh != null && this.region.getDataPolicy().withPartitioning()) {
                try {
                    callbackArg = this.getRoutingObject(this.region, key, delta);
                }
                catch (EntryNotFoundException enfe) {
                    GemFireXDUtils.checkForInsufficientDataStore(this.region);
                    if (flushBatch) {
                        this.doPutAllOfAllDeltas(mkvh, lcc);
                    }
                    return null;
                }
            }
            if (lcc != null) {
                possibleDuplicate = lcc.isPossibleDuplicate();
                isTrigger = lcc.isTriggerBody();
                skipListeners = lcc.isSkipListeners();
                skipConstraintChecks = lcc.isSkipConstraintChecks();
            } else {
                possibleDuplicate = false;
                isTrigger = false;
                skipListeners = false;
                skipConstraintChecks = false;
            }
            Object sca = this.getCallbackArgument(callbackArg, lcc, tx, mkvh == null && !isTrigger, false, isPkBased, skipListeners, false, skipConstraintChecks);
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: updating key {" + key + "] with row [" + RowUtil.toString(changedRow) + "] and callbackArg=" + sca + " [" + tx + "] in container: " + this.toString() + " IS GFE Tx Set =" + Misc.getGemFireCache().getTxManager().exists()));
            }
            Object oldValue = null;
            String strRepOfKeyBeingUpdated = null;
            if (GemFireXDUtils.TraceConglomUpdate) {
                strRepOfKeyBeingUpdated = key.toString();
            }
            try {
                if (mkvh == null) {
                    long startPut = CachePerfStats.getStatTime();
                    EntryEventImpl event = this.region.newUpdateEntryEvent(key, (Object)delta, sca);
                    event.setPossibleDuplicate(possibleDuplicate);
                    event.setTXState(tx);
                    oldValue = this.region.validatedPut(event, startPut);
                } else {
                    mkvh.addKeyValueAndCallbackArg(key, delta, sca);
                    if (flushBatch) {
                        this.doPutAllOfAllDeltas(mkvh, lcc);
                    }
                }
            }
            catch (PartitionedRegionDistributionException prde) {
                if (prde.getCause() instanceof EntryNotFoundException) {
                    throw (EntryNotFoundException)prde.getCause();
                }
                if (prde.getCause() instanceof TransactionException) {
                    throw (TransactionException)prde.getCause();
                }
                throw prde;
            }
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GemFireContainer: updated key [" + strRepOfKeyBeingUpdated + "] with row [" + RowUtil.toString(changedRow) + "] in container: " + this.toString()));
            }
            return oldValue;
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "update of key " + key + " in table " + this.qualifiedName, true);
        }
        catch (RuntimeException e) {
            throw this.processRuntimeException(e, "update of key " + key + " in table " + this.qualifiedName);
        }
    }

    private Object getRoutingObject(LocalRegion r, Object key, Object value) {
        InternalPartitionResolver pr = (InternalPartitionResolver)r.getPartitionAttributes().getPartitionResolver();
        return pr.getRoutingObject(key, value, null, (Region)r);
    }

    public VersionedObjectList doPutAllOfAllDeltas(GemFireUpdateActivation.MultipleKeyValueHolder mkvh, LanguageConnectionContext lcc) throws StandardException {
        LinkedHashMap<Object, Object> toBeInsertedDeltas = null;
        boolean possibleDuplicate = false;
        try {
            assert (mkvh != null) : "Null MultipleKeyValueHolder object not expected";
            toBeInsertedDeltas = mkvh.getToBeInsertedDeltas();
            if (toBeInsertedDeltas == null) {
                return null;
            }
            DistributedPutAllOperation putAllOp = this.region.newPutAllOperation(toBeInsertedDeltas);
            possibleDuplicate = lcc != null && lcc.isPossibleDuplicate();
            Object[] callbackArgs = mkvh.getCallbackArgs().toArray();
            if (putAllOp != null) {
                GemFireXDQueryObserver observer;
                if (possibleDuplicate) {
                    putAllOp.getBaseEvent().setPossibleDuplicate(possibleDuplicate);
                }
                if (callbackArgs != null) {
                    putAllOp.setCallbackArgs(callbackArgs);
                }
                if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
                    observer.putAllCalledWithMapSize(toBeInsertedDeltas.size());
                }
                return this.region.basicPutAll(toBeInsertedDeltas, putAllOp, null);
            }
            return null;
        }
        catch (PutAllPartialResultException papre) {
            GemFireXDUtils.checkForInsufficientDataStore(this.region);
            return papre.getResult().getSucceededKeysAndVersions();
        }
        catch (GemFireException gfeex) {
            EntryExistsException eee = null;
            for (Throwable t = gfeex; t != null; t = t.getCause()) {
                if (!(t instanceof EntryExistsException)) continue;
                eee = (EntryExistsException)t;
                break;
            }
            if (eee != null) {
                boolean isGlobalIndex = this.isGlobalIndex();
                if (!isGlobalIndex && possibleDuplicate) {
                    return null;
                }
                String constraintType = isGlobalIndex ? "unique constraint" : "primary key constraint";
                String valueMessage = null;
                if (toBeInsertedDeltas != null) {
                    if (toBeInsertedDeltas.size() > 5) {
                        StringBuilder sb = new StringBuilder();
                        sb.append('[');
                        int num = 0;
                        for (Map.Entry<Object, Object> e : toBeInsertedDeltas.entrySet()) {
                            sb.append(e.getKey()).append('=').append(e.getValue()).append(", ");
                            if (++num < 5) continue;
                            sb.append("...]");
                            break;
                        }
                        valueMessage = sb.toString();
                    } else {
                        valueMessage = toBeInsertedDeltas.toString();
                    }
                }
                throw GemFireXDUtils.newDuplicateKeyViolation(constraintType, this.qualifiedName, valueMessage, eee);
            }
            throw Misc.processGemFireException(gfeex, gfeex, "insert of keys " + (toBeInsertedDeltas != null ? toBeInsertedDeltas.keySet() : "(null)") + " into table " + this.qualifiedName, true);
        }
        catch (RuntimeException e) {
            throw this.processRuntimeException(e, "insert of keys " + (toBeInsertedDeltas != null ? toBeInsertedDeltas.keySet() : "(null)") + " into table " + this.qualifiedName);
        }
    }

    private Object replacePartialRowInContainer(RegionEntry entry, FormatableBitSet validColumns, DataValueDescriptor[] changedRow, int bucketId, TXStateInterface tx, LanguageConnectionContext lcc) throws StandardException {
        Object key = entry.getKeyCopy();
        LogWriterI18n logger = this.region.getCache().getLoggerI18n();
        Object routingObject = GemFireXDUtils.getRoutingObject(bucketId);
        if (routingObject == null && this.isPartitioned()) {
            if (!entry.isDestroyedOrRemoved()) {
                routingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(key, entry, this.region);
            } else {
                throw new EntryDestroyedException("Update on key=" + key + " could not be done as row is already removed");
            }
        }
        if (logger.fineEnabled()) {
            logger.fine("GemFireContainer::replacePartialRow: Before fetching old value for entry=" + entry + " with bucket ID = " + bucketId);
        }
        return this.replacePartialRow(key, routingObject, false, validColumns, changedRow, false, tx, lcc, null, false);
    }

    private StandardException processRuntimeException(RuntimeException e, String op) {
        return Misc.processRuntimeException(e, op, this.getRegion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object makeValueAsPerStorage(Object val) throws StandardException, SQLException {
        DataValueDescriptor[] retDVDArray = null;
        ColumnDescriptorList cdl = this.tableInfo.getTableDescriptor().getColumnDescriptorList();
        int numOfCols = cdl.size();
        if (val instanceof DataValueDescriptor[]) {
            retDVDArray = (DataValueDescriptor[])val;
            if (retDVDArray.length != numOfCols) {
                throw StandardException.newException("X0Z10.S", (Object)retDVDArray.length, (Object)numOfCols);
            }
        } else if (val instanceof Object[]) {
            Object[] tmpval = (Object[])val;
            if (tmpval.length != numOfCols) {
                throw StandardException.newException("X0Z10.S", (Object)tmpval.length, (Object)numOfCols);
            }
            retDVDArray = new DataValueDescriptor[numOfCols];
            for (int index = 0; index < numOfCols; ++index) {
                DataValueDescriptor dvd = cdl.elementAt((int)index).columnType.getNull();
                Object o = tmpval[index];
                if (o != null) {
                    dvd.setObjectForCast(o, true, o.getClass().getName());
                } else {
                    dvd.setToNull();
                }
                retDVDArray[index] = dvd;
            }
        } else if (val instanceof List) {
            List lst = (List)val;
            if (lst.size() != numOfCols) {
                throw StandardException.newException("X0Z10.S", (Object)lst.size(), (Object)numOfCols);
            }
            retDVDArray = new DataValueDescriptor[numOfCols];
            for (int index = 0; index < numOfCols; ++index) {
                DataValueDescriptor dvd = cdl.elementAt((int)index).columnType.getNull();
                Object o = lst.get(index);
                if (o != null) {
                    dvd.setObjectForCast(o, true, o.getClass().getName());
                } else {
                    dvd.setToNull();
                }
                retDVDArray[index] = dvd;
            }
        } else if (val instanceof ResultSet) {
            ResultSet rs = (ResultSet)val;
            retDVDArray = new DataValueDescriptor[numOfCols];
            if (rs == null || !rs.next()) return null;
            if (rs.getMetaData().getColumnCount() != numOfCols) {
                throw StandardException.newException("X0Z10.S", (Object)rs.getMetaData().getColumnCount(), (Object)numOfCols);
            }
            for (int index = 0; index < numOfCols; ++index) {
                DataValueDescriptor dvd = cdl.elementAt((int)index).columnType.getNull();
                Object o = rs.getObject(index + 1);
                if (o != null) {
                    dvd.setObjectForCast(o, true, o.getClass().getName());
                } else {
                    dvd.setToNull();
                }
                retDVDArray[index] = dvd;
            }
            rs.close();
        } else {
            if (val != null) throw new IllegalArgumentException("unknown value type passed as argument: " + val);
            return null;
        }
        if (!this.isByteArrayStore()) return retDVDArray;
        return this.tableInfo.getRowFormatter().generateBytes(retDVDArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getNumRows() {
        long rows = this.previousNumRows;
        if (rows < 0L) {
            LocalRegion lr;
            if (GemFireXDUtils.TraceConglom) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("[warning getting row count -ve, so determining the region's local size " + this.region.getName() + " {3} " + rows));
            }
            if ((lr = this.region) == null || !lr.isInitialized() || lr.isDestroyed()) {
                return 0L;
            }
            rows = 0L;
            if (this.isPartitioned()) {
                PartitionedRegion pr = (PartitionedRegion)lr;
                if (pr.getLocalMaxMemory() > 0) {
                    boolean currentSettingOfQueryHFDS = pr.includeHDFSResults();
                    try {
                        pr.setQueryHDFS(false);
                        rows = pr.entryCount(null, pr.getDataStore().getAllLocalBucketIds());
                    }
                    finally {
                        pr.setQueryHDFS(currentSettingOfQueryHFDS);
                    }
                } else {
                    rows = pr.sizeEstimate();
                }
            } else {
                rows = lr.size();
            }
            this.previousNumRows = rows;
        }
        return rows;
    }

    public void updateNumRows(boolean dec) {
        this.previousNumRows = dec ? --this.previousNumRows : ++this.previousNumRows;
        short s = this.counter;
        this.counter = (short)(s - 1);
        if (s <= 0) {
            this.counter = (short)1000;
            this.rowSize = 0L;
        }
    }

    public String toString() {
        String type = this.baseId != null ? (this.comparator != null ? "local-index: " : "global-index: ") + (this.isUniqueIndex ? "{UNIQUE} " : "") : "table: ";
        return '[' + type + this.qualifiedName + ", id: " + this.id + ", isAppTable=" + this.isApplicationTable() + ']';
    }

    public boolean isLocalIndex() {
        return this.skipListMap != null;
    }

    public boolean isGlobalIndex() {
        return this.baseId != null && this.comparator == null;
    }

    public final boolean isUniqueIndex() {
        return this.isUniqueIndex;
    }

    public final boolean isGlobalIndexForPrimaryKey() {
        return GemFireXDUtils.isSet(this.containerFlags, 8);
    }

    public final boolean isSYSTABLES() {
        return GemFireXDUtils.isSet(this.containerFlags, 32);
    }

    public final boolean isApplicationTable() {
        return GemFireXDUtils.isSet(this.containerFlags, 64);
    }

    public final boolean isApplicationTableOrGlobalIndex() {
        return GemFireXDUtils.isSet(this.containerFlags, 128);
    }

    @Override
    public Page addPage() throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Page addPage(int flag) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void backupContainer(String backupContainerPath) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void close() {
        throw new AssertionError((Object)"unexpected execution");
    }

    public final boolean open(GemFireTransaction tran, int mode) throws StandardException {
        if (this.locking != null && !tran.skipLocks(this, null)) {
            boolean waitForLock = (mode & 0x80) == 0;
            int modeMask = 68;
            if ((mode & 0x44) == 68) {
                return this.locking.lockContainer(tran, this, waitForLock, true);
            }
            return this.locking.lockContainer(tran, this, waitForLock, false);
        }
        return false;
    }

    public final void closeForEndTransaction(GemFireTransaction tran, boolean forUpdate) {
        if (this.locking != null && tran != null && !tran.skipLocks() && !tran.isTransactional()) {
            this.locking.unlockContainer(tran, this);
        }
    }

    @Override
    public void compactRecord(RecordHandle record) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void compressContainer() throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void flushContainer() throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    private void addProperty(Properties props, String name, Object value) {
        if (props.get(name) == null && value != null) {
            if (value instanceof String) {
                props.setProperty(name, (String)value);
            } else {
                props.put(name, value);
            }
        }
    }

    @Override
    public void getContainerProperties(Properties props) throws StandardException {
        this.addProperty(props, "GFXD_DATATYPEDESCRIPTORS", this.tableInfo);
        this.addProperty(props, GfxdConstants.PROPERTY_SCHEMA_NAME, this.schemaName);
        this.addProperty(props, GfxdConstants.PROPERTY_TABLE_NAME, this.tableName);
        this.addProperty(props, "GEMFIRE_REGION_ATTRIBUTES", this.regionAttributes);
        this.addProperty(props, "baseConglomerateId", this.baseId);
        this.addProperty(props, "indexComparator", this.comparator);
        this.addProperty(props, "ddIndex", GemFireXDUtils.isSet(this.containerFlags, 2));
        if (this.baseContainer != null) {
            this.addProperty(props, GfxdConstants.PROPERTY_INDEX_BASE_COL_POS, this.baseColumnPositions);
            this.addProperty(props, GfxdConstants.PROPERTY_INDEX_BASE_TABLE_DESC, this.baseContainer.getTableDescriptor());
        }
    }

    @Override
    public long getEstimatedPageCount(int flag) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public final long getEstimatedRowCount(int flag) throws StandardException {
        return this.getNumRows();
    }

    @Override
    public Page getFirstPage() throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public ContainerKey getId() {
        return this.id;
    }

    @Override
    public ContainerKey getBaseId() {
        return this.baseId;
    }

    public int[] getBaseColumnPositions() {
        return this.baseColumnPositions;
    }

    public GemFireContainer getBaseContainer() {
        return this.baseContainer;
    }

    @Override
    public GFContainerLocking getLockingPolicy() {
        return this.locking;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GemFireContainer) {
            GemFireContainer otherContainer = (GemFireContainer)other;
            return this.id.getContainerId() == otherContainer.id.getContainerId() && this.id.getSegmentId() == otherContainer.id.getSegmentId();
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public Page getNextPage(long prevNum) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Page getPage(long pageNumber) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Page getPageForCompress(int flag, long pageno) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Page getPageForInsert(int flag) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Page getPageNoWait(long pageNumber) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public long getReusableRecordIdSequenceNumber() throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public SpaceInfo getSpaceInfo() throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Object getUniqueId() {
        return this.getId().getContainerId();
    }

    @Override
    public Page getUserPageNoWait(long pageNumber) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public Page getUserPageWait(long pageNumber) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isTemporaryContainer() {
        return this.id.getSegmentId() == -1L;
    }

    @Override
    public RecordHandle makeRecordHandle(long pageNumber, int recordId) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void preAllocate(int numPage) {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void removePage(Page page) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    @Override
    public void setEstimatedRowCount(long count, int flag) throws StandardException {
    }

    @Override
    public void setLockingPolicy(LockingPolicy newLockingPolicy) {
        throw new AssertionError((Object)"unexpected execution");
    }

    public MemConglomerate getConglomerate() {
        return this.conglom;
    }

    public void setConglomerate(MemConglomerate conglom) {
        this.conglom = conglom;
        this.isUniqueIndex = this.isLocalIndex() ? ((MemIndex)conglom).isUnique() : this.isGlobalIndex();
    }

    public ExecRow newTemplateRow() {
        return this.templateRow.getNewNullRow();
    }

    public ExecRow newTemplateRow(RowFormatter targetFormat, int[] validColumns) throws StandardException {
        if (this.isByteArrayStore()) {
            assert (targetFormat != null);
            return this.newCompactExecRow(null, targetFormat);
        }
        int size = validColumns.length;
        DataValueDescriptor[] row = new DataValueDescriptor[size];
        for (int index = 0; index < size; ++index) {
            row[index] = this.templateRow.getColumn(validColumns[index]).getNewNull();
        }
        return new ValueRow(row);
    }

    public final void initCompactTemplateRow(ExtraTableInfo tableInfo) throws StandardException {
        if (tableInfo != null && this.isByteArrayStore()) {
            RowFormatter rf = tableInfo.getRowFormatter();
            AbstractCompactExecRow cRow = this.newCompactExecRow(null, rf);
            int numLobs = rf.numLobs();
            if (numLobs > 0) {
                cRow.setRowArray(new byte[numLobs + 1][], rf);
            }
            this.templateRow = cRow;
        }
    }

    public int numColumns() {
        TableDescriptor td = this.getTableDescriptor();
        if (td != null) {
            return td.getNumberOfColumns();
        }
        return this.templateRow.nColumns();
    }

    public final TableDescriptor getTableDescriptor() {
        return this.tableInfo != null ? this.tableInfo.getTableDescriptor() : null;
    }

    public final boolean isDataStore() {
        return this.region != null && this.region.getDataPolicy().withStorage() && (!this.region.getDataPolicy().withPartitioning() || this.region.getPartitionAttributes().getLocalMaxMemory() != 0);
    }

    public final boolean isByteArrayStore() {
        return (this.containerFlags & 1) != 0;
    }

    public final boolean isObjectStore() {
        return this.encoder != null;
    }

    public final RowEncoder getRowEncoder() {
        return this.encoder;
    }

    private final boolean isCandidateForByteArrayStore() {
        return !"SYS".equals(this.schemaName) && !"SESSION".equals(this.schemaName) && !this.isObjectStore();
    }

    public final boolean isPartitioned() {
        return this.regionAttributes.getDataPolicy().withPartitioning();
    }

    public final boolean isRowBuffer() {
        return this.isPartitioned() && ((PartitionedRegion)this.region).needsBatching();
    }

    public final boolean isColumnStore() {
        return this.isObjectStore() && this.tableName.endsWith("_COLUMN_STORE_");
    }

    public final boolean isOffHeap() {
        LocalRegion region = this.region;
        if (region != null) {
            return region.getEnableOffHeapMemory();
        }
        return this.regionAttributes != null && this.regionAttributes.getEnableOffHeapMemory();
    }

    public final boolean isOverFlowType() {
        return GemFireXDUtils.isSet(this.containerFlags, 256);
    }

    public final boolean hasAutoGeneratedCols() {
        return GemFireXDUtils.isSet(this.containerFlags, 512);
    }

    public final boolean isRedundant() {
        if (this.regionAttributes.getDataPolicy().withPartitioning()) {
            return this.regionAttributes.getPartitionAttributes().getRedundantCopies() > 0;
        }
        return false;
    }

    public final boolean hasBucketRowLoc() {
        return GemFireXDUtils.isSet(this.containerFlags, 4);
    }

    public final boolean regionKeyRequiresRegionContext() {
        int[] pkCols;
        return this.isByteArrayStore() && (pkCols = this.tableInfo.getPrimaryKeyColumns()) != null && pkCols.length > 0 || this.isGlobalIndex();
    }

    private void initTableFlags() {
        this.setFlag(4, this.isPartitioned());
        this.setFlag(64, !this.isLocalIndex() && !this.regionAttributes.getScope().isLocal() && !this.isGlobalIndex());
        this.setFlag(128, !this.isLocalIndex() && !this.regionAttributes.getScope().isLocal());
        EvictionAttributes ea = this.regionAttributes.getEvictionAttributes();
        this.setFlag(256, ea != null && ea.getAction().equals(EvictionAction.OVERFLOW_TO_DISK));
    }

    public final ExecRow newExecRow(Object rawStoreRow) {
        if (rawStoreRow != null) {
            if (this.isByteArrayStore()) {
                Class<?> rawStoreRowClass = rawStoreRow.getClass();
                if (rawStoreRowClass == byte[].class) {
                    byte[] rowBytes = (byte[])rawStoreRow;
                    return this.newExecRowFromBytes(rowBytes, this.getRowFormatter(rowBytes));
                }
                if (rawStoreRowClass == byte[][].class) {
                    byte[][] rowByteArrays = (byte[][])rawStoreRow;
                    return this.newExecRowFromByteArrays(rowByteArrays, this.getRowFormatter(rowByteArrays));
                }
                if (rawStoreRowClass == OffHeapRow.class) {
                    OffHeapRow rowBytes = (OffHeapRow)((Object)rawStoreRow);
                    return this.newExecRowFromByteSource(rowBytes, this.getRowFormatter(rowBytes));
                }
                if (rawStoreRowClass == OffHeapRowWithLobs.class) {
                    OffHeapRowWithLobs rowByteArrays = (OffHeapRowWithLobs)((Object)rawStoreRow);
                    return this.newExecRowFromByteSource(rowByteArrays, this.getRowFormatter(rowByteArrays));
                }
                GemFireXDUtils.throwAssert("Unhandle rawStoreRow type = " + rawStoreRowClass);
                return null;
            }
            assert (rawStoreRow instanceof DataValueDescriptor[]) : "unexpected type of entry value: " + rawStoreRow.getClass().getName();
            return this.newValueRow((DataValueDescriptor[])rawStoreRow);
        }
        return null;
    }

    public final ExecRow newExecRow(Object rawKey, Object rawStoreRow) {
        if (this.isObjectStore()) {
            return this.encoder.toRow(rawKey, rawStoreRow, this);
        }
        return this.newExecRow(rawStoreRow);
    }

    public final ExecRow newExecRow(RegionEntry entry, Object rawStoreRow, ExtraTableInfo tableInfo, boolean faultIn) {
        if (rawStoreRow != null) {
            if (this.isByteArrayStore()) {
                Class<?> rawStoreRowClass = rawStoreRow.getClass();
                if (rawStoreRowClass == byte[].class) {
                    byte[] rowBytes = (byte[])rawStoreRow;
                    return this.newExecRowFromBytes(rowBytes, this.getRowFormatter(rowBytes, tableInfo));
                }
                if (rawStoreRowClass == byte[][].class) {
                    byte[][] rowByteArrays = (byte[][])rawStoreRow;
                    return this.newExecRowFromByteArrays(rowByteArrays, this.getRowFormatter(rowByteArrays[0], tableInfo));
                }
                if (OffHeapRegionEntry.class.isAssignableFrom(rawStoreRowClass)) {
                    return this.createExecRowFromAddress((RegionEntry)((OffHeapRegionEntry)rawStoreRow), tableInfo, this.getRegion(), faultIn);
                }
                throw new AssertionError((Object)("Unexpected raw store data . Object is " + rawStoreRow));
            }
            if (this.isObjectStore()) {
                return this.encoder.toRow(entry.getRawKey(), rawStoreRow, this);
            }
            assert (rawStoreRow instanceof DataValueDescriptor[]) : "unexpected type of entry value: " + rawStoreRow.getClass().getName();
            return this.newValueRow((DataValueDescriptor[])rawStoreRow);
        }
        return null;
    }

    private static final boolean reallyHasLobs(RowFormatter rf) {
        if (rf.isTableFormatter()) {
            return true;
        }
        return rf.hasLobs();
    }

    public final AbstractCompactExecRow newExecRowFromBytes(byte[] rowBytes, RowFormatter rf) {
        if (!this.hasLobs || !GemFireContainer.reallyHasLobs(rf)) {
            if (!this.isOffHeap()) {
                return new CompactExecRow(rowBytes, rf);
            }
            return new OffHeapCompactExecRow(rowBytes, rf);
        }
        byte[][] rowByteArrays = rf.createByteArraysWithDefaultLobs(rowBytes);
        if (!this.isOffHeap()) {
            return new CompactExecRowWithLobs(rowByteArrays, rf);
        }
        return new OffHeapCompactExecRowWithLobs(rowByteArrays, rf);
    }

    public final AbstractCompactExecRow newExecRowFromBytes(byte[] rowBytes, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        if (!this.hasLobs || !GemFireContainer.reallyHasLobs(rf)) {
            if (!this.isOffHeap()) {
                return new CompactExecRow(rowBytes, rf, row, rowLen, doClone);
            }
            return new OffHeapCompactExecRow(rowBytes, rf, row, rowLen, doClone);
        }
        byte[][] rowByteArrays = rf.createByteArraysWithDefaultLobs(rowBytes);
        if (!this.isOffHeap()) {
            return new CompactExecRowWithLobs(rowByteArrays, rf, row, rowLen, doClone);
        }
        return new OffHeapCompactExecRowWithLobs(rowByteArrays, rf, row, rowLen, doClone);
    }

    public final AbstractCompactExecRow newExecRowFromByteArrays(byte[][] rowByteArrays, RowFormatter rf) {
        if (this.hasLobs && GemFireContainer.reallyHasLobs(rf)) {
            if (!this.isOffHeap()) {
                return new CompactExecRowWithLobs(rowByteArrays, rf);
            }
            return new OffHeapCompactExecRowWithLobs(rowByteArrays, rf);
        }
        if (!this.isOffHeap()) {
            return new CompactExecRow(rowByteArrays[0], rf);
        }
        return new OffHeapCompactExecRow(rowByteArrays[0], rf);
    }

    public final AbstractCompactExecRow newExecRowFromByteArrays(byte[][] rowByteArrays, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        if (this.hasLobs && GemFireContainer.reallyHasLobs(rf)) {
            if (!this.isOffHeap()) {
                return new CompactExecRowWithLobs(rowByteArrays, rf, row, rowLen, doClone);
            }
            return new OffHeapCompactExecRowWithLobs(rowByteArrays, rf, row, rowLen, doClone);
        }
        if (!this.isOffHeap()) {
            return new CompactExecRow(rowByteArrays[0], rf, row, rowLen, doClone);
        }
        return new OffHeapCompactExecRow(rowByteArrays[0], rf, row, rowLen, doClone);
    }

    public final AbstractCompactExecRow newExecRowFromByteSource(OffHeapRow rowBytes, RowFormatter rf) {
        if (!this.hasLobs || !GemFireContainer.reallyHasLobs(rf)) {
            return new OffHeapCompactExecRow(rowBytes, rf);
        }
        return new OffHeapCompactExecRowWithLobs(rowBytes, rf);
    }

    public final AbstractCompactExecRow newExecRowFromByteSource(OffHeapRow rowBytes, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        if (!this.hasLobs || !GemFireContainer.reallyHasLobs(rf)) {
            return new OffHeapCompactExecRow((Object)rowBytes, rf, row, rowLen, doClone);
        }
        return new OffHeapCompactExecRowWithLobs(rowBytes, rf, row, rowLen, doClone);
    }

    public final AbstractCompactExecRow newExecRowFromByteSource(OffHeapRowWithLobs rowByteArrays, RowFormatter rf) {
        if (this.hasLobs && GemFireContainer.reallyHasLobs(rf)) {
            return new OffHeapCompactExecRowWithLobs(rowByteArrays, rf);
        }
        return new OffHeapCompactExecRow((Object)rowByteArrays, rf);
    }

    public final AbstractCompactExecRow newExecRowFromByteSource(OffHeapRowWithLobs rowByteArrays, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        if (this.hasLobs && GemFireContainer.reallyHasLobs(rf)) {
            return new OffHeapCompactExecRowWithLobs(rowByteArrays, rf, row, rowLen, doClone);
        }
        return new OffHeapCompactExecRow((Object)rowByteArrays, rf, row, rowLen, doClone);
    }

    public final AbstractCompactExecRow createExecRowFromAddress(RegionEntry offHeapEntry, ExtraTableInfo tableInfo, LocalRegion rgn, boolean faultIn) {
        if (this.isPartitioned()) {
            int bucketID = ((RowLocation)offHeapEntry).getBucketID();
            rgn = RegionEntryUtils.getBucketRegion((PartitionedRegion)rgn, bucketID);
        }
        AbstractCompactExecRow row = null;
        Object source = RegionEntryUtils.convertOffHeapEntrytoByteSourceRetain(offHeapEntry, rgn, faultIn, false);
        if (source != null) {
            if (source.getClass() == byte[].class) {
                byte[] vbytes = (byte[])source;
                RowFormatter rf = this.getRowFormatter(vbytes, tableInfo);
                row = this.hasLobs && GemFireContainer.reallyHasLobs(rf) ? new OffHeapCompactExecRowWithLobs(vbytes, rf) : new OffHeapCompactExecRow(vbytes, rf);
            } else {
                OffHeapByteSource vbs = (OffHeapByteSource)((Object)source);
                RowFormatter rf = this.getRowFormatter(vbs, tableInfo);
                row = this.hasLobs && GemFireContainer.reallyHasLobs(rf) ? new OffHeapCompactExecRowWithLobs(vbs, rf) : new OffHeapCompactExecRow((Object)vbs, rf);
            }
        }
        return row;
    }

    public final AbstractCompactExecRow newCompactExecRow(DataValueDescriptor[] dvds, RowFormatter rf) throws StandardException {
        if (!this.hasLobs || !GemFireContainer.reallyHasLobs(rf)) {
            if (!this.isOffHeap()) {
                return new CompactExecRow(dvds, rf);
            }
            return new OffHeapCompactExecRow(dvds, rf);
        }
        if (!this.isOffHeap()) {
            return new CompactExecRowWithLobs(dvds, rf);
        }
        return new OffHeapCompactExecRowWithLobs(dvds, rf);
    }

    public final ValueRow newValueRow(DataValueDescriptor[] dvds) {
        ValueRow vrow = new ValueRow(dvds.length);
        if (this.isSYSTABLES()) {
            LocalRegion region;
            String schemaName;
            DataValueDescriptor schema = dvds[4];
            DataValueDescriptor table = dvds[1];
            String string = schemaName = schema != null ? schema.toString() : null;
            if (table != null && !"SYS".equals(schemaName) && (region = (LocalRegion)Misc.getRegionForTableByPath(Misc.getFullTableName(schemaName, table.toString(), null), false)) != null) {
                DataValueDescriptor tType;
                ExpirationAttributes expirationAttrs;
                String dataPolicy = "NORMAL";
                String pattrsStr = null;
                String resolverStr = null;
                String evictionStr = null;
                StringBuilder expirationStr = new StringBuilder();
                String diskAttrsStr = null;
                String loaderStr = null;
                String writerStr = null;
                StringBuilder listenersStr = new StringBuilder();
                boolean gatewayEnabled = false;
                TreeSet<String> asyncListeners = null;
                String asyncListenersStr = null;
                TreeSet<String> senderIds = null;
                String senderIdsStr = null;
                dvds = (DataValueDescriptor[])dvds.clone();
                RegionAttributes attrs = region.getAttributes();
                PartitionAttributesImpl pattrs = (PartitionAttributesImpl)attrs.getPartitionAttributes();
                EvictionAttributes evictAttrs = attrs.getEvictionAttributes();
                CacheLoader loader = attrs.getCacheLoader();
                CacheWriter writer = attrs.getCacheWriter();
                CacheListener[] listeners = attrs.getCacheListeners();
                boolean isOverflow = false;
                dataPolicy = attrs.getDataPolicy().toString();
                if (pattrs != null) {
                    pattrsStr = pattrs.getStringForGFXD();
                    resolverStr = ((InternalPartitionResolver)pattrs.getPartitionResolver()).getDDLString();
                }
                if ((expirationAttrs = attrs.getRegionIdleTimeout()) != null && expirationAttrs.getTimeout() != 0) {
                    expirationStr.append("region-idle-timeout: ").append(expirationAttrs.toString());
                }
                if ((expirationAttrs = attrs.getRegionTimeToLive()) != null && expirationAttrs.getTimeout() != 0) {
                    expirationStr.append(";region-time-to-live: ").append(expirationAttrs.toString());
                }
                if ((expirationAttrs = attrs.getEntryIdleTimeout()) != null && expirationAttrs.getTimeout() != 0) {
                    expirationStr.append(";entry-idle-timeout: ").append(expirationAttrs.toString());
                }
                if ((expirationAttrs = attrs.getEntryTimeToLive()) != null && expirationAttrs.getTimeout() != 0) {
                    expirationStr.append(";entry-time-to-live: ").append(expirationAttrs.toString());
                }
                if (evictAttrs != null && !evictAttrs.getAction().isNone()) {
                    evictionStr = evictAttrs.toString();
                    if (evictAttrs.getAction().isOverflowToDisk()) {
                        isOverflow = true;
                    }
                }
                if (isOverflow || attrs.getDataPolicy().withPersistence()) {
                    diskAttrsStr = "DiskStore is " + attrs.getDiskStoreName() + ";" + (attrs.isDiskSynchronous() ? " Synchronous writes to disk" : "Asynchronous writes to disk");
                }
                if (loader != null) {
                    loaderStr = loader.toString();
                }
                if (writer != null) {
                    writerStr = writer.toString();
                }
                if (listeners != null && listeners.length > 0) {
                    for (CacheListener listener : listeners) {
                        if (listenersStr.length() > 0) {
                            listenersStr.append(',');
                        }
                        if (listener instanceof GfxdCacheListener) {
                            listenersStr.append(((GfxdCacheListener)listener).getName());
                            continue;
                        }
                        listenersStr.append(String.valueOf(listener));
                    }
                }
                Set regionSenderIds = region.getGatewaySenderIds();
                Set asyncQueueIds = region.getAsyncEventQueueIds();
                if (regionSenderIds != null && regionSenderIds.size() > 0) {
                    senderIds = new TreeSet<String>();
                    for (String id : regionSenderIds) {
                        senderIds.add(id);
                    }
                    gatewayEnabled = true;
                }
                if (asyncQueueIds != null && asyncQueueIds.size() > 0) {
                    asyncListeners = new TreeSet<String>();
                    for (String asyncId : asyncQueueIds) {
                        asyncListeners.add(asyncId);
                    }
                    gatewayEnabled = true;
                }
                if (asyncListeners != null) {
                    asyncListenersStr = SharedUtils.toCSV(asyncListeners);
                }
                if (senderIds != null) {
                    senderIdsStr = SharedUtils.toCSV(senderIds);
                }
                if ((tType = dvds[2]) != null && "T".equalsIgnoreCase(tType.toString()) && !LocalRegion.isMetaTable((String)region.getFullPath())) {
                    ExternalCatalog ec = Misc.getMemStore().getExternalCatalog();
                    LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                    if (ec != null && lcc != null && lcc.isQueryRoutingFlagTrue() && Misc.initialDDLReplayDone() && ec.isColumnTable(schemaName, table.toString(), true)) {
                        dvds[2] = new SQLChar("C");
                    }
                }
                dvds[7] = new SQLVarchar(dataPolicy);
                dvds[8] = new SQLLongvarchar(pattrsStr);
                dvds[9] = new SQLLongvarchar(resolverStr);
                dvds[10] = new SQLLongvarchar(expirationStr.length() > 0 ? expirationStr.toString() : null);
                dvds[11] = new SQLLongvarchar(evictionStr);
                dvds[12] = new SQLLongvarchar(diskAttrsStr);
                dvds[13] = new SQLLongvarchar(loaderStr);
                dvds[14] = new SQLLongvarchar(writerStr);
                dvds[15] = new SQLLongvarchar(listenersStr.length() == 0 ? null : listenersStr.toString());
                dvds[16] = new SQLVarchar(asyncListenersStr);
                dvds[17] = new SQLBoolean(gatewayEnabled);
                dvds[18] = new SQLVarchar(senderIdsStr);
                dvds[19] = new SQLBoolean(attrs.getEnableOffHeapMemory());
            }
        }
        vrow.setRowArray(dvds);
        return vrow;
    }

    @Override
    public Object getName() {
        return this.qualifiedName;
    }

    public final Object getLocalIndexKey(ExecRow baseRow, Object entry) throws StandardException {
        return this.getLocalIndexKey(baseRow, entry, false, false);
    }

    public final CompactCompositeIndexKey getLocalIndexKey(ExecRow baseRow, Object entry, boolean forInsert, boolean createExtractingKey) throws StandardException {
        Object value = baseRow instanceof AbstractCompactExecRow ? ((AbstractCompactExecRow)baseRow).getByteSource() : baseRow.getRawRowValue(false);
        return this.getLocalIndexKey(value, entry, forInsert, createExtractingKey);
    }

    public final CompactCompositeIndexKey getLocalIndexKey(Object value, Object entry, boolean forInsert, boolean createExtractingKey) throws StandardException {
        Object vbs = this.getLocalIndexKeyValueBytes(value);
        if (vbs == null) {
            if (value instanceof DataValueDescriptor[]) {
                return new CompactCompositeIndexKey((DataValueDescriptor[])value, this.indexInfo);
            }
            throw new AssertionError((Object)("getIndexKey: Unhandled row " + value));
        }
        CompactCompositeIndexKey ccik = createExtractingKey ? new ExtractingIndexKey(vbs, this.indexInfo) : new CompactCompositeIndexKey(vbs, this.indexInfo);
        if (forInsert) {
            return ccik;
        }
        boolean snapShotKeyBytes = false;
        if (this.baseContainer.isOffHeap() && entry instanceof OffHeapRegionEntry) {
            if (OffHeapRegionEntryHelper.isAddressInvalidOrRemoved((long)((OffHeapRegionEntry)entry).getAddress())) {
                snapShotKeyBytes = true;
            }
        } else {
            Object ev = ((RegionEntry)entry)._getValue();
            if (ev == null || Token.isInvalidOrRemoved((Object)ev)) {
                snapShotKeyBytes = true;
            }
        }
        if (snapShotKeyBytes) {
            ccik.snapshotKeyFromValue();
        }
        return ccik;
    }

    public final Object getLocalIndexKeyValueBytes(Object value) {
        Class<?> cls = value.getClass();
        if (cls == byte[].class) {
            return value;
        }
        if (cls == byte[][].class) {
            return ((byte[][])value)[0];
        }
        if (OffHeapByteSource.isOffHeapBytesClass(cls)) {
            return value;
        }
        if (cls == SimpleMemoryAllocatorImpl.DataAsAddress.class) {
            return OffHeapRegionEntryHelper.encodedAddressToObject((long)((SimpleMemoryAllocatorImpl.DataAsAddress)value).getEncodedAddress(), (boolean)false, (boolean)true);
        }
        return null;
    }

    public final ExtractingIndexKey getExtractingKey(Object rowBytes) throws StandardException {
        if (rowBytes != null) {
            return new ExtractingIndexKey(rowBytes, this.indexInfo);
        }
        return null;
    }

    public final Object getGlobalIndexKey(ExecRow baseRow) throws StandardException {
        int[] baseColumnPositions = this.baseColumnPositions;
        if (baseColumnPositions.length == 1) {
            return baseRow.getColumn(baseColumnPositions[0]);
        }
        DataValueDescriptor[] indexKey = new DataValueDescriptor[baseColumnPositions.length];
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            indexKey[index] = baseRow.getColumn(baseColumnPositions[index]);
        }
        return new CompositeRegionKey(indexKey);
    }

    @Override
    public boolean traceThisLock() {
        return SanityManager.TRACE_ON((String)("TraceLock_" + this.qualifiedName)) || SanityManager.TRACE_ON((String)"TraceLock_DD");
    }

    public boolean isPrimaryKeyBased() {
        return this.tableInfo.getPrimaryKeyColumns() != null;
    }

    public void unlockRecordAfterRead(Transaction t, ContainerHandle container, RecordHandle record, boolean forUpdate, boolean row_qualified) {
        throw new AssertionError((Object)"unexpected execution");
    }

    public boolean zeroDurationLockRecordForWrite(Transaction t, RecordHandle record, boolean lockForPreviousKey, boolean waitForLock) throws StandardException {
        throw new AssertionError((Object)"unexpected execution");
    }

    public int getMode() {
        return 2;
    }

    public long estimateMemoryOverhead(SingleObjectSizer sizer) {
        long size = sizer.sizeof((Object)this);
        if (this.isApplicationTableOrGlobalIndex()) {
            size += this.region.estimateMemoryOverhead(sizer);
        } else assert (this.isLocalIndex());
        return size;
    }

    public int getIndexSize() {
        if (this.isLocalIndex()) {
            int sz = 0;
            ConcurrentSkipListMap<Object, Object> slm = this.skipListMap;
            if (slm == null || slm.isEmpty()) {
                sz = 0;
            } else {
                for (Object value : slm.values()) {
                    if (value == null) continue;
                    Class<?> valueCls = value.getClass();
                    if (valueCls == RowLocation[].class) {
                        sz += ((RowLocation[])value).length;
                        continue;
                    }
                    if (valueCls == ConcurrentTHashSet.class) {
                        sz += ((ConcurrentTHashSet)value).size();
                        continue;
                    }
                    assert (value instanceof RowLocation) : "unexpected type in index " + valueCls.getName() + ": " + value;
                    ++sz;
                }
            }
            return sz;
        }
        throw new GemFireXDRuntimeException("getIndexSize should be called only for local index but is being called for: " + this);
    }

    public void setIndexTrace(boolean indexTraceOn) {
        this.indexTraceOnForThisTable = indexTraceOn;
    }

    public boolean isIndexTraceOn() {
        return this.indexTraceOnForThisTable;
    }

    public void setGlobalIndexCaching() throws StandardException {
        boolean cacheGlobalIndexes;
        GemFireStore store = Misc.getMemStore();
        boolean bl = cacheGlobalIndexes = this.CACHE_GLOBAL_INDEX && store.isDataDictionaryPersistent() && store.isPersistIndexes();
        if (cacheGlobalIndexes) {
            if (!this.CACHE_GLOBAL_INDEX_IN_MAP) {
                try {
                    this.globalIndexMap = GlobalIndexCacheWithLocalRegion.createInstance(this.qualifiedName);
                }
                catch (Exception e) {
                    throw StandardException.newException("XJ001.U", e);
                }
            } else {
                this.globalIndexMap = new GlobalIndexCacheWithInMemoryMap();
            }
        } else {
            this.globalIndexMap = null;
        }
    }

    public void updateCache(Serializable globalIndexKey, Object robj) {
        if (this.globalIndexMap != null) {
            this.globalIndexMap.put((Object)globalIndexKey, robj);
        }
    }

    private boolean doAccounting() {
        if (!this.callback.isSnappyStore()) {
            return false;
        }
        LocalRegion baseRegion = this.getBaseRegion();
        return baseRegion != null && !baseRegion.reservedTable();
    }

    public void accountMemoryForIndex(long cursorPos, boolean forceAccount) {
        if (cursorPos >= 8L && (cursorPos & cursorPos - 1L) == 0L || forceAccount) {
            this.accountIndexMemory(true, false);
        }
    }

    public void resetInitialAccounting() {
        this.intialAccounting = 0L;
    }

    public void accountIndexMemory(boolean askMemoryManager, boolean isDestroy) {
        if (!this.doAccounting()) {
            return;
        }
        LocalRegion baseRegion = this.getBaseRegion();
        String baseTableContainerName = baseRegion.getFullPath();
        ArrayList<GemFireContainer> indexes = new ArrayList<GemFireContainer>();
        indexes.add(this);
        LinkedHashMap<String, Object[]> retEstimates = new LinkedHashMap<String, Object[]>();
        long sum = 0L;
        long totalOverhead = 0L;
        try {
            this.sizer.estimateIndexEntryValueSizes(baseTableContainerName, indexes, retEstimates, null);
            Misc.getCacheLogWriter().info("Computing initial index overhead of region " + baseTableContainerName + " for index " + this.getName());
            for (Map.Entry<String, Object[]> e : retEstimates.entrySet()) {
                long[] value = (long[])e.getValue()[0];
                sum += value[0];
                sum += value[1];
                sum += value[2];
                long rowCount = value[5];
                totalOverhead += (long)(rowCount == 0L ? 0 : Math.round(((sum += value[3]) - this.intialAccounting) / rowCount));
                if (askMemoryManager) {
                    Misc.getCacheLogWriter().info("Total overhead computed = " + sum + " intialAccounting = " + this.intialAccounting);
                    baseRegion.acquirePoolMemory(0L, sum - this.intialAccounting, false, null, false);
                    this.intialAccounting = sum;
                    this.sizeAccountedByIndex.set(sum);
                }
                this.totalRows = rowCount;
            }
            if (!isDestroy) {
                this.adjustAccountedMemory(totalOverhead);
                this.currenrOverhead = (int)totalOverhead;
            }
        }
        catch (StandardException | IllegalAccessException e) {
            throw new GemFireXDRuntimeException(e);
        }
        catch (InterruptedException ie) {
            Misc.checkIfCacheClosing(ie);
            Thread.currentThread().interrupt();
        }
    }

    private void releaseIndexMemory() {
        LocalRegion baseRegion = this.getBaseRegion();
        if (this.doAccounting()) {
            long memoryToBeFreed = (long)this.currenrOverhead * this.totalRows;
            this.getBaseRegion().freePoolMemory(memoryToBeFreed + this.sizeAccountedByIndex.get(), false);
            if (!baseRegion.isDestroyed) {
                baseRegion.setIndexOverhead(-1 * this.currenrOverhead);
                baseRegion.incIgnoreBytes(memoryToBeFreed);
            }
        }
    }

    public void accountSnapshotEntry(int numBytes) {
        LocalRegion baseRegion = this.getBaseRegion();
        if (this.doAccounting()) {
            this.getBaseRegion().acquirePoolMemory(0L, (long)numBytes, false, null, false);
            this.sizeAccountedByIndex.addAndGet(numBytes);
        }
    }

    public void adjustAccountedMemory(long newValue) {
        LocalRegion baseRegion = this.getBaseRegion();
        if (this.doAccounting()) {
            long adjustedMemory = newValue - (long)this.currenrOverhead;
            baseRegion.setIndexOverhead((int)adjustedMemory);
        }
    }

    public void runEstimation() {
        long numOps;
        if (this.doAccounting() && (numOps = this.numOperations.incrementAndGet()) >= 8L && (numOps & numOps - 1L) == 0L) {
            this.accountIndexMemory(false, false);
        }
    }

    static final class GFContainerLocking
    implements LockingPolicy {
        private final GfxdLockable containerLockObject;
        private final GfxdLockable ddLockObject;
        private final boolean isLocal;
        private boolean hasLobs;
        private final boolean traceLock;

        GFContainerLocking(GfxdLockable lockable, boolean local, GemFireContainer container) {
            GfxdDataDictionary dd;
            assert (lockable != null) : "expected non-null GfxdLockable for GFContainerLocking constructor";
            this.containerLockObject = lockable;
            this.isLocal = local;
            GemFireStore memStore = GemFireStore.getBootingInstance();
            this.ddLockObject = memStore != null && (dd = memStore.getDatabase().getDataDictionary()) != null ? dd.getLockObject() : null;
            if (container != null) {
                this.traceLock = container.traceLock();
                this.hasLobs = container.hasLobs;
            } else {
                this.traceLock = GemFireXDUtils.TraceLock;
            }
        }

        @Override
        public boolean lockContainer(Transaction tran, ContainerHandle container, boolean waitForLock, boolean forUpdate) throws StandardException {
            if (!forUpdate && container == null) {
                SanityManager.THROWASSERT((String)"expected non null container handle when acquiring a lock on container");
            }
            if (tran == null) {
                return false;
            }
            GemFireTransaction t = (GemFireTransaction)tran;
            t.setActiveState();
            GfxdLockable lockObject = this.getLockableForTransaction(t, forUpdate);
            if (this.traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GFContainerLocking: acquiring " + (this.isLocal ? "local " : "") + (forUpdate ? "write" : "read") + " lock on object " + lockObject + " [TX " + t + ']'), (Throwable)(GemFireXDUtils.TraceLock ? new Throwable() : null));
            }
            GfxdLockSet lockSet = t.getLockSpace();
            if (GfxdDataDictionary.SKIP_LOCKS.get().booleanValue()) {
                return true;
            }
            if (lockSet.acquireLock(lockObject, waitForLock ? (long)GfxdLockSet.MAX_LOCKWAIT_VAL : 0L, forUpdate, this.isLocal, forUpdate) != 0) {
                if (this.traceLock) {
                    SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GFContainerLocking: successfully acquired " + (this.isLocal ? "local " : "") + (forUpdate ? "write" : "read") + " lock on object " + lockObject + " [TX " + t + "] for lock " + lockObject.getReadWriteLock()));
                }
                return true;
            }
            if (waitForLock) {
                throw lockSet.getLockService().getLockTimeoutException(lockObject, lockSet.getOwner(), true);
            }
            return false;
        }

        @Override
        public void unlockContainer(Transaction tran, ContainerHandle container) {
            if (tran == null) {
                return;
            }
            GemFireTransaction t = (GemFireTransaction)tran;
            boolean forUpdate = container == null;
            GfxdLockable lockObject = this.getLockableForTransaction(t, forUpdate);
            if (this.traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GFContainerLocking: releasing " + (this.isLocal ? "local " : "") + (forUpdate ? "write " : "read ") + " lock on object " + lockObject + " [TX " + t + "] for lock " + lockObject.getReadWriteLock()), (Throwable)(GemFireXDUtils.TraceLock ? new Throwable() : null));
            }
            t.getLockSpace().releaseLock(lockObject, forUpdate, this.isLocal);
            if (this.traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GFContainerLocking: released " + (this.isLocal ? "local " : "") + (forUpdate ? "write" : "read") + " lock on object " + lockObject + " [TX " + t + "] for lock " + lockObject.getReadWriteLock()));
            }
        }

        private final GfxdLockable getLockableForTransaction(GemFireTransaction tran, boolean forUpdate) {
            if (GemFireXDUtils.TraceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GFContainerLocking: getLockableForTransaction " + (this.isLocal ? "local " : "") + (forUpdate ? "write" : "read") + " lock" + (this.ddLockObject == null ? "(ddLockObject null)" : "") + " with isTransactional=" + tran.isTransactional() + " for transaction: " + tran));
            }
            return !forUpdate && (this.hasLobs || tran.isTransactional()) && this.ddLockObject != null ? this.ddLockObject : this.containerLockObject;
        }

        final void update(GemFireContainer container) {
            this.hasLobs = container.hasLobs;
        }

        @Override
        public boolean lockRecordForRead(Transaction t, ContainerHandle container, RecordHandle record, boolean waitForLock, boolean forUpdate) throws StandardException {
            throw new AssertionError((Object)"unexpected execution");
        }

        @Override
        public boolean lockRecordForWrite(Transaction t, RecordHandle record, boolean lockForInsert, boolean waitForLock) throws StandardException {
            throw new AssertionError((Object)"unexpected execution");
        }

        @Override
        public void unlockRecordAfterRead(Transaction t, ContainerHandle container, RecordHandle record, boolean forUpdate, boolean row_qualified) {
            throw new AssertionError((Object)"unexpected execution");
        }

        @Override
        public boolean zeroDurationLockRecordForWrite(Transaction t, RecordHandle record, boolean lockForPreviousKey, boolean waitForLock) throws StandardException {
            throw new AssertionError((Object)"unexpected execution");
        }

        @Override
        public int getMode() {
            return 2;
        }
    }

    public static final class SerializableDelta
    extends GfxdDataSerializable
    implements Delta,
    Sizeable {
        private DataValueDescriptor[] changedRow;
        private FormatableBitSet validColumns;
        private transient int deltaSize = -1;
        private transient VersionTag<?> versionTag;
        private static final byte HAS_FBS = 1;
        private static final byte HAS_VERSION_TAG = 2;
        private static final byte HAS_PERSISTENT_VERSION_TAG = 4;

        public SerializableDelta() {
        }

        public SerializableDelta(DataValueDescriptor[] changedRow, FormatableBitSet validColumns) {
            this.changedRow = changedRow;
            this.validColumns = validColumns;
        }

        public Object apply(EntryEvent<?, ?> event) {
            return this.apply(event.getRegion(), event.getKey(), ((EntryEventImpl)event).getOldValueAsOffHeapDeserializedOrRaw(), event.getTransactionId() == null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final Object apply(Region<?, ?> region, Object key, Object rowObject, boolean prepareForOffHeap) {
            if (rowObject == null || Token.isRemoved((Object)rowObject)) {
                throw new EntryDestroyedException("Update on key=" + key + " could not be done as row (" + rowObject + ") is already destroyed");
            }
            GemFireContainer container = (GemFireContainer)region.getUserAttribute();
            assert (container != null) : "SerializableDelta: container not set as user attribute for the region '" + region.getFullPath() + "'";
            Object row = null;
            try {
                if (container.isByteArrayStore()) {
                    Class<?> cls = rowObject.getClass();
                    if (cls == byte[].class) {
                        byte[] rowBytes = (byte[])rowObject;
                        RowFormatter rf = container.getRowFormatter(rowBytes);
                        row = !rf.hasLobs() ? (Object)rf.setColumns(this.validColumns, this.changedRow, rowBytes, container.getCurrentRowFormatter()) : (Object)rf.setColumns(this.validColumns, this.changedRow, (byte[][])null, rowBytes, container.getCurrentRowFormatter());
                    } else if (cls == byte[][].class) {
                        byte[][] rowBytes = (byte[][])rowObject;
                        byte[] firstBytes = rowBytes[0];
                        RowFormatter rf = container.getRowFormatter(firstBytes);
                        row = rf.hasLobs() ? (Object)rf.setColumns(this.validColumns, this.changedRow, rowBytes, firstBytes, container.getCurrentRowFormatter()) : (Object)rf.setColumns(this.validColumns, this.changedRow, rowBytes[0], container.getCurrentRowFormatter());
                    } else if (cls == OffHeapRow.class) {
                        OffHeapRow offheapSource = (OffHeapRow)((Object)rowObject);
                        RowFormatter rf = container.getRowFormatter(offheapSource);
                        row = !rf.hasLobs() ? (Object)rf.setColumns(this.validColumns, this.changedRow, offheapSource, container.getCurrentRowFormatter()) : (Object)rf.setColumns(this.validColumns, this.changedRow, null, offheapSource, container.getCurrentRowFormatter(), prepareForOffHeap);
                    } else {
                        if (cls != OffHeapRowWithLobs.class) throw new InternalGemFireError("SerializableDelta.applyDelta: unknown value type " + cls + ": " + rowObject);
                        OffHeapRowWithLobs offheapSource = (OffHeapRowWithLobs)((Object)rowObject);
                        RowFormatter rf = container.getRowFormatter(offheapSource);
                        row = rf.hasLobs() ? (Object)rf.setColumns(this.validColumns, this.changedRow, offheapSource, null, container.getCurrentRowFormatter(), prepareForOffHeap) : (Object)rf.setColumns(this.validColumns, this.changedRow, (OffHeapByteSource)offheapSource, container.getCurrentRowFormatter());
                    }
                } else {
                    LocalRegion lr = (LocalRegion)region;
                    DataValueDescriptor[] oldValue = (DataValueDescriptor[])rowObject;
                    DataValueDescriptor[] thisRow = (DataValueDescriptor[])oldValue.clone();
                    for (int i = 0; i < this.changedRow.length; ++i) {
                        if (this.changedRow[i] == null) continue;
                        thisRow[i] = this.changedRow[i].getClone();
                        thisRow[i].setRegionContext(lr);
                    }
                    row = thisRow;
                }
                if (GemFireXDUtils.TraceConglomUpdate) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Applied delta ");
                    ArrayUtils.objectStringNonRecursive((Object)this.changedRow, (StringBuilder)sb);
                    sb.append(" on row ");
                    ArrayUtils.objectStringNonRecursive((Object)rowObject, (StringBuilder)sb);
                    sb.append(" to get result ");
                    ArrayUtils.objectStringNonRecursive((Object)row, (StringBuilder)sb);
                    SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)sb.toString());
                }
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("Unexpected failure in Delta apply", se);
            }
            assert (row != null) : "Row cannot be null after applying delta";
            return row;
        }

        public Delta merge(Region<?, ?> region, Delta toMerge) {
            SerializableDelta newDelta;
            assert (toMerge instanceof SerializableDelta) : "unknown Delta to merge: " + toMerge;
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("SerializableDelta#merge: toMerge [" + toMerge.toString() + "] this [" + this.toString() + ']'));
            }
            SerializableDelta other = (SerializableDelta)toMerge;
            DataValueDescriptor[] thisRow = this.changedRow;
            DataValueDescriptor[] otherRow = other.changedRow;
            if (thisRow.length >= otherRow.length) {
                DataValueDescriptor[] newRow = (DataValueDescriptor[])thisRow.clone();
                newDelta = new SerializableDelta(newRow, new FormatableBitSet(this.validColumns));
                FormatableBitSet otherCols = other.validColumns;
                newDelta.validColumns.or(otherCols);
                int pos = otherCols.anySetBit();
                while (pos >= 0) {
                    newRow[pos] = otherRow[pos];
                    pos = otherCols.anySetBit(pos);
                }
            } else {
                DataValueDescriptor[] newRow = (DataValueDescriptor[])otherRow.clone();
                newDelta = new SerializableDelta(newRow, new FormatableBitSet(other.validColumns));
                FormatableBitSet thisCols = this.validColumns;
                newDelta.validColumns.or(thisCols);
                int pos = thisCols.anySetBit();
                while (pos >= 0) {
                    if (newRow[pos] == null) {
                        newRow[pos] = thisRow[pos];
                    }
                    pos = thisCols.anySetBit(pos);
                }
            }
            if (GemFireXDUtils.TraceConglomUpdate) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("SerializableDelta#merge: after merge: " + newDelta.toString()));
            }
            return newDelta;
        }

        public final DataValueDescriptor[] getChangedRow() {
            return this.changedRow;
        }

        public final FormatableBitSet getChangedColumns() {
            return this.validColumns;
        }

        public void setVersionTag(VersionTag versionTag) {
            this.versionTag = versionTag;
        }

        public VersionTag<?> getVersionTag() {
            return this.versionTag;
        }

        public String toString() {
            return "SerializableDelta@0x" + Integer.toHexString(System.identityHashCode(this)) + ": changedRow=" + RowUtil.toString(this.changedRow) + ", validColumns=" + (this.validColumns != null ? this.validColumns.toString() : null) + (this.versionTag != null ? ", version=" + this.versionTag : "");
        }

        @Override
        public byte getGfxdID() {
            return 81;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            FormatableBitSet fbs = this.validColumns;
            DataValueDescriptor[] row = this.changedRow;
            int flags = 0;
            VersionTag<?> version = this.versionTag;
            if (version != null) {
                flags = (byte)(flags | 2);
                if (version instanceof DiskVersionTag) {
                    flags = (byte)(flags | 4);
                }
            }
            if (fbs != null) {
                out.writeByte(1 | flags);
                fbs.toData(out);
                InternalDataSerializer.writeArrayLength((int)row.length, (DataOutput)out);
                int pos = fbs.anySetBit();
                while (pos >= 0) {
                    DataValueDescriptor dvd = row[pos];
                    if (dvd != null) {
                        dvd.toData(out);
                    } else {
                        out.writeByte(41);
                        out.writeByte(41);
                    }
                    pos = fbs.anySetBit(pos);
                }
            } else {
                out.writeByte(flags);
                DataType.writeDVDArray(row, out);
            }
            if (version != null) {
                InternalDataSerializer.invokeToData(version, (DataOutput)out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            byte flags = in.readByte();
            if ((flags & 1) != 0) {
                FormatableBitSet fbs = new FormatableBitSet();
                fbs.fromData(in);
                this.validColumns = fbs;
                int numColumns = InternalDataSerializer.readArrayLength((DataInput)in);
                this.changedRow = new DataValueDescriptor[numColumns];
                int pos = fbs.anySetBit();
                while (pos >= 0) {
                    this.changedRow[pos] = DataType.readDVD(in);
                    pos = fbs.anySetBit(pos);
                }
            } else {
                DataType.readDVDArray(in);
            }
            if ((flags & 2) != 0) {
                this.versionTag = VersionTag.create(((flags & 4) != 0 ? 1 : 0) != 0, (DataInput)in);
            }
        }

        public int getSizeInBytes() {
            if (this.deltaSize < 0) {
                assert (this.changedRow != null) : "SerializableDelta: delta can never be null ";
                int sz = 0;
                for (int index = 0; index < this.changedRow.length; ++index) {
                    DataValueDescriptor dvd = this.changedRow[index];
                    try {
                        sz += dvd != null ? dvd.getLength() : 0;
                        continue;
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                }
                this.deltaSize = sz;
            }
            return this.deltaSize;
        }

        public final SerializableDelta cloneDelta() {
            DataValueDescriptor[] newRow = new DataValueDescriptor[this.changedRow.length];
            int index = 0;
            for (DataValueDescriptor dvd : this.changedRow) {
                newRow[index] = dvd.getClone();
                ++index;
            }
            return new SerializableDelta(newRow, this.validColumns.clone());
        }

        public boolean allowCreate() {
            return false;
        }
    }

    public static final class BulkKeyLookupResult
    extends GfxdDataSerializable {
        public Object gfKey;
        public boolean exists;

        public BulkKeyLookupResult() {
        }

        public BulkKeyLookupResult(Object key, boolean contains) {
            this.gfKey = key;
            this.exists = contains;
        }

        public String toString() {
            String s = "gfKey=" + this.gfKey + ",exists=" + this.exists;
            return s;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            InternalDataSerializer.writeObject((Object)this.gfKey, (DataOutput)out);
            out.writeBoolean(this.exists);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.gfKey = InternalDataSerializer.readObject((DataInput)in);
            this.exists = in.readBoolean();
        }

        @Override
        public byte getGfxdID() {
            return 104;
        }
    }

    private static final class PREntriesFullIterator
    implements PREntriesIterator<Object> {
        private final PREntriesIterator<?> entriesItr;

        PREntriesFullIterator(PartitionedRegion pr) {
            this.entriesItr = (PREntriesIterator)pr.allEntries().iterator();
        }

        public boolean hasNext() {
            return this.entriesItr.hasNext();
        }

        public RowLocation next() {
            Region.Entry entry = (Region.Entry)this.entriesItr.next();
            assert (entry != null);
            if (!entry.isDestroyed()) {
                if (GemFireXDUtils.TraceConglomRead) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)("PREntriesFullIterator#next: returning entry: " + entry));
                }
                return PREntriesFullIterator.extractRowLocationFromEntry(entry);
            }
            return null;
        }

        public PartitionedRegion getPartitionedRegion() {
            return this.entriesItr.getPartitionedRegion();
        }

        public int getBucketId() {
            return this.entriesItr.getBucketId();
        }

        public Bucket getBucket() {
            return this.entriesItr.getBucket();
        }

        public BucketRegion getHostedBucketRegion() {
            return this.entriesItr.getHostedBucketRegion();
        }

        public void remove() {
            throw new UnsupportedOperationException("Unsupported Operation remove!");
        }

        private static RowLocation extractRowLocationFromEntry(Region.Entry<?, ?> entry) {
            if (entry != null) {
                Class<?> cls = entry.getClass();
                if (cls == LocalRegion.NonTXEntry.class) {
                    return (RowLocation)((LocalRegion.NonTXEntry)entry).getRegionEntry();
                }
                if (cls == TXEntry.class) {
                    return (GfxdTXEntryState)((TXEntry)entry).getTXEntryState();
                }
                return (RowLocation)((EntrySnapshot)entry).getRegionEntry();
            }
            return null;
        }
    }
}

