/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.ObjToByteArraySerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import java.nio.ByteBuffer;
import org.apache.spark.unsafe.Platform;

public final class GfxdHeapDataOutputStream
extends HeapDataOutputStream
implements ObjToByteArraySerializer {
    static final int MIN_SIZE = Integer.getInteger("gemfirexd.heap-output-stream-size", 512);
    final GfxdHeapThresholdListener thresholdListener;
    final String query;
    final boolean wrapBytes;

    public GfxdHeapDataOutputStream(GfxdHeapThresholdListener thresholdListener, String query, boolean wrapBytes, Version v) {
        this(MIN_SIZE, thresholdListener, query, wrapBytes, v);
    }

    public GfxdHeapDataOutputStream(int minSize, GfxdHeapThresholdListener thresholdListener, String query, boolean wrapBytes, Version v) {
        super(minSize, v);
        this.thresholdListener = thresholdListener;
        this.query = query;
        this.wrapBytes = wrapBytes;
        this.markForReuse();
    }

    public final void write(byte[] source, int offset, int len) {
        if (this.wrapBytes && this.buffer.position() > 0 && this.buffer.remaining() < len) {
            this.writeWithByteArrayWrappedConditionally(source, offset, len);
        } else {
            super.write(source, offset, len);
        }
    }

    public final void write(ByteBuffer source) {
        if (this.wrapBytes) {
            this.writeWithByteBufferWrappedConditionally(source);
        } else {
            super.write(source);
        }
    }

    public final void copyMemory(Object src, long srcOffset, int length) {
        ByteBuffer buffer = this.buffer;
        byte[] dst = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        int remainingSpace = buffer.capacity() - pos;
        if (remainingSpace < length) {
            Platform.copyMemory((Object)src, (long)srcOffset, (Object)dst, (long)(Platform.BYTE_ARRAY_OFFSET + offset + pos), (long)remainingSpace);
            buffer.position(pos + remainingSpace);
            srcOffset += (long)remainingSpace;
            this.ensureCapacity(length -= remainingSpace);
            buffer = this.buffer;
            dst = buffer.array();
            offset = buffer.arrayOffset();
            pos = buffer.position();
        }
        Platform.copyMemory((Object)src, (long)srcOffset, (Object)dst, (long)(Platform.BYTE_ARRAY_OFFSET + offset + pos), (long)length);
        buffer.position(pos + length);
    }

    protected final void expand(int amount) {
        Misc.checkMemoryRuntime(this.thresholdListener, this.query, amount);
        super.expand(amount);
    }
}

