/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

public class DiskStoreIDs
extends GfxdVTITemplate {
    private Iterator<DiskStoreImpl> diskStores;
    private DiskStoreImpl currentDiskStore;
    public static final String MEMBERID = "MEMBERID";
    public static final String NAME = "NAME";
    public static final String ID = "ID";
    public static final String DIRS = "DIRS";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("MEMBERID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("NAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("ID", 1, false, 36), EmbedResultSetMetaData.getResultColumnDescriptor("DIRS", 12, false, 32672)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public boolean next() throws SQLException {
        GemFireCacheImpl cache;
        if (this.diskStores == null && (cache = GemFireCacheImpl.getInstance()) != null && !cache.isClosed()) {
            this.diskStores = cache.listDiskStoresIncludingRegionOwned().iterator();
        }
        if (this.diskStores != null && this.diskStores.hasNext()) {
            this.currentDiskStore = this.diskStores.next();
            this.wasNull = false;
            return true;
        }
        this.currentDiskStore = null;
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        String res;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        String columnName = desc.getName();
        if (MEMBERID.equals(columnName)) {
            res = this.currentDiskStore.getCache().getMyId().getId();
        } else if (NAME.equals(columnName)) {
            res = this.currentDiskStore.getName();
        } else if (ID.equals(columnName)) {
            res = this.currentDiskStore.getDiskStoreUUID().toString();
        } else if (DIRS.equals(columnName)) {
            StringBuilder dirs = new StringBuilder();
            for (File dir : this.currentDiskStore.getDiskDirs()) {
                String dirPath;
                if (dirs.length() > 0) {
                    dirs.append(',');
                }
                try {
                    dirPath = dir.getCanonicalPath();
                }
                catch (IOException ioe) {
                    dirPath = dir.getAbsolutePath();
                }
                dirs.append(dirPath);
            }
            res = dirs.toString();
        } else {
            res = null;
        }
        return res;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }
}

