/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.GFToSlf4jBridge;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLPreprocess;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColPermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoutinePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TablePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstantActionActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RoutinePrivilegeInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TablePrivilegeInfo;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;

public final class GfxdSystemProcedureMessage
extends AbstractGfxdReplayableMessage
implements GfxdDDLPreprocess {
    private static final long serialVersionUID = 2039841562674551814L;
    protected static final short HAS_SERVER_GROUPS = 64;
    protected static final short INITIAL_DDL_REPLAY_IN_PROGRESS = 128;
    private SysProcMethod procMethod;
    private Object[] params;
    private transient DistributedMember sender;
    private String currentSchemaName;
    private long connId;
    private long ddlId;
    private transient boolean initialDDLReplayInProgress;

    public GfxdSystemProcedureMessage() {
        this.currentSchemaName = null;
        this.connId = -1L;
        this.ddlId = -1L;
        this.procMethod = null;
        this.params = null;
        this.sender = null;
    }

    public GfxdSystemProcedureMessage(SysProcMethod procMethod, Object[] params, String currentSchemaName, long connId, long ddlId, DistributedMember sender) {
        this.currentSchemaName = currentSchemaName;
        this.connId = connId;
        this.ddlId = ddlId;
        this.procMethod = procMethod;
        this.params = params;
        this.sender = sender;
        this.initialDDLReplayInProgress = Misc.initialDDLReplayInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(DistributionManager dm) {
        EmbedConnection conn;
        block23: {
            this.sender = this.getSender();
            Exception t = null;
            conn = null;
            LanguageConnectionContext lcc = null;
            StatementContext statementContext = null;
            boolean popContext = false;
            try {
                if (!this.procMethod.allowExecution(this.params)) {
                    if (GemFireXDUtils.TraceSysProcedures) {
                        SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Skipping execution of system procedure on " + GemFireXDUtils.getMyVMKind() + " JVM"));
                    }
                    return;
                }
                if (!this.procMethod.initConnection()) {
                    if (GemFireXDUtils.TraceSysProcedures) {
                        SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:processMessage: Processing GfxdSystemProcedureMessage with no connection " + this));
                    }
                    this.execute();
                    return;
                }
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:processMessage: About to acquire connection for " + this));
                }
                conn = GemFireXDUtils.getTSSConnection(true, true, true);
                conn.getTR().setupContextStack();
                Object object = conn.getConnectionSynchronization();
                synchronized (object) {
                    lcc = conn.getLanguageConnectionContext();
                    lcc.pushMe();
                    popContext = true;
                    assert (ContextService.getContextOrNull("LanguageConnectionContext") != null);
                    statementContext = lcc.pushStatementContext(false, false, this.procMethod.name(), null, false, 0L);
                    statementContext.setSQLAllowed((short)0, true);
                    if (GemFireXDUtils.TraceSysProcedures) {
                        SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:processMessage: Processing GfxdSystemProcedureMessage " + this));
                    }
                    this.execute();
                }
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, t);
                }
                if (lcc == null || !popContext) break block23;
            }
            catch (Exception ex) {
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:processMessage: Exception occured while processing message " + this), (Throwable)ex);
                }
                t = ex;
                throw new ReplyException("GfxdSystemProcedureMessage:processMessage: Unexpected Exception on member " + dm.getDistributionManagerId(), (Throwable)ex);
            }
            finally {
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, t);
                }
                if (lcc != null && popContext) {
                    lcc.popMe();
                }
                if (conn != null) {
                    conn.getTR().restoreContextStack();
                }
            }
            lcc.popMe();
        }
        if (conn != null) {
            conn.getTR().restoreContextStack();
        }
    }

    @Override
    public void execute() throws StandardException {
        if (!this.procMethod.allowExecution(this.params)) {
            if (GemFireXDUtils.TraceSysProcedures) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Skipping execution of system procedure on " + GemFireXDUtils.getMyVMKind() + " JVM"));
            }
            return;
        }
        if (GemFireXDUtils.TraceSysProcedures) {
            SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:execute:  calling " + (Object)((Object)this.procMethod)));
        }
        this.procMethod.processMessage(this.params, this.sender);
    }

    @Override
    public byte getGfxdID() {
        return 2;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.currentSchemaName = InternalDataSerializer.readString((DataInput)in);
        this.connId = in.readLong();
        this.ddlId = in.readLong();
        byte ordinal = in.readByte();
        this.procMethod = SysProcMethod.values()[ordinal];
        this.params = this.procMethod.readParams(in, this.flags);
        this.initialDDLReplayInProgress = (this.flags & 0x80) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.writeString((String)this.currentSchemaName, (DataOutput)out);
        out.writeLong(this.connId);
        out.writeLong(this.ddlId);
        out.writeByte(this.procMethod.ordinal());
        this.procMethod.writeParams(this.params, out);
    }

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.initialDDLReplayInProgress) {
            flags = (short)(flags | 0x80);
        }
        return this.procMethod.computeFlags(flags, this.params);
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return !this.initialDDLReplayInProgress;
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; procedureMethod='").append(this.procMethod.toString()).append('\'');
        if (this.initialDDLReplayInProgress) {
            sb.append("; initialDDLReplayInProgress=true");
        }
        this.procMethod.appendParams(this.params, sb);
    }

    @Override
    public boolean shouldBeMerged() {
        return this.procMethod.shouldBeMerged(this.params);
    }

    @Override
    public boolean merge(Conflatable existing) {
        if (existing instanceof GfxdSystemProcedureMessage) {
            GfxdSystemProcedureMessage msg = (GfxdSystemProcedureMessage)existing;
            Object[] newParams = this.procMethod.merge(this.params, msg.procMethod, msg.params);
            if (newParams != SysProcMethod.NOT_MERGED) {
                this.params = newParams;
                return true;
            }
        }
        return false;
    }

    public boolean shouldBeConflated() {
        return this.procMethod.shouldBeConflated(this.params);
    }

    public String getRegionToConflate() {
        return this.procMethod.getRegionToConflate(this.params);
    }

    public Object getKeyToConflate() {
        return this.procMethod.getKeyToConflate(this.params);
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public boolean preprocess() {
        return this.procMethod.preprocess();
    }

    @Override
    public String getSQLStatement() throws StandardException {
        return this.procMethod.getSQLStatement(this.params);
    }

    public SysProcMethod getSysProcMethod() {
        return this.procMethod;
    }

    public Object[] getParameters() {
        return this.params;
    }

    public static enum SysProcMethod {
        setDatabaseProperty{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (String.class.isInstance(params[0]) && (String.class.isInstance(params[1]) || params[1] == null));
                String key = (String)params[0];
                String value = (String)params[1];
                Misc.getMemStoreBooting().setProperty(key, (Serializable)((Object)value), false);
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("configured (" + key + "," + value + ") for request originated from " + sender));
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                int numPrms = InternalDataSerializer.readArrayLength((DataInput)in);
                assert (numPrms == 2);
                Object[] inParams = new Object[numPrms];
                for (int count = 0; count < numPrms; ++count) {
                    inParams[count] = InternalDataSerializer.readString((DataInput)in);
                }
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeArrayLength((int)params.length, (DataOutput)out);
                for (Object prm : params) {
                    assert (prm == null || String.class.isInstance(prm));
                    InternalDataSerializer.writeString((String)((String)prm), (DataOutput)out);
                }
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return true;
            }

            @Override
            Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
                if (existingMethod == setDatabaseProperty && params[0] != null && params[0].equals(existingMethodParams[0])) {
                    return params;
                }
                return NOT_MERGED;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return false;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_DBPROPERTY";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[0];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                sb.append("CALL SYSCS_UTIL.SET_DATABASE_PROPERTY('").append((String)params[0]).append("',");
                if (params[1] != null) {
                    sb.append('\'').append((String)params[1]).append('\'');
                } else {
                    sb.append("NULL");
                }
                return sb.append(')').toString();
            }

            @Override
            void appendParams(Object[] params, StringBuilder sb) {
                assert (params.length == 2) : params.length;
                String key = (String)params[0];
                String value = (String)params[1];
                if (key.startsWith("_GFXD_INTERNAL_PVT_KEY")) {
                    value = "***";
                }
                sb.append("; key=").append(key).append(", value=").append(value);
            }
        }
        ,
        createUser{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (String.class.isInstance(params[0]) && (String.class.isInstance(params[1]) || params[1] == null));
                String key = (String)params[0];
                String value = (String)params[1];
                Misc.getMemStoreBooting().setProperty(key, (Serializable)((Object)value), false);
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("creating distributed system user (" + key + "). "));
                    SanityManager.ASSERT((PropertyUtil.whereSet(key, null) != 0 ? 1 : 0) != 0, (String)("Cannot be a system user " + key));
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                int numPrms = InternalDataSerializer.readArrayLength((DataInput)in);
                assert (numPrms == 2);
                Object[] inParams = new Object[numPrms];
                for (int count = 0; count < numPrms; ++count) {
                    inParams[count] = InternalDataSerializer.readString((DataInput)in);
                }
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeArrayLength((int)params.length, (DataOutput)out);
                for (Object prm : params) {
                    assert (prm == null || String.class.isInstance(prm));
                    InternalDataSerializer.writeString((String)((String)prm), (DataOutput)out);
                }
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return false;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return false;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_USERS";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[0];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                return 2.getCreateUserStatement((String)params[0], (String)params[1]);
            }
        }
        ,
        changePassword{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (String.class.isInstance(params[0]) && String.class.isInstance(params[1]) && String.class.isInstance(params[2]));
                String key = (String)params[0];
                String value = (String)params[2];
                Misc.getMemStoreBooting().setProperty(key, (Serializable)((Object)value), false);
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("changing distributed system user password (" + key + "," + value + "). "));
                    SanityManager.ASSERT((PropertyUtil.whereSet(key, null) != 0 ? 1 : 0) != 0, (String)("Cannot be a system user " + key));
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                int numPrms = InternalDataSerializer.readArrayLength((DataInput)in);
                assert (numPrms == 3 || numPrms == 4);
                Object[] inParams = new Object[numPrms];
                for (int count = 0; count < numPrms; ++count) {
                    inParams[count] = InternalDataSerializer.readString((DataInput)in);
                }
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && (params.length == 3 || params.length == 4));
                InternalDataSerializer.writeArrayLength((int)params.length, (DataOutput)out);
                for (Object prm : params) {
                    assert (prm == null || String.class.isInstance(prm));
                    InternalDataSerializer.writeString((String)((String)prm), (DataOutput)out);
                }
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return true;
            }

            @Override
            Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
                if ((existingMethod == createUser || existingMethod == changePassword) && ArrayUtils.objectEquals((Object)params[0], (Object)existingMethodParams[0])) {
                    Object[] newParams = new Object[]{params[0], params[1], params[2], "converted to 'createUser'"};
                    return newParams;
                }
                return NOT_MERGED;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return false;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_USERS";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[0];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                if (params.length == 4) {
                    return 3.getCreateUserStatement((String)params[0], (String)params[2]);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("CALL SYS.CHANGE_PASSWORD('").append((String)params[0]).append("',");
                if (params[1] != null) {
                    sb.append('\'').append((String)params[1]).append('\'');
                } else {
                    sb.append("NULL");
                }
                if (params[2] != null) {
                    sb.append('\'').append((String)params[2]).append('\'');
                } else {
                    sb.append("NULL");
                }
                return sb.append(')').toString();
            }
        }
        ,
        dropUser{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            boolean initConnection() {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (String.class.isInstance(params[0]) && params.length == 1);
                String userId = (String)params[0];
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                Misc.getMemStoreBooting().setProperty(userId, null, false);
                String authId = userId;
                if (userId.startsWith("gemfirexd.user.")) {
                    authId = userId.substring("gemfirexd.user.".length());
                } else if (userId.startsWith("sqlfire.user.")) {
                    authId = userId.substring("sqlfire.user.".length());
                }
                lcc.getDataDictionary().dropAllPermsByGrantee(authId, lcc.getTransactionExecute());
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("dropped distributed system user (" + userId + ") "));
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                int numPrms = InternalDataSerializer.readArrayLength((DataInput)in);
                assert (numPrms == 1);
                Object[] inParams = new Object[numPrms];
                inParams[0] = InternalDataSerializer.readString((DataInput)in);
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 1);
                InternalDataSerializer.writeArrayLength((int)1, (DataOutput)out);
                assert (String.class.isInstance(params[0]));
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return true;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_USERS";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[0];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.DROP_USER('").append((String)params[0]).append("')").toString();
            }
        }
        ,
        setCriticalHeapPercentage{

            @Override
            boolean allowExecution(Object[] params) throws StandardException {
                assert (params[1] == null || params[1] instanceof String) : params[1];
                if (super.allowExecution(params)) {
                    return params[1] == null || !CallbackProcedures.skipExecutionForGroupsAndTable((String)params[1], null);
                }
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (params[0] instanceof Float) : params[0];
                float heapPercent = ((Float)params[0]).floatValue();
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("about to invoke critical_heap_percentage (" + heapPercent + ") for request originated remotely. "));
                }
                GfxdSystemProcedures.SET_CRITICAL_HEAP_PERCENTAGE(heapPercent);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] params = new Object[2];
                params[0] = InternalDataSerializer.readFloat((DataInput)in);
                if ((flags & 0x40) != 0) {
                    params[1] = InternalDataSerializer.readString((DataInput)in);
                }
                return params;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeFloat((Float)((Float)params[0]), (DataOutput)out);
                if (params[1] != null) {
                    InternalDataSerializer.writeString((String)((String)params[1]), (DataOutput)out);
                }
            }

            @Override
            short computeFlags(short flags, Object[] params) {
                if (params[1] != null) {
                    flags = (short)(flags | 0x40);
                }
                return flags;
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return true;
            }

            @Override
            Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
                if (existingMethod == setCriticalHeapPercentage && ArrayUtils.objectEquals((Object)params[1], (Object)existingMethodParams[1])) {
                    return params;
                }
                return NOT_MERGED;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return ((Float)params[0]).floatValue() == 0.0f;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_CRITICALHEAP";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[1];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                sb.append("CALL SYS.SET_CRITICAL_HEAP_PERCENTAGE_SG(").append(params[0]).append(',');
                if (params[1] != null) {
                    sb.append('\'').append((String)params[1]).append('\'');
                } else {
                    sb.append("NULL");
                }
                return sb.append(')').toString();
            }
        }
        ,
        setCriticalOffHeapPercentage{

            @Override
            boolean allowExecution(Object[] params) throws StandardException {
                assert (params[1] == null || params[1] instanceof String) : params[1];
                if (super.allowExecution(params)) {
                    return params[1] == null || !CallbackProcedures.skipExecutionForGroupsAndTable((String)params[1], null);
                }
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (params[0] instanceof Float) : params[0];
                float offHeapPercent = ((Float)params[0]).floatValue();
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("about to invoke critical_off_heap_percentage (" + offHeapPercent + ") for request originated remotely. "));
                }
                GfxdSystemProcedures.SET_CRITICAL_OFFHEAP_PERCENTAGE(offHeapPercent);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] params = new Object[2];
                params[0] = InternalDataSerializer.readFloat((DataInput)in);
                if ((flags & 0x40) != 0) {
                    params[1] = InternalDataSerializer.readString((DataInput)in);
                }
                return params;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeFloat((Float)((Float)params[0]), (DataOutput)out);
                if (params[1] != null) {
                    InternalDataSerializer.writeString((String)((String)params[1]), (DataOutput)out);
                }
            }

            @Override
            short computeFlags(short flags, Object[] params) {
                if (params[1] != null) {
                    flags = (short)(flags | 0x40);
                }
                return flags;
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return true;
            }

            @Override
            Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
                if (existingMethod == setCriticalOffHeapPercentage && ArrayUtils.objectEquals((Object)params[1], (Object)existingMethodParams[1])) {
                    return params;
                }
                return NOT_MERGED;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return ((Float)params[0]).floatValue() == 0.0f;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_CRITICALOFFHEAP";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[1];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                sb.append("CALL SYS.SET_CRITICAL_OFFHEAP_PERCENTAGE_SG(").append(params[0]).append(',');
                if (params[1] != null) {
                    sb.append('\'').append((String)params[1]).append('\'');
                } else {
                    sb.append("NULL");
                }
                return sb.append(')').toString();
            }

            @Override
            public boolean isOffHeapMethod() {
                return true;
            }
        }
        ,
        setEvictionHeapPercentage{

            @Override
            boolean allowExecution(Object[] params) throws StandardException {
                assert (params[1] == null || params[1] instanceof String) : params[1];
                if (super.allowExecution(params)) {
                    return params[1] == null || !CallbackProcedures.skipExecutionForGroupsAndTable((String)params[1], null);
                }
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (params[0] instanceof Float) : params[0];
                float heapPercent = ((Float)params[0]).floatValue();
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("about to invoke eviction_heap_percentage (" + heapPercent + ") for request originated remotely from " + sender));
                }
                GfxdSystemProcedures.SET_EVICTION_HEAP_PERCENTAGE(heapPercent);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] params = new Object[2];
                params[0] = InternalDataSerializer.readFloat((DataInput)in);
                if ((flags & 0x40) != 0) {
                    params[1] = InternalDataSerializer.readString((DataInput)in);
                }
                return params;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeFloat((Float)((Float)params[0]), (DataOutput)out);
                if (params[1] != null) {
                    InternalDataSerializer.writeString((String)((String)params[1]), (DataOutput)out);
                }
            }

            @Override
            short computeFlags(short flags, Object[] params) {
                if (params[1] != null) {
                    flags = (short)(flags | 0x40);
                }
                return flags;
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return true;
            }

            @Override
            Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
                if (existingMethod == setEvictionHeapPercentage && ArrayUtils.objectEquals((Object)params[1], (Object)existingMethodParams[1])) {
                    return params;
                }
                return NOT_MERGED;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return ((Float)params[0]).floatValue() == 0.0f;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_EVICTIONHEAP";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[1];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                sb.append("CALL SYS.SET_EVICTION_HEAP_PERCENTAGE_SG(").append(params[0]).append(',');
                if (params[1] != null) {
                    sb.append('\'').append((String)params[1]).append('\'');
                } else {
                    sb.append("NULL");
                }
                return sb.append(')').toString();
            }
        }
        ,
        setEvictionOffHeapPercentage{

            @Override
            boolean allowExecution(Object[] params) throws StandardException {
                assert (params[1] == null || params[1] instanceof String) : params[1];
                if (super.allowExecution(params)) {
                    return params[1] == null || !CallbackProcedures.skipExecutionForGroupsAndTable((String)params[1], null);
                }
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                assert (params[0] instanceof Float) : params[0];
                float offHeapPercent = ((Float)params[0]).floatValue();
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("about to invoke eviction_offheap_percentage (" + offHeapPercent + ") for request originated remotely from " + sender));
                }
                GfxdSystemProcedures.SET_EVICTION_OFFHEAP_PERCENTAGE(offHeapPercent);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] params = new Object[2];
                params[0] = InternalDataSerializer.readFloat((DataInput)in);
                if ((flags & 0x40) != 0) {
                    params[1] = InternalDataSerializer.readString((DataInput)in);
                }
                return params;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeFloat((Float)((Float)params[0]), (DataOutput)out);
                if (params[1] != null) {
                    InternalDataSerializer.writeString((String)((String)params[1]), (DataOutput)out);
                }
            }

            @Override
            short computeFlags(short flags, Object[] params) {
                if (params[1] != null) {
                    flags = (short)(flags | 0x40);
                }
                return flags;
            }

            @Override
            boolean shouldBeMerged(Object[] params) {
                return true;
            }

            @Override
            Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
                if (existingMethod == setEvictionOffHeapPercentage && ArrayUtils.objectEquals((Object)params[1], (Object)existingMethodParams[1])) {
                    return params;
                }
                return NOT_MERGED;
            }

            @Override
            boolean shouldBeConflated(Object[] params) {
                return ((Float)params[0]).floatValue() == 0.0f;
            }

            @Override
            String getRegionToConflate(Object[] params) {
                return "SYS.__GFXD_INTERNAL_EVICTIONOFFHEAP";
            }

            @Override
            Object getKeyToConflate(Object[] params) {
                return params[1];
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                sb.append("CALL SYS.SET_EVICTION_OFFHEAP_PERCENTAGE_SG(").append(params[0]).append(',');
                if (params[1] != null) {
                    sb.append('\'').append((String)params[1]).append('\'');
                } else {
                    sb.append("NULL");
                }
                return sb.append(')').toString();
            }

            @Override
            public boolean isOffHeapMethod() {
                return true;
            }
        }
        ,
        setTraceFlag{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) {
                String traceFlag = (String)params[0];
                Boolean on = (Boolean)params[1];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: setting DEBUG traceFlag '" + traceFlag + "' to " + on));
                if ("DistributionManager.VERBOSE".equals(traceFlag)) {
                    DistributionManager.VERBOSE = on;
                } else if (on.booleanValue()) {
                    SanityManager.DEBUG_SET((String)traceFlag);
                } else {
                    SanityManager.DEBUG_CLEAR((String)traceFlag);
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[]{InternalDataSerializer.readString((DataInput)in), in.readBoolean()};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
                out.writeBoolean((Boolean)params[1]);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.SET_TRACE_FLAG('").append(params[0]).append("',").append((Boolean)params[1] != false ? (char)'1' : '0').append(')').toString();
            }
        }
        ,
        waitForSenderQueueFlush{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isAccessorOrStore();
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) {
                String id = (String)params[0];
                Boolean isAsyncListener = (Boolean)params[1];
                Integer maxWaitTime = (Integer)params[2];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: waiting for sender queue flush for id=" + id + ", isAsyncListener=" + isAsyncListener + ", maxWaitTime=" + maxWaitTime));
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache != null) {
                    try {
                        int elapsed = cache.waitForSenderQueueFlush(id, isAsyncListener.booleanValue(), maxWaitTime.intValue());
                        if (elapsed >= 0) {
                            params[2] = elapsed;
                        }
                    }
                    catch (CancelException cancelException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[]{InternalDataSerializer.readString((DataInput)in), in.readBoolean(), in.readInt()};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
                out.writeBoolean((Boolean)params[1]);
                out.writeInt((Integer)params[2]);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.WAIT_FOR_ASYNC_QUEUE_FLUSH('").append(params[0]).append("',").append((Boolean)params[1] != false ? (char)'1' : '0').append(',').append(params[2]).append(')').toString();
            }
        }
        ,
        setLogLevel{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                try {
                    String logClass = (String)params[0];
                    Level level = Level.toLevel((String)((String)params[1]));
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: setting log level for class '" + logClass + "' to " + level));
                    if (logClass.equals("")) {
                        LogManager.getRootLogger().setLevel(level);
                        LogWriter logger = Misc.getCacheLogWriterNoThrow();
                        if (logger instanceof GFToSlf4jBridge) {
                            ((GFToSlf4jBridge)logger).setLevelForLog4jLevel(level);
                        }
                    } else {
                        LogManager.getLogger((String)logClass).setLevel(level);
                    }
                }
                catch (Exception e) {
                    throw StandardException.newException("X0Z27.S", (Throwable)e, (Object)e.getMessage());
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[]{InternalDataSerializer.readString((DataInput)in), InternalDataSerializer.readString((DataInput)in)};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
                InternalDataSerializer.writeString((String)((String)params[1]), (DataOutput)out);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.SET_LOG_LEVEL('").append(params[0]).append("', '").append(params[1]).append("')").toString();
            }
        }
        ,
        setGatewayFKChecks{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isAccessorOrStore();
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) {
                Boolean flag = (Boolean)params[0];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: Setting Gateway FK Checks to " + flag));
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache != null) {
                    cache.setSkipFKChecksForGatewayEvents(flag == false);
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[3];
                inParams[0] = InternalDataSerializer.readBoolean((DataInput)in);
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeBoolean((Boolean)((Boolean)params[0]), (DataOutput)out);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.SET_GATEWAY_FK_CHECKS(").append(params[0]).append(')').toString();
            }
        }
        ,
        incrementTableVersion{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isAccessorOrStore();
            }

            @Override
            boolean initConnection() {
                return true;
            }

            @Override
            boolean preprocess() {
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                String schemaName = (String)params[0];
                String tableName = (String)params[1];
                Integer increment = (Integer)params[2];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: incrementing table version for [" + schemaName + '.' + tableName + "] by " + increment));
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                if (lcc == null) {
                    throw StandardException.newException("08003");
                }
                GemFireContainer container = GemFireXDUtils.getGemFireContainer(schemaName, tableName, lcc);
                if (container == null) {
                    throw StandardException.newException("42X05", Misc.getFullTableName(schemaName, tableName, lcc));
                }
                ExtraTableInfo tableInfo = container.getExtraTableInfo();
                container.schemaVersionChange(lcc.getDataDictionary(), tableInfo.getTableDescriptor(), lcc);
                container.getExtraTableInfo().refreshCachedInfo(null, container);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[]{InternalDataSerializer.readString((DataInput)in), InternalDataSerializer.readString((DataInput)in), in.readInt()};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
                InternalDataSerializer.writeString((String)((String)params[1]), (DataOutput)out);
                out.writeInt((Integer)params[2]);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.INCREMENT_TABLE_VERSION('").append(params[0]).append("','").append(params[1]).append("',").append(params[2]).append(')').toString();
            }
        }
        ,
        diskStoreFsync{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isStore();
            }

            @Override
            boolean preprocess() {
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                String diskStoreName = (String)params[0];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: fsyncing diskstore " + diskStoreName));
                GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
                if (diskStoreName != null) {
                    DiskStoreImpl diskStore = cache.findDiskStore(diskStoreName);
                    if (diskStore == null && (diskStore = cache.findDiskStore(SharedUtils.SQLToUpperCase((String)diskStoreName))) == null) {
                        throw StandardException.newException("42Y55", (Object)"FSYNC DISKSTORE", (Object)diskStoreName);
                    }
                    diskStore.flushAndSync();
                } else {
                    for (DiskStoreImpl diskStore : cache.listDiskStoresIncludingRegionOwned()) {
                        diskStore.flushAndSync();
                    }
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[]{InternalDataSerializer.readString((DataInput)in)};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.DISKSTORE_FSYNC('").append(params[0]).append("')").toString();
            }
        }
        ,
        setStatementStats{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isAccessorOrStore();
            }

            @Override
            boolean initConnection() {
                return false;
            }

            @Override
            boolean preprocess() {
                return false;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                final Boolean enableStats = (Boolean)params[0];
                final Boolean enableTimeStats = (Boolean)params[1];
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("GfxdSystemProcedure: Switching " + (enableStats != false ? "On" : "Off") + " statement statistics collection globally with timeStats=" + enableTimeStats + '.'));
                PropertyUtil.setSystemProperty(GfxdConstants.GFXD_ENABLE_STATS, enableStats.toString());
                PropertyUtil.setSystemProperty(GfxdConstants.GFXD_ENABLE_TIMESTATS, enableTimeStats.toString());
                GemFireXDUtils.Visitor<LanguageConnectionContext> setStats = new GemFireXDUtils.Visitor<LanguageConnectionContext>(){

                    @Override
                    public boolean visit(LanguageConnectionContext lcc) {
                        lcc.setStatsEnabled(enableStats, enableTimeStats, lcc.explainConnection());
                        return true;
                    }
                };
                GemFireXDUtils.forAllContexts(setStats);
                if (enableTimeStats.booleanValue()) {
                    DistributionStats.enableClockStats = true;
                    CachePerfStats.enableClockStats = true;
                    ConnectionStats.setClockStats(true, false);
                } else {
                    boolean timeStatsEnabled;
                    DistributionStats.enableClockStats = timeStatsEnabled = Misc.getDistributedSystem().getConfig().getEnableTimeStatistics();
                    CachePerfStats.enableClockStats = timeStatsEnabled;
                    ConnectionStats.setClockStats(timeStatsEnabled, false);
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[3];
                inParams[0] = in.readBoolean();
                inParams[1] = in.readBoolean();
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                out.writeBoolean((Boolean)params[0]);
                out.writeBoolean((Boolean)params[1]);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.SET_GLOBAL_STATEMENT_STATISTICS(").append(params[0] == Boolean.TRUE ? 1 : 0).append(',').append(params[1] == Boolean.TRUE ? 1 : 0).append(')').toString();
            }
        }
        ,
        dumpStacks{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) {
                Object user = params[0];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: dumping thread stacks/locks invoked by " + user));
                GemFireXDUtils.dumpStacks(Misc.getMemStoreBooting(), "SYS.DUMP_STACKS invoked by " + user);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException, ClassNotFoundException {
                return new Object[]{DataSerializer.readObject((DataInput)in)};
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                DataSerializer.writeObject((Object)params[0], (DataOutput)out);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                return "CALL SYS.DUMP_STACKS(1)";
            }
        }
        ,
        forceHDFSWriteonlyFileRollover{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isStore();
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                String regionPath = Misc.getRegionPath((String)params[0]);
                Integer minSizeForFileRollover = (Integer)params[1];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage: waiting for file rollover for HDFS table " + params[0] + ", minSizeForFileRollover=" + minSizeForFileRollover));
                try {
                    HDFSRegionDirector.getInstance().closeWritersForRegion(regionPath, minSizeForFileRollover.intValue());
                }
                catch (IOException e) {
                    throw StandardException.newException("X0Z30.S", (Throwable)e, (Object)e.getMessage());
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException {
                Object[] inParams = new Object[3];
                inParams[0] = InternalDataSerializer.readString((DataInput)in);
                inParams[1] = in.readInt();
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
                out.writeInt((Integer)params[1]);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('").append(params[0]).append("',").append(params[1]).append(')').toString();
            }
        }
        ,
        setNanoTimerType{

            @Override
            boolean allowExecution(Object[] params) {
                return true;
            }

            @Override
            public void processMessage(Object[] params, DistributedMember sender) {
                Boolean useNativeTimer = (Boolean)params[0];
                String nativeTimerType = (String)params[1];
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:SET_NANOTIMER_TYPE native timer: " + useNativeTimer + " NativeTimerType: " + nativeTimerType));
                NanoTimer.setNativeTimer((boolean)useNativeTimer, (String)nativeTimerType);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException, ClassNotFoundException {
                Object[] inParams = new Object[]{in.readBoolean(), in.readUTF()};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                out.writeBoolean((Boolean)params[0]);
                out.writeUTF((String)params[1]);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.SET_NANOTIMER_TYPE('").append(params[0]).append("','").append(params[1]).append("')").toString();
            }
        }
        ,
        checkTableEx{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isStore();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                EmbedConnection conn;
                block10: {
                    LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                    if (lcc != null) {
                        this.executeCheckTable(params);
                        return;
                    }
                    conn = null;
                    StatementContext statementContext = null;
                    boolean popContext = false;
                    Throwable t = null;
                    try {
                        conn = GemFireXDUtils.getTSSConnection(true, true, true);
                        conn.getTR().setupContextStack();
                        Object object = conn.getConnectionSynchronization();
                        synchronized (object) {
                            lcc = conn.getLanguageConnectionContext();
                            lcc.pushMe();
                            popContext = true;
                            assert (ContextService.getContextOrNull("LanguageConnectionContext") != null);
                            statementContext = lcc.pushStatementContext(false, false, this.name(), null, false, 0L);
                            statementContext.setSQLAllowed((short)0, true);
                            this.executeCheckTable(params);
                        }
                        if (statementContext != null) {
                            lcc.popStatementContext(statementContext, t);
                        }
                        if (lcc == null || !popContext) break block10;
                    }
                    catch (Throwable throwable) {
                        if (statementContext != null) {
                            lcc.popStatementContext(statementContext, t);
                        }
                        if (lcc != null && popContext) {
                            lcc.popMe();
                        }
                        if (conn == null) throw throwable;
                        conn.getTR().restoreContextStack();
                        throw throwable;
                    }
                    lcc.popMe();
                }
                if (conn == null) return;
                conn.getTR().restoreContextStack();
            }

            private void executeCheckTable(Object[] params) throws StandardException {
                try {
                    String schema = (String)params[0];
                    String table = (String)params[1];
                    DistributedMember targetNode = (DistributedMember)params[2];
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("GfxdSystemProcedureMessage:CHECK_TABLE_EX schema: " + schema + " table: " + table + " target node to verify global index size:" + targetNode));
                    SystemProcedures.CHECK_TABLE(schema, table);
                    if (Misc.getMyId().equals((Object)targetNode)) {
                        this.verifyGlobalIndexSizes(params);
                    }
                }
                catch (SQLException sq) {
                    throw StandardException.unexpectedUserException(sq);
                }
            }

            private void verifyGlobalIndexSizes(Object[] params) throws StandardException {
                List<GemFireContainer> indexContainers;
                String schema = (String)params[0];
                String table = (String)params[1];
                LocalRegion region = (LocalRegion)Misc.getRegionForTable(schema + "." + table, true);
                GfxdIndexManager indexManager = (GfxdIndexManager)region.getIndexUpdater();
                if (indexManager != null && (indexContainers = indexManager.getIndexContainers()) != null) {
                    for (GemFireContainer indexContainer : indexContainers) {
                        int numIndexEntries;
                        int numTableEntries;
                        if (!indexContainer.isGlobalIndex() || (numTableEntries = region.size()) == (numIndexEntries = indexContainer.getRegion().size())) continue;
                        throw StandardException.newException("X0Y55.S", indexContainer.getName(), (Object)schema, (Object)table, (Object)numIndexEntries, (Object)numTableEntries);
                    }
                }
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException, ClassNotFoundException {
                Object[] inParams = new Object[]{in.readUTF(), in.readUTF(), InternalDataSerializer.readObject((DataInput)in)};
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                out.writeUTF((String)params[0]);
                out.writeUTF((String)params[1]);
                InternalDataSerializer.writeObject((Object)params[2], (DataOutput)out);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("VALUES SYS.CHECK_TABLE_EX('").append(params[0]).append("','").append(params[1]).append("')").toString();
            }
        }
        ,
        refreshLdapGroup{

            @Override
            boolean allowExecution(Object[] params) {
                return GemFireXDUtils.getMyVMKind().isAccessorOrStore();
            }

            @Override
            boolean initConnection() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processMessage(Object[] params, DistributedMember sender) throws StandardException {
                boolean disableLogging;
                String ldapGroup = (String)params[0];
                Set currentMembers = (Set)params[1];
                if (GemFireXDUtils.TraceSysProcedures) {
                    SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("refreshing LDAP group '" + ldapGroup + "' for all tables"));
                }
                ArrayList groupDescs = new ArrayList();
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                TransactionController tc = lcc.getTransactionExecute();
                boolean bl = disableLogging = !tc.needLogging();
                if (disableLogging) {
                    tc.enableLogging();
                }
                try {
                    DataDictionary dd = lcc.getDataDictionary();
                    dd.getAllLDAPDescriptorsHavingPermissions(ldapGroup, 16, 12, tc, groupDescs);
                    dd.getAllLDAPDescriptorsHavingPermissions(ldapGroup, 18, 6, tc, groupDescs);
                    HashSet<String> removedMembers = new HashSet<String>(groupDescs.size());
                    HashSet<PermissionsDescriptor> groupPermissions = new HashSet<PermissionsDescriptor>();
                    for (PermissionsDescriptor desc : groupDescs) {
                        String grantee = desc.getGrantee();
                        if (grantee.startsWith("LDAPGROUP:")) {
                            groupPermissions.add(desc);
                            continue;
                        }
                        if (currentMembers.contains(grantee)) continue;
                        removedMembers.add(grantee);
                    }
                    for (PermissionsDescriptor desc : groupDescs) {
                        currentMembers.remove(desc.getGrantee());
                    }
                    if (currentMembers.size() > 0 || removedMembers.size() > 0) {
                        ArrayList<String> newMembers = null;
                        ArrayList<String> oldMembers = null;
                        if (currentMembers.size() > 0) {
                            newMembers = new ArrayList<String>(currentMembers.size());
                            for (Object e : currentMembers) {
                                newMembers.add(ldapGroup + ':' + e);
                            }
                        }
                        if (removedMembers.size() > 0) {
                            oldMembers = new ArrayList<String>(removedMembers.size());
                            for (Object e : removedMembers) {
                                oldMembers.add(ldapGroup + ':' + e);
                            }
                        }
                        ConstantActionActivation act = new ConstantActionActivation();
                        act.initFromContext(lcc, false, null);
                        for (PermissionsDescriptor perm : groupPermissions) {
                            if (perm instanceof TablePermsDescriptor) {
                                if (newMembers != null) {
                                    this.grantRevokeGroupMember((TablePermsDescriptor)perm, newMembers, ldapGroup, true, act, dd);
                                }
                                if (oldMembers == null) continue;
                                this.grantRevokeGroupMember((TablePermsDescriptor)perm, oldMembers, ldapGroup, false, act, dd);
                                continue;
                            }
                            RoutinePermsDescriptor routinePerm = (RoutinePermsDescriptor)perm;
                            RoutinePrivilegeInfo privileges = new RoutinePrivilegeInfo(dd.getAliasDescriptor(routinePerm.getRoutineUUID()));
                            if (newMembers != null) {
                                privileges.executeGrantRevoke(act, true, newMembers);
                            }
                            if (oldMembers == null) continue;
                            privileges.executeGrantRevoke(act, false, oldMembers);
                        }
                    }
                }
                finally {
                    tc.commit();
                    GfxdDistributionAdvisor.GfxdProfile profile = GemFireXDUtils.getGfxdProfile((DistributedMember)Misc.getMyId());
                    if (profile != null && profile.hasSparkURL()) {
                        CallbackFactoryProvider.getStoreCallbacks().clearSessionCache(true);
                        CallbackFactoryProvider.getStoreCallbacks().refreshPolicies(ldapGroup);
                    }
                    if (disableLogging) {
                        tc.disableLogging();
                    }
                }
            }

            private void grantRevokeGroupMember(TablePermsDescriptor groupPerm, List<?> grantees, String ldapGroup, boolean grant, ConstantActionActivation activation, DataDictionary dd) throws StandardException {
                UUID tableUUID = groupPerm.getTableUUID();
                TableDescriptor td = dd.getTableDescriptor(tableUUID);
                String ldapGroupFull = "LDAPGROUP:" + ldapGroup;
                boolean[] actionAllowed = new boolean[7];
                FormatableBitSet[] columnBitSets = new FormatableBitSet[7];
                actionAllowed[0] = this.isAllowed(groupPerm.getSelectPriv());
                actionAllowed[2] = this.isAllowed(groupPerm.getInsertPriv());
                actionAllowed[3] = this.isAllowed(groupPerm.getUpdatePriv());
                actionAllowed[1] = this.isAllowed(groupPerm.getDeletePriv());
                actionAllowed[4] = this.isAllowed(groupPerm.getReferencesPriv());
                actionAllowed[5] = this.isAllowed(groupPerm.getTriggerPriv());
                actionAllowed[6] = this.isAllowed(groupPerm.getAlterPriv());
                for (int[] actions : tableActions) {
                    ColPermsDescriptor colDesc = dd.getColumnPermissions(tableUUID, actions[1], false, ldapGroupFull);
                    if (colDesc == null) continue;
                    columnBitSets[actions[0]] = colDesc.getColumns();
                }
                TablePrivilegeInfo privileges = new TablePrivilegeInfo(td, actionAllowed, columnBitSets, null);
                privileges.executeGrantRevoke(activation, grant, grantees);
            }

            private boolean isAllowed(String privilege) {
                return "y".equalsIgnoreCase(privilege);
            }

            @Override
            public Object[] readParams(DataInput in, short flags) throws IOException, ClassNotFoundException {
                int numPrms = InternalDataSerializer.readArrayLength((DataInput)in);
                assert (numPrms == 2);
                Object[] inParams = new Object[numPrms];
                inParams[0] = InternalDataSerializer.readString((DataInput)in);
                inParams[1] = InternalDataSerializer.readSet((DataInput)in);
                return inParams;
            }

            @Override
            public void writeParams(Object[] params, DataOutput out) throws IOException {
                assert (params != null && params.length == 2);
                InternalDataSerializer.writeArrayLength((int)params.length, (DataOutput)out);
                InternalDataSerializer.writeString((String)((String)params[0]), (DataOutput)out);
                InternalDataSerializer.writeSet((Collection)((Set)params[1]), (DataOutput)out);
            }

            @Override
            String getSQLStatement(Object[] params) throws StandardException {
                StringBuilder sb = new StringBuilder();
                return sb.append("CALL SYS.REFRESH_LDAP_GROUP('").append(params[0]).append("')").toString();
            }
        };

        static final int[][] tableActions;
        static final Object[] NOT_MERGED;

        boolean allowExecution(Object[] params) throws StandardException {
            return GemFireXDUtils.getMyVMKind().isAccessorOrStore();
        }

        public abstract void processMessage(Object[] var1, DistributedMember var2) throws StandardException;

        abstract Object[] readParams(DataInput var1, short var2) throws IOException, ClassNotFoundException;

        abstract void writeParams(Object[] var1, DataOutput var2) throws IOException;

        static String getCreateUserStatement(String user, String password) throws StandardException {
            StringBuilder sb = new StringBuilder();
            sb.append("CALL SYS.CREATE_USER('").append(user).append("',");
            if (password != null) {
                sb.append('\'').append(password).append('\'');
            } else {
                sb.append("NULL");
            }
            return sb.append(')').toString();
        }

        short computeFlags(short flags, Object[] params) {
            return flags;
        }

        boolean initConnection() {
            return false;
        }

        public boolean isOffHeapMethod() {
            return false;
        }

        boolean shouldBeMerged(Object[] params) {
            return false;
        }

        Object[] merge(Object[] params, SysProcMethod existingMethod, Object[] existingMethodParams) {
            throw new AssertionError((Object)"not expected to be invoked");
        }

        boolean shouldBeConflated(Object[] params) {
            return false;
        }

        String getRegionToConflate(Object[] params) {
            return null;
        }

        Object getKeyToConflate(Object[] params) {
            return null;
        }

        boolean preprocess() {
            return true;
        }

        abstract String getSQLStatement(Object[] var1) throws StandardException;

        void appendParams(Object[] params, StringBuilder sb) {
            if (params != null) {
                sb.append("; params ");
                for (Object prm : params) {
                    sb.append('[');
                    sb.append(prm);
                    sb.append("] ");
                }
            }
        }

        static {
            tableActions = new int[][]{{0, 0}, {2, 3}, {3, 1}, {1, 4}, {4, 2}, {5, 5}, {6, 7}};
            NOT_MERGED = new Object[0];
        }
    }
}

