/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.RegionQueueException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gnu.trove.TLongHashSet;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.internal.engine.GfxdOpConflationHandler;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLPreprocess;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLQueueEntry;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegion;
import com.pivotal.gemfirexd.internal.engine.ddl.ReplayableConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdReentrantReadWriteLock;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateSchemaConstantAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class GfxdDDLRegionQueue
implements RegionQueue {
    private final GfxdDDLRegion region;
    private final String regionName;
    private final SortedSet<QueueValue> queue;
    private final TLongHashSet queueTracker;
    private long queueSequenceId;
    private final GfxdReadWriteLock queueLock;
    private final GfxdOpConflationHandler<QueueValue> conflationHandler;
    private volatile boolean initialized;
    private boolean cleared;

    public GfxdDDLRegionQueue(String regionName, GemFireCacheImpl cache, boolean persistDD, String persistentDir, CacheListener<Long, GfxdDDLRegion.RegionValue> listener) {
        this.regionName = regionName;
        this.queue = new TreeSet<QueueValue>();
        this.queueTracker = new TLongHashSet();
        this.queueSequenceId = 1L;
        this.queueLock = new GfxdReentrantReadWriteLock("GfxdDDLRegionQueue", false);
        this.conflationHandler = new GfxdOpConflationHandler();
        this.initialized = false;
        this.cleared = false;
        try {
            this.region = GfxdDDLRegion.createInstance(this, cache, this.regionName, listener, persistDD, persistentDir);
        }
        catch (IOException e) {
            throw new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString(), (Throwable)e);
        }
    }

    public GfxdDDLRegionQueue(GfxdDDLRegion region) {
        this.region = region;
        this.regionName = region.getName();
        this.queue = new TreeSet<QueueValue>();
        this.queueTracker = new TLongHashSet();
        this.queueSequenceId = 1L;
        this.queueLock = new GfxdReentrantReadWriteLock("GfxdDDLRegionQueue", false);
        this.conflationHandler = new GfxdOpConflationHandler();
        this.initialized = false;
        this.cleared = false;
    }

    public void initializeQueue(GfxdDataDictionary dd) {
        this.initializeQueue(dd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeQueue(GfxdDataDictionary dd, boolean takeLock) {
        List<QueueValue> removeList;
        if (takeLock) {
            dd.lockForReadingInDDLReplay(Misc.getMemStoreBooting());
        }
        try {
            this.lockQueue(true);
        }
        finally {
            if (takeLock) {
                dd.unlockAfterReading(null);
            }
        }
        this.conflationHandler.setLogPrefix(this.toString());
        try {
            removeList = this.populateQueue();
            this.initialized = true;
        }
        finally {
            this.unlockQueue(true);
        }
        this.region.doConflate(removeList, "INITQUEUE");
    }

    private List<QueueValue> populateQueue() {
        for (Object entry : this.region.entrySet()) {
            Object key;
            Region.Entry rEntry = (Region.Entry)entry;
            if (rEntry.isDestroyed() || !((key = rEntry.getKey()) instanceof Long)) continue;
            this.addToQueue(new QueueValue((Long)key, (GfxdDDLRegion.RegionValue)rEntry.getValue()), false, null);
        }
        ArrayList<QueueValue> removeList = new ArrayList<QueueValue>();
        for (QueueValue qEntry : this.queue) {
            this.doConflate(qEntry, removeList, null, false);
        }
        for (QueueValue qEntry : removeList) {
            this.queue.remove(qEntry);
        }
        return removeList;
    }

    boolean addToQueue(QueueValue qValue, boolean conflate, List<QueueValue> conflatedItems) {
        long itemId;
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": trying to add entry in queue [" + qValue + "]"));
        }
        if (!this.queueTracker.contains(itemId = qValue.getKey().longValue())) {
            long sequenceId = ((QueueValue)qValue).regValue.sequenceId;
            if (sequenceId <= 0L) {
                ((QueueValue)qValue).regValue.sequenceId = this.queueSequenceId++;
                sequenceId = ((QueueValue)qValue).regValue.sequenceId;
            } else if (sequenceId >= this.queueSequenceId) {
                this.queueSequenceId = sequenceId + 1L;
            }
            if (conflate && this.doConflate(qValue, conflatedItems, this.queue, true)) {
                return true;
            }
            this.queue.add(qValue);
            this.queueTracker.add(itemId);
            if (GemFireXDUtils.TraceDDLQueue) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": added entry in queue [" + qValue + "]"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean conflate(Conflatable confVal, Object confValEntry, boolean removeFromQueue, List<QueueValue> conflatedItems) {
        if (confVal.getRegionToConflate() != null) {
            this.lockQueue(true);
            try {
                boolean bl = this.conflationHandler.applyConflate(confVal, confVal.getKeyToConflate(), confValEntry, conflatedItems, null, removeFromQueue ? this.queue : null, false, false);
                return bl;
            }
            finally {
                this.unlockQueue(true);
            }
        }
        return false;
    }

    private boolean doConflate(QueueValue qValue, List<QueueValue> conflatedItems, SortedSet<QueueValue> queue, boolean skipExecuting) {
        Conflatable confVal;
        Object val = qValue.getValue();
        if (val instanceof Conflatable && (confVal = (Conflatable)val).getRegionToConflate() != null) {
            if (this.conflationHandler.doConflate(confVal, confVal.getKeyToConflate(), qValue, conflatedItems, queue, true, skipExecuting)) {
                return true;
            }
            if (GemFireXDUtils.TraceConflation) {
                SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)(this.toString() + ": adding conflatable entry " + qValue + " with region=" + confVal.getRegionToConflate() + " key=" + confVal.getKeyToConflate() + " value=" + confVal.getValueToConflate()));
            }
            this.conflationHandler.addToConflationIndex(confVal, qValue);
        }
        return false;
    }

    boolean removeFromQueue(QueueValue val) {
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": removing entry from queue: " + val));
        }
        if (this.queueTracker.remove(val.getKey().longValue())) {
            if (val.getValue() instanceof Conflatable) {
                this.conflationHandler.removeFromConflationIndex((Conflatable)val.getValue());
            }
            this.queue.remove(val);
            this.queueSequenceId = this.queue.size() > 0 ? ((QueueValue)this.queue.last()).regValue.sequenceId + 1L : 1L;
            return true;
        }
        return false;
    }

    public void put(Object object) throws InterruptedException, CacheException {
        long uuid = this.newUUID();
        this.put(uuid, object);
    }

    public final long newUUID() throws IllegalStateException {
        return this.region.newUUID(true);
    }

    public long put(Long key, Object object) throws InterruptedException, CacheException {
        return this.put(key, -1L, object, true, false);
    }

    public long put(Long key, long sequenceId, Object object, boolean conflate, boolean localPut) throws InterruptedException, CacheException {
        QueueValue qValue = new QueueValue(key, new GfxdDDLRegion.RegionValue(object, sequenceId));
        EntryEventImpl event = this.region.newUpdateEntryEvent(key, qValue.regValue, null);
        if (localPut) {
            event.setSkipDistributionOps();
        }
        if (conflate) {
            ArrayList<QueueValue> conflatedItems = new ArrayList<QueueValue>(4);
            this.putInQueue(qValue, true, conflatedItems);
            this.region.validatedPut(event, CachePerfStats.getStatTime());
            this.region.doConflate(conflatedItems, qValue);
        } else {
            this.putInQueue(qValue, false, null);
            this.region.validatedPut(event, CachePerfStats.getStatTime());
        }
        return ((QueueValue)qValue).regValue.sequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putInQueue(QueueValue qValue, boolean conflate, List<QueueValue> conflatedItems) throws InterruptedException, EntryExistsException {
        this.lockQueue(true);
        try {
            if (!this.addToQueue(qValue, conflate, conflatedItems)) {
                if (!Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
                    throw new InternalGemFireError("expected to add " + qValue + " to queue");
                }
                throw new EntryExistsException("expected to add " + qValue + " to queue", (Object)qValue);
            }
        }
        finally {
            this.unlockQueue(true);
        }
        return true;
    }

    public GfxdDDLQueueEntry peek() throws CacheException {
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Peeking an object"));
        }
        this.lockQueue(false);
        try {
            if (this.isCleared()) {
                throw new RegionQueueException(this.toString() + ": queue has been cleared.");
            }
            if (!this.queue.isEmpty()) {
                QueueValue qValue = this.queue.first();
                if (GemFireXDUtils.TraceDDLQueue) {
                    SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Peeked object -> " + qValue));
                }
                QueueValue queueValue = qValue;
                return queueValue;
            }
        }
        finally {
            this.unlockQueue(false);
        }
        return null;
    }

    public List<GfxdDDLQueueEntry> peek(int batchSize) throws InterruptedException, CacheException {
        return this.peekOrTake(null, batchSize, -1, false, false);
    }

    public List<GfxdDDLQueueEntry> peek(int batchSize, int timeToWait) throws InterruptedException, CacheException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<GfxdDDLQueueEntry> peekAndRemoveFromQueue(int batchSize, int timeToWait) throws InterruptedException, CacheException {
        return this.peekOrTake(null, batchSize, timeToWait, true, false);
    }

    public GfxdDDLQueueEntry take() throws CacheException {
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Taking an object"));
        }
        QueueValue qValue = null;
        this.lockQueue(true);
        try {
            if (!this.queue.isEmpty() && !this.removeFromQueue(qValue = this.queue.last())) {
                throw new AssertionError((Object)("expected to remove element [" + qValue + "] from queue"));
            }
        }
        finally {
            this.unlockQueue(true);
        }
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Took object -> " + qValue));
        }
        if (qValue != null) {
            try {
                this.region.destroy(qValue.key);
            }
            catch (Exception ex) {
                SanityManager.DEBUG_PRINT((String)"warning:TraceDDLQueue", (String)(this.toString() + " unexpected exception in take"), (Throwable)ex);
            }
            if (GemFireXDUtils.TraceDDLQueue) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Destroyed entry " + qValue));
            }
        }
        return qValue;
    }

    public List<GfxdDDLQueueEntry> take(int batchSize) throws CacheException, InterruptedException {
        return this.peekOrTake(null, batchSize, -1, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GfxdDDLQueueEntry> peekOrTake(GfxdDDLQueueEntry startEntry, int batchSize, int timeToWait, boolean take, boolean destroyFromRegion) throws CacheException {
        assert (startEntry == null || startEntry instanceof QueueValue) : "did  not expect startEntry of type " + startEntry.getClass();
        int origBatchSize = batchSize;
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": " + (take ? "Taking " : "Peeking ") + batchSize + " objects starting from entry " + startEntry));
        }
        LinkedList<GfxdDDLQueueEntry> entries = new LinkedList<GfxdDDLQueueEntry>();
        this.lockQueue(take);
        try {
            if (!take && this.isCleared()) {
                throw new RegionQueueException(this.toString() + ": queue has been cleared.");
            }
            QueueValue startValue = (QueueValue)startEntry;
            SortedSet<QueueValue> peekSet = startValue != null ? this.queue.tailSet(startValue) : this.queue;
            for (QueueValue qValue : peekSet) {
                if (startValue != null && startValue.key.longValue() == qValue.key.longValue()) continue;
                if (batchSize-- == 0) break;
                entries.add(qValue);
                if (!GemFireXDUtils.TraceDDLQueue) continue;
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": " + (take ? "Took" : "Peeked") + " object -> " + qValue));
            }
            if (take) {
                for (Object e : entries) {
                    QueueValue qValue = (QueueValue)e;
                    boolean removed = destroyFromRegion ? this.removeFromQueue(qValue) : this.queue.remove(e);
                    if (removed) continue;
                    throw new InternalGemFireError("expected to remove element [" + e + "] from queue");
                }
            }
        }
        finally {
            this.unlockQueue(take);
        }
        if (destroyFromRegion) {
            for (GfxdDDLQueueEntry entry : entries) {
                try {
                    this.region.destroy(entry.getKey());
                }
                catch (Exception ex) {
                    SanityManager.DEBUG_PRINT((String)"warning:TraceDDLQueue", (String)(this.toString() + " unexpected exception in peekOrTake"), (Throwable)ex);
                }
                if (!GemFireXDUtils.TraceDDLQueue) continue;
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Destroyed entry " + entry));
            }
        }
        assert (origBatchSize < 0 || entries.size() <= origBatchSize) : "expected to retrieve at most " + origBatchSize + " elements but got " + entries.size() + ": " + entries;
        return entries;
    }

    public void remove() throws InterruptedException, CacheException {
        this.take();
    }

    public void remove(int top) throws CacheException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public GfxdDDLRegion getRegion() {
        return this.region;
    }

    public int size() {
        return this.region.size();
    }

    final void lockQueue(boolean exclusive) {
        GfxdDDLRegion.acquireLock(this.queueLock, exclusive, this.region);
    }

    final void unlockQueue(boolean exclusive) {
        GfxdDDLRegion.releaseLock(this.queueLock, exclusive);
    }

    public void addCacheListener(CacheListener listener) {
        if (this.region != null) {
            this.region.getAttributesMutator().addCacheListener(listener);
        }
    }

    public void removeCacheListener() {
        throw new UnsupportedOperationException("removing listener not allowed");
    }

    public List<GfxdDDLQueueEntry> getPreprocessedDDLQueue(List<GfxdDDLQueueEntry> currentQueue, Map<DDLConflatable, DDLConflatable> skipRegionInit, String currentSchema, TObjectIntHashMap pre11TableSchemaVer, boolean traceConflation) {
        ArrayList<GfxdDDLQueueEntry> preprocessedQueue = new ArrayList<GfxdDDLQueueEntry>();
        ListIterator<GfxdDDLQueueEntry> iter = currentQueue.listIterator();
        if (currentSchema == null) {
            currentSchema = "APP";
        }
        block0: while (iter.hasNext()) {
            ArrayList<QueueValue> conflatedItems;
            GfxdDDLPreprocess preprocessMsg;
            GfxdDDLQueueEntry entry = iter.next();
            Object qVal = entry.getValue();
            if (qVal instanceof ReplayableConflatable && ((ReplayableConflatable)qVal).skipInLocalExecution()) {
                iter.remove();
                continue;
            }
            if (qVal instanceof GfxdDDLPreprocess && (preprocessMsg = (GfxdDDLPreprocess)qVal).preprocess()) {
                Object[] params;
                String key;
                GfxdSystemProcedureMessage m;
                if (pre11TableSchemaVer != null && preprocessMsg instanceof GfxdSystemProcedureMessage && (m = (GfxdSystemProcedureMessage)qVal).getSysProcMethod() == GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty && (key = (String)(params = m.getParameters())[0]) != null && key.startsWith("PRE11_RECOVERY_SCHEMA_VERSION_")) {
                    pre11TableSchemaVer.put((Object)key.substring("PRE11_RECOVERY_SCHEMA_VERSION_".length()), Integer.parseInt((String)params[1]));
                }
                preprocessedQueue.add(entry);
                iter.remove();
                continue;
            }
            if (!(qVal instanceof DDLConflatable)) continue;
            DDLConflatable ddl = (DDLConflatable)qVal;
            if (skipRegionInit == null) {
                String newSchema = ddl.getCurrentSchema();
                if (newSchema == null) {
                    newSchema = "APP";
                }
                if (!currentSchema.equals(newSchema)) {
                    DDLConflatable schemaDDL = new DDLConflatable("SET SCHEMA " + newSchema, newSchema, new CreateSchemaConstantAction(newSchema, null), null, null, 0L, true, null);
                    QueueValue qValue = new QueueValue(0L, new GfxdDDLRegion.RegionValue(schemaDDL, 0L));
                    iter.add(qValue);
                }
                currentSchema = newSchema;
                continue;
            }
            if (!ddl.shouldDelayRegionInitialization() || !this.conflate(ddl, ddl, false, conflatedItems = new ArrayList<QueueValue>(4))) continue;
            for (QueueValue confItem : conflatedItems) {
                DDLConflatable createDDL;
                Object confVal = confItem.getValue();
                if (!(confVal instanceof DDLConflatable) || !(createDDL = (DDLConflatable)confVal).isCreateTable()) continue;
                skipRegionInit.put(createDDL, ddl);
                if (!traceConflation) continue block0;
                SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("FabricDatabase: delaying initializing [" + confVal + "] for DDL [" + ddl + ']'));
                continue block0;
            }
        }
        preprocessedQueue.addAll(currentQueue);
        return preprocessedQueue;
    }

    public String toString() {
        return "GemFireXD DDL region queue on " + this.regionName;
    }

    public void clearQueue() {
        this.lockQueue(true);
        try {
            this.queue.clear();
            this.queueTracker.clear();
            this.cleared = true;
        }
        finally {
            this.unlockQueue(true);
        }
    }

    public void close() {
        this.lockQueue(true);
        try {
            this.region.close();
            this.queue.clear();
            this.queueSequenceId = 1L;
            this.conflationHandler.close();
        }
        finally {
            this.unlockQueue(true);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    boolean isCleared() {
        return this.cleared;
    }

    public long estimateMemoryFootprint(SingleObjectSizer sizer) {
        return sizer.sizeof((Object)this) + sizer.sizeof(this.queue) + sizer.sizeof((Object)this.queueTracker) + sizer.sizeof(this.conflationHandler);
    }

    public void release() {
    }

    public static final class QueueValue
    implements GfxdDDLQueueEntry,
    Comparable<QueueValue> {
        private final Long key;
        private final GfxdDDLRegion.RegionValue regValue;

        QueueValue(Long key, GfxdDDLRegion.RegionValue value) {
            this.key = key;
            this.regValue = value;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.regValue.getValue();
        }

        @Override
        public long getSequenceId() {
            return this.regValue.sequenceId;
        }

        @Override
        public void setSequenceId(long seqId) {
            this.regValue.sequenceId = seqId;
        }

        @Override
        public int compareTo(QueueValue other) {
            long thisSeqId = this.regValue.sequenceId;
            long otherSeqId = other.regValue.sequenceId;
            return thisSeqId < otherSeqId ? -1 : (thisSeqId == otherSeqId ? this.key.compareTo(other.key) : 1);
        }

        public boolean equals(Object other) {
            if (other instanceof QueueValue) {
                return this.key.longValue() == ((QueueValue)other).key.longValue();
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return "{QueueValue: key=" + this.key + ", value=" + this.regValue + '}';
        }
    }
}

