/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.IOException;

public final class MemInsertOperation
extends MemOperation {
    private final DataValueDescriptor[] row;
    private Object regionKey;
    private final Object value;
    private Object routingObject;
    private final boolean isCacheLoaded;

    public MemInsertOperation(GemFireContainer container, DataValueDescriptor[] row, Object key, Object value, boolean isCacheLoaded) {
        super(container);
        this.row = row;
        this.regionKey = key;
        this.value = value;
        this.isCacheLoaded = isCacheLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        LanguageConnectionContext lcc = ((GemFireTransaction)xact).getLanguageConnectionContext();
        Object oldContext = null;
        if (lcc != null) {
            oldContext = lcc.getContextObject();
        }
        try {
            if (this.row != null) {
                this.regionKey = this.memcontainer.insertRow(this.row, null, null, lcc, false);
            } else {
                this.memcontainer.insert(this.regionKey, this.value, true, null, null, lcc, this.isCacheLoaded, false, false);
            }
            if (lcc != null) {
                this.routingObject = lcc.getContextObject();
            }
        }
        finally {
            if (lcc != null) {
                lcc.setContextObject(oldContext);
            }
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.regionKey != null) {
            return new MemDeleteOperation(this.memcontainer, this.regionKey, this.routingObject, true, false);
        }
        return null;
    }

    @Override
    public Object getKeyToConflate() {
        return this.regionKey;
    }

    @Override
    public Object getValueToConflate() {
        return this.value;
    }

    public Object getRegionKey() {
        return this.regionKey;
    }

    @Override
    protected StringBuilder toStringBuilder(StringBuilder sb, String regionName) {
        return sb.append(this.getClass().getName()).append(" region=").append(regionName).append(" row={").append(RowUtil.toString(this.row)).append('}');
    }
}

