/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTLongObjectHashMap;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineLOB;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EnginePreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.WrapperEngineBLOB;
import com.pivotal.gemfirexd.internal.iapi.jdbc.WrapperEngineCLOB;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.ApplicationObjectInputStream;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.xa.XAXactId;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedDatabaseMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.EmbedXAConnection;
import com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource40;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import io.snappydata.thrift.BlobChunk;
import io.snappydata.thrift.ClobChunk;
import io.snappydata.thrift.ColumnDescriptor;
import io.snappydata.thrift.ColumnValue;
import io.snappydata.thrift.ConnectionProperties;
import io.snappydata.thrift.CursorUpdateOperation;
import io.snappydata.thrift.EntityId;
import io.snappydata.thrift.OpenConnectionArgs;
import io.snappydata.thrift.OutputParameter;
import io.snappydata.thrift.PrepareResult;
import io.snappydata.thrift.Row;
import io.snappydata.thrift.RowIdLifetime;
import io.snappydata.thrift.RowSet;
import io.snappydata.thrift.ServiceFeature;
import io.snappydata.thrift.ServiceFeatureParameterized;
import io.snappydata.thrift.ServiceMetaData;
import io.snappydata.thrift.ServiceMetaDataArgs;
import io.snappydata.thrift.ServiceMetaDataCall;
import io.snappydata.thrift.SnappyDataService;
import io.snappydata.thrift.SnappyException;
import io.snappydata.thrift.SnappyExceptionData;
import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.StatementAttrs;
import io.snappydata.thrift.StatementResult;
import io.snappydata.thrift.TransactionAttribute;
import io.snappydata.thrift.TransactionXid;
import io.snappydata.thrift.UpdateResult;
import io.snappydata.thrift.common.BufferedBlob;
import io.snappydata.thrift.common.Converters;
import io.snappydata.thrift.common.ThriftUtils;
import io.snappydata.thrift.internal.ClientBlob;
import io.snappydata.thrift.server.ClientTracker;
import io.snappydata.thrift.server.ConnectionHolder;
import io.snappydata.thrift.server.LocatorServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TTransport;

public final class SnappyDataServiceImpl
extends LocatorServiceImpl
implements SnappyDataService.Iface {
    final GfxdHeapThresholdListener thresholdListener;
    final SecureRandom rand;
    final ConcurrentTLongObjectHashMap<ConnectionHolder> connectionMap;
    final ConcurrentTLongObjectHashMap<ConnectionHolder.StatementHolder> statementMap;
    final ConcurrentTLongObjectHashMap<ConnectionHolder.StatementHolder> resultSetMap;
    final ConcurrentHashMap<String, ClientTracker> clientTrackerMap;
    final ConcurrentHashMap<TTransport, ClientTracker> clientSocketTrackerMap;
    final AtomicLong currentConnectionId;
    final AtomicLong currentStatementId;
    final AtomicLong currentCursorId;
    volatile boolean recordStatementStartTime;
    static final ThreadLocal<String> currentClientHostId = new ThreadLocal();
    static final ThreadLocal<Boolean> closeClientSocket = new ThreadLocal();
    private static final int INVALID_ID = 0;
    static final Converters.ObjectInputStreamCreator javaObjectCreator = new Converters.ObjectInputStreamCreator(){

        public ObjectInputStream create(InputStream stream) throws IOException {
            return new ApplicationObjectInputStream(stream, Misc.getMemStore().getDatabase().getClassFactory());
        }
    };

    public SnappyDataServiceImpl(String address, int port) {
        super(address, port);
        GemFireStore store = Misc.getMemStoreBooting();
        this.thresholdListener = store.thresholdListener();
        this.rand = new SecureRandom();
        byte[] someBytes = new byte[55];
        this.rand.nextBytes(someBytes);
        this.connectionMap = new ConcurrentTLongObjectHashMap();
        this.statementMap = new ConcurrentTLongObjectHashMap();
        this.resultSetMap = new ConcurrentTLongObjectHashMap();
        this.clientTrackerMap = new ConcurrentHashMap();
        this.clientSocketTrackerMap = new ConcurrentHashMap();
        this.currentConnectionId = new AtomicLong(1L);
        this.currentStatementId = new AtomicLong(1L);
        this.currentCursorId = new AtomicLong(1L);
        this.recordStatementStartTime = false;
    }

    public ConnectionProperties openConnection(OpenConnectionArgs arguments) throws SnappyException {
        currentClientHostId.remove();
        try {
            ConnectionHolder connHolder;
            long connId;
            EngineConnection conn;
            EmbedXAConnection xaConn;
            String protocol;
            GemFireStore memStore;
            Properties props = new Properties();
            String clientHost = null;
            String clientId = null;
            boolean forXA = false;
            if (arguments != null) {
                if (arguments.isSetUserName()) {
                    props.put("user", arguments.getUserName());
                }
                if (arguments.isSetPassword()) {
                    props.put("password", arguments.getPassword());
                }
                if (arguments.isSetProperties()) {
                    props.putAll((Map<?, ?>)arguments.getProperties());
                }
                clientHost = arguments.getClientHostName();
                clientId = arguments.getClientID();
                boolean bl = forXA = arguments.isSetForXA() && arguments.isForXA();
            }
            if ((memStore = Misc.getMemStoreBooting()).isSnappyStore()) {
                String routeQuery = props.getProperty("route-query");
                if (routeQuery == null || routeQuery.isEmpty()) {
                    props.setProperty("route-query", "true");
                } else if (!Boolean.parseBoolean(routeQuery) && memStore.isRLSEnabled()) {
                    throw Util.generateCsSQLException("XJ112.S", null, new IllegalStateException("Row level security (snappydata.enable-rls) does not allow smart connector mode or with route-query=false"));
                }
                protocol = "jdbc:snappydata:";
            } else {
                protocol = "jdbc:gemfirexd:";
            }
            if (forXA) {
                EmbeddedXADataSource40 ds = new EmbeddedXADataSource40();
                String user = null;
                String password = null;
                if (!props.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (String key : props.stringPropertyNames()) {
                        if (key.equalsIgnoreCase("user") || key.equalsIgnoreCase("UserName")) {
                            user = props.getProperty(key);
                            continue;
                        }
                        if (key.equalsIgnoreCase("password")) {
                            password = props.getProperty(key);
                            continue;
                        }
                        if (sb.length() > 0) {
                            sb.append(';');
                        }
                        sb.append(key).append('=').append(props.getProperty(key));
                    }
                    if (sb.length() > 0) {
                        ds.setConnectionAttributes(sb.toString());
                    }
                }
                xaConn = user != null ? (EmbedXAConnection)ds.getXAConnection(user, password) : (EmbedXAConnection)ds.getXAConnection();
                conn = (EngineConnection)xaConn.getConnection();
                xaConn.checkAutoCommit(false);
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(2);
            } else {
                conn = (EngineConnection)InternalDriver.activeDriver().connect(protocol, props, Converters.getJdbcIsolation((int)0));
                conn.setAutoCommit(false);
                xaConn = null;
            }
            while (this.connectionMap.putIfAbsent(connId = SnappyDataServiceImpl.getNextId(this.currentConnectionId), (Object)(connHolder = new ConnectionHolder(conn, xaConn, arguments, connId, props, this.rand))) != null) {
            }
            ConnectionProperties connProps = new ConnectionProperties(connId, clientHost, clientId);
            connProps.setToken(connHolder.getToken());
            connProps.setDefaultSchema(conn.getCurrentSchemaName());
            String clientHostId = connHolder.getClientHostId();
            ClientTracker tracker = ClientTracker.addOrGetTracker(clientHostId, this);
            if (tracker != null) {
                tracker.addClientConnection(connId);
                currentClientHostId.set(clientHostId);
            }
            return connProps;
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void closeConnection(long connId, boolean closeSocket, ByteBuffer token) {
        block4: {
            try {
                ConnectionHolder connHolder = (ConnectionHolder)this.connectionMap.getPrimitive(connId);
                if (connHolder == null) break block4;
                if (connHolder.sameToken(token)) {
                    connHolder.close(this, false);
                    this.connectionMap.removePrimitive(connId);
                    ClientTracker tracker = ClientTracker.addOrGetTracker(connHolder.getClientHostId(), this);
                    if (tracker != null) {
                        tracker.removeClientConnection(connId);
                    }
                    closeClientSocket.set(closeSocket);
                    break block4;
                }
                throw this.tokenMismatchException(token, "closeConnection [connId=" + connId + ']');
            }
            catch (Throwable t) {
                if (this.ignoreNonFatalException(t)) break block4;
                this.logger.info("Unexpected exception in closeConnection for CONNID=" + connId, t);
            }
        }
    }

    public void bulkClose(List<EntityId> entities) {
        if (entities == null) {
            return;
        }
        for (EntityId entity : entities) {
            try {
                long id = entity.id;
                ByteBuffer token = entity.token;
                switch (entity.type) {
                    case 1: {
                        this.closeResultSet(id, token);
                        break;
                    }
                    case 2: {
                        this.freeLob(entity.connId, id, token);
                        break;
                    }
                    case 3: {
                        this.closeStatement(id, token);
                        break;
                    }
                    case 4: {
                        this.closeConnection(id, false, token);
                        break;
                    }
                }
            }
            catch (SnappyException se) {
                if (!"08004.C.1".substring(0, 5).equals(se.getExceptionData().getSqlState())) continue;
                this.logger.warn("AUTH exception in bulkClose (continuing with other close operations): " + (Object)((Object)se));
            }
            catch (Throwable t) {
                if (this.ignoreNonFatalException(t)) continue;
                this.logger.info("Unexpected exception in bulkClose (continuing with other close operations): " + t);
            }
        }
    }

    void forceCloseConnection(long connId) {
        try {
            ConnectionHolder connHolder = (ConnectionHolder)this.connectionMap.removePrimitive(connId);
            if (connHolder != null) {
                connHolder.close(this, true);
            }
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            this.logger.info("Unexpected exception in forceCloseConnection for CONNID=" + connId, t);
        }
    }

    @Override
    public void stop() {
        try {
            long[] connIds;
            for (long connId : connIds = this.connectionMap.keys()) {
                ConnectionHolder connHolder = (ConnectionHolder)this.connectionMap.removePrimitive(connId);
                if (connHolder == null) continue;
                try {
                    connHolder.close(this, true);
                }
                catch (Throwable t) {
                    this.checkSystemFailure(t);
                    this.logger.info("Unexpected exception in connection close in stop for CONNID=" + connId, t);
                }
            }
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            this.logger.info("Unexpected exception in stop", t);
        }
        super.stop();
    }

    private ConnectionHolder getValidConnection(long connId, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = (ConnectionHolder)this.connectionMap.getPrimitive(connId);
        if (connHolder != null) {
            if (connHolder.sameToken(token)) {
                return connHolder;
            }
            throw this.tokenMismatchException(token, "getConnection [connId=" + connId + ']');
        }
        SnappyExceptionData exData = new SnappyExceptionData();
        exData.setReason("No connection with ID=" + ConnectionHolder.getTokenAsString(token));
        exData.setSqlState("08003");
        exData.setErrorCode(20000);
        throw new SnappyException(exData, this.getServerInfo());
    }

    private XAResource getXAResource(ConnectionHolder connHolder) throws SQLException, XAException {
        EmbedXAConnection xaConn = connHolder.getXAConnection();
        if (xaConn != null) {
            return xaConn.getXAResource();
        }
        throw new XAException(-6);
    }

    private ConnectionHolder.StatementHolder getStatement(ByteBuffer token, long stmtId, boolean isPrepared, String op) throws SnappyException {
        ConnectionHolder.StatementHolder stmtHolder = (ConnectionHolder.StatementHolder)this.statementMap.getPrimitive(stmtId);
        if (stmtHolder != null) {
            if (stmtHolder.getConnectionHolder().sameToken(token)) {
                if (!isPrepared || stmtHolder.getStatement() instanceof PreparedStatement) {
                    return stmtHolder;
                }
                throw this.statementNotFoundException(stmtId, op, true);
            }
            throw this.tokenMismatchException(token, op);
        }
        throw this.statementNotFoundException(stmtId, op, isPrepared);
    }

    private ConnectionHolder.StatementHolder getStatementForResultSet(ByteBuffer token, long cursorId, String op) throws SnappyException {
        ConnectionHolder.StatementHolder stmtHolder = (ConnectionHolder.StatementHolder)this.resultSetMap.getPrimitive(cursorId);
        if (stmtHolder != null) {
            if (stmtHolder.getConnectionHolder().sameToken(token)) {
                return stmtHolder;
            }
            throw this.tokenMismatchException(token, op);
        }
        throw this.resultSetNotFoundException(cursorId, op);
    }

    SnappyException tokenMismatchException(ByteBuffer token, String op) {
        SnappyExceptionData exData = new SnappyExceptionData();
        String message = token != null && token.hasRemaining() ? "connection token " + ConnectionHolder.getTokenAsString(token) + " mismatch for operation " + op : "No connection token passed for operation " + op;
        exData.setReason(MessageService.getTextMessage("08004.C.1", message));
        exData.setSqlState("08004.C.1".substring(0, 5));
        exData.setErrorCode(40000);
        return new SnappyException(exData, this.getServerInfo());
    }

    SnappyException resultSetNotFoundException(long cursorId, String op) {
        SnappyExceptionData exData = new SnappyExceptionData();
        exData.setReason("No result set open with ID=" + cursorId + " for operation " + op);
        exData.setSqlState("XCL16.S.0".substring(0, 5));
        exData.setErrorCode(20000);
        return new SnappyException(exData, this.getServerInfo());
    }

    SnappyException statementNotFoundException(long stmtId, String op, boolean isPrepared) {
        SnappyExceptionData exData = new SnappyExceptionData();
        exData.setReason("No " + (isPrepared ? "prepared " : "") + "statement with ID=" + stmtId + " for operation " + op);
        exData.setSqlState("40XC0");
        exData.setErrorCode(20000);
        return new SnappyException(exData, this.getServerInfo());
    }

    @Override
    protected String getServerInfo() {
        return "Server=" + this.hostAddress + '[' + this.hostPort + "] Thread=" + Thread.currentThread().getName();
    }

    private static long getNextId(AtomicLong id) {
        long nextId;
        long currentId;
        do {
            if ((nextId = (currentId = id.get()) + 1L) != 0L) continue;
            ++nextId;
        } while (!id.compareAndSet(currentId, nextId));
        return currentId;
    }

    static int getResultType(StatementAttrs attrs) {
        int rsType = attrs != null && attrs.isSetResultSetType() ? (int)attrs.getResultSetType() : 1;
        switch (rsType) {
            case 1: {
                return 1003;
            }
            case 2: {
                return 1004;
            }
            case 3: {
                return 1005;
            }
        }
        throw new InternalGemFireError("unknown resultSet type " + attrs.getResultSetType());
    }

    static int getResultSetConcurrency(StatementAttrs attrs) {
        return attrs != null && attrs.isSetUpdatable() && attrs.isUpdatable() ? 1008 : 1007;
    }

    static int getResultSetHoldability(StatementAttrs attrs) {
        return attrs != null && attrs.isSetHoldCursorsOverCommit() && attrs.isHoldCursorsOverCommit() ? 1 : 2;
    }

    private static BlobChunk getAsLastChunk(Blob blob, int length) throws SQLException {
        if (blob instanceof BufferedBlob) {
            return ((BufferedBlob)blob).getAsLastChunk();
        }
        return new BlobChunk(ByteBuffer.wrap(blob.getBytes(1L, length)), true);
    }

    private BlobChunk handleBlob(Blob blob, ConnectionHolder connHolder, StatementAttrs attrs) throws SQLException {
        long length = blob.length();
        if (length > Integer.MAX_VALUE) {
            throw Util.generateCsSQLException("XJ093.S", (Object)Long.toString(length), Long.toString(Integer.MAX_VALUE));
        }
        BlobChunk chunk = new BlobChunk().setOffset(0L).setTotalLength(length);
        int chunkSize = attrs != null && attrs.isSetLobChunkSize() ? attrs.lobChunkSize : 0x200000;
        if (chunkSize > 0 && (long)chunkSize < length) {
            chunk.chunk = ByteBuffer.wrap(blob.getBytes(1L, chunkSize));
            chunk.setLast(false);
            long lobId = blob instanceof EngineLOB ? (long)((EngineLOB)((Object)blob)).getLocator() : (long)new WrapperEngineBLOB(connHolder.getConnection(), blob).getLocator();
            chunk.setLobId(lobId);
        } else {
            chunk = SnappyDataServiceImpl.getAsLastChunk(blob, (int)length);
            blob.free();
        }
        return chunk;
    }

    private ClobChunk handleClob(Clob clob, ConnectionHolder connHolder, StatementAttrs attrs) throws SQLException {
        long length = clob.length();
        if (length > Integer.MAX_VALUE) {
            throw Util.generateCsSQLException("XJ093.S", (Object)Long.toString(length), Long.toString(Integer.MAX_VALUE));
        }
        ClobChunk chunk = new ClobChunk().setOffset(0L).setTotalLength(length);
        int chunkSize = attrs != null && attrs.isSetLobChunkSize() ? attrs.lobChunkSize : 0x200000;
        if (chunkSize > 0 && (long)chunkSize < length) {
            chunk.setChunk(clob.getSubString(1L, chunkSize)).setLast(false);
            long lobId = clob instanceof EngineLOB ? (long)((EngineLOB)((Object)clob)).getLocator() : (long)new WrapperEngineCLOB(connHolder.getConnection(), clob).getLocator();
            chunk.setLobId(lobId);
        } else {
            chunk.setChunk(clob.getSubString(1L, (int)length)).setLast(true);
            clob.free();
        }
        return chunk;
    }

    private long setColumnValue(ResultSet rs, SnappyType colType, int columnPosition, ConnectionHolder connHolder, StatementAttrs attrs, Row result) throws SQLException {
        int index = columnPosition - 1;
        switch (colType) {
            case BOOLEAN: {
                boolean boolValue = rs.getBoolean(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setBoolean(index, boolValue);
                return 1L;
            }
            case TINYINT: {
                byte byteValue = rs.getByte(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setByte(index, byteValue);
                return 1L;
            }
            case SMALLINT: {
                short shortValue = rs.getShort(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setShort(index, shortValue);
                return 2L;
            }
            case INTEGER: {
                int intValue = rs.getInt(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setInt(index, intValue);
                return 4L;
            }
            case BIGINT: {
                long longValue = rs.getLong(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setLong(index, longValue);
                return 8L;
            }
            case FLOAT: {
                float fltValue = rs.getFloat(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setFloat(index, fltValue);
                return 4L;
            }
            case DOUBLE: {
                double dblValue = rs.getDouble(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setDouble(index, dblValue);
                return 8L;
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                String strValue = rs.getString(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setObject(index, (Object)strValue, colType);
                return (long)(ReflectionSingleObjectSizer.OBJECT_SIZE + strValue.length()) << 1;
            }
            case BLOB: {
                Blob blob = rs.getBlob(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                BlobChunk chunk = this.handleBlob(blob, connHolder, attrs);
                result.setObject(index, (Object)chunk, SnappyType.BLOB);
                return ReflectionSingleObjectSizer.OBJECT_SIZE * 3 + chunk.chunk.limit() + 12;
            }
            case CLOB: 
            case JSON: 
            case SQLXML: {
                Clob clob = rs.getClob(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                ClobChunk chunk = this.handleClob(clob, connHolder, attrs);
                result.setObject(index, (Object)chunk, colType);
                return ReflectionSingleObjectSizer.OBJECT_SIZE * 3 + chunk.chunk.length() + 12;
            }
            case DECIMAL: {
                BigDecimal bd = rs.getBigDecimal(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                if (connHolder.useStringForDecimal()) {
                    String s = bd.toPlainString();
                    result.setObject(index, (Object)s, SnappyType.VARCHAR);
                    return (long)(ReflectionSingleObjectSizer.OBJECT_SIZE + s.length()) << 1;
                }
                result.setObject(index, (Object)bd, SnappyType.DECIMAL);
                return ReflectionSingleObjectSizer.OBJECT_SIZE * 3 + (bd.precision() << 2);
            }
            case DATE: {
                java.sql.Date dtVal = rs.getDate(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setDateTime(index, (Date)dtVal);
                return 8L;
            }
            case TIME: {
                Time timeVal = rs.getTime(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setDateTime(index, (Date)timeVal);
                return 8L;
            }
            case TIMESTAMP: {
                Timestamp tsVal = rs.getTimestamp(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setTimestamp(index, tsVal);
                return 8L;
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                byte[] byteArray = rs.getBytes(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setObject(index, (Object)byteArray, colType);
                return ReflectionSingleObjectSizer.OBJECT_SIZE + byteArray.length;
            }
            case NULLTYPE: {
                result.setNull(index);
                return 1L;
            }
            case JAVA_OBJECT: {
                Object o = rs.getObject(columnPosition);
                if (rs.wasNull()) {
                    result.setNull(index);
                    return 1L;
                }
                result.setObject(index, (Object)new Converters.JavaObjectWrapper(o, columnPosition), SnappyType.JAVA_OBJECT);
                return 128L;
            }
        }
        throw Util.generateCsSQLException("0A000.S.7", Util.typeName(Converters.getJdbcType((SnappyType)colType)));
    }

    private ColumnValue getColumnValue(CallableStatement cstmt, int paramPosition, int paramType, ConnectionHolder connHolder, StatementAttrs attrs) throws SQLException {
        ColumnValue cv = new ColumnValue();
        switch (paramType) {
            case 16: {
                boolean boolValue = cstmt.getBoolean(paramPosition);
                if (boolValue || !cstmt.wasNull()) {
                    cv.setBool_val(boolValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case -6: {
                byte byteValue = cstmt.getByte(paramPosition);
                if (byteValue != 0 || !cstmt.wasNull()) {
                    cv.setByte_val(byteValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 5: {
                short shortValue = cstmt.getShort(paramPosition);
                if (shortValue != 0 || !cstmt.wasNull()) {
                    cv.setI16_val(shortValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 4: {
                int intValue = cstmt.getInt(paramPosition);
                if (intValue != 0 || !cstmt.wasNull()) {
                    cv.setI32_val(intValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case -5: {
                long longValue = cstmt.getLong(paramPosition);
                if (longValue != 0L || !cstmt.wasNull()) {
                    cv.setI64_val(longValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 7: {
                float fltValue = cstmt.getFloat(paramPosition);
                if (fltValue != 0.0f || !cstmt.wasNull()) {
                    cv.setFloat_val(Float.floatToIntBits(fltValue));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 6: 
            case 8: {
                double dblValue = cstmt.getDouble(paramPosition);
                if (dblValue != 0.0 || !cstmt.wasNull()) {
                    cv.setDouble_val(dblValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                String strValue = cstmt.getString(paramPosition);
                if (strValue != null) {
                    cv.setString_val(strValue);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 2004: {
                Blob blob = cstmt.getBlob(paramPosition);
                if (blob != null) {
                    cv.setBlob_val(this.handleBlob(blob, connHolder, attrs));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 2005: 
            case 2009: 
            case 4002: {
                Clob clob = cstmt.getClob(paramPosition);
                if (clob != null) {
                    cv.setClob_val(this.handleClob(clob, connHolder, attrs));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = cstmt.getBigDecimal(paramPosition);
                if (bd != null) {
                    if (connHolder.useStringForDecimal()) {
                        cv.setString_val(bd.toPlainString());
                        break;
                    }
                    cv.setDecimal_val(Converters.getDecimal((BigDecimal)bd));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 91: {
                java.sql.Date dtVal = cstmt.getDate(paramPosition);
                if (dtVal != null) {
                    cv.setDate_val(Converters.getDateTime((Date)dtVal));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 92: {
                Time timeVal = cstmt.getTime(paramPosition);
                if (timeVal != null) {
                    cv.setTime_val(Converters.getDateTime((Date)timeVal));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 93: {
                Timestamp tsVal = cstmt.getTimestamp(paramPosition);
                if (tsVal != null) {
                    cv.setTimestamp_val(Converters.getTimestampNanos((Timestamp)tsVal));
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byteArray = cstmt.getBytes(paramPosition);
                if (byteArray != null) {
                    cv.setBinary_val(byteArray);
                    break;
                }
                cv.setNull_val(true);
                break;
            }
            case 0: {
                cstmt.getObject(paramPosition);
                cv.setNull_val(cstmt.wasNull());
                break;
            }
            case 2000: {
                Object o = cstmt.getObject(paramPosition);
                if (o == null) {
                    cv.setNull_val(true);
                    break;
                }
                cv.setJava_val(Converters.getJavaObjectAsBytes((Object)o, (int)paramPosition));
                break;
            }
            default: {
                throw Util.generateCsSQLException("0A000.S.7", Util.typeName(paramType));
            }
        }
        return cv;
    }

    private ArrayList<ColumnDescriptor> getRowSetMetaData(ResultSetMetaData rsmd, int columnCount, boolean useStringForDecimal) throws SQLException {
        ArrayList<ColumnDescriptor> descriptors = new ArrayList<ColumnDescriptor>(columnCount);
        if (rsmd instanceof EmbedResultSetMetaData) {
            EmbedResultSetMetaData ersmd = (EmbedResultSetMetaData)rsmd;
            boolean tableReadOnly = ersmd.isTableReadOnly();
            for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
                ResultColumnDescriptor rcd = ersmd.getColumnDescriptor(colIndex);
                DataTypeDescriptor dtd = rcd.getType();
                TypeId typeId = dtd.getTypeId();
                int jdbcType = typeId.getJDBCTypeId();
                SnappyType type = Converters.getThriftSQLType((int)jdbcType, (boolean)useStringForDecimal);
                ColumnDescriptor columnDesc = new ColumnDescriptor();
                String columnName = rcd.getName();
                if (columnName != null) {
                    columnDesc.setName(columnName);
                }
                String schemaName = rcd.getSourceSchemaName();
                String tableName = rcd.getSourceTableName();
                String fullTableName = schemaName != null ? schemaName + '.' + tableName : tableName;
                columnDesc.setFullTableName(fullTableName);
                int nullable = DataTypeUtilities.isNullable(dtd);
                if (nullable == 1) {
                    columnDesc.setNullable(true);
                } else if (nullable == 0) {
                    columnDesc.setNullable(false);
                }
                if (!tableReadOnly) {
                    if (rcd.updatableByCursor()) {
                        columnDesc.setUpdatable(true);
                    }
                    if (ersmd.isDefiniteWritable_(colIndex)) {
                        columnDesc.setDefinitelyUpdatable(true);
                    }
                }
                if (rcd.isAutoincrement()) {
                    columnDesc.setAutoIncrement(true);
                }
                columnDesc.setType(type);
                columnDesc.setPrecision((short)DataTypeUtilities.getDigitPrecision(dtd));
                int scale = dtd.getScale();
                if (scale != 0) {
                    columnDesc.setScale((short)scale);
                }
                if (jdbcType == 2000) {
                    String typeName = typeId.getSQLTypeName();
                    String className = typeId.getResultSetMetaDataTypeName();
                    columnDesc.setUdtTypeAndClassName(typeName + (className != null ? ":" + className : ""));
                }
                descriptors.add(columnDesc);
            }
        } else {
            String prevSchemaName = null;
            String prevTableName = null;
            String prevTypeName = null;
            String prevClassName = null;
            for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
                String fullTableName;
                ColumnDescriptor columnDesc = new ColumnDescriptor();
                columnDesc.setName(rsmd.getColumnName(colIndex));
                String schemaName = rsmd.getSchemaName(colIndex);
                String tableName = rsmd.getTableName(colIndex);
                if (colIndex > 1) {
                    if (schemaName != null && !schemaName.equals(prevSchemaName) || tableName != null && !tableName.equals(prevTableName)) {
                        fullTableName = schemaName != null ? schemaName + '.' + tableName : tableName;
                        columnDesc.setFullTableName(fullTableName);
                    }
                } else {
                    fullTableName = schemaName != null ? schemaName + '.' + tableName : tableName;
                    columnDesc.setFullTableName(fullTableName);
                }
                prevSchemaName = schemaName;
                prevTableName = tableName;
                int nullable = rsmd.isNullable(colIndex);
                if (nullable == 1) {
                    columnDesc.setNullable(true);
                } else if (nullable == 0) {
                    columnDesc.setNullable(false);
                }
                if (rsmd.isDefinitelyWritable(colIndex)) {
                    columnDesc.setDefinitelyUpdatable(true);
                }
                if (rsmd.isWritable(colIndex)) {
                    columnDesc.setUpdatable(true);
                }
                if (rsmd.isAutoIncrement(colIndex)) {
                    columnDesc.setAutoIncrement(true);
                }
                int jdbcType = rsmd.getColumnType(colIndex);
                columnDesc.setType(Converters.getThriftSQLType((int)jdbcType, (boolean)useStringForDecimal));
                columnDesc.setPrecision((short)rsmd.getPrecision(colIndex));
                int scale = rsmd.getScale(colIndex);
                if (scale != 0) {
                    columnDesc.setScale((short)scale);
                }
                if (jdbcType == 2000) {
                    String typeName = rsmd.getColumnTypeName(colIndex);
                    String className = rsmd.getColumnClassName(colIndex);
                    if (typeName != null && !typeName.equals(prevTypeName) || className != null && !className.equals(prevClassName)) {
                        columnDesc.setUdtTypeAndClassName(typeName + (className != null ? ":" + className : ""));
                    }
                    prevTypeName = typeName;
                    prevClassName = className;
                }
                descriptors.add(columnDesc);
            }
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowSet getRowSet(Statement stmt, ConnectionHolder.StatementHolder stmtHolder, ResultSet rs, long cursorId, ConnectionHolder.ResultSetHolder holder, long connId, StatementAttrs attrs, int offset, boolean offsetIsAbsolute, boolean fetchReverse, int fetchSize, ConnectionHolder connHolder, String sql) throws SnappyException {
        boolean isLastBatch = true;
        try {
            boolean dynamicResults;
            RowSet result = SnappyDataServiceImpl.createEmptyRowSet().setConnId(connId);
            boolean isForwardOnly = rs.getType() == 1003;
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            ArrayList<ColumnDescriptor> descriptors = this.getRowSetMetaData(rsmd, columnCount, connHolder.useStringForDecimal());
            if (holder == null) {
                result.setMetadata(descriptors);
            }
            boolean moveForward = !fetchReverse && (attrs == null || !attrs.fetchReverse);
            boolean hasMoreRows = false;
            byte flags = 0;
            long startTime = 0L;
            int batchSize = fetchSize > 0 ? fetchSize : (attrs != null && attrs.isSetBatchSize() ? attrs.batchSize : 8192);
            if (offsetIsAbsolute) {
                hasMoreRows = rs.absolute(offset >= 0 ? ++offset : offset);
                if (!hasMoreRows) {
                    if (offset > 0) {
                        flags = (byte)(flags | 8);
                        if (!moveForward) {
                            hasMoreRows = rs.previous();
                        }
                    } else {
                        flags = (byte)(flags | 4);
                        if (moveForward) {
                            hasMoreRows = rs.next();
                        }
                    }
                }
                result.setOffset(Math.max(0, rs.getRow() - 1));
            } else if (offset == 0) {
                if (holder == null) {
                    result.setOffset(0);
                } else {
                    result.setOffset(holder.rsOffset);
                }
            } else {
                hasMoreRows = rs.relative(offset);
                if (!hasMoreRows) {
                    if (offset > 0) {
                        flags = (byte)(flags | 8);
                        if (!moveForward) {
                            hasMoreRows = rs.previous();
                        }
                    } else {
                        flags = (byte)(flags | 4);
                        if (moveForward) {
                            hasMoreRows = rs.next();
                        }
                    }
                }
                result.setOffset(Math.max(0, rs.getRow() - 1));
            }
            EngineConnection conn = connHolder.getConnection();
            List rows = result.getRows();
            Row templateRow = new Row(descriptors);
            EngineStatement estmt = null;
            long estimatedSize = 0L;
            int nrows = 0;
            if (rs instanceof EmbedResultSet) {
                EmbedResultSet ers = (EmbedResultSet)rs;
                estmt = (EngineStatement)stmt;
                Object object = conn.getConnectionSynchronization();
                synchronized (object) {
                    LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
                    ers.setupContextStack(false);
                    ers.pushStatementContext(lcc, true);
                    try {
                        if (offset == 0) {
                            boolean bl = hasMoreRows = moveForward ? ers.lightWeightNext() : ers.lightWeightPrevious();
                        }
                        while (hasMoreRows) {
                            Row eachRow = new Row(templateRow, true, true);
                            for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
                                estimatedSize += this.setColumnValue(ers, descriptors.get((int)(colIndex - 1)).type, colIndex, connHolder, attrs, eachRow);
                            }
                            rows.add(eachRow);
                            if (++nrows % GemFireXDUtils.DML_SAMPLE_INTERVAL == 0) {
                                if (this.throttleIfCritical()) {
                                    isLastBatch = false;
                                    break;
                                }
                                this.getCancelCriterion().checkCancelInProgress(null);
                                long currentTime = System.nanoTime();
                                if (startTime > 0L) {
                                    if (currentTime - startTime >= 1000000L * (long)GemFireXDUtils.DML_MAX_CHUNK_MILLIS) {
                                        isLastBatch = false;
                                        break;
                                    }
                                } else {
                                    startTime = currentTime;
                                }
                            }
                            if (nrows >= batchSize || estimatedSize > GemFireXDUtils.DML_MAX_CHUNK_SIZE) {
                                isLastBatch = false;
                                break;
                            }
                            hasMoreRows = moveForward ? ers.lightWeightNext() : ers.lightWeightPrevious();
                        }
                    }
                    finally {
                        StatementContext context = lcc.getStatementContext();
                        if (lcc.getStatementDepth() > 0) {
                            lcc.popStatementContext(context, null);
                        } else if (context != null && context.inUse()) {
                            context.clearInUse();
                        }
                        ers.restoreContextStack();
                    }
                }
            }
            if (offset == 0) {
                boolean bl = hasMoreRows = moveForward ? rs.next() : rs.previous();
            }
            while (hasMoreRows) {
                Row eachRow = new Row(templateRow, true, true);
                for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
                    estimatedSize += this.setColumnValue(rs, descriptors.get((int)(colIndex - 1)).type, colIndex, connHolder, attrs, eachRow);
                }
                rows.add(eachRow);
                if (++nrows % GemFireXDUtils.DML_SAMPLE_INTERVAL == 0) {
                    if (this.throttleIfCritical()) {
                        isLastBatch = false;
                        break;
                    }
                    this.getCancelCriterion().checkCancelInProgress(null);
                    long currentTime = System.nanoTime();
                    if (startTime > 0L) {
                        if (currentTime - startTime >= 1000000L * (long)GemFireXDUtils.DML_MAX_CHUNK_MILLIS) {
                            isLastBatch = false;
                            break;
                        }
                    } else {
                        startTime = currentTime;
                    }
                }
                if (nrows >= batchSize || estimatedSize > GemFireXDUtils.DML_MAX_CHUNK_SIZE) {
                    isLastBatch = false;
                    break;
                }
                hasMoreRows = moveForward ? rs.next() : rs.previous();
            }
            if (isLastBatch) {
                flags = (byte)(flags | 1);
            }
            boolean bl = dynamicResults = estmt != null && estmt.hasDynamicResults();
            if (dynamicResults) {
                flags = (byte)(flags | 2);
            }
            result.setFlags(flags);
            this.fillWarnings(result, rs);
            if (isLastBatch && isForwardOnly && !conn.hasLOBs() && !dynamicResults) {
                if (stmtHolder == null || cursorId == 0L) {
                    rs.close();
                } else {
                    stmtHolder.closeResultSet(cursorId, this);
                }
                if (holder == null && estmt != null && !estmt.isPrepared()) {
                    connHolder.setStatementForReuse(estmt);
                }
                result.setCursorId(0L);
                result.setStatementId(0L);
            } else {
                if (holder == null) {
                    cursorId = SnappyDataServiceImpl.getNextId(this.currentCursorId);
                    if (stmtHolder == null) {
                        stmtHolder = this.registerResultSet(cursorId, rs, connHolder, stmt, attrs, sql);
                        holder = stmtHolder;
                    } else {
                        holder = this.registerResultSet(cursorId, rs, stmtHolder);
                    }
                }
                result.setCursorId(cursorId);
                result.setStatementId(stmtHolder.getStatementId());
                holder.rsOffset = moveForward ? result.offset + rows.size() : Math.max(0, result.offset - rows.size());
            }
            return result;
        }
        catch (SQLException e) {
            throw this.SnappyException(e);
        }
    }

    private boolean isLast(RowSet rs) {
        return rs == null || (rs.flags & 1) != 0;
    }

    private boolean throttleIfCritical() {
        if (this.thresholdListener.isCritical()) {
            try {
                for (int tries = 1; tries <= 5; ++tries) {
                    Thread.sleep(4L);
                    if (this.thresholdListener.isCritical()) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                this.getCancelCriterion().checkCancelInProgress((Throwable)ie);
            }
            return true;
        }
        return false;
    }

    private static RowSet createEmptyRowSet() {
        RowSet rs = new RowSet();
        rs.setRows(new ArrayList());
        return rs;
    }

    private StatementResult createEmptyStatementResult() {
        return new StatementResult();
    }

    private ConnectionHolder.StatementHolder registerResultSet(long cursorId, ResultSet rs, ConnectionHolder connHolder, Statement stmt, StatementAttrs attrs, String sql) {
        ConnectionHolder.StatementHolder stmtHolder;
        if (stmt != null) {
            long stmtId = SnappyDataServiceImpl.getNextId(this.currentStatementId);
            stmtHolder = connHolder.registerResultSet(stmt, attrs, stmtId, rs, cursorId, sql, this.recordStatementStartTime);
            this.statementMap.putPrimitive(stmtId, (Object)stmtHolder);
        } else {
            stmtHolder = connHolder.registerResultSet(null, null, 0L, rs, cursorId, sql, this.recordStatementStartTime);
        }
        this.resultSetMap.putPrimitive(cursorId, (Object)stmtHolder);
        return stmtHolder;
    }

    private ConnectionHolder.ResultSetHolder registerResultSet(long cursorId, ResultSet rs, ConnectionHolder.StatementHolder stmtHolder) {
        ConnectionHolder.ResultSetHolder holder;
        long stmtId = stmtHolder.getStatementId();
        if (stmtId != 0L) {
            holder = stmtHolder.getConnectionHolder().registerResultSet(stmtHolder, rs, cursorId);
            this.statementMap.putPrimitive(stmtId, (Object)stmtHolder);
        } else {
            holder = stmtHolder.addResultSet(rs, cursorId);
        }
        this.resultSetMap.putPrimitive(cursorId, (Object)stmtHolder);
        return holder;
    }

    private boolean processPendingTransactionAttributes(StatementAttrs attrs, EngineConnection conn) throws SnappyException {
        if (attrs == null) {
            return false;
        }
        Map pendingTXAttrs = attrs.getPendingTransactionAttrs();
        if (pendingTXAttrs != null && !pendingTXAttrs.isEmpty()) {
            this.beginOrAlterTransaction(conn, (byte)64, pendingTXAttrs, false);
        }
        if (attrs.possibleDuplicate) {
            conn.setPossibleDuplicate(true);
            return true;
        }
        return false;
    }

    private void cleanupResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanupStatement(EngineStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkSystemFailure(Throwable t) {
        Error err;
        if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
            SystemFailure.initiateFailure((Error)err);
            throw err;
        }
        SystemFailure.checkFailure();
    }

    private boolean ignoreNonFatalException(Throwable t) {
        this.checkSystemFailure(t);
        return GemFireXDUtils.nodeFailureException(t);
    }

    private StatementAttrs applyMergeAttributes(StatementAttrs source, StatementAttrs target, EngineConnection conn, Statement stmt) throws SQLException {
        if (target == null) {
            target = source;
        } else if (source != null) {
            if (source.isSetBatchSize() && !target.isSetBatchSize()) {
                target.setBatchSize(source.getBatchSize());
            }
            if (source.isSetFetchReverse() && !target.isSetFetchReverse()) {
                target.setFetchReverse(source.isFetchReverse());
            }
            if (source.isSetLobChunkSize() && !target.isSetLobChunkSize()) {
                target.setLobChunkSize(source.getLobChunkSize());
            }
            if (source.isSetBucketIds() && !target.isSetBucketIds()) {
                target.setBucketIds(source.getBucketIds());
                target.setBucketIdsTable(source.getBucketIdsTable());
            }
            if (source.isSetRetainBucketIds() && !target.isSetRetainBucketIds()) {
                target.setRetainBucketIds(source.isRetainBucketIds());
            }
            if (source.isSetCatalogVersion() && !target.isSetCatalogVersion()) {
                target.setCatalogVersion(source.getCatalogVersion());
            }
            if (source.isSetSnapshotTransactionId() && !target.isSetSnapshotTransactionId()) {
                target.setSnapshotTransactionId(source.getSnapshotTransactionId());
            }
        }
        if (target != null) {
            if (stmt != null) {
                if (target.isSetTimeout()) {
                    stmt.setQueryTimeout(target.getTimeout());
                }
                if (target.isSetMaxRows()) {
                    stmt.setMaxRows(target.getMaxRows());
                }
                if (target.isSetMaxFieldSize()) {
                    stmt.setMaxFieldSize(target.getMaxFieldSize());
                }
                if (target.isSetCursorName()) {
                    stmt.setCursorName(target.getCursorName());
                }
            }
            if (target.isSetBucketIds()) {
                GfxdSystemProcedures.setBucketsForLocalExecution(target.getBucketIdsTable(), target.getBucketIds(), target.isRetainBucketIds(), conn.getLanguageConnectionContext());
            }
            if (target.isSetCatalogVersion()) {
                ExternalCatalog catalog = Misc.getMemStore().getExistingExternalCatalog();
                long actualVersion = catalog.getCatalogSchemaVersion();
                long catalogVersion = target.getCatalogVersion();
                if (catalogVersion != -1L && actualVersion != catalogVersion) {
                    throw Util.generateCsSQLException("X0Z39", (Object)actualVersion, catalogVersion);
                }
            }
            if (target.isSetSnapshotTransactionId()) {
                GfxdSystemProcedures.useSnapshotTXId(target.getSnapshotTransactionId(), conn.getLanguageConnectionContext());
            }
        }
        return target;
    }

    public StatementResult execute(long connId, String sql, Map<Integer, OutputParameter> outputParams, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        EngineStatement stmt = null;
        ResultSet rs = null;
        boolean posDup = false;
        try {
            connHolder = this.getValidConnection(connId, token);
            conn = connHolder.getConnection();
            String initialDefaultSchema = conn.getCurrentSchemaName();
            posDup = this.processPendingTransactionAttributes(attrs, conn);
            if (outputParams != null && !outputParams.isEmpty()) {
                throw this.notImplementedException("unprepared CALL with output");
            }
            stmt = connHolder.createNewStatement(attrs);
            ConnectionHolder.StatementHolder stmtHolder = connHolder.newStatementHolder(stmt, attrs, SnappyDataServiceImpl.getNextId(this.currentStatementId), sql, this.recordStatementStartTime, "EXECUTING");
            connHolder.setActiveStatement(stmtHolder);
            this.applyMergeAttributes(null, attrs, conn, stmt);
            StatementResult sr = this.createEmptyStatementResult();
            if (stmt.execute(sql)) {
                stmtHolder.setStatus("FILLING RESULT SET");
                rs = stmt.getResultSet();
                RowSet rowSet = this.getRowSet(stmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, sql);
                sr.setResultSet(rowSet);
            } else {
                String newDefaultSchema;
                stmtHolder.setStatus("FILLING UPDATE COUNT");
                sr.setUpdateCount(stmt.getUpdateCount());
                rs = stmt.getGeneratedKeys();
                if (rs != null) {
                    RowSet rowSet = this.getRowSet(stmt, null, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, "getGeneratedKeys");
                    sr.setGeneratedKeys(rowSet);
                }
                if (initialDefaultSchema != (newDefaultSchema = conn.getCurrentSchemaName())) {
                    sr.setNewDefaultSchema(newDefaultSchema);
                }
            }
            connHolder.clearActiveStatement(stmt);
            EngineStatement st = stmt;
            stmt = null;
            this.fillWarnings(sr, (Statement)st);
            if (rs == null) {
                connHolder.setStatementForReuse(st);
            }
            if (posDup) {
                conn.setPossibleDuplicate(false);
            }
            StatementResult statementResult = sr;
            return statementResult;
        }
        catch (Throwable t) {
            if (posDup && conn != null) {
                conn.setPossibleDuplicate(false);
            }
            this.cleanupResultSet(rs);
            if (stmt != null) {
                connHolder.clearActiveStatement(stmt);
                this.cleanupStatement(stmt);
            }
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    public UpdateResult executeUpdate(long connId, List<String> sqls, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        EngineStatement stmt = null;
        ResultSet rs = null;
        boolean posDup = false;
        try {
            UpdateResult result;
            connHolder = this.getValidConnection(connId, token);
            conn = connHolder.getConnection();
            String initialDefaultSchema = conn.getCurrentSchemaName();
            posDup = this.processPendingTransactionAttributes(attrs, conn);
            stmt = connHolder.createNewStatement(attrs);
            boolean singleUpdate = sqls.size() == 1;
            ConnectionHolder.StatementHolder stmtHolder = connHolder.newStatementHolder(stmt, attrs, SnappyDataServiceImpl.getNextId(this.currentStatementId), sqls, this.recordStatementStartTime, singleUpdate ? "EXECUTING UPDATE" : "EXECUTING BATCH UPDATE");
            connHolder.setActiveStatement(stmtHolder);
            this.applyMergeAttributes(null, attrs, conn, stmt);
            if (singleUpdate) {
                int updateCount = stmt.executeUpdate(sqls.get(0));
                stmtHolder.setStatus("FILLING UPDATE COUNT");
                result = new UpdateResult();
                result.setUpdateCount(updateCount);
            } else {
                stmt.clearBatch();
                for (String string : sqls) {
                    stmt.addBatch(string);
                }
                int[] batchUpdateCounts = stmt.executeBatch();
                stmtHolder.setStatus("FILLING BATCH UPDATE COUNTS");
                result = new UpdateResult();
                for (int count : batchUpdateCounts) {
                    result.addToBatchUpdateCounts(count);
                }
            }
            rs = stmt.getGeneratedKeys();
            if (rs != null) {
                RowSet rowSet = this.getRowSet(stmt, null, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, "getGeneratedKeys");
                result.setGeneratedKeys(rowSet);
            }
            connHolder.clearActiveStatement(stmt);
            String newDefaultSchema = conn.getCurrentSchemaName();
            if (initialDefaultSchema != newDefaultSchema) {
                result.setNewDefaultSchema(newDefaultSchema);
            }
            EngineStatement engineStatement = stmt;
            stmt = null;
            this.fillWarnings(result, (Statement)engineStatement);
            if (rs == null) {
                connHolder.setStatementForReuse(engineStatement);
            }
            if (posDup) {
                conn.setPossibleDuplicate(false);
            }
            UpdateResult updateResult = result;
            return updateResult;
        }
        catch (Throwable t) {
            if (posDup && conn != null) {
                conn.setPossibleDuplicate(false);
            }
            this.cleanupResultSet(rs);
            if (stmt != null) {
                connHolder.clearActiveStatement(stmt);
                this.cleanupStatement(stmt);
            }
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (stmt != null && sqls != null && sqls.size() > 1) {
                stmt.forceClearBatch();
            }
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    public RowSet executeQuery(long connId, String sql, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        EngineStatement stmt = null;
        ResultSet rs = null;
        boolean posDup = false;
        try {
            connHolder = this.getValidConnection(connId, token);
            conn = connHolder.getConnection();
            posDup = this.processPendingTransactionAttributes(attrs, conn);
            stmt = connHolder.createNewStatement(attrs);
            ConnectionHolder.StatementHolder stmtHolder = connHolder.newStatementHolder(stmt, attrs, SnappyDataServiceImpl.getNextId(this.currentStatementId), sql, this.recordStatementStartTime, "EXECUTING QUERY");
            connHolder.setActiveStatement(stmtHolder);
            this.applyMergeAttributes(null, attrs, conn, stmt);
            rs = stmt.executeQuery(sql);
            stmtHolder.setStatus("FILLING RESULT SET");
            RowSet rowSet = this.getRowSet(stmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, sql);
            connHolder.clearActiveStatement(stmt);
            stmt = null;
            if (posDup) {
                conn.setPossibleDuplicate(false);
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        catch (Throwable t) {
            if (posDup && conn != null) {
                conn.setPossibleDuplicate(false);
            }
            this.cleanupResultSet(rs);
            if (stmt != null) {
                connHolder.clearActiveStatement(stmt);
                this.cleanupStatement(stmt);
            }
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    public PrepareResult prepareStatement(long connId, String sql, Map<Integer, OutputParameter> outputParams, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        Statement pstmt = null;
        ConnectionHolder.StatementHolder stmtHolder = null;
        boolean posDup = false;
        try {
            ResultSetMetaData rsmd;
            int statementType;
            connHolder = this.getValidConnection(connId, token);
            conn = connHolder.getConnection();
            posDup = this.processPendingTransactionAttributes(attrs, conn);
            SnappyExceptionData sqlw = null;
            this.applyMergeAttributes(null, attrs, conn, null);
            int resultSetType = SnappyDataServiceImpl.getResultType(attrs);
            int resultSetConcurrency = SnappyDataServiceImpl.getResultSetConcurrency(attrs);
            int resultSetHoldability = SnappyDataServiceImpl.getResultSetHoldability(attrs);
            if (attrs != null && attrs.isSetRequireAutoIncCols() && attrs.requireAutoIncCols) {
                int nCols;
                if (outputParams != null && !outputParams.isEmpty()) {
                    throw this.newSnappyException("XJ009.S", "AUTOINC not valid with output parameters: " + sql);
                }
                List autoIncCols = attrs.autoIncColumns;
                if (autoIncCols != null && (nCols = autoIncCols.size()) > 0) {
                    int[] aiCols = new int[nCols];
                    for (int index = 0; index < nCols; ++index) {
                        aiCols[index] = (Integer)autoIncCols.get(index);
                    }
                    pstmt = conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, aiCols);
                } else {
                    List autoIncColNames = attrs.autoIncColumnNames;
                    pstmt = autoIncColNames != null && (nCols = autoIncColNames.size()) > 0 ? conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoIncColNames.toArray(new String[nCols])) : conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 1);
                }
            } else {
                CallableStatement cstmt = conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                pstmt = cstmt;
                this.registerOutputParameters(cstmt, outputParams);
            }
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            int numParams = pmd.getParameterCount();
            ArrayList<ColumnDescriptor> pmDescs = new ArrayList<ColumnDescriptor>(numParams);
            for (int paramPosition = 1; paramPosition <= numParams; ++paramPosition) {
                int pmType = pmd.getParameterType(paramPosition);
                ColumnDescriptor pmDesc = new ColumnDescriptor();
                SnappyType type = Converters.getThriftSQLType((int)pmType);
                int mode = pmd.getParameterMode(paramPosition);
                switch (mode) {
                    case 1: {
                        pmDesc.setParameterIn(true);
                        break;
                    }
                    case 4: {
                        pmDesc.setParameterOut(true);
                        break;
                    }
                    case 2: {
                        pmDesc.setParameterIn(true);
                        pmDesc.setParameterOut(true);
                        break;
                    }
                    default: {
                        pmDesc.setParameterIn(true);
                    }
                }
                int nullable = pmd.isNullable(paramPosition);
                if (nullable == 1) {
                    pmDesc.setNullable(true);
                } else if (nullable == 0) {
                    pmDesc.setNullable(false);
                }
                pmDesc.setType(type);
                pmDesc.setPrecision((short)pmd.getPrecision(paramPosition));
                int scale = pmd.getScale(paramPosition);
                if (scale != 0) {
                    pmDesc.setScale((short)scale);
                }
                if (pmType == 2000) {
                    String typeName = pmd.getParameterTypeName(paramPosition);
                    String className = pmd.getParameterClassName(paramPosition);
                    if (className != null) {
                        pmDesc.setUdtTypeAndClassName(typeName + ':' + className);
                    } else {
                        pmDesc.setUdtTypeAndClassName(typeName);
                    }
                }
                pmDescs.add(pmDesc);
            }
            SQLWarning warnings = pstmt.getWarnings();
            if (warnings != null) {
                sqlw = this.snappyWarning(warnings);
            }
            long pstmtId = SnappyDataServiceImpl.getNextId(this.currentStatementId);
            stmtHolder = connHolder.registerPreparedStatement((PreparedStatement)pstmt, attrs, pstmtId, sql, this.recordStatementStartTime);
            this.statementMap.putPrimitive(pstmtId, (Object)stmtHolder);
            stmtHolder.setStatus("FILLING PREPARE RESULT");
            if (pstmt instanceof EnginePreparedStatement) {
                switch (((EnginePreparedStatement)pstmt).getStatementType()) {
                    case 0: {
                        statementType = 0;
                        break;
                    }
                    case 3: {
                        statementType = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        statementType = 1;
                        break;
                    }
                    case 4: {
                        statementType = 3;
                        break;
                    }
                    case -2: 
                    case -1: {
                        statementType = 4;
                        break;
                    }
                    default: {
                        statementType = 5;
                        break;
                    }
                }
            } else {
                String firstToken = ClientSharedUtils.getStatementToken((String)sql, (int)0);
                statementType = firstToken == null || firstToken.equalsIgnoreCase("select") ? 0 : (firstToken.equalsIgnoreCase("update") ? 2 : (firstToken.equalsIgnoreCase("insert") ? 1 : (firstToken.equalsIgnoreCase("delete") ? 3 : (firstToken.equalsIgnoreCase("call") ? 4 : 5))));
            }
            PrepareResult result = new PrepareResult(pstmtId, (byte)statementType, pmDescs);
            if (sqlw != null) {
                result.setWarnings(sqlw);
            }
            if ((rsmd = pstmt.getMetaData()) != null) {
                result.setResultSetMetaData(this.getRowSetMetaData(rsmd, rsmd.getColumnCount(), connHolder.useStringForDecimal()));
            }
            if (posDup) {
                conn.setPossibleDuplicate(false);
            }
            PrepareResult prepareResult = result;
            if (pstmt != null) {
                connHolder.clearActiveStatement(pstmt);
            }
            return prepareResult;
        }
        catch (Throwable t) {
            try {
                if (posDup && conn != null) {
                    conn.setPossibleDuplicate(false);
                }
                if (pstmt != null) {
                    if (stmtHolder != null) {
                        connHolder.closeStatement(stmtHolder, this);
                    }
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.checkSystemFailure(t);
                throw this.SnappyException(t);
            }
            catch (Throwable throwable) {
                if (pstmt != null) {
                    connHolder.clearActiveStatement(pstmt);
                }
                throw throwable;
            }
        }
    }

    private void registerOutputParameters(CallableStatement cstmt, Map<Integer, OutputParameter> outputParams) throws SQLException {
        if (outputParams != null && !outputParams.isEmpty()) {
            for (Map.Entry<Integer, OutputParameter> param : outputParams.entrySet()) {
                OutputParameter outParam = param.getValue();
                int jdbcType = Converters.getJdbcType((SnappyType)outParam.type);
                int paramPosition = param.getKey();
                if (outParam.isSetScale()) {
                    cstmt.registerOutParameter(paramPosition, jdbcType, outParam.scale);
                    continue;
                }
                if (outParam.isSetTypeName()) {
                    cstmt.registerOutParameter(paramPosition, jdbcType, outParam.typeName);
                    continue;
                }
                cstmt.registerOutParameter(paramPosition, jdbcType);
            }
        }
    }

    private void fillOutputParameterValues(CallableStatement cstmt, ParameterMetaData pmd, Map<Integer, OutputParameter> outputParams, ConnectionHolder connHolder, StatementAttrs attrs, StatementResult stmtResult) throws SQLException {
        int numParams = pmd.getParameterCount();
        HashMap<Integer, ColumnValue> outParams = new HashMap<Integer, ColumnValue>(outputParams.size());
        for (int paramPosition = 1; paramPosition <= numParams; ++paramPosition) {
            int paramMode = pmd.getParameterMode(paramPosition);
            if (paramMode != 2 && paramMode != 4) continue;
            outParams.put(paramPosition, this.getColumnValue(cstmt, paramPosition, pmd.getParameterType(paramPosition), connHolder, attrs));
        }
        stmtResult.setProcedureOutParams(outParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateParameters(Row params, PreparedStatement pstmt, ParameterMetaData pmd, EngineConnection conn) throws SQLException {
        if (params == null) return;
        int numParams = params.size();
        block19: for (int paramPosition = 1; paramPosition <= numParams; ++paramPosition) {
            int index = paramPosition - 1;
            if (pmd != null && pmd.getParameterMode(paramPosition) == 4) continue;
            int paramType = params.getType(index);
            switch (Math.abs(paramType)) {
                case 9: 
                case 10: 
                case 11: {
                    if (paramType > 0) {
                        pstmt.setString(paramPosition, (String)params.getObject(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, Converters.getJdbcType((SnappyType)SnappyType.findByValue((int)paramType)));
                    continue block19;
                }
                case 4: {
                    if (paramType > 0) {
                        pstmt.setInt(paramPosition, params.getInt(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 4);
                    continue block19;
                }
                case 5: {
                    if (paramType > 0) {
                        pstmt.setLong(paramPosition, params.getLong(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, -5);
                    continue block19;
                }
                case 12: {
                    if (paramType > 0) {
                        pstmt.setDate(paramPosition, params.getDate(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 91);
                    continue block19;
                }
                case 14: {
                    if (paramType > 0) {
                        pstmt.setTimestamp(paramPosition, params.getTimestamp(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 93);
                    continue block19;
                }
                case 7: {
                    if (paramType > 0) {
                        pstmt.setDouble(paramPosition, params.getDouble(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 8);
                    continue block19;
                }
                case 8: {
                    if (paramType > 0) {
                        pstmt.setBigDecimal(paramPosition, (BigDecimal)params.getObject(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 3);
                    continue block19;
                }
                case 6: {
                    if (paramType > 0) {
                        pstmt.setFloat(paramPosition, params.getFloat(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 7);
                    continue block19;
                }
                case 3: {
                    if (paramType > 0) {
                        pstmt.setShort(paramPosition, params.getShort(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 5);
                    continue block19;
                }
                case 1: {
                    if (paramType > 0) {
                        pstmt.setBoolean(paramPosition, params.getBoolean(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 16);
                    continue block19;
                }
                case 2: {
                    if (paramType > 0) {
                        pstmt.setByte(paramPosition, params.getByte(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, -6);
                    continue block19;
                }
                case 13: {
                    if (paramType > 0) {
                        pstmt.setTime(paramPosition, params.getTime(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 92);
                    continue block19;
                }
                case 18: {
                    Blob blob;
                    if (paramType <= 0) {
                        pstmt.setNull(paramPosition, 2004);
                        continue block19;
                    }
                    Object paramVal = params.getObject(index);
                    if (paramVal instanceof byte[]) {
                        pstmt.setBytes(paramPosition, (byte[])paramVal);
                        continue block19;
                    }
                    BlobChunk chunk = (BlobChunk)paramVal;
                    if (chunk.isSetLobId()) {
                        Object lob = conn.getLOBMapping(chunk.lobId);
                        if (!(lob instanceof Blob)) throw Util.generateCsSQLException("XJ217.S");
                        blob = (Blob)lob;
                    } else {
                        if (chunk.last) {
                            pstmt.setBlob(paramPosition, (Blob)new ClientBlob(chunk.chunk));
                            continue block19;
                        }
                        blob = conn.createBlob();
                    }
                    long offset = 1L;
                    if (chunk.isSetOffset()) {
                        offset += chunk.offset;
                    }
                    blob.setBytes(offset, chunk.getChunk());
                    chunk.free();
                    pstmt.setBlob(paramPosition, blob);
                    continue block19;
                }
                case 19: 
                case 20: 
                case 25: {
                    Clob clob;
                    if (paramType <= 0) {
                        pstmt.setNull(paramPosition, paramType == 25 ? 4002 : 2005);
                        continue block19;
                    }
                    Object paramVal = params.getObject(index);
                    if (paramVal instanceof String) {
                        pstmt.setString(paramPosition, (String)paramVal);
                        continue block19;
                    }
                    ClobChunk chunk = (ClobChunk)paramVal;
                    if (chunk.isSetLobId()) {
                        Object lob = conn.getLOBMapping(chunk.lobId);
                        if (!(lob instanceof Clob)) throw Util.generateCsSQLException("XJ217.S");
                        clob = (Clob)lob;
                    } else {
                        if (chunk.last) {
                            pstmt.setString(paramPosition, chunk.getChunk());
                            continue block19;
                        }
                        clob = conn.createClob();
                    }
                    long offset = 1L;
                    if (chunk.isSetOffset()) {
                        offset += chunk.offset;
                    }
                    clob.setString(offset, chunk.getChunk());
                    pstmt.setClob(paramPosition, clob);
                    continue block19;
                }
                case 15: 
                case 16: 
                case 17: {
                    if (paramType > 0) {
                        pstmt.setBytes(paramPosition, (byte[])params.getObject(index));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, Converters.getJdbcType((SnappyType)SnappyType.findByValue((int)paramType)));
                    continue block19;
                }
                case 24: {
                    pstmt.setNull(paramPosition, 0);
                    continue block19;
                }
                case 26: {
                    if (paramType > 0) {
                        pstmt.setObject(paramPosition, ((Converters.JavaObjectWrapper)params.getObject(index)).getDeserialized(paramPosition, javaObjectCreator));
                        continue block19;
                    }
                    pstmt.setNull(paramPosition, 2000);
                    continue block19;
                }
                default: {
                    SnappyType type = SnappyType.findByValue((int)paramType);
                    throw Util.generateCsSQLException("0A000.S.7", type != null ? type.toString() : Integer.toString(paramType));
                }
            }
        }
    }

    public StatementResult executePrepared(long stmtId, Row params, Map<Integer, OutputParameter> outputParams, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        PreparedStatement pstmt = null;
        CallableStatement cstmt = null;
        ParameterMetaData pmd = null;
        ResultSet rs = null;
        RowSet rowSet = null;
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatement(token, stmtId, true, "executePrepared");
            connHolder = stmtHolder.getConnectionHolder();
            long connId = connHolder.getConnectionId();
            conn = connHolder.getConnection();
            String initialDefaultSchema = conn.getCurrentSchemaName();
            pstmt = (PreparedStatement)stmtHolder.getStatement();
            stmtHolder.setStatus("EXECUTING PREPARED");
            stmtHolder.incrementAccessFrequency();
            connHolder.setActiveStatement(stmtHolder);
            attrs = this.applyMergeAttributes(stmtHolder.getStatementAttrs(), attrs, conn, pstmt);
            if (outputParams != null && !outputParams.isEmpty()) {
                if (pstmt instanceof CallableStatement) {
                    cstmt = (CallableStatement)pstmt;
                    pmd = cstmt.getParameterMetaData();
                    this.registerOutputParameters(cstmt, outputParams);
                    stmtHolder.setStatus("EXECUTING PREPARED CALL");
                } else {
                    throw this.newSnappyException("XJ009.S", stmtHolder.getSQL());
                }
            }
            StatementResult stmtResult = this.createEmptyStatementResult();
            pstmt.clearParameters();
            this.updateParameters(params, pstmt, pmd, conn);
            boolean resultType = pstmt.execute();
            if (resultType) {
                stmtHolder.setStatus("FILLING RESULT SET");
                rs = pstmt.getResultSet();
                rowSet = this.getRowSet(pstmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, null);
                stmtResult.setResultSet(rowSet);
                if (cstmt != null) {
                    this.fillOutputParameterValues(cstmt, pmd, outputParams, connHolder, attrs, stmtResult);
                }
            } else {
                String newDefaultSchema;
                stmtHolder.setStatus("FILLING UPDATE COUNT");
                stmtResult.setUpdateCount(pstmt.getUpdateCount());
                rs = pstmt.getGeneratedKeys();
                if (rs != null) {
                    rowSet = this.getRowSet(pstmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, "getGeneratedKeys");
                    stmtResult.setGeneratedKeys(rowSet);
                }
                if (initialDefaultSchema != (newDefaultSchema = conn.getCurrentSchemaName())) {
                    stmtResult.setNewDefaultSchema(newDefaultSchema);
                }
            }
            if (cstmt != null) {
                this.fillOutputParameterValues(cstmt, pmd, outputParams, connHolder, attrs, stmtResult);
            }
            this.fillWarnings(stmtResult, (Statement)pstmt);
            StatementResult statementResult = stmtResult;
            return statementResult;
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (pstmt != null) {
                try {
                    if (this.isLast(rowSet)) {
                        pstmt.clearParameters();
                    }
                }
                catch (Throwable t) {
                    this.checkSystemFailure(t);
                }
                connHolder.clearActiveStatement(pstmt);
            }
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    public UpdateResult executePreparedUpdate(long stmtId, Row params, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        RowSet rowSet = null;
        try {
            String newDefaultSchema;
            ConnectionHolder.StatementHolder stmtHolder = this.getStatement(token, stmtId, true, "executePreparedUpdate");
            connHolder = stmtHolder.getConnectionHolder();
            long connId = connHolder.getConnectionId();
            conn = connHolder.getConnection();
            String initialDefaultSchema = conn.getCurrentSchemaName();
            pstmt = (PreparedStatement)stmtHolder.getStatement();
            stmtHolder.setStatus("EXECUTING PREPARED UPDATE");
            stmtHolder.incrementAccessFrequency();
            connHolder.setActiveStatement(stmtHolder);
            attrs = this.applyMergeAttributes(stmtHolder.getStatementAttrs(), attrs, conn, pstmt);
            pstmt.clearParameters();
            this.updateParameters(params, pstmt, null, conn);
            int updateCount = pstmt.executeUpdate();
            stmtHolder.setStatus("FILLING UPDATE COUNT");
            UpdateResult result = new UpdateResult();
            result.setUpdateCount(updateCount);
            rs = pstmt.getGeneratedKeys();
            if (rs != null) {
                rowSet = this.getRowSet(pstmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, "getGeneratedKeys");
                result.setGeneratedKeys(rowSet);
            }
            if (initialDefaultSchema != (newDefaultSchema = conn.getCurrentSchemaName())) {
                result.setNewDefaultSchema(newDefaultSchema);
            }
            this.fillWarnings(result, (Statement)pstmt);
            UpdateResult updateResult = result;
            return updateResult;
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (pstmt != null) {
                try {
                    if (this.isLast(rowSet)) {
                        pstmt.clearParameters();
                    }
                }
                catch (Throwable t) {
                    this.checkSystemFailure(t);
                }
                connHolder.clearActiveStatement(pstmt);
            }
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    public RowSet executePreparedQuery(long stmtId, Row params, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        RowSet rowSet = null;
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatement(token, stmtId, true, "executePreparedQuery");
            connHolder = stmtHolder.getConnectionHolder();
            long connId = connHolder.getConnectionId();
            conn = connHolder.getConnection();
            pstmt = (PreparedStatement)stmtHolder.getStatement();
            stmtHolder.setStatus("EXECUTING PREPARED QUERY");
            stmtHolder.incrementAccessFrequency();
            connHolder.setActiveStatement(stmtHolder);
            attrs = this.applyMergeAttributes(stmtHolder.getStatementAttrs(), attrs, conn, pstmt);
            pstmt.clearParameters();
            this.updateParameters(params, pstmt, null, conn);
            rs = pstmt.executeQuery();
            stmtHolder.setStatus("FILLING RESULT SET");
            RowSet rowSet2 = rowSet = this.getRowSet(pstmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, null);
            return rowSet2;
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (pstmt != null) {
                try {
                    if (this.isLast(rowSet)) {
                        pstmt.clearParameters();
                    }
                }
                catch (Throwable t) {
                    this.checkSystemFailure(t);
                }
                connHolder.clearActiveStatement(pstmt);
            }
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    public UpdateResult executePreparedBatch(long stmtId, List<Row> paramsBatch, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        EngineConnection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        RowSet rowSet = null;
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatement(token, stmtId, true, "executePreparedBatch");
            connHolder = stmtHolder.getConnectionHolder();
            long connId = connHolder.getConnectionId();
            conn = connHolder.getConnection();
            pstmt = (PreparedStatement)stmtHolder.getStatement();
            stmtHolder.setStatus("EXECUTING PREPARED BATCH");
            stmtHolder.incrementAccessFrequency();
            connHolder.setActiveStatement(stmtHolder);
            attrs = this.applyMergeAttributes(stmtHolder.getStatementAttrs(), attrs, conn, pstmt);
            pstmt.clearParameters();
            pstmt.clearBatch();
            for (Row params : paramsBatch) {
                this.updateParameters(params, pstmt, null, conn);
                pstmt.addBatch();
            }
            int[] batchUpdateCounts = pstmt.executeBatch();
            stmtHolder.setStatus("FILLING BATCH UPDATE COUNTS");
            UpdateResult result = new UpdateResult();
            for (int count : batchUpdateCounts) {
                result.addToBatchUpdateCounts(count);
            }
            rs = pstmt.getGeneratedKeys();
            if (rs != null) {
                rowSet = this.getRowSet(pstmt, stmtHolder, rs, 0L, null, connId, attrs, 0, false, false, 0, connHolder, "getGeneratedKeys");
                result.setGeneratedKeys(rowSet);
            }
            this.fillWarnings(result, (Statement)pstmt);
            UpdateResult updateResult = result;
            return updateResult;
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
        finally {
            if (pstmt != null) {
                try {
                    if (this.isLast(rowSet)) {
                        pstmt.clearParameters();
                    }
                }
                catch (Throwable t) {
                    this.checkSystemFailure(t);
                }
                try {
                    pstmt.clearBatch();
                }
                catch (Throwable t) {
                    this.checkSystemFailure(t);
                }
                connHolder.clearActiveStatement(pstmt);
            }
            if (conn != null && attrs != null && attrs.isSetBucketIds()) {
                conn.getLanguageConnectionContext().setExecuteLocally(null, null, false, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementResult prepareAndExecute(long connId, String sql, List<Row> paramsBatch, Map<Integer, OutputParameter> outputParams, StatementAttrs attrs, ByteBuffer token) throws SnappyException {
        PrepareResult prepResult = this.prepareStatement(connId, sql, outputParams, attrs, token);
        ConnectionHolder connHolder = null;
        boolean posDup = attrs != null && attrs.possibleDuplicate;
        try {
            StatementResult sr;
            if (posDup) {
                connHolder = this.getValidConnection(connId, token);
                connHolder.getConnection().setPossibleDuplicate(true);
            }
            if (paramsBatch.size() == 1) {
                sr = this.executePrepared(prepResult.statementId, paramsBatch.get(0), outputParams, attrs, token);
                if (sr.updateCount >= 0) {
                    sr.setBatchUpdateCounts(Collections.singletonList(sr.updateCount));
                }
            } else {
                UpdateResult ur = this.executePreparedBatch(prepResult.statementId, paramsBatch, attrs, token);
                sr = new StatementResult();
                sr.setBatchUpdateCounts(ur.getBatchUpdateCounts());
                sr.setGeneratedKeys(ur.getGeneratedKeys());
                sr.setNewDefaultSchema(ur.getNewDefaultSchema());
                sr.setWarnings(ur.getWarnings());
            }
            sr.setPreparedResult(prepResult);
            StatementResult statementResult = sr;
            return statementResult;
        }
        finally {
            if (posDup && connHolder != null) {
                connHolder.getConnection().setPossibleDuplicate(false);
            }
        }
    }

    public byte beginTransaction(long connId, byte isolationLevel, Map<TransactionAttribute, Boolean> flags, ByteBuffer token) throws SnappyException {
        return this.beginOrAlterTransaction(this.getValidConnection(connId, token).getConnection(), isolationLevel, flags, true);
    }

    public void setTransactionAttributes(long connId, Map<TransactionAttribute, Boolean> flags, ByteBuffer token) throws SnappyException {
        if (flags != null && !flags.isEmpty()) {
            this.beginOrAlterTransaction(this.getValidConnection(connId, token).getConnection(), (byte)64, flags, false);
        }
    }

    public Map<TransactionAttribute, Boolean> getTransactionAttributes(long connId, ByteBuffer token) throws SnappyException {
        try {
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            EnumMap txAttrs = ThriftUtils.newTransactionFlags();
            EnumSet<TransactionFlag> txFlags = conn.getTransactionFlags();
            txAttrs.put(TransactionAttribute.AUTOCOMMIT, conn.getAutoCommit());
            txAttrs.put(TransactionAttribute.READ_ONLY_CONNECTION, conn.isReadOnly());
            if (txFlags != null) {
                txAttrs.put(TransactionAttribute.DISABLE_BATCHING, txFlags.contains(TransactionFlag.DISABLE_BATCHING));
                txAttrs.put(TransactionAttribute.SYNC_COMMITS, txFlags.contains(TransactionFlag.SYNC_COMMITS));
                txAttrs.put(TransactionAttribute.WAITING_MODE, txFlags.contains(TransactionFlag.WAITING_MODE));
            } else {
                txAttrs.put(TransactionAttribute.DISABLE_BATCHING, false);
                txAttrs.put(TransactionAttribute.SYNC_COMMITS, false);
                txAttrs.put(TransactionAttribute.WAITING_MODE, false);
            }
            return txAttrs;
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    private byte beginOrAlterTransaction(EngineConnection conn, byte isolationLevel, Map<TransactionAttribute, Boolean> flags, boolean commitExisting) throws SnappyException {
        try {
            EnumSet<TransactionFlag> txFlags = null;
            Boolean autoCommit = null;
            Boolean readOnly = null;
            boolean hasTXFlags = false;
            if (flags != null && flags.size() > 0) {
                txFlags = EnumSet.noneOf(TransactionFlag.class);
                for (Map.Entry<TransactionAttribute, Boolean> e : flags.entrySet()) {
                    TransactionAttribute flag = e.getKey();
                    switch (flag) {
                        case AUTOCOMMIT: {
                            autoCommit = e.getValue();
                            break;
                        }
                        case DISABLE_BATCHING: {
                            if (e.getValue().booleanValue()) {
                                txFlags.add(TransactionFlag.DISABLE_BATCHING);
                            }
                            hasTXFlags = true;
                            break;
                        }
                        case WAITING_MODE: {
                            if (e.getValue().booleanValue()) {
                                txFlags.add(TransactionFlag.WAITING_MODE);
                            }
                            hasTXFlags = true;
                            break;
                        }
                        case SYNC_COMMITS: {
                            if (e.getValue().booleanValue()) {
                                txFlags.add(TransactionFlag.SYNC_COMMITS);
                            }
                            hasTXFlags = true;
                            break;
                        }
                        case READ_ONLY_CONNECTION: {
                            readOnly = e.getValue();
                        }
                    }
                }
                if (!hasTXFlags) {
                    txFlags = null;
                }
            }
            if (readOnly != null) {
                conn.setReadOnly(readOnly);
            }
            if (autoCommit != null) {
                conn.setAutoCommit(autoCommit);
            }
            if (isolationLevel != 64) {
                conn.setTransactionIsolation(Converters.getJdbcIsolation((int)isolationLevel), txFlags);
                isolationLevel = Converters.getThriftTransactionIsolation((int)conn.getTransactionIsolation());
            } else {
                if (commitExisting) {
                    conn.commit();
                }
                if (txFlags != null) {
                    LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
                    lcc.setTXFlags(txFlags);
                }
            }
            return isolationLevel;
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void commitTransaction(long connId, boolean startNewTransaction, Map<TransactionAttribute, Boolean> flags, ByteBuffer token) throws SnappyException {
        try {
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            if (flags != null && !flags.isEmpty()) {
                this.beginOrAlterTransaction(conn, (byte)64, flags, false);
            }
            conn.commit();
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            if (lcc != null) {
                lcc.clearExecuteLocally();
            }
            if (!startNewTransaction) {
                conn.setTransactionIsolation(0);
            }
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void rollbackTransaction(long connId, boolean startNewTransaction, Map<TransactionAttribute, Boolean> flags, ByteBuffer token) throws SnappyException {
        try {
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            if (flags != null && !flags.isEmpty()) {
                this.beginOrAlterTransaction(conn, (byte)64, flags, false);
            }
            conn.rollback();
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            if (lcc != null) {
                lcc.clearExecuteLocally();
            }
            if (!startNewTransaction) {
                conn.setTransactionIsolation(0);
            }
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public RowSet scrollCursor(long cursorId, int offset, boolean offsetIsAbsolute, boolean fetchReverse, int fetchSize, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        Statement stmt = null;
        RowSet rowSet = null;
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatementForResultSet(token, cursorId, "scrollCursor");
            connHolder = stmtHolder.getConnectionHolder();
            long connId = connHolder.getConnectionId();
            ConnectionHolder.ResultSetHolder holder = stmtHolder.findResultSet(cursorId);
            if (holder != null) {
                stmt = stmtHolder.getStatement();
                stmtHolder.setStatus("SCROLLING CURSOR");
                stmtHolder.incrementAccessFrequency();
                connHolder.setActiveStatement(stmtHolder);
                StatementAttrs attrs = stmtHolder.getStatementAttrs();
                RowSet rowSet2 = rowSet = this.getRowSet(stmt, stmtHolder, holder.resultSet, holder.rsCursorId, holder, connId, attrs, offset, offsetIsAbsolute, fetchReverse, fetchSize, connHolder, null);
                return rowSet2;
            }
            try {
                throw this.resultSetNotFoundException(cursorId, "scrollCursor");
            }
            catch (Throwable t) {
                this.checkSystemFailure(t);
                throw this.SnappyException(t);
            }
        }
        finally {
            try {
                if (this.isLast(rowSet) && stmt != null && stmt.getResultSetType() == 1003 && stmt instanceof PreparedStatement) {
                    ((PreparedStatement)stmt).clearParameters();
                }
            }
            catch (Throwable t) {
                this.checkSystemFailure(t);
            }
            if (connHolder != null) {
                connHolder.clearActiveStatement(stmt);
            }
        }
    }

    public void executeCursorUpdate(long cursorId, List<CursorUpdateOperation> operations, List<Row> changedRows, List<List<Integer>> changedColumnsList, List<Integer> changedRowIndexes, ByteBuffer token) throws SnappyException {
        throw this.notImplementedException("executeCursorUpdate");
    }

    public void startXATransaction(long connId, TransactionXid xid, int timeoutInSeconds, int flags, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            xaResource.setTransactionTimeout(timeoutInSeconds);
            XAXactId xaXid = new XAXactId(xid.getFormatId(), xid.getGlobalId(), xid.getBranchQualifier());
            xaResource.start(xaXid, flags);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public int prepareXATransaction(long connId, TransactionXid xid, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            XAXactId xaXid = new XAXactId(xid.getFormatId(), xid.getGlobalId(), xid.getBranchQualifier());
            return xaResource.prepare(xaXid);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void commitXATransaction(long connId, TransactionXid xid, boolean onePhase, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            XAXactId xaXid = new XAXactId(xid.getFormatId(), xid.getGlobalId(), xid.getBranchQualifier());
            xaResource.commit(xaXid, onePhase);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void rollbackXATransaction(long connId, TransactionXid xid, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            XAXactId xaXid = new XAXactId(xid.getFormatId(), xid.getGlobalId(), xid.getBranchQualifier());
            xaResource.rollback(xaXid);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void forgetXATransaction(long connId, TransactionXid xid, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            XAXactId xaXid = new XAXactId(xid.getFormatId(), xid.getGlobalId(), xid.getBranchQualifier());
            xaResource.forget(xaXid);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void endXATransaction(long connId, TransactionXid xid, int flags, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            XAXactId xaXid = new XAXactId(xid.getFormatId(), xid.getGlobalId(), xid.getBranchQualifier());
            xaResource.end(xaXid, flags);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public List<TransactionXid> recoverXATransaction(long connId, int flag, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            XAResource xaResource = this.getXAResource(connHolder);
            Xid[] result = xaResource.recover(flag);
            if (result != null && result.length > 0) {
                ArrayList<TransactionXid> xids = new ArrayList<TransactionXid>(result.length);
                for (Xid xid : result) {
                    xids.add(new TransactionXid().setFormatId(xid.getFormatId()).setGlobalId(xid.getGlobalTransactionId()).setBranchQualifier(xid.getBranchQualifier()));
                }
                return xids;
            }
            return new ArrayList<TransactionXid>(0);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public RowSet getNextResultSet(long cursorId, byte otherResultSetBehaviour, ByteBuffer token) throws SnappyException {
        ResultSet rs;
        Statement stmt;
        ConnectionHolder connHolder;
        block17: {
            boolean moreResults;
            ConnectionHolder.StatementHolder stmtHolder;
            block16: {
                connHolder = null;
                stmt = null;
                rs = null;
                stmtHolder = this.getStatementForResultSet(token, cursorId, "getNextResultSet");
                stmt = stmtHolder.getStatement();
                if (stmt != null) break block16;
                RowSet rowSet = SnappyDataServiceImpl.createEmptyRowSet();
                if (connHolder != null) {
                    connHolder.clearActiveStatement(stmt);
                }
                return rowSet;
            }
            connHolder = stmtHolder.getConnectionHolder();
            stmtHolder.setStatus("CLOSE PREVIOUS RESULT SET");
            stmtHolder.incrementAccessFrequency();
            connHolder.setActiveStatement(stmtHolder);
            stmtHolder.closeResultSet(cursorId, this);
            stmtHolder.setStatus("GET NEXT RESULT SET");
            if (otherResultSetBehaviour == 0) {
                moreResults = stmt.getMoreResults();
            } else {
                int current;
                switch (otherResultSetBehaviour) {
                    case 2: {
                        current = 1;
                        break;
                    }
                    case 1: {
                        current = 2;
                        break;
                    }
                    default: {
                        current = 3;
                    }
                }
                moreResults = stmt.getMoreResults(current);
            }
            if (!moreResults) break block17;
            rs = stmt.getResultSet();
            stmtHolder.setStatus("FILLING NEXT RESULT SET");
            RowSet rowSet = this.getRowSet(stmt, stmtHolder, rs, 0L, null, connHolder.getConnectionId(), stmtHolder.getStatementAttrs(), 0, false, false, 0, connHolder, null);
            if (connHolder != null) {
                connHolder.clearActiveStatement(stmt);
            }
            return rowSet;
        }
        try {
            RowSet rowSet = SnappyDataServiceImpl.createEmptyRowSet();
            if (connHolder != null) {
                connHolder.clearActiveStatement(stmt);
            }
            return rowSet;
        }
        catch (Throwable t) {
            try {
                this.cleanupResultSet(rs);
                this.checkSystemFailure(t);
                throw this.SnappyException(t);
            }
            catch (Throwable throwable) {
                if (connHolder != null) {
                    connHolder.clearActiveStatement(stmt);
                }
                throw throwable;
            }
        }
    }

    public BlobChunk getBlobChunk(long connId, long lobId, long offset, int chunkSize, boolean freeLobAtEnd, ByteBuffer token) throws SnappyException {
        try {
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            Object lob = conn.getLOBMapping(lobId);
            if (lob instanceof Blob) {
                Blob blob = (Blob)lob;
                long length = blob.length() - offset;
                if (length > Integer.MAX_VALUE) {
                    throw Util.generateCsSQLException("XJ093.S", (Object)Long.toString(length), Long.toString(Integer.MAX_VALUE));
                }
                BlobChunk chunk = new BlobChunk().setLobId(lobId).setOffset(offset);
                if (chunkSize > 0 && (long)chunkSize < length) {
                    chunk.chunk = ByteBuffer.wrap(blob.getBytes(offset + 1L, chunkSize));
                    chunk.setLast(false);
                } else {
                    chunk = SnappyDataServiceImpl.getAsLastChunk(blob, (int)length);
                    if (freeLobAtEnd) {
                        conn.removeLOBMapping(lobId);
                        blob.free();
                    }
                }
                return chunk;
            }
            throw Util.generateCsSQLException("XJ217.S");
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public ClobChunk getClobChunk(long connId, long lobId, long offset, int chunkSize, boolean freeLobAtEnd, ByteBuffer token) throws SnappyException {
        try {
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            Object lob = conn.getLOBMapping(lobId);
            if (lob instanceof Clob) {
                Clob clob = (Clob)lob;
                long length = clob.length() - offset;
                if (length > Integer.MAX_VALUE) {
                    throw Util.generateCsSQLException("XJ093.S", (Object)Long.toString(length), Long.toString(Integer.MAX_VALUE));
                }
                ClobChunk chunk = new ClobChunk().setLobId(lobId).setOffset(offset);
                if (chunkSize > 0 && (long)chunkSize < length) {
                    chunk.setChunk(clob.getSubString(offset + 1L, chunkSize)).setLast(false);
                } else {
                    chunk.setChunk(clob.getSubString(offset + 1L, (int)length)).setLast(true);
                    if (freeLobAtEnd) {
                        conn.removeLOBMapping(lobId);
                        clob.free();
                    }
                }
                return chunk;
            }
            throw Util.generateCsSQLException("XJ217.S");
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void closeResultSet(long cursorId, ByteBuffer token) throws SnappyException {
        if (cursorId == 0L) {
            return;
        }
        ConnectionHolder connHolder = null;
        Statement stmt = null;
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatementForResultSet(token, cursorId, "closeResultSet");
            connHolder = stmtHolder.getConnectionHolder();
            stmtHolder.setStatus("CLOSING RESULT SET");
            connHolder.setActiveStatement(stmtHolder);
            stmt = stmtHolder.getStatement();
            stmtHolder.closeResultSet(cursorId, this);
            if (connHolder != null) {
                connHolder.clearActiveStatement(stmt);
            }
        }
        catch (Throwable t) {
            try {
                this.checkSystemFailure(t);
                throw this.SnappyException(t);
            }
            catch (Throwable throwable) {
                if (connHolder != null) {
                    connHolder.clearActiveStatement(stmt);
                }
                throw throwable;
            }
        }
    }

    private void checkDBOwner(long connId, ByteBuffer token, String module) throws SnappyException {
        String authId;
        ConnectionHolder connHolder = this.getValidConnection(connId, token);
        try {
            authId = IdUtil.getUserAuthorizationId(connHolder.getUserName());
        }
        catch (Exception e) {
            throw this.SnappyException(e);
        }
        if (!Misc.getMemStore().getDatabase().getDataDictionary().getAuthorizationDatabaseOwner().equals(authId)) {
            throw this.newSnappyException("08004", "administrator access required for " + module);
        }
    }

    public List<ConnectionProperties> fetchActiveConnections(long connId, ByteBuffer token) throws SnappyException {
        this.checkDBOwner(connId, token, "fetchActiveConnections");
        final ArrayList<ConnectionProperties> activeConns = new ArrayList<ConnectionProperties>(this.connectionMap.size());
        this.connectionMap.forEachValue(new TObjectProcedure(){

            public boolean execute(Object h) {
                ConnectionHolder connHolder = (ConnectionHolder)h;
                ConnectionProperties props = new ConnectionProperties(connHolder.getConnectionId(), connHolder.getClientHostName(), connHolder.getClientID());
                props.setUserName(connHolder.getUserName());
                activeConns.add(props);
                return true;
            }
        });
        return activeConns;
    }

    public Map<Long, String> fetchActiveStatements(long connId, ByteBuffer token) throws SnappyException {
        this.checkDBOwner(connId, token, "fetchActiveStatements");
        THashMap activeStmts = new THashMap(this.statementMap.size());
        this.statementMap.forEachValue(new TObjectProcedure((Map)activeStmts){
            final /* synthetic */ Map val$activeStmts;
            {
                this.val$activeStmts = map;
            }

            public boolean execute(Object h) {
                ConnectionHolder.StatementHolder stmtHolder = (ConnectionHolder.StatementHolder)h;
                this.val$activeStmts.put(stmtHolder.getStatementId(), String.valueOf(stmtHolder.getSQL()));
                return true;
            }
        });
        return activeStmts;
    }

    public void cancelStatement(long stmtId, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatement(token, stmtId, false, "cancelStatement");
            stmtHolder.getStatement().cancel();
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void cancelCurrentStatement(long connId, ByteBuffer token) throws SnappyException {
        try {
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            Statement activeStatement = connHolder.uniqueActiveStatement(true);
            if (activeStatement != null) {
                activeStatement.cancel();
            }
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void closeStatement(long stmtId, ByteBuffer token) throws SnappyException {
        ConnectionHolder connHolder = null;
        Statement stmt = null;
        try {
            ConnectionHolder.StatementHolder stmtHolder = this.getStatement(token, stmtId, false, "closeStatement");
            connHolder = stmtHolder.getConnectionHolder();
            stmt = stmtHolder.getStatement();
            stmtHolder.setStatus("CLOSING STATEMENT");
            connHolder.setActiveStatement(stmtHolder);
            connHolder.closeStatement(stmtHolder, this);
            if (connHolder != null) {
                connHolder.clearActiveStatement(stmt);
            }
        }
        catch (Throwable t) {
            try {
                this.checkSystemFailure(t);
                throw this.SnappyException(t);
            }
            catch (Throwable throwable) {
                if (connHolder != null) {
                    connHolder.clearActiveStatement(stmt);
                }
                throw throwable;
            }
        }
    }

    private SnappyExceptionData snappyWarning(SQLWarning warnings) throws SQLException {
        SnappyExceptionData warningData = new SnappyExceptionData(warnings.getMessage(), warnings.getErrorCode()).setSqlState(warnings.getSQLState());
        ArrayList<SnappyExceptionData> nextWarnings = null;
        SQLWarning next = warnings.getNextWarning();
        if (next != null) {
            nextWarnings = new ArrayList<SnappyExceptionData>();
            do {
                nextWarnings.add(new SnappyExceptionData(next.getMessage(), next.getErrorCode()).setSqlState(next.getSQLState()));
            } while ((next = next.getNextWarning()) != null);
        }
        if (nextWarnings != null) {
            warningData.setReason(warningData.getReason() + nextWarnings.toString());
        }
        return warningData;
    }

    private void fillWarnings(StatementResult sr, Statement stmt) throws SQLException {
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            sr.setWarnings(this.snappyWarning(warnings));
        }
    }

    private void fillWarnings(UpdateResult ur, Statement stmt) throws SQLException {
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            ur.setWarnings(this.snappyWarning(warnings));
        }
    }

    private void fillWarnings(RowSet rs, ResultSet resultSet) throws SQLException {
        SQLWarning warnings = resultSet.getWarnings();
        if (warnings != null) {
            rs.setWarnings(this.snappyWarning(warnings));
        }
    }

    private SnappyException internalException(String message) {
        SnappyExceptionData exData = new SnappyExceptionData();
        exData.setReason(message);
        exData.setSqlState("XJ001.U");
        exData.setErrorCode(0);
        return new SnappyException(exData, this.getServerInfo());
    }

    private SnappyException notImplementedException(String method) {
        SnappyExceptionData exData = new SnappyExceptionData();
        exData.setReason("ASSERT: " + method + "() not implemented");
        exData.setSqlState("0A000.S.2");
        exData.setErrorCode(20000);
        return new SnappyException(exData, this.getServerInfo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long sendBlobChunk(BlobChunk chunk, long connId, ByteBuffer token) throws SnappyException {
        try {
            Blob blob;
            long lobId;
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            if (chunk.isSetLobId()) {
                lobId = chunk.lobId;
                Object lob = conn.getLOBMapping(lobId);
                if (!(lob instanceof Blob)) throw Util.generateCsSQLException("XJ217.S");
                blob = (Blob)lob;
            } else {
                blob = conn.createBlob();
                lobId = ((EngineLOB)((Object)blob)).getLocator();
            }
            long offset = 1L;
            if (chunk.isSetOffset()) {
                offset += chunk.offset;
            }
            blob.setBytes(offset, chunk.getChunk());
            chunk.free();
            return lobId;
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long sendClobChunk(ClobChunk chunk, long connId, ByteBuffer token) throws SnappyException {
        try {
            Clob clob;
            long lobId;
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            if (chunk.isSetLobId()) {
                lobId = chunk.lobId;
                Object lob = conn.getLOBMapping(lobId);
                if (!(lob instanceof Clob)) throw Util.generateCsSQLException("XJ217.S");
                clob = (Clob)lob;
            } else {
                clob = conn.createClob();
                lobId = ((EngineLOB)((Object)clob)).getLocator();
            }
            long offset = 1L;
            if (chunk.isSetOffset()) {
                offset += chunk.offset;
            }
            clob.setString(offset, chunk.getChunk());
            return lobId;
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public void freeLob(long connId, long lobId, ByteBuffer token) throws SnappyException {
        try {
            EngineConnection conn = this.getValidConnection(connId, token).getConnection();
            Object lob = conn.getLOBMapping(lobId);
            if (!(lob instanceof EngineLOB)) {
                throw Util.generateCsSQLException("XJ217.S");
            }
            ((EngineLOB)lob).free();
            conn.removeLOBMapping(lobId);
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public ServiceMetaData getServiceMetaData(long connId, ByteBuffer token) throws SnappyException {
        try {
            int[] concurTypes;
            int[] rsTypes;
            int[] isolationLevels;
            RowIdLifetime rowIdLifeTime;
            ConnectionHolder connHolder = this.getValidConnection(connId, token);
            EmbedDatabaseMetaData dmd = (EmbedDatabaseMetaData)connHolder.getConnection().getMetaData();
            ServiceMetaData metadata = new ServiceMetaData().setCatalogSeparator(dmd.getCatalogSeparator()).setCatalogTerm(dmd.getCatalogTerm()).setDateTimeFunctions(this.toList(dmd.getTimeDateFunctions())).setDefaultResultSetHoldabilityHoldCursorsOverCommit(dmd.getResultSetHoldability() == 1).setDefaultResultSetType((byte)1).setDefaultTransactionIsolation(0).setExtraNameCharacters(dmd.getExtraNameCharacters()).setCatalogAtStart(dmd.isCatalogAtStart()).setIdentifierQuote(dmd.getIdentifierQuoteString()).setJdbcMajorVersion(dmd.getJDBCMajorVersion()).setJdbcMinorVersion(dmd.getJDBCMinorVersion()).setMaxBinaryLiteralLength(dmd.getMaxBinaryLiteralLength()).setMaxCatalogNameLength(dmd.getMaxCatalogNameLength()).setMaxCharLiteralLength(dmd.getMaxCharLiteralLength()).setMaxColumnNameLength(dmd.getMaxColumnNameLength()).setMaxColumnsInGroupBy(dmd.getMaxColumnsInGroupBy()).setMaxColumnsInIndex(dmd.getMaxColumnsInIndex()).setMaxColumnsInOrderBy(dmd.getMaxColumnsInOrderBy()).setMaxColumnsInSelect(dmd.getMaxColumnsInSelect()).setMaxColumnsInTable(dmd.getMaxColumnsInTable()).setMaxConnections(dmd.getMaxConnections()).setMaxCursorNameLength(dmd.getMaxCursorNameLength()).setMaxIndexLength(dmd.getMaxIndexLength()).setMaxOpenStatements(dmd.getMaxStatements()).setMaxProcedureNameLength(dmd.getMaxProcedureNameLength()).setMaxRowSize(dmd.getMaxRowSize()).setMaxSchemaNameLength(dmd.getMaxSchemaNameLength()).setMaxStatementLength(dmd.getMaxStatementLength()).setMaxTableNameLength(dmd.getMaxTableNameLength()).setMaxTableNamesInSelect(dmd.getMaxTablesInSelect()).setMaxUserNameLength(dmd.getMaxUserNameLength()).setNumericFunctions(this.toList(dmd.getNumericFunctions())).setProcedureTerm(dmd.getProcedureTerm()).setProductMajorVersion(dmd.getDatabaseMajorVersion()).setProductMinorVersion(dmd.getDatabaseMinorVersion()).setProductName(dmd.getDatabaseProductName()).setProductVersion(dmd.getDatabaseProductVersion()).setSchemaTerm(dmd.getSchemaTerm()).setSearchStringEscape(dmd.getSearchStringEscape()).setSqlKeywords(this.toList(dmd.getSQLKeywords())).setSqlStateIsXOpen(dmd.getSQLStateType() == 1).setStringFunctions(this.toList(dmd.getStringFunctions())).setSystemFunctions(this.toList(dmd.getSystemFunctions()));
            EnumMap txDefaults = ThriftUtils.newTransactionFlags();
            SystemProperties sysProps = SystemProperties.getServerInstance();
            txDefaults.put(TransactionAttribute.AUTOCOMMIT, false);
            txDefaults.put(TransactionAttribute.DISABLE_BATCHING, sysProps.getBoolean("gemfirexd.disable-tx-batching", false));
            txDefaults.put(TransactionAttribute.READ_ONLY_CONNECTION, dmd.isReadOnly());
            txDefaults.put(TransactionAttribute.SYNC_COMMITS, sysProps.getBoolean("gemfirexd.sync-commits", false));
            txDefaults.put(TransactionAttribute.WAITING_MODE, sysProps.getBoolean("gemfirexd.enable-tx-wait-mode", false));
            metadata.setTransactionDefaults((Map)txDefaults);
            switch (dmd.getRowIdLifetime()) {
                case ROWID_VALID_OTHER: {
                    rowIdLifeTime = RowIdLifetime.ROWID_VALID_OTHER;
                    break;
                }
                case ROWID_VALID_FOREVER: {
                    rowIdLifeTime = RowIdLifetime.ROWID_VALID_FOREVER;
                    break;
                }
                case ROWID_VALID_SESSION: {
                    rowIdLifeTime = RowIdLifetime.ROWID_VALID_SESSION;
                    break;
                }
                case ROWID_VALID_TRANSACTION: {
                    rowIdLifeTime = RowIdLifetime.ROWID_VALID_TRANSACTION;
                    break;
                }
                default: {
                    rowIdLifeTime = RowIdLifetime.ROWID_UNSUPPORTED;
                }
            }
            metadata.setRowIdLifeTime(rowIdLifeTime);
            HashSet<ServiceFeature> supportedFeatures = new HashSet<ServiceFeature>();
            if (dmd.supportsAlterTableWithAddColumn()) {
                supportedFeatures.add(ServiceFeature.ALTER_TABLE_ADD_COLUMN);
            }
            if (dmd.supportsAlterTableWithDropColumn()) {
                supportedFeatures.add(ServiceFeature.ALTER_TABLE_DROP_COLUMN);
            }
            if (dmd.supportsANSI92EntryLevelSQL()) {
                supportedFeatures.add(ServiceFeature.SQL_GRAMMAR_ANSI92_ENTRY);
            }
            if (dmd.supportsANSI92FullSQL()) {
                supportedFeatures.add(ServiceFeature.SQL_GRAMMAR_ANSI92_FULL);
            }
            if (dmd.supportsANSI92IntermediateSQL()) {
                supportedFeatures.add(ServiceFeature.SQL_GRAMMAR_ANSI92_INTERMEDIATE);
            }
            if (dmd.supportsBatchUpdates()) {
                supportedFeatures.add(ServiceFeature.BATCH_UPDATES);
            }
            if (dmd.supportsCatalogsInDataManipulation()) {
                supportedFeatures.add(ServiceFeature.CATALOGS_IN_DMLS);
            }
            if (dmd.supportsCatalogsInIndexDefinitions()) {
                supportedFeatures.add(ServiceFeature.CATALOGS_IN_INDEX_DEFS);
            }
            if (dmd.supportsCatalogsInPrivilegeDefinitions()) {
                supportedFeatures.add(ServiceFeature.CATALOGS_IN_PRIVILEGE_DEFS);
            }
            if (dmd.supportsCatalogsInProcedureCalls()) {
                supportedFeatures.add(ServiceFeature.CATALOGS_IN_PROCEDURE_CALLS);
            }
            if (dmd.supportsCatalogsInTableDefinitions()) {
                supportedFeatures.add(ServiceFeature.CATALOGS_IN_TABLE_DEFS);
            }
            if (dmd.supportsColumnAliasing()) {
                supportedFeatures.add(ServiceFeature.COLUMN_ALIASING);
            }
            if (dmd.supportsConvert()) {
                supportedFeatures.add(ServiceFeature.CONVERT);
            }
            if (dmd.supportsCoreSQLGrammar()) {
                supportedFeatures.add(ServiceFeature.SQL_GRAMMAR_CORE);
            }
            if (dmd.supportsCorrelatedSubqueries()) {
                supportedFeatures.add(ServiceFeature.SUBQUERIES_CORRELATED);
            }
            if (dmd.supportsDataDefinitionAndDataManipulationTransactions()) {
                supportedFeatures.add(ServiceFeature.TRANSACTIONS_BOTH_DMLS_AND_DDLS);
            }
            if (dmd.supportsDataManipulationTransactionsOnly()) {
                supportedFeatures.add(ServiceFeature.TRANSACTIONS_DMLS_ONLY);
            }
            if (dmd.supportsDifferentTableCorrelationNames()) {
                supportedFeatures.add(ServiceFeature.TABLE_CORRELATION_NAMES_DIFFERENT);
            }
            if (dmd.supportsExpressionsInOrderBy()) {
                supportedFeatures.add(ServiceFeature.ORDER_BY_EXPRESSIONS);
            }
            if (dmd.supportsExtendedSQLGrammar()) {
                supportedFeatures.add(ServiceFeature.SQL_GRAMMAR_EXTENDED);
            }
            if (dmd.supportsFullOuterJoins()) {
                supportedFeatures.add(ServiceFeature.OUTER_JOINS_FULL);
            }
            if (dmd.supportsGetGeneratedKeys()) {
                supportedFeatures.add(ServiceFeature.GENERATED_KEYS_RETRIEVAL);
            }
            if (dmd.supportsGroupBy()) {
                supportedFeatures.add(ServiceFeature.GROUP_BY);
            }
            if (dmd.supportsGroupByBeyondSelect()) {
                supportedFeatures.add(ServiceFeature.GROUP_BY_BEYOND_SELECT);
            }
            if (dmd.supportsGroupByUnrelated()) {
                supportedFeatures.add(ServiceFeature.GROUP_BY_UNRELATED);
            }
            if (dmd.supportsIntegrityEnhancementFacility()) {
                supportedFeatures.add(ServiceFeature.INTEGRITY_ENHANCEMENT);
            }
            if (dmd.supportsLikeEscapeClause()) {
                supportedFeatures.add(ServiceFeature.LIKE_ESCAPE);
            }
            if (dmd.supportsLimitedOuterJoins()) {
                supportedFeatures.add(ServiceFeature.OUTER_JOINS_LIMITED);
            }
            if (dmd.supportsMinimumSQLGrammar()) {
                supportedFeatures.add(ServiceFeature.SQL_GRAMMAR_MINIMUM);
            }
            if (dmd.supportsMixedCaseIdentifiers()) {
                supportedFeatures.add(ServiceFeature.MIXEDCASE_IDENTIFIERS);
            }
            if (dmd.supportsMixedCaseQuotedIdentifiers()) {
                supportedFeatures.add(ServiceFeature.MIXEDCASE_QUOTED_IDENTIFIERS);
            }
            if (dmd.supportsMultipleOpenResults()) {
                supportedFeatures.add(ServiceFeature.MULTIPLE_RESULTSETS);
            }
            if (dmd.supportsMultipleTransactions()) {
                supportedFeatures.add(ServiceFeature.MULTIPLE_TRANSACTIONS);
            }
            if (dmd.supportsNamedParameters()) {
                supportedFeatures.add(ServiceFeature.CALLABLE_NAMED_PARAMETERS);
            }
            if (dmd.supportsNonNullableColumns()) {
                supportedFeatures.add(ServiceFeature.NON_NULLABLE_COLUMNS);
            }
            if (dmd.supportsOpenCursorsAcrossCommit()) {
                supportedFeatures.add(ServiceFeature.OPEN_CURSORS_ACROSS_COMMIT);
            }
            if (dmd.supportsOpenCursorsAcrossRollback()) {
                supportedFeatures.add(ServiceFeature.OPEN_CURSORS_ACROSS_ROLLBACK);
            }
            if (dmd.supportsOpenStatementsAcrossCommit()) {
                supportedFeatures.add(ServiceFeature.OPEN_STATEMENTS_ACROSS_COMMIT);
            }
            if (dmd.supportsOpenStatementsAcrossRollback()) {
                supportedFeatures.add(ServiceFeature.OPEN_STATEMENTS_ACROSS_ROLLBACK);
            }
            if (dmd.supportsOrderByUnrelated()) {
                supportedFeatures.add(ServiceFeature.ORDER_BY_UNRELATED);
            }
            if (dmd.supportsOuterJoins()) {
                supportedFeatures.add(ServiceFeature.OUTER_JOINS);
            }
            if (dmd.supportsPositionedDelete()) {
                supportedFeatures.add(ServiceFeature.POSITIONED_DELETE);
            }
            if (dmd.supportsPositionedUpdate()) {
                supportedFeatures.add(ServiceFeature.POSITIONED_UPDATE);
            }
            if (dmd.supportsResultSetHoldability(2)) {
                supportedFeatures.add(ServiceFeature.RESULTSET_HOLDABILITY_CLOSE_CURSORS_AT_COMMIT);
            }
            if (dmd.supportsResultSetHoldability(1)) {
                supportedFeatures.add(ServiceFeature.RESULTSET_HOLDABILITY_HOLD_CURSORS_OVER_COMMIT);
            }
            if (dmd.supportsResultSetType(1003)) {
                supportedFeatures.add(ServiceFeature.RESULTSET_FORWARD_ONLY);
            }
            if (dmd.supportsResultSetType(1004)) {
                supportedFeatures.add(ServiceFeature.RESULTSET_SCROLL_INSENSITIVE);
            }
            if (dmd.supportsResultSetType(1005)) {
                supportedFeatures.add(ServiceFeature.RESULTSET_SCROLL_SENSITIVE);
            }
            if (dmd.supportsSavepoints()) {
                supportedFeatures.add(ServiceFeature.TRANSACTIONS_SAVEPOINTS);
            }
            if (dmd.supportsSchemasInDataManipulation()) {
                supportedFeatures.add(ServiceFeature.SCHEMAS_IN_DMLS);
            }
            if (dmd.supportsSchemasInIndexDefinitions()) {
                supportedFeatures.add(ServiceFeature.SCHEMAS_IN_INDEX_DEFS);
            }
            if (dmd.supportsSchemasInPrivilegeDefinitions()) {
                supportedFeatures.add(ServiceFeature.SCHEMAS_IN_PRIVILEGE_DEFS);
            }
            if (dmd.supportsSchemasInProcedureCalls()) {
                supportedFeatures.add(ServiceFeature.SCHEMAS_IN_PROCEDURE_CALLS);
            }
            if (dmd.supportsSchemasInTableDefinitions()) {
                supportedFeatures.add(ServiceFeature.SCHEMAS_IN_TABLE_DEFS);
            }
            if (dmd.supportsSelectForUpdate()) {
                supportedFeatures.add(ServiceFeature.SELECT_FOR_UPDATE);
            }
            if (dmd.supportsStatementPooling()) {
                supportedFeatures.add(ServiceFeature.STATEMENT_POOLING);
            }
            if (dmd.supportsStoredFunctionsUsingCallSyntax()) {
                supportedFeatures.add(ServiceFeature.STORED_FUNCTIONS_USING_CALL);
            }
            if (dmd.supportsStoredProcedures()) {
                supportedFeatures.add(ServiceFeature.STORED_PROCEDURES);
            }
            if (dmd.supportsSubqueriesInComparisons()) {
                supportedFeatures.add(ServiceFeature.SUBQUERIES_IN_COMPARISONS);
            }
            if (dmd.supportsSubqueriesInExists()) {
                supportedFeatures.add(ServiceFeature.SUBQUERIES_IN_EXISTS);
            }
            if (dmd.supportsSubqueriesInIns()) {
                supportedFeatures.add(ServiceFeature.SUBQUERIES_IN_INS);
            }
            if (dmd.supportsSubqueriesInQuantifieds()) {
                supportedFeatures.add(ServiceFeature.SUBQUERIES_IN_QUANTIFIEDS);
            }
            if (dmd.supportsTableCorrelationNames()) {
                supportedFeatures.add(ServiceFeature.TABLE_CORRELATION_NAMES);
            }
            if (dmd.supportsTransactions()) {
                supportedFeatures.add(ServiceFeature.TRANSACTIONS);
            }
            if (dmd.supportsUnion()) {
                supportedFeatures.add(ServiceFeature.UNION);
            }
            if (dmd.supportsUnionAll()) {
                supportedFeatures.add(ServiceFeature.UNION_ALL);
            }
            if (dmd.allProceduresAreCallable()) {
                supportedFeatures.add(ServiceFeature.ALL_PROCEDURES_CALLABLE);
            }
            if (dmd.allTablesAreSelectable()) {
                supportedFeatures.add(ServiceFeature.ALL_TABLES_SELECTABLE);
            }
            if (dmd.autoCommitFailureClosesAllResultSets()) {
                supportedFeatures.add(ServiceFeature.AUTOCOMMIT_FAILURE_CLOSES_ALL_RESULTSETS);
            }
            if (dmd.dataDefinitionCausesTransactionCommit()) {
                supportedFeatures.add(ServiceFeature.TRANSACTIONS_DDLS_IMPLICIT_COMMIT);
            }
            if (dmd.dataDefinitionIgnoredInTransactions()) {
                supportedFeatures.add(ServiceFeature.TRANSACTIONS_DDLS_IGNORED);
            }
            if (dmd.doesMaxRowSizeIncludeBlobs()) {
                supportedFeatures.add(ServiceFeature.MAX_ROWSIZE_INCLUDES_BLOBSIZE);
            }
            if (dmd.generatedKeyAlwaysReturned()) {
                supportedFeatures.add(ServiceFeature.GENERATED_KEYS_ALWAYS_RETURNED);
            }
            if (dmd.locatorsUpdateCopy()) {
                supportedFeatures.add(ServiceFeature.LOB_UPDATES_COPY);
            }
            if (dmd.nullPlusNonNullIsNull()) {
                supportedFeatures.add(ServiceFeature.NULL_CONCAT_NON_NULL_IS_NULL);
            }
            if (dmd.nullsAreSortedAtEnd()) {
                supportedFeatures.add(ServiceFeature.NULLS_SORTED_END);
            }
            if (dmd.nullsAreSortedAtStart()) {
                supportedFeatures.add(ServiceFeature.NULLS_SORTED_START);
            }
            if (dmd.nullsAreSortedHigh()) {
                supportedFeatures.add(ServiceFeature.NULLS_SORTED_HIGH);
            }
            if (dmd.nullsAreSortedLow()) {
                supportedFeatures.add(ServiceFeature.NULLS_SORTED_LOW);
            }
            if (dmd.storesLowerCaseIdentifiers()) {
                supportedFeatures.add(ServiceFeature.STORES_LOWERCASE_IDENTIFIERS);
            }
            if (dmd.storesLowerCaseQuotedIdentifiers()) {
                supportedFeatures.add(ServiceFeature.STORES_LOWERCASE_QUOTED_IDENTIFIERS);
            }
            if (dmd.storesMixedCaseIdentifiers()) {
                supportedFeatures.add(ServiceFeature.STORES_MIXEDCASE_IDENTIFIERS);
            }
            if (dmd.storesMixedCaseQuotedIdentifiers()) {
                supportedFeatures.add(ServiceFeature.STORES_MIXEDCASE_QUOTED_IDENTIFIERS);
            }
            if (dmd.storesUpperCaseIdentifiers()) {
                supportedFeatures.add(ServiceFeature.STORES_UPPERCASE_IDENTIFIERS);
            }
            if (dmd.storesUpperCaseQuotedIdentifiers()) {
                supportedFeatures.add(ServiceFeature.STORES_UPPERCASE_QUOTED_IDENTIFIERS);
            }
            if (dmd.usesLocalFilePerTable()) {
                supportedFeatures.add(ServiceFeature.USES_LOCAL_FILE_PER_TABLE);
            }
            if (dmd.usesLocalFiles()) {
                supportedFeatures.add(ServiceFeature.USES_LOCAL_FILES);
            }
            metadata.setSupportedFeatures(supportedFeatures);
            int[] allTypes = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -16, -4, -1, -15, 2011, 0, 2, -9, 1111, 7, 2006, -8, 5, 2009, 2002, 92, 93, -6, -3, 12, 4001, 4002};
            HashMap convertMap = new HashMap();
            for (int fromType : allTypes) {
                HashSet<SnappyType> supportedConverts = new HashSet<SnappyType>();
                int[] nArray = allTypes;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int toType = nArray[i];
                    if (!dmd.supportsConvert(fromType, toType)) continue;
                    supportedConverts.add(Converters.getThriftSQLType((int)toType));
                }
                if (supportedConverts.isEmpty()) continue;
                convertMap.put(Converters.getThriftSQLType((int)fromType), supportedConverts);
            }
            metadata.setSupportedCONVERT(convertMap);
            HashMap featureParameters = new HashMap();
            ArrayList<Integer> supportedValues = new ArrayList<Integer>(4);
            for (int isolationLevel : isolationLevels = new int[]{0, 1, 2, 4, 8}) {
                if (!dmd.supportsTransactionIsolationLevel(isolationLevel)) continue;
                supportedValues.add(Integer.valueOf(Converters.getThriftTransactionIsolation((int)isolationLevel)));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.TRANSACTIONS_SUPPORT_ISOLATION, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes = new int[]{1003, 1004, 1005}) {
                if (!dmd.supportsResultSetType(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_TYPE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int concurType : concurTypes = new int[]{1007, 1008}) {
                ServiceFeatureParameterized thriftConcurType = concurType == 1007 ? ServiceFeatureParameterized.RESULTSET_CONCURRENCY_READ_ONLY : ServiceFeatureParameterized.RESULTSET_CONCURRENCY_UPDATABLE;
                for (int rsType : rsTypes) {
                    if (!dmd.supportsResultSetConcurrency(rsType, concurType)) continue;
                    supportedValues.add(Converters.getThriftResultSetType((int)rsType));
                }
                if (supportedValues.isEmpty()) continue;
                featureParameters.put(thriftConcurType, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.ownUpdatesAreVisible(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_OWN_UPDATES_VISIBLE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.ownDeletesAreVisible(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_OWN_DELETES_VISIBLE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.ownInsertsAreVisible(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_OWN_INSERTS_VISIBLE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.othersUpdatesAreVisible(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_OTHERS_UPDATES_VISIBLE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.othersDeletesAreVisible(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_OTHERS_DELETES_VISIBLE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.othersInsertsAreVisible(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_OTHERS_INSERTS_VISIBLE, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.updatesAreDetected(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_UPDATES_DETECTED, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.deletesAreDetected(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_DELETES_DETECTED, supportedValues);
                supportedValues = new ArrayList(4);
            }
            for (int rsType : rsTypes) {
                if (!dmd.insertsAreDetected(rsType)) continue;
                supportedValues.add(Converters.getThriftResultSetType((int)rsType));
            }
            if (!supportedValues.isEmpty()) {
                featureParameters.put(ServiceFeatureParameterized.RESULTSET_INSERTS_DETECTED, supportedValues);
            }
            metadata.setFeaturesWithParams(featureParameters);
            return metadata;
        }
        catch (Throwable t) {
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    private ArrayList<String> toList(String csv) {
        ArrayList<String> strings = new ArrayList<String>();
        SharedUtils.splitCSV((String)csv, (SharedUtils.CSVVisitor)SharedUtils.stringAggregator, strings, (Object)Boolean.TRUE);
        return strings;
    }

    public RowSet getSchemaMetaData(ServiceMetaDataCall schemaCall, ServiceMetaDataArgs args) throws SnappyException {
        ResultSet rs = null;
        try {
            ConnectionHolder connHolder = this.getValidConnection(args.connId, args.token);
            EmbedDatabaseMetaData dmd = (EmbedDatabaseMetaData)connHolder.getConnection().getMetaData();
            boolean isODBC = args.getDriverType() == 2;
            switch (schemaCall) {
                case ATTRIBUTES: {
                    rs = dmd.getAttributes(null, args.getSchema(), args.getTypeName(), args.getAttributeName());
                    break;
                }
                case CATALOGS: {
                    rs = dmd.getCatalogs();
                    break;
                }
                case CLIENTINFOPROPS: {
                    rs = dmd.getClientInfoProperties();
                    break;
                }
                case COLUMNPRIVILEGES: {
                    rs = dmd.getColumnPrivileges(null, args.getSchema(), args.getTable(), args.getColumnName());
                    break;
                }
                case COLUMNS: {
                    if (isODBC) {
                        rs = dmd.getColumnsForODBC(null, args.getSchema(), args.getTable(), args.getColumnName());
                        break;
                    }
                    rs = dmd.getColumns(null, args.getSchema(), args.getTable(), args.getColumnName());
                    break;
                }
                case CROSSREFERENCE: {
                    if (isODBC) {
                        rs = dmd.getCrossReferenceForODBC(null, args.getSchema(), args.getTable(), null, args.getForeignSchema(), args.getForeignTable());
                        break;
                    }
                    rs = dmd.getCrossReference(null, args.getSchema(), args.getTable(), null, args.getForeignSchema(), args.getForeignTable());
                    break;
                }
                case EXPORTEDKEYS: {
                    rs = dmd.getExportedKeys(null, args.getSchema(), args.getTable());
                    break;
                }
                case FUNCTIONCOLUMNS: {
                    rs = dmd.getFunctionColumns(null, args.getSchema(), args.getFunctionName(), args.getColumnName());
                    break;
                }
                case FUNCTIONS: {
                    rs = dmd.getFunctions(null, args.getSchema(), args.getFunctionName());
                    break;
                }
                case IMPORTEDKEYS: {
                    rs = dmd.getImportedKeys(null, args.getSchema(), args.getTable());
                    break;
                }
                case PRIMARYKEYS: {
                    rs = dmd.getPrimaryKeys(null, args.getSchema(), args.getTable());
                    break;
                }
                case PROCEDURECOLUMNS: {
                    if (isODBC) {
                        rs = dmd.getProcedureColumnsForODBC(null, args.getSchema(), args.getProcedureName(), args.getColumnName());
                        break;
                    }
                    rs = dmd.getProcedureColumns(null, args.getSchema(), args.getProcedureName(), args.getColumnName());
                    break;
                }
                case PROCEDURES: {
                    if (isODBC) {
                        rs = dmd.getProceduresForODBC(null, args.getSchema(), args.getProcedureName());
                        break;
                    }
                    rs = dmd.getProcedures(null, args.getSchema(), args.getProcedureName());
                    break;
                }
                case PSEUDOCOLUMNS: {
                    rs = dmd.getPseudoColumns(null, args.getSchema(), args.getTable(), args.getColumnName());
                    break;
                }
                case SCHEMAS: {
                    if (args.getSchema() != null) {
                        rs = dmd.getSchemas(null, args.getSchema());
                        break;
                    }
                    rs = dmd.getSchemas();
                    break;
                }
                case SUPERTABLES: {
                    rs = dmd.getSuperTables(null, args.getSchema(), args.getTypeName());
                    break;
                }
                case SUPERTYPES: {
                    rs = dmd.getSuperTypes(null, args.getSchema(), args.getTypeName());
                    break;
                }
                case TABLEPRIVILEGES: {
                    rs = dmd.getTablePrivileges(null, args.getSchema(), args.getTable());
                    break;
                }
                case TABLES: {
                    List tableTypes = args.getTableTypes();
                    String[] types = null;
                    if (tableTypes != null && !tableTypes.isEmpty()) {
                        types = tableTypes.toArray(new String[tableTypes.size()]);
                    }
                    if (isODBC && "%".equals(args.getSchema()) && args.getTable() != null && args.getTable().isEmpty()) {
                        rs = dmd.getTableSchemas();
                        break;
                    }
                    rs = dmd.getTables(null, args.getSchema(), args.getTable(), types);
                    break;
                }
                case TABLETYPES: {
                    rs = dmd.getTableTypes();
                    break;
                }
                case TYPEINFO: {
                    if (isODBC) {
                        rs = dmd.getTypeInfoForODBC((short)(args.isSetTypeId() ? Converters.getJdbcType((SnappyType)args.getTypeId()) : 0));
                        break;
                    }
                    rs = dmd.getTypeInfo();
                    break;
                }
                case VERSIONCOLUMNS: {
                    if (isODBC) {
                        rs = dmd.getVersionColumnsForODBC(null, args.getSchema(), args.getTable());
                        break;
                    }
                    rs = dmd.getVersionColumns(null, args.getSchema(), args.getTable());
                    break;
                }
                default: {
                    throw this.internalException("unexpected metadata call: " + schemaCall);
                }
            }
            return this.getRowSet(null, null, rs, 0L, null, args.connId, null, 0, false, false, 0, connHolder, "getSchemaMetaData");
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public RowSet getIndexInfo(ServiceMetaDataArgs args, boolean unique, boolean approximate) throws SnappyException {
        ResultSet rs = null;
        try {
            ConnectionHolder connHolder = this.getValidConnection(args.connId, args.token);
            EmbedDatabaseMetaData dmd = (EmbedDatabaseMetaData)connHolder.getConnection().getMetaData();
            boolean isODBC = args.getDriverType() == 2;
            rs = isODBC ? dmd.getIndexInfoForODBC(null, args.getSchema(), args.getTable(), unique, approximate) : dmd.getIndexInfo(null, args.getSchema(), args.getTable(), unique, approximate);
            return this.getRowSet(null, null, rs, 0L, null, args.connId, null, 0, false, false, 0, connHolder, "getIndexInfo");
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public RowSet getUDTs(ServiceMetaDataArgs args, List<SnappyType> types) throws SnappyException {
        ResultSet rs = null;
        try {
            ConnectionHolder connHolder = this.getValidConnection(args.connId, args.token);
            EmbedDatabaseMetaData dmd = (EmbedDatabaseMetaData)connHolder.getConnection().getMetaData();
            int[] sqlTypes = null;
            if (types != null && !types.isEmpty()) {
                sqlTypes = new int[types.size()];
                for (int index = 0; index < types.size(); ++index) {
                    sqlTypes[index] = Converters.getJdbcType((SnappyType)types.get(index));
                }
            }
            rs = dmd.getUDTs(null, args.getSchema(), args.getTypeName(), sqlTypes);
            return this.getRowSet(null, null, rs, 0L, null, args.connId, null, 0, false, false, 0, connHolder, "getUDTs");
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public RowSet getBestRowIdentifier(ServiceMetaDataArgs args, int scope, boolean nullable) throws SnappyException {
        ResultSet rs = null;
        try {
            ConnectionHolder connHolder = this.getValidConnection(args.connId, args.token);
            EmbedDatabaseMetaData dmd = (EmbedDatabaseMetaData)connHolder.getConnection().getMetaData();
            boolean isODBC = args.getDriverType() == 2;
            rs = isODBC ? dmd.getBestRowIdentifierForODBC(null, args.getSchema(), args.getTable(), scope, nullable) : dmd.getBestRowIdentifier(null, args.getSchema(), args.getTable(), scope, nullable);
            return this.getRowSet(null, null, rs, 0L, null, args.connId, null, 0, false, false, 0, connHolder, "getBestRowIdentifier");
        }
        catch (Throwable t) {
            this.cleanupResultSet(rs);
            this.checkSystemFailure(t);
            throw this.SnappyException(t);
        }
    }

    public static final class Processor
    extends SnappyDataService.Processor<SnappyDataServiceImpl> {
        private final SnappyDataServiceImpl inst;
        private final HashMap<String, ProcessFunction<SnappyDataServiceImpl, ?>> fnMap;

        public Processor(SnappyDataServiceImpl inst) {
            super((SnappyDataService.Iface)inst);
            this.inst = inst;
            this.fnMap = new HashMap(super.getProcessMapView());
        }

        public final boolean process(TProtocol in, TProtocol out) throws TException {
            TMessage msg = in.readMessageBegin();
            ProcessFunction<SnappyDataServiceImpl, ?> fn = this.fnMap.get(msg.name);
            if (fn != null) {
                fn.process(msg.seqid, in, out, (Object)this.inst);
                Class<?> fnClass = fn.getClass();
                if (fnClass == SnappyDataService.Processor.openConnection.class) {
                    String clientHostId = currentClientHostId.get();
                    currentClientHostId.remove();
                    ClientTracker tracker = ClientTracker.addOrGetTracker(clientHostId, this.inst);
                    if (tracker != null) {
                        tracker.addClientSocket(in.getTransport(), this.inst);
                    }
                } else if (fnClass == SnappyDataService.Processor.closeConnection.class) {
                    Boolean closeSocket = closeClientSocket.get();
                    closeClientSocket.remove();
                    return closeSocket == null || closeSocket == false;
                }
                return true;
            }
            TProtocolUtil.skip((TProtocol)in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }

        public void clientSocketClosed(TTransport clientTransport) {
            ClientTracker.removeClientSocket(clientTransport, this.inst);
        }
    }
}

