/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SqlXmlUtil;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue;

public class SqlXmlExecutor {
    private Activation activation;
    private int sqlXUtilId;
    private int targetTypeId;
    private int targetMaxWidth;
    private int targetCollationType;
    private boolean preserveWS;

    public SqlXmlExecutor(Activation activation, int utilId, boolean preserveWS) {
        this.activation = activation;
        this.sqlXUtilId = utilId;
        this.preserveWS = preserveWS;
    }

    public SqlXmlExecutor(int targetTypeId, int targetMaxWidth, int targetCollationType) {
        this.targetTypeId = targetTypeId;
        this.targetMaxWidth = targetMaxWidth;
        this.targetCollationType = targetCollationType;
    }

    public SqlXmlExecutor(Activation activation, int utilId) {
        this.activation = activation;
        this.sqlXUtilId = utilId;
    }

    public XMLDataValue XMLParse(StringDataValue xmlText, XMLDataValue result) throws StandardException {
        if (result == null) {
            result = new XML();
        }
        if (xmlText.isNull()) {
            result.setToNull();
            return result;
        }
        return result.XMLParse(xmlText.getString(), this.preserveWS, this.getSqlXmlUtil());
    }

    public StringDataValue XMLSerialize(XMLDataValue xmlVal, StringDataValue result) throws StandardException {
        return xmlVal.XMLSerialize(result, this.targetTypeId, this.targetMaxWidth, this.targetCollationType);
    }

    public BooleanDataValue XMLExists(StringDataValue xExpr, XMLDataValue xmlContext) throws StandardException {
        return xmlContext.XMLExists(this.getSqlXmlUtil());
    }

    public XMLDataValue XMLQuery(StringDataValue xExpr, XMLDataValue xmlContext, XMLDataValue result) throws StandardException {
        return xmlContext.XMLQuery(result, this.getSqlXmlUtil());
    }

    private SqlXmlUtil getSqlXmlUtil() throws StandardException {
        return (SqlXmlUtil)this.activation.getSavedObject(this.sqlXUtilId);
    }
}

