/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.List;

public class DropDiskStoreConstantAction
extends DDLConstantAction {
    private final String diskStoreName;
    private final boolean onlyIfExists;

    DropDiskStoreConstantAction(String diskStoreName, boolean onlyIfExists) {
        this.diskStoreName = diskStoreName;
        this.onlyIfExists = onlyIfExists;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return "__GFXD_INTERNAL_DISKSTORE_" + this.diskStoreName;
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        if (Misc.getMemStore().isSnappyStore()) {
            DropDiskStoreConstantAction.executeConstantAction(this.diskStoreName + "-SNAPPY-DELTA", this.onlyIfExists, activation);
        }
        DropDiskStoreConstantAction.executeConstantAction(this.diskStoreName, this.onlyIfExists, activation);
    }

    private static void executeConstantAction(String diskStoreName, boolean onlyIfExists, Activation activation) throws StandardException {
        if (!ServerGroupUtils.isDataStore()) {
            return;
        }
        if (diskStoreName.equals("GFXD-DEFAULT-DISKSTORE") || diskStoreName.equals("GFXD-DD-DISKSTORE") || diskStoreName.equals("SNAPPY-INTERNAL-DELTA")) {
            throw StandardException.newException("0A000.S", "Cannot DROP default diskstores");
        }
        GemFireCacheImpl cache = Misc.getGemFireCache();
        List<GemFireContainer> containers = Misc.getMemStore().getAllContainers();
        for (GemFireContainer container : containers) {
            String regionDiskStoreName;
            if (container.getRegion() == null || !container.isApplicationTable() || (regionDiskStoreName = container.getRegionAttributes().getDiskStoreName()) == null || !regionDiskStoreName.equalsIgnoreCase(diskStoreName)) continue;
            throw StandardException.newException("X0Y25.S", "DROP", (Object)("DiskStore " + diskStoreName), (Object)"table", (Object)container.getQualifiedTableName());
        }
        for (GatewaySender sender : cache.getGatewaySenders()) {
            if (!sender.getDiskStoreName().equalsIgnoreCase(diskStoreName)) continue;
            throw StandardException.newException("X0Y25.S", "DROP", (Object)("DiskStore " + diskStoreName), (Object)"gatewaysender", (Object)sender.getId());
        }
        for (AsyncEventQueue asyncQueue : cache.getAsyncEventQueues()) {
            if (!asyncQueue.getDiskStoreName().equalsIgnoreCase(diskStoreName)) continue;
            throw StandardException.newException("X0Y25.S", "DROP", (Object)("DiskStore " + diskStoreName), (Object)"asynceventqueue", (Object)asyncQueue.getId());
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
        keyRow.setColumn(1, new SQLVarchar(diskStoreName));
        TabInfoImpl ti = dd.getNonCoreTI(20);
        int rowsDeleted = ti.deleteRow(tc, keyRow, 0);
        if (rowsDeleted == 0) {
            if (onlyIfExists) {
                return;
            }
            throw StandardException.newException("42Y55", (Object)"DROP DISKSTORE", (Object)diskStoreName);
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropDiskStore:: removed DiskStore " + diskStoreName + " from SYS table"));
        DiskStoreImpl store = cache.findDiskStore(diskStoreName);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropDiskStore :: found DiskStore " + store));
        cache.removeDiskStore(store);
        store.destroy();
    }

    public String toString() {
        return this.constructToString("DROP DISKSTORE ", this.diskStoreName);
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

