/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.conn;

import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

final class TempTableInfo {
    private TableDescriptor td;
    private int declaredInSavepointLevel;
    private int droppededInSavepointLevel;
    private int dataModifiedInSavepointLevel;
    private long conglomId;
    private MemConglomerate conglomerate;

    TempTableInfo(TableDescriptor td, int declaredInSavepointLevel, MemConglomerate conglomerate) {
        this.td = td;
        this.declaredInSavepointLevel = declaredInSavepointLevel;
        this.droppededInSavepointLevel = -1;
        this.dataModifiedInSavepointLevel = -1;
        this.conglomId = conglomerate.getId().getContainerId();
        this.conglomerate = conglomerate;
    }

    TableDescriptor getTableDescriptor() {
        return this.td;
    }

    void setTableDescriptor(TableDescriptor td, TransactionController tran) {
        this.td = td;
        ConglomerateDescriptorList conglomList = td.getConglomerateDescriptorList();
        assert (conglomList.size() == 1) : "we don't expect multiple for temp tables";
        ConglomerateDescriptor conglomDesc = (ConglomerateDescriptor)conglomList.get(0);
        this.conglomId = conglomDesc.getConglomerateNumber();
        try {
            this.conglomerate = ((GemFireTransaction)tran).findConglomerate(this.conglomId);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("UnExpected exception ", e);
        }
    }

    boolean matches(String tableName) {
        return this.td.getName().equals(tableName) && this.droppededInSavepointLevel == -1;
    }

    int getModifiedInSavepointLevel() {
        return this.dataModifiedInSavepointLevel;
    }

    void setModifiedInSavepointLevel(int dataModifiedInSavepointLevel) {
        this.dataModifiedInSavepointLevel = dataModifiedInSavepointLevel;
    }

    int getDeclaredInSavepointLevel() {
        return this.declaredInSavepointLevel;
    }

    void setDeclaredInSavepointLevel(int declaredInSavepointLevel) {
        this.declaredInSavepointLevel = declaredInSavepointLevel;
    }

    int getDroppedInSavepointLevel() {
        return this.droppededInSavepointLevel;
    }

    public void setDroppedInSavepointLevel(int droppededInSavepointLevel) {
        this.droppededInSavepointLevel = droppededInSavepointLevel;
    }

    MemConglomerate getConglom() {
        return this.conglomerate;
    }

    public boolean matches(long conglomId) {
        return this.conglomId == conglomId;
    }
}

