/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTableNumbersVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class UnaryComparisonOperatorNode
extends UnaryOperatorNode {
    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        this.bindComparisonOperator();
        return this;
    }

    public void bindComparisonOperator() throws StandardException {
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        return this.getNegation(this.operand);
    }

    UnaryOperatorNode getNegation(ValueNode operand) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("expected to call getNegation() for subclass " + this.getClass().toString()));
        return this;
    }

    public ColumnReference getColumnOperand(Optimizable optTable, int columnPosition) {
        ColumnReference cr;
        SanityManager.ASSERT((boolean)(optTable instanceof FromBaseTable));
        FromBaseTable ft = (FromBaseTable)optTable;
        if (this.operand instanceof ColumnReference && (cr = (ColumnReference)this.operand).getTableNumber() == ft.getTableNumber() && cr.getSource().getColumnPosition() == columnPosition) {
            return cr;
        }
        return null;
    }

    public ColumnReference getColumnOperand(Optimizable optTable) {
        ColumnReference cr;
        if (this.operand instanceof ColumnReference && (cr = (ColumnReference)this.operand).getTableNumber() == optTable.getTableNumber()) {
            return cr;
        }
        return null;
    }

    public ValueNode getOperand(ColumnReference cRef, int refSetSize, boolean otherSide) {
        if (otherSide) {
            return null;
        }
        if (this.operand instanceof ColumnReference) {
            JBitSet cRefTables = new JBitSet(refSetSize);
            JBitSet crTables = new JBitSet(refSetSize);
            BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(crTables);
            ColumnReference cr = (ColumnReference)this.operand;
            try {
                cr.accept(btnVis);
                btnVis.setTableMap(cRefTables);
                cRef.accept(btnVis);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)"Failed when trying to find base table number for column reference check:", (Throwable)se);
            }
            crTables.and(cRefTables);
            if (crTables.getFirstSetBit() != -1 && cr.getSource().getColumnPosition() == cRef.getColumnNumber()) {
                return this.operand;
            }
        }
        return null;
    }

    public ValueNode getOtherOperand(ValueNode thisOperand) {
        return null;
    }

    public boolean selfComparison(ColumnReference cr) {
        SanityManager.ASSERT((cr == this.operand ? 1 : 0) != 0, (String)"ColumnReference not found in IsNullNode.");
        return false;
    }

    public ValueNode getExpressionOperand(int tableNumber, int columnNumber, FromTable ft) {
        return null;
    }

    public void generateExpressionOperand(Optimizable optTable, int columnPosition, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.generateNull(mb, this.operand.getTypeCompiler(), this.operand.getTypeServices().getCollationType());
    }

    public int getStartOperator(Optimizable optTable) {
        SanityManager.THROWASSERT((String)("getStartOperator not expected to be called for " + this.getClass().getName()));
        return 1;
    }

    public int getStopOperator(Optimizable optTable) {
        SanityManager.THROWASSERT((String)("getStopOperator not expected to be called for " + this.getClass().getName()));
        return -1;
    }

    public void generateOrderedNulls(MethodBuilder mb) {
        mb.push(true);
    }

    public void generateQualMethod(ExpressionClassBuilder acb, MethodBuilder mb, Optimizable optTable) throws StandardException {
        MethodBuilder qualMethod = acb.newUserExprFun();
        acb.generateNull(qualMethod, this.operand.getTypeCompiler(), this.operand.getTypeServices().getCollationType());
        qualMethod.methodReturn();
        qualMethod.complete();
        acb.pushMethodReference(mb, qualMethod);
    }

    public void generateAbsoluteColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        String columnName = this.getColumnName(optTable);
        mb.push(columnPosition);
        mb.push(columnName);
    }

    public void generateRelativeColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        columnPosition = optTable.convertAbsoluteToRelativeColumnPosition(columnPosition, null);
        String columnName = this.getColumnName(optTable);
        mb.push(columnPosition);
        mb.push(columnName);
    }

    private int getAbsoluteColumnPosition(Optimizable optTable) {
        ColumnReference cr = (ColumnReference)this.operand;
        int columnPosition = cr.getSource().getColumnPosition();
        ConglomerateDescriptor bestCD = optTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        SanityManager.ASSERT((optTable instanceof FromVTI || bestCD != null ? 1 : 0) != 0);
        if (bestCD != null && bestCD.isIndex()) {
            columnPosition = bestCD.getIndexDescriptor().getKeyColumnPosition(columnPosition);
            SanityManager.ASSERT((columnPosition > 0 ? 1 : 0) != 0, (String)"Base column not found in index");
        }
        return columnPosition - 1;
    }

    private String getColumnName(Optimizable optTable) {
        ColumnReference cr = (ColumnReference)this.operand;
        return cr.getColumnName();
    }

    public boolean orderedNulls() {
        return true;
    }

    public boolean isQualifier(Optimizable optTable, boolean forPush) {
        if (!(this.operand instanceof ColumnReference)) {
            return false;
        }
        ColumnReference cr = (ColumnReference)this.operand;
        FromTable ft = (FromTable)optTable;
        return cr.getTableNumber() == ft.getTableNumber();
    }

    public int getOrderableVariantType(Optimizable optTable) throws StandardException {
        return this.operand.getOrderableVariantType();
    }
}

