/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PrivilegeInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TablePrivilegeInfo;
import java.util.ArrayList;
import java.util.List;

public class TablePrivilegesNode
extends QueryTreeNode {
    private boolean[] actionAllowed = new boolean[7];
    private ResultColumnList[] columnLists = new ResultColumnList[7];
    private FormatableBitSet[] columnBitSets = new FormatableBitSet[7];
    private TableDescriptor td;
    private List descriptorList;

    public void addAll() {
        for (int i = 0; i < 7; ++i) {
            this.actionAllowed[i] = true;
            this.columnLists[i] = null;
        }
    }

    public void addAction(int action, ResultColumnList privilegeColumnList) {
        this.actionAllowed[action] = true;
        if (privilegeColumnList == null) {
            this.columnLists[action] = null;
        } else if (this.columnLists[action] == null) {
            this.columnLists[action] = privilegeColumnList;
        } else {
            this.columnLists[action].appendResultColumns(privilegeColumnList, false);
        }
    }

    public void bind(TableDescriptor td, boolean isGrant) throws StandardException {
        this.td = td;
        for (int action = 0; action < 7; ++action) {
            if (this.columnLists[action] != null) {
                this.columnBitSets[action] = this.columnLists[action].bindResultColumnsByName(td, null);
            }
            if (td.getTableType() != 2 || action == 0 || !this.actionAllowed[action]) continue;
            throw StandardException.newException("42509", td.getQualifiedName());
        }
        if (isGrant && td.getTableType() == 2) {
            this.bindPrivilegesForView(td);
        }
    }

    public PrivilegeInfo makePrivilegeInfo() {
        return new TablePrivilegeInfo(this.td, this.actionAllowed, this.columnBitSets, this.descriptorList);
    }

    private void bindPrivilegesForView(TableDescriptor td) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        ViewDescriptor vd = dd.getViewDescriptor(td);
        DependencyManager dm = dd.getDependencyManager();
        ProviderInfo[] pis = dm.getPersistentProviderInfos(vd);
        this.descriptorList = new ArrayList();
        int siz = pis.length;
        for (int i = 0; i < siz; ++i) {
            Provider provider = (Provider)pis[i].getDependableFinder().getDependable(dd, pis[i].getObjectId());
            if (!(provider instanceof TableDescriptor) && !(provider instanceof ViewDescriptor) && !(provider instanceof AliasDescriptor)) continue;
            this.descriptorList.add(provider);
        }
    }
}

