/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public final class LengthOperatorNode
extends UnaryOperatorNode {
    private int parameterType;
    private int parameterWidth;

    @Override
    public void setNodeType(int nodeType) {
        String operator = null;
        String methodName = null;
        if (nodeType == 23) {
            operator = "char_length";
            methodName = "charLength";
            this.parameterType = 12;
            this.parameterWidth = 32672;
        } else {
            SanityManager.THROWASSERT((String)("Unexpected nodeType = " + nodeType));
        }
        this.setOperator(operator);
        this.setMethodName(methodName);
        super.setNodeType(nodeType);
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId operandType = this.operand.getTypeId();
        switch (operandType.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)operandType.getSQLTypeName());
            }
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.parameterType, true, this.parameterWidth));
    }

    @Override
    public String getReceiverInterfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.ConcatableDataValue";
    }
}

