/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public final class IsNullNode
extends UnaryComparisonOperatorNode
implements RelationalOperator {
    private DataValueDescriptor nullValue;

    @Override
    public void setNodeType(int nodeType) {
        String methodName;
        String operator;
        if (nodeType == 25) {
            operator = "is null";
            methodName = "isNullOp";
        } else {
            if (nodeType != 24) {
                SanityManager.THROWASSERT((String)("Unexpected nodeType = " + nodeType));
            }
            operator = "is not null";
            methodName = "isNotNull";
        }
        this.setOperator(operator);
        this.setMethodName(methodName);
        super.setNodeType(nodeType);
    }

    @Override
    UnaryOperatorNode getNegation(ValueNode operand) throws StandardException {
        SanityManager.ASSERT((this.getTypeServices() != null ? 1 : 0) != 0, (String)"dataTypeServices is expected to be non-null");
        if (this.isNullNode()) {
            this.setNodeType(24);
        } else {
            if (!this.isNotNullNode()) {
                SanityManager.THROWASSERT((String)("Unexpected nodeType = " + this.getNodeType()));
            }
            this.setNodeType(25);
        }
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
    }

    @Override
    public boolean usefulStartKey(Optimizable optTable) {
        return this.isNullNode();
    }

    @Override
    public boolean usefulStopKey(Optimizable optTable) {
        return this.isNullNode();
    }

    @Override
    public int getStartOperator(Optimizable optTable) {
        if (!this.isNullNode()) {
            SanityManager.THROWASSERT((String)("getNodeType() not expected to return " + this.getNodeType()));
        }
        return 1;
    }

    @Override
    public int getStopOperator(Optimizable optTable) {
        if (!this.isNullNode()) {
            SanityManager.THROWASSERT((String)("getNodeType() not expected to return " + this.getNodeType()));
        }
        return -1;
    }

    @Override
    public void generateOperator(MethodBuilder mb, Optimizable optTable) {
        mb.push(2);
    }

    @Override
    public void generateNegate(MethodBuilder mb, Optimizable optTable) {
        mb.push(this.isNotNullNode());
    }

    @Override
    public int getOperator() {
        int operator;
        if (this.isNullNode()) {
            operator = 7;
        } else {
            if (!this.isNotNullNode()) {
                SanityManager.THROWASSERT((String)("Unexpected nodeType = " + this.getNodeType()));
            }
            operator = 8;
        }
        return operator;
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        return true;
    }

    @Override
    public boolean compareWithParameterNode(Optimizable optTable) {
        return true;
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        if (this.nullValue == null) {
            this.nullValue = this.operand.getTypeServices().getNull();
        }
        return this.nullValue;
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        boolean retval = false;
        if (this.isNotNullNode()) {
            return false;
        }
        if (this.operand instanceof ColumnReference) {
            int tabNum = ((ColumnReference)this.operand).getTableNumber();
            if (optTable.hasTableNumber() && optTable.getTableNumber() == tabNum) {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public RelationalOperator getTransitiveSearchClause(ColumnReference otherCR) throws StandardException {
        return (RelationalOperator)((Object)this.getNodeFactory().getNode(this.getNodeType(), otherCR, this.getContextManager()));
    }

    @Override
    public String getReceiverInterfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor";
    }

    @Override
    public double selectivity(Optimizable optTable) {
        if (this.isNullNode()) {
            return 0.1;
        }
        if (!this.isNotNullNode()) {
            SanityManager.THROWASSERT((String)("Unexpected nodeType = " + this.getNodeType()));
        }
        return 0.9;
    }

    private boolean isNullNode() {
        return this.getNodeType() == 25;
    }

    private boolean isNotNullNode() {
        return this.getNodeType() == 24;
    }

    @Override
    public boolean isRelationalOperator() {
        return true;
    }

    @Override
    public boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) {
        if (!this.isNullNode() || !isNullOkay) {
            return false;
        }
        ColumnReference cr = this.getColumnOperand(optTable, columnNumber);
        return cr != null;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        if (this.operand instanceof SubqueryNode) {
            this.operand.computeQueryInfo(qic);
        }
        return null;
    }
}

