/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public class HasVariantValueNodeVisitor
extends VisitorAdaptor {
    private boolean hasVariant;
    private int variantType;
    private boolean ignoreParameters;

    public HasVariantValueNodeVisitor() {
        this.variantType = 0;
        this.ignoreParameters = false;
        SanityManager.ASSERT((boolean)true, (String)"qualifier constants not ordered as expected");
        SanityManager.ASSERT((boolean)true, (String)"qualifier constants not ordered as expected");
    }

    public HasVariantValueNodeVisitor(int variantType, boolean ignoreParameters) {
        this.variantType = variantType;
        this.ignoreParameters = ignoreParameters;
        SanityManager.ASSERT((variantType >= 0 ? 1 : 0) != 0, (String)"bad variantType");
        SanityManager.ASSERT((variantType <= 2 ? 1 : 0) != 0, (String)"bad variantType");
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ValueNode) {
            if (this.ignoreParameters && ((ValueNode)node).requiresTypeFromContext()) {
                return node;
            }
            if (((ValueNode)node).getOrderableVariantType() <= this.variantType) {
                this.hasVariant = true;
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasVariant;
    }

    public boolean hasVariant() {
        return this.hasVariant;
    }

    @Override
    public boolean supportsDeltaMerge() {
        return true;
    }

    @Override
    public boolean initForDeltaState() {
        return true;
    }

    @Override
    public Object getAndResetDeltaState() {
        return this.hasVariant;
    }

    @Override
    public Visitable mergeDeltaState(Object delta, Visitable node) {
        if (!this.hasVariant) {
            this.hasVariant = (Boolean)delta;
        }
        return node;
    }
}

