/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.Constants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AccessPathImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasCorrelatedCRsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionEngineRule;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public abstract class FromTable
extends ResultSetNode
implements Optimizable {
    Properties tableProperties;
    String correlationName;
    TableName corrTableName;
    int tableNumber;
    ExecutionEngineRule.ExecutionEngine executionEngine = ExecutionEngineRule.ExecutionEngine.NOT_DECIDED;
    int level;
    int[] hashKeyColumns;
    int initialCapacity = -1;
    float loadFactor = -1.0f;
    int maxCapacity = -1;
    boolean includeSecondaryBuckets = false;
    boolean explicitSecondaryBucketSet = false;
    boolean queryHDFS = false;
    AccessPathImpl currentAccessPath;
    AccessPathImpl bestAccessPath;
    AccessPathImpl bestSortAvoidancePath;
    AccessPathImpl trulyTheBestAccessPath;
    private int joinStrategyNumber;
    protected String userSpecifiedJoinStrategy;
    protected CostEstimate bestCostEstimate;
    private FormatableBitSet refCols;
    private double perRowUsage = -1.0;
    private boolean considerSortAvoidancePath;
    private HashMap bestPlanMap;
    protected static final short REMOVE_PLAN = 0;
    protected static final short ADD_PLAN = 1;
    protected static final short LOAD_PLAN = 2;
    protected TableName origTableName;
    static final String validQueryHintProperites = (Object)((Object)Constants.QueryHints.joinStrategy) + "," + (Object)((Object)Constants.QueryHints.hashInitialCapacity) + "," + (Object)((Object)Constants.QueryHints.hashLoadFactor) + "," + (Object)((Object)Constants.QueryHints.hashMaxCapacity) + ",";

    public FromTable() {
    }

    public FromTable(FromTable other) {
        super(other);
        this.correlationName = other.correlationName;
        this.tableProperties = other.tableProperties;
        this.tableNumber = other.tableNumber;
        this.bestPlanMap = other.bestPlanMap;
        this.level = other.level;
        this.origTableName = other.origTableName;
    }

    @Override
    public void init(Object correlationName, Object tableProperties) {
        this.correlationName = (String)correlationName;
        this.tableProperties = (Properties)tableProperties;
        if (this.tableProperties != null) {
            Enumeration<Object> e = this.tableProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.tableProperties.get(key);
                if (!key.equals(Constants.QueryHints.queryHDFS.name())) continue;
                this.queryHDFS = Misc.parseBoolean(value);
                this.getCompilerContext().setQueryHDFS(this.queryHDFS);
                this.getCompilerContext().setHasQueryHDFS(true);
            }
        }
        if (this.queryHDFS) {
            this.getCompilerContext().setOrListOptimizationFlag(false);
        }
        this.tableNumber = -1;
        this.bestPlanMap = null;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        this.updateBestPlanMap((short)1, this);
        CostEstimate singleScanCost = this.estimateCost(predList, null, outerCost, optimizer, rowOrdering);
        this.getCostEstimate(optimizer);
        this.setCostEstimate(singleScanCost);
        this.optimizeSubqueries(this.getDataDictionary(), this.costEstimate.rowCount());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, predList, this.getCostEstimate(), outerCost);
        return this.getCostEstimate();
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        int numStrat = optimizer.getNumberOfJoinStrategies();
        boolean found = false;
        AccessPath ap = this.getCurrentAccessPath();
        this.ncjSetUserSpecifiedJoinStrategy();
        if (this.userSpecifiedJoinStrategy != null) {
            if (ap.getJoinStrategy() != null) {
                ap.setJoinStrategy(null);
                found = false;
            } else {
                ap.setJoinStrategy(optimizer.getJoinStrategy(this.userSpecifiedJoinStrategy));
                if (ap.getJoinStrategy() == null) {
                    throw StandardException.newException("42Y56", (Object)this.userSpecifiedJoinStrategy, (Object)this.getBaseTableName());
                }
                found = true;
            }
        } else if (this.joinStrategyNumber < numStrat) {
            ap.setJoinStrategy(optimizer.getJoinStrategy(this.joinStrategyNumber));
            ++this.joinStrategyNumber;
            found = true;
            optimizer.trace(28, this.tableNumber, 0, 0.0, ap.getJoinStrategy());
        }
        this.tellRowOrderingAboutConstantColumns(rowOrdering, predList);
        return found;
    }

    protected boolean canBeOrdered() {
        return false;
    }

    @Override
    public AccessPath getCurrentAccessPath() {
        return this.currentAccessPath;
    }

    @Override
    public AccessPath getBestAccessPath() {
        return this.bestAccessPath;
    }

    @Override
    public AccessPath getBestSortAvoidancePath() {
        return this.bestSortAvoidancePath;
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        return this.trulyTheBestAccessPath;
    }

    @Override
    public void rememberSortAvoidancePath() {
        this.considerSortAvoidancePath = true;
    }

    @Override
    public boolean considerSortAvoidancePath() {
        return this.considerSortAvoidancePath;
    }

    @Override
    public void rememberJoinStrategyAsBest(AccessPath ap) {
        Optimizer optimizer = ap.getOptimizer();
        ap.setJoinStrategy(this.getCurrentAccessPath().getJoinStrategy());
        optimizer.trace(49, this.tableNumber, 0, 0.0, this.getCurrentAccessPath().getJoinStrategy());
        if (ap == this.bestAccessPath) {
            optimizer.trace(50, this.tableNumber, 0, 0.0, ap);
        } else if (ap == this.bestSortAvoidancePath) {
            optimizer.trace(51, this.tableNumber, 0, 0.0, ap);
        } else {
            optimizer.trace(52, this.tableNumber, 0, 0.0, ap);
        }
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        SanityManager.THROWASSERT((String)("getTableDescriptor() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates, JBitSet outerTables) throws StandardException {
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        return this;
    }

    @Override
    public boolean isCoveringIndex(ConglomerateDescriptor cd) throws StandardException {
        return false;
    }

    @Override
    public Properties getProperties() {
        return this.tableProperties;
    }

    @Override
    public void setProperties(Properties tableProperties) {
        this.tableProperties = tableProperties;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean indexSpecified = false;
        Enumeration<Object> e = this.tableProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals(Constants.QueryHints.joinStrategy.name())) {
                this.setUserSpecifiedJoinStrategy(value);
                continue;
            }
            if (key.equals(Constants.QueryHints.hashInitialCapacity.name())) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (key.equals(Constants.QueryHints.hashLoadFactor.name())) {
                try {
                    this.loadFactor = Float.valueOf(value).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("42Y58", (Object)value, (Object)key);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", value);
            }
            if (key.equals(Constants.QueryHints.hashMaxCapacity.name())) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            throw StandardException.newException("42Y44", (Object)key, (Object)validQueryHintProperites);
        }
    }

    @Override
    public String getName() throws StandardException {
        return this.getExposedName();
    }

    @Override
    public String getBaseTableName() {
        return "";
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition, ColumnReference ref) {
        return absolutePosition;
    }

    @Override
    public void updateBestPlanMap(short action, Object planKey) throws StandardException {
        if (action == 0) {
            if (this.bestPlanMap != null) {
                this.bestPlanMap.remove(planKey);
                if (this.bestPlanMap.size() == 0) {
                    this.bestPlanMap = null;
                }
            }
            return;
        }
        AccessPath bestPath = this.getTrulyTheBestAccessPath();
        AccessPathImpl ap = null;
        if (action == 1) {
            if (bestPath == null) {
                return;
            }
            if (this.bestPlanMap == null) {
                this.bestPlanMap = new HashMap();
            } else {
                ap = (AccessPathImpl)this.bestPlanMap.get(planKey);
            }
            if (ap == null) {
                ap = planKey instanceof Optimizer ? new AccessPathImpl((Optimizer)planKey) : new AccessPathImpl(null);
            }
            ap.copy(bestPath);
            this.bestPlanMap.put(planKey, ap);
            return;
        }
        if (this.bestPlanMap == null) {
            return;
        }
        ap = (AccessPathImpl)this.bestPlanMap.get(planKey);
        if (ap == null || ap.getCostEstimate() == null) {
            return;
        }
        bestPath.copy(ap);
    }

    @Override
    public void rememberAsBest(int planType, Optimizer optimizer) throws StandardException {
        AccessPath bestPath = null;
        switch (planType) {
            case 1: {
                bestPath = this.getBestAccessPath();
                break;
            }
            case 2: {
                bestPath = this.getBestSortAvoidancePath();
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid plan type " + planType));
            }
        }
        this.getTrulyTheBestAccessPath().copy(bestPath);
        if (!(this instanceof ProjectRestrictNode)) {
            this.updateBestPlanMap((short)1, optimizer);
        } else {
            ProjectRestrictNode prn = (ProjectRestrictNode)this;
            if (!(prn.getChildResult() instanceof Optimizable)) {
                this.updateBestPlanMap((short)1, optimizer);
            }
        }
        ConglomerateDescriptor cd = bestPath.getConglomerateDescriptor();
        if (this.isBaseTable()) {
            DataDictionary dd = this.getDataDictionary();
            TableDescriptor td = this.getTableDescriptor();
            this.getTrulyTheBestAccessPath().initializeAccessPathName(dd, td);
        }
        this.setCostEstimate(bestPath.getCostEstimate());
        bestPath.getOptimizer().trace(29, this.tableNumber, planType, 0.0, bestPath);
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        this.resetJoinStrategies(optimizer);
        this.considerSortAvoidancePath = false;
        CostEstimate ce = this.getBestAccessPath().getCostEstimate();
        if (ce != null) {
            ce.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if ((ce = this.getBestSortAvoidancePath().getCostEstimate()) != null) {
            ce.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (!this.canBeOrdered()) {
            rowOrdering.addUnorderedOptimizable(this);
        }
    }

    protected void resetJoinStrategies(Optimizer optimizer) {
        this.joinStrategyNumber = 0;
        this.getCurrentAccessPath().setJoinStrategy(null);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        SanityManager.THROWASSERT((String)("estimateCost() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    @Override
    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getTrulyTheBestAccessPath() == null ? this.costEstimate : this.getTrulyTheBestAccessPath().getCostEstimate();
        return this.finalCostEstimate;
    }

    @Override
    public boolean isBaseTable() {
        return false;
    }

    @Override
    public boolean isMaterializable() throws StandardException {
        HasCorrelatedCRsVisitor visitor = new HasCorrelatedCRsVisitor();
        this.accept(visitor);
        return !visitor.hasCorrelatedCRs();
    }

    @Override
    public boolean supportsMultipleInstantiations() {
        return true;
    }

    @Override
    public int getTableNumber() {
        return this.tableNumber;
    }

    @Override
    public boolean hasTableNumber() {
        return this.tableNumber >= 0;
    }

    @Override
    public boolean forUpdate() {
        return false;
    }

    @Override
    public int initialCapacity() {
        SanityManager.THROWASSERT((String)"Not expected to be called");
        return 0;
    }

    @Override
    public float loadFactor() {
        SanityManager.THROWASSERT((String)"Not expected to be called");
        return 0.0f;
    }

    @Override
    public int maxCapacity(JoinStrategy joinStrategy, int maxMemoryPerTable) throws StandardException {
        return joinStrategy.maxCapacity(this.maxCapacity, maxMemoryPerTable, this.getPerRowUsage());
    }

    private double getPerRowUsage() throws StandardException {
        if (this.perRowUsage < 0.0) {
            FormatableBitSet refCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
            this.perRowUsage = 0.0;
            for (int i = 0; i < refCols.getLength(); ++i) {
                ResultColumn rc;
                DataTypeDescriptor expressionType;
                if (!refCols.isSet(i) || (expressionType = (rc = (ResultColumn)this.resultColumns.elementAt(i)).getExpression().getTypeServices()) == null) continue;
                this.perRowUsage += expressionType.estimatedMemoryUsage();
            }
            ConglomerateDescriptor cd = this.getCurrentAccessPath().getConglomerateDescriptor();
            if (cd != null && cd.isIndex() && !this.isCoveringIndex(cd)) {
                this.perRowUsage += 12.0;
            }
        }
        return this.perRowUsage;
    }

    @Override
    public int[] hashKeyColumns() {
        SanityManager.ASSERT((this.hashKeyColumns != null ? 1 : 0) != 0, (String)"hashKeyColumns expected to be non-null");
        return this.hashKeyColumns;
    }

    @Override
    public void setHashKeyColumns(int[] columnNumbers) {
        this.hashKeyColumns = columnNumbers;
    }

    @Override
    public boolean feasibleJoinStrategy(OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        return this.getCurrentAccessPath().getJoinStrategy().feasible(this, predList, optimizer);
    }

    @Override
    public boolean memoryUsageOK(double rowCount, int maxMemoryPerTable) throws StandardException {
        this.ncjSetUserSpecifiedJoinStrategy();
        if (this.userSpecifiedJoinStrategy != null) {
            return true;
        }
        int intRowCount = rowCount > 2.147483647E9 ? Integer.MAX_VALUE : (int)rowCount;
        return intRowCount <= this.maxCapacity(this.getCurrentAccessPath().getJoinStrategy(), maxMemoryPerTable);
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        return true;
    }

    @Override
    public int getNumColumnsReturned() {
        return this.resultColumns.size();
    }

    @Override
    public boolean isTargetTable() {
        return false;
    }

    @Override
    public boolean isOneRowScan() throws StandardException {
        return this.isOneRowResultSet();
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        if (this.currentAccessPath == null) {
            this.currentAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestAccessPath == null) {
            this.bestAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestSortAvoidancePath == null) {
            this.bestSortAvoidancePath = new AccessPathImpl(optimizer);
        }
        if (this.trulyTheBestAccessPath == null) {
            this.trulyTheBestAccessPath = new AccessPathImpl(optimizer);
        }
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        return -1.0;
    }

    private FormatableBitSet getRefCols() {
        if (this.refCols == null) {
            this.refCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
        }
        return this.refCols;
    }

    String getUserSpecifiedJoinStrategy() {
        if (this.tableProperties == null) {
            return null;
        }
        return this.tableProperties.getProperty("joinStrategy");
    }

    protected boolean cursorTargetTable() {
        return false;
    }

    protected CostEstimate getCostEstimate(Optimizer optimizer) {
        if (this.costEstimate == null) {
            this.costEstimate = optimizer.newCostEstimate();
        }
        return this.costEstimate;
    }

    protected CostEstimate getScratchCostEstimate(Optimizer optimizer) {
        if (this.scratchCostEstimate == null) {
            this.scratchCostEstimate = optimizer.newCostEstimate();
        }
        return this.scratchCostEstimate;
    }

    protected void setCostEstimate(CostEstimate newCostEstimate) {
        this.costEstimate = this.getCostEstimate();
        this.costEstimate.setCost(newCostEstimate);
    }

    protected void assignCostEstimate(CostEstimate newCostEstimate) {
        this.costEstimate = newCostEstimate;
    }

    @Override
    public String toString() {
        return "correlation Name: " + this.correlationName + "\n" + (this.corrTableName != null ? this.corrTableName.toString() : "null") + "\ntableNumber " + this.tableNumber + "\nlevel " + this.level + "\n" + super.toString();
    }

    @Override
    public String shortString() {
        return "correlation Name: " + this.correlationName + "\n" + (this.corrTableName != null ? this.corrTableName.toString() : "null") + "\ntableNumber " + this.tableNumber + "\nlevel " + this.level + "\n";
    }

    public ResultColumnList getResultColumnsForList(TableName allTableName, ResultColumnList inputRcl, TableName tableName) throws StandardException {
        ResultColumnList rcList = null;
        TableName toCompare = this.correlationName == null ? tableName : (allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName));
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        TableName exposedName = this.correlationName == null ? tableName : this.makeTableName(null, this.correlationName);
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int inputSize = inputRcl.size();
        for (int index = 0; index < inputSize; ++index) {
            String columnName = ((ResultColumn)inputRcl.elementAt(index)).getName();
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnName, exposedName, this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    void pushExpressions(PredicateList predicateList) throws StandardException {
        SanityManager.ASSERT((predicateList != null ? 1 : 0) != 0, (String)"predicateList is expected to be non-null");
    }

    public String getExposedName() throws StandardException {
        SanityManager.THROWASSERT((String)("getExposedName() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    public void setTableNumber(int tableNumber) {
        SanityManager.ASSERT((this.tableNumber == -1 ? 1 : 0) != 0, (String)"tableNumber is not expected to be already set");
        this.tableNumber = tableNumber;
    }

    public TableName getTableName() throws StandardException {
        if (this.correlationName == null) {
            return null;
        }
        if (this.corrTableName == null) {
            this.corrTableName = this.makeTableName(null, this.correlationName);
        }
        return this.corrTableName;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    void decrementLevel(int decrement) {
        if (this.level < decrement && this.level != 0) {
            SanityManager.THROWASSERT((String)("level (" + this.level + ") expected to be >= decrement (" + decrement + ")"));
        }
        if (this.level > 0) {
            this.level -= decrement;
        }
    }

    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(this.corrTableName);
    }

    public SchemaDescriptor getSchemaDescriptor(TableName tableName) throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor(tableName.getSchemaName());
        return sd;
    }

    @Override
    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        if (schemaName != null) {
            return null;
        }
        if (this.getExposedName().equals(name)) {
            return this;
        }
        return null;
    }

    public boolean isFlattenableJoinNode() {
        return false;
    }

    public boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    public FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        return this;
    }

    @Override
    public void fillInReferencedTableMap(JBitSet passedMap) {
        if (this.tableNumber != -1) {
            passedMap.set(this.tableNumber);
        }
    }

    protected void markUpdatableByCursor(Vector updateColumns) {
        this.resultColumns.markUpdatableByCursor(updateColumns);
    }

    public FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl) throws StandardException {
        SanityManager.THROWASSERT((String)("flatten() not expected to be called for " + this));
        return null;
    }

    void optimizeSubqueries(DataDictionary dd, double rowCount) throws StandardException {
    }

    protected void tellRowOrderingAboutConstantColumns(RowOrdering rowOrdering, OptimizablePredicateList predList) {
        if (predList != null) {
            for (int i = 0; i < predList.size(); ++i) {
                ColumnReference cr;
                Predicate pred = (Predicate)predList.getOptPredicate(i);
                if (!pred.equalsComparisonWithConstantExpression(this) || (cr = pred.getRelop().getColumnOperand(this)) == null) continue;
                rowOrdering.columnAlwaysOrdered(this, cr.getColumnNumber());
            }
        }
    }

    public boolean needsSpecialRCLBinding() {
        return false;
    }

    public void setOrigTableName(TableName tableName) {
        this.origTableName = tableName;
    }

    public TableName getOrigTableName() {
        return this.origTableName;
    }

    public LocalRegion getRegion(boolean returnUnInitialized) throws StandardException {
        SanityManager.THROWASSERT((String)"Not expected to be called");
        return null;
    }

    @Override
    public void delayScanOpening(boolean delay) {
    }

    @Override
    public void getTablesReferencedByRestrictionLists(JBitSet referencedTables) {
    }

    protected void setUserSpecifiedJoinStrategy(String value) {
        String upperValue;
        this.userSpecifiedJoinStrategy = upperValue = StringUtil.SQLToUpperCase(value);
    }

    protected void setUserSpecifiedExecutionEngine(String value) {
        if (StringUtil.SQLEqualsIgnoreCase(value, ExecutionEngineRule.ExecutionEngine.STORE.name())) {
            this.executionEngine = ExecutionEngineRule.ExecutionEngine.STORE;
        } else if (StringUtil.SQLEqualsIgnoreCase(value, ExecutionEngineRule.ExecutionEngine.SPARK.name())) {
            this.executionEngine = ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        this.getCompilerContext().setExecutionEngine(this.executionEngine);
    }

    protected ExecutionEngineRule.ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    @Override
    public int getNumPartitioningCols() throws StandardException {
        Optimizable opt = this.getBaseTable();
        if (opt == null || !opt.isBaseTable()) {
            return -1;
        }
        DistributionDescriptor dd = opt.getTableDescriptor().getDistributionDescriptor();
        if (dd == null || dd.getPartitionColumnNames() == null) {
            return -1;
        }
        return dd.getPartitionColumnNames().length;
    }

    @Override
    public boolean isColocatedWith(Optimizable other) throws StandardException {
        Optimizable opt = this.getBaseTable();
        Optimizable othrOpt = other.getBaseTable();
        if (opt == null || !opt.isBaseTable() || othrOpt == null || !othrOpt.isBaseTable()) {
            return false;
        }
        PartitionAttributes pat = opt.getTableDescriptor().getRegion().getAttributes().getPartitionAttributes();
        PartitionAttributes otherPat = othrOpt.getTableDescriptor().getRegion().getAttributes().getPartitionAttributes();
        return ((GfxdPartitionResolver)pat.getPartitionResolver()).getMasterTable(true).equals(((GfxdPartitionResolver)otherPat.getPartitionResolver()).getMasterTable(true));
    }

    @Override
    public Optimizable getBaseTable() throws StandardException {
        return this;
    }

    private void ncjSetUserSpecifiedJoinStrategy() {
        String ncjJoinStrategy = "NESTEDLOOP";
        if (this.userSpecifiedJoinStrategy == null || this.userSpecifiedJoinStrategy != "NESTEDLOOP") {
            try {
                FromBaseTable fbTbl;
                CompilerContext cc = this.getCompilerContext();
                if (cc != null && cc.isNCJoinOnRemote() && (fbTbl = this.ncjGetOnlyOneFBTNode()) != null && (NcjHashMapWrapper.isTabForPull(cc.getNCJMetaDataOnRemote(), fbTbl.ncjGetCorrelationName()) || NcjHashMapWrapper.isTabAtSecondPosition(cc.getNCJMetaDataOnRemote(), fbTbl.ncjGetCorrelationName()))) {
                    this.userSpecifiedJoinStrategy = "NESTEDLOOP";
                }
            }
            catch (Throwable x) {
                SanityManager.THROWASSERT((Throwable)x);
            }
        }
    }

    public String ncjGetCorrelationName() {
        String retVal = this.correlationName;
        if (retVal == null) {
            try {
                retVal = this.getRegion(false).getName();
                SanityManager.ASSERT((retVal != null ? 1 : 0) != 0);
            }
            catch (StandardException e) {
                e.printStackTrace();
            }
        }
        SanityManager.ASSERT((retVal != null ? 1 : 0) != 0);
        return retVal;
    }
}

