/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import java.util.Vector;

class ColumnOrdering {
    int myDirection;
    Vector columns = new Vector();
    Vector tables = new Vector();

    ColumnOrdering(int direction) {
        this.myDirection = direction;
    }

    boolean ordered(int direction, int tableNumber, int columnNumber) {
        if (direction != 3 && direction != this.myDirection) {
            return false;
        }
        return this.contains(tableNumber, columnNumber);
    }

    boolean contains(int tableNumber, int columnNumber) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Integer col = (Integer)this.columns.elementAt(i);
            Integer tab = (Integer)this.tables.elementAt(i);
            if (tab != tableNumber || col != columnNumber) continue;
            return true;
        }
        return false;
    }

    int direction() {
        return this.myDirection;
    }

    void addColumn(int tableNumber, int columnNumber) {
        this.tables.addElement(tableNumber);
        this.columns.addElement(columnNumber);
    }

    void removeColumns(int tableNumber) {
        for (int i = this.tables.size() - 1; i >= 0; --i) {
            Integer tab = (Integer)this.tables.elementAt(i);
            if (tab != tableNumber) continue;
            this.tables.removeElementAt(i);
            this.columns.removeElementAt(i);
        }
    }

    boolean empty() {
        return this.tables.size() == 0;
    }

    ColumnOrdering cloneMe() {
        ColumnOrdering retval = new ColumnOrdering(this.myDirection);
        for (int i = 0; i < this.columns.size(); ++i) {
            retval.columns.addElement(this.columns.elementAt(i));
            retval.tables.addElement(this.tables.elementAt(i));
        }
        return retval;
    }

    boolean hasTable(int tableNumber) {
        if (this.tables.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            Integer tab = (Integer)this.tables.elementAt(i);
            if (tab != tableNumber) continue;
            return true;
        }
        return false;
    }

    boolean hasAnyOtherTable(int tableNumber) {
        if (this.tables.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            Integer tab = (Integer)this.tables.elementAt(i);
            if (tab == tableNumber) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String retval = "";
        retval = retval + "Direction: " + this.myDirection;
        for (int i = 0; i < this.columns.size(); ++i) {
            retval = retval + " Table " + this.tables.elementAt(i) + ", Column " + this.columns.elementAt(i);
        }
        return retval;
    }
}

