/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;

public class CollectAndEliminateColumnsVisitor
extends VisitorAdaptor {
    private boolean collectColumnReferences = true;
    private final TObjectHashingStrategy comparisonStrategy = new TObjectHashingStrategy(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(Object o) {
            assert (o instanceof String || o instanceof ResultColumn) : o;
            if (o instanceof ResultColumn) {
                return ((ResultColumn)o).exposedName.hashCode();
            }
            return ((String)o).hashCode();
        }

        public boolean equals(Object o1, Object o2) {
            assert (o1 instanceof String && o2 instanceof String || o1 instanceof ResultColumn && o2 instanceof ResultColumn);
            if (o1 instanceof ResultColumn) {
                try {
                    return ((ResultColumn)o1).isEquivalent((ResultColumn)o2);
                }
                catch (StandardException e) {
                    SanityManager.DEBUG_PRINT((String)"error", (String)"ResultColumn comparison error : ", (Throwable)e);
                    return false;
                }
            }
            return ((String)o1).equals(o2);
        }
    };
    private final THashSet columnReferences = new THashSet(this.comparisonStrategy);
    private boolean columnFound = false;

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return this.columnFound || node instanceof ResultColumnList;
    }

    @Override
    public boolean stopTraversal() {
        return this.columnFound;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (this.collectColumnReferences) {
            if (node instanceof ColumnReference) {
                this.columnReferences.putIfAbsent((Object)((ColumnReference)node).getColumnName());
            } else if (node instanceof ResultColumn) {
                ResultColumn rc = (ResultColumn)node;
                this.columnReferences.putIfAbsent((Object)rc.name);
                this.columnReferences.putIfAbsent((Object)rc.exposedName);
                String srcCol = rc.getSourceColumnName();
                if (srcCol != null) {
                    this.columnReferences.putIfAbsent((Object)srcCol);
                }
                if (rc.isNameGenerated || rc.isGenerated || rc.isExpanded || rc.isGeneratedForUnmatchedColumnInInsert() || rc.getExpression() == null) {
                    this.columnReferences.putIfAbsent((Object)rc);
                }
            } else if (node instanceof BaseColumnNode) {
                this.columnReferences.putIfAbsent((Object)((BaseColumnNode)node).getColumnName());
            }
        } else if (node instanceof ColumnReference) {
            this.columnFound = this.columnReferences.contains((Object)((ColumnReference)node).getColumnName());
        } else if (node instanceof ResultColumn) {
            ResultColumn rc = (ResultColumn)node;
            String colName = rc.name;
            if (colName != null) {
                this.columnFound = this.columnReferences.contains((Object)colName);
            }
            if (!this.columnFound) {
                colName = rc.exposedName;
                if (colName != null) {
                    this.columnFound = this.columnReferences.contains((Object)colName);
                }
                if (!this.columnFound && (colName = rc.getSourceColumnName()) != null) {
                    this.columnFound = this.columnReferences.contains((Object)colName);
                }
            }
        } else if (node instanceof BaseColumnNode) {
            this.columnFound = this.columnReferences.contains((Object)((BaseColumnNode)node).getColumnName());
        }
        return node;
    }

    public void stopCollectingColumnReferences() {
        this.collectColumnReferences = false;
    }

    public boolean isColumnUsed(ResultColumn rc) throws StandardException {
        rc.accept(this);
        if (this.columnFound) {
            this.columnFound = false;
            return true;
        }
        return false;
    }
}

