/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateActivation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecCursorTableReference;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.sql.CursorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.GenericActivationHolder;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Token;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import java.io.Serializable;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class GenericPreparedStatement
implements ExecPreparedStatement,
Serializable {
    public Statement statement;
    protected volatile GeneratedClass activationClass;
    protected ResultDescription resultDesc;
    protected DataTypeDescriptor[] paramTypeDescriptors;
    private String spsName;
    private SQLWarning warnings;
    protected List<TypeCompiler> origTypeCompilers;
    private int statementType;
    private LocalRegion localRegion = null;
    private PartitionedRegion partitionedRegionForSingleHop = null;
    private boolean isSubqueryPrepStmnt;
    private ProviderList dependencyProviders = null;
    private boolean isInsertAsSubselect;
    private GenericPreparedStatement parentPS = null;
    private ArrayList<GenericPreparedStatement> childPS = null;
    private boolean useOnlyPrimaryBuckets;
    private boolean queryHDFS = false;
    private boolean hasQueryHDFS = false;
    private boolean isCallableStatement;
    private ArrayList<Token> dynamicTokenList;
    private boolean referencesSessionSchema;
    protected ExecCursorTableReference targetTable;
    protected ResultColumnDescriptor[] targetColumns;
    protected String[] updateColumns;
    protected int updateMode;
    protected ConstantAction executionConstants;
    protected Object[] savedObjects;
    protected List requiredPermissionsList;
    protected String UUIDString;
    protected UUID UUIDValue;
    private boolean needsSavepoint;
    private String execStmtName;
    private String execSchemaName;
    protected boolean isAtomic;
    protected String sourceTxt;
    private final AtomicInteger inUseCount = new AtomicInteger(0);
    protected long parseTime;
    protected long bindTime;
    protected long optimizeTime;
    protected long routingInfoTime;
    protected long generateTime;
    protected long compileTime;
    protected Timestamp beginCompileTimestamp;
    protected Timestamp endCompileTimestamp;
    protected int numPrepared;
    private static final int IS_INVALID = 1;
    private static final int IS_COMPILING = 2;
    private static final int IS_ACTIVATION_CLASS_NULL = 4;
    private final AtomicInteger isInvalid = new AtomicInteger(5);
    private transient StatementStats stats;
    private Set routingInfoObjects;
    private volatile QueryInfo qinfo;
    private boolean isPutDML = false;
    protected boolean spsAction;
    private volatile Cacheable cacheHolder;
    private long versionCounter;

    private GenericPreparedStatement(boolean isSubqueryPrepStmnt) {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.UUIDValue = uuidFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
        this.spsAction = false;
        this.isSubqueryPrepStmnt = isSubqueryPrepStmnt;
    }

    GenericPreparedStatement() {
        this(false);
    }

    public GenericPreparedStatement(Statement st) {
        this(false);
        this.statement = st;
    }

    public GenericPreparedStatement(Statement st, boolean isSubqueryPrepStmt) {
        this(isSubqueryPrepStmt);
        this.statement = st;
    }

    @Override
    public final boolean upToDate() {
        return this.isInvalid.get() == 0;
    }

    @Override
    public void rePrepare(LanguageConnectionContext lcc, Activation oldAct) throws StandardException {
        if (!this.upToDate()) {
            if (this.isSubqueryPrepStmnt) {
                GenericPreparedStatement pps = this.getParentPS();
                pps.makeInvalid(23, lcc);
                throw StandardException.newException("XCL55.S");
            }
            if (GemFireXDUtils.TraceStatementMatching) {
                SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)(GemFireXDUtils.addressOf(this) + " starting to reprepare [" + this.statement + " ]"), (Throwable)new Throwable());
            }
            Activation a = null;
            if (oldAct != null) {
                if (oldAct instanceof GenericActivationHolder) {
                    a = ((GenericActivationHolder)oldAct).getActivation();
                } else if (oldAct instanceof Activation) {
                    a = oldAct;
                }
            }
            if (a != null && a instanceof GemFireUpdateActivation) {
                if (GemFireXDUtils.TraceConglomUpdate) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("GPS#rePrepare flushing the current batch for GemFireUpdateActivation: " + a));
                }
                ((GemFireUpdateActivation)a).flushBatch();
            }
            FunctionContext fc = oldAct != null ? oldAct.getFunctionContext() : null;
            boolean allTablesReplicated = false;
            if (fc != null && fc instanceof RegionExecutorMessage) {
                allTablesReplicated = ((RegionExecutorMessage)fc).allTablesAreReplicatedOnRemote();
            }
            ((GenericStatement)this.statement).setReplicatedFlag(allTablesReplicated);
            PreparedStatement ps = this.statement.prepare(lcc, false);
            SanityManager.ASSERT((ps == this ? 1 : 0) != 0, (String)"ps != this");
        }
    }

    @Override
    public Activation getActivation(LanguageConnectionContext lcc, boolean scrollable, String statementText) throws StandardException {
        return this.getActivation(lcc, scrollable, statementText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activation getActivation(LanguageConnectionContext lcc, boolean scrollable, String statementText, boolean addToLCC) throws StandardException {
        GeneratedClass gc = this.getActivationClass();
        if (gc == null) {
            DataDictionary dd = lcc.getDataDictionary();
            int readMode = dd.startReading(lcc);
            try {
                GenericPreparedStatement genericPreparedStatement = this;
                synchronized (genericPreparedStatement) {
                    this.rePrepare(lcc, null);
                    gc = this.getActivationClass();
                }
            }
            finally {
                dd.doneReading(readMode, lcc);
            }
        }
        GenericActivationHolder ac = new GenericActivationHolder(lcc, gc, this, scrollable, statementText, addToLCC);
        this.inUseCount.incrementAndGet();
        if (this.useOnlyPrimaryBuckets) {
            ac.setUseOnlyPrimaryBuckets(true);
        }
        ac.setQueryHDFS(this.queryHDFS);
        ac.setHasQueryHDFS(this.hasQueryHDFS);
        lcc.closeUnusedActivations();
        ac.setCallActivation(lcc.getCaller());
        return ac;
    }

    @Override
    public ResultSet execute(LanguageConnectionContext lcc, boolean rollbackParentContext, long timeoutMillis) throws StandardException {
        Activation a = this.getActivation(lcc, false, null);
        a.setSingleExecution();
        return this.execute(a, rollbackParentContext, timeoutMillis, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet execute(Activation activation, boolean rollbackParentContext, long timeoutMillis, boolean popStmntCntxt, boolean accountInProgress) throws StandardException {
        ResultSet resultSet;
        StatementContext statementContext;
        LanguageConnectionContext lccToUse;
        boolean statsEnabled;
        boolean createQI = this.statement.createQueryInfo();
        boolean bl = statsEnabled = accountInProgress && activation.getLanguageConnectionContext().statsEnabled();
        if (statsEnabled) {
            this.stats.incStat(2, createQI, 1L);
        }
        boolean needToClearSavePoint = false;
        if (activation == null || activation.getPreparedStatement() != this) {
            throw StandardException.newException("XCL09.S", "execute");
        }
        while (true) {
            if ((lccToUse = activation.getLanguageConnectionContext()).getLogStatementText()) {
                HeaderPrintWriter istream = Monitor.getStream();
                String xactId = lccToUse.getTransactionExecute().getActiveStateTxIdString();
                String pvsString = "";
                ParameterValueSet pvs = activation.getParameterValueSet();
                if (pvs != null && pvs.getParameterCount() > 0) {
                    pvsString = " with " + pvs.getParameterCount() + " parameters " + pvs.toString();
                }
                istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lccToUse.getInstanceNumber() + "), " + "(DATABASE = " + lccToUse.getDbname() + "), " + "(DRDAID = " + lccToUse.getDrdaID() + "), Executing prepared statement: " + this.getSource() + " :End prepared statement" + pvsString);
            }
            ParameterValueSet pvs = activation.getParameterValueSet();
            if (!this.spsAction) {
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null) {
                    observer.beforeQueryReprepare(this, lccToUse);
                }
                this.rePrepare(lccToUse, activation);
            }
            statementContext = lccToUse.pushStatementContext(this.isAtomic, this.updateMode == 1, this.getSource(), pvs, rollbackParentContext, timeoutMillis);
            if (this.needsSavepoint()) {
                statementContext.setSavePoint();
                needToClearSavePoint = true;
            }
            if (this.executionConstants != null) {
                lccToUse.validateStmtExecution(this.executionConstants);
            }
            resultSet = null;
            long beginExecute = lccToUse.getStatisticsTiming() ? XPLAINUtil.recordTiming(-1L) : 0L;
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            try {
                if (observer != null) {
                    observer.beforeQueryExecution(this, lccToUse);
                }
                if (GemFireXDUtils.TraceActivation) {
                    SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("GenericPreparedStatement::execute::Using activation = " + activation));
                }
                resultSet = activation.execute();
                if (observer != null) {
                    observer.afterQueryExecution(this, activation);
                }
                resultSet.open();
                if (observer == null) break;
                observer.afterResultSetOpen(this, lccToUse, resultSet);
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("XCL32.S") || this.spsAction) {
                    GemFireTransaction gft = (GemFireTransaction)lccToUse.getTransactionExecute();
                    if (gft != null) {
                        gft.release();
                    }
                    throw se;
                }
                statementContext.cleanupOnError(se);
                TransactionController tc = lccToUse.getTransactionExecute();
                if (tc == null) continue;
                tc.releaseAllLocks(false, false);
                continue;
            }
            finally {
                if (statsEnabled) {
                    this.stats.incStat(2, createQI, -1L);
                    this.stats.incStat(1, createQI, 1L);
                }
                if (beginExecute != 0L && this.stats != null) {
                    this.stats.incStat(11, createQI, XPLAINUtil.recordTiming(beginExecute));
                }
                if (observer == null) continue;
                observer.statementStatsBeforeExecutingStatement(this.stats);
                continue;
            }
            break;
        }
        if (needToClearSavePoint) {
            statementContext.clearSavePoint();
        }
        if (popStmntCntxt) {
            lccToUse.popStatementContext(statementContext, null);
        }
        if (activation.isSingleExecution() && resultSet.isClosed()) {
            activation.close();
        }
        return resultSet;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDesc;
    }

    public void setResultDescription(ResultDescription rd) {
        this.resultDesc = rd;
    }

    @Override
    public DataTypeDescriptor[] getParameterTypes() {
        return this.paramTypeDescriptors;
    }

    public void setParameterTypes(DataTypeDescriptor[] paramTypes) {
        this.paramTypeDescriptors = paramTypes;
    }

    @Override
    public String getSource() {
        return this.sourceTxt != null ? this.sourceTxt : (this.statement == null ? "null" : this.statement.getSource());
    }

    @Override
    public String getUserQueryString(LanguageConnectionContext lcc) {
        return this.statement == null ? (this.sourceTxt != null ? this.sourceTxt : "null") : (lcc != null ? this.statement.getQueryStringForParse(lcc) : this.statement.getSource());
    }

    @Override
    public void setSource(String text) {
        this.sourceTxt = text;
    }

    public List<TypeCompiler> getOriginalParameterTypeCompilers() {
        return this.origTypeCompilers;
    }

    public void setStatementType(int stmntType) {
        this.statementType = stmntType;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public final Statement getStatement() {
        return this.statement;
    }

    public void setFlags(boolean atomic, boolean readOnly) {
        this.isAtomic = atomic;
        if (readOnly) {
            this.updateMode = 1;
        }
    }

    public final void setSPSName(String name) {
        this.spsName = name;
    }

    @Override
    public String getSPSName() {
        return this.spsName;
    }

    @Override
    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    @Override
    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    @Override
    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    @Override
    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    @Override
    public long getRoutingInfoTimeInMillis() {
        return this.routingInfoTime;
    }

    @Override
    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    @Override
    public Timestamp getBeginCompileTimestamp() {
        return this.beginCompileTimestamp;
    }

    @Override
    public Timestamp getEndCompileTimestamp() {
        return this.endCompileTimestamp;
    }

    void setCompileTimeWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    @Override
    public final SQLWarning getCompileTimeWarnings() {
        return this.warnings;
    }

    public void setCompileTimeMillis(long parseTime, long bindTime, long optimizeTime, long routingInfoTime, long generateTime, long compileTime, Timestamp beginCompileTimestamp, Timestamp endCompileTimestamp) {
        this.parseTime = parseTime;
        this.bindTime = bindTime;
        this.optimizeTime = optimizeTime;
        this.generateTime = generateTime;
        this.routingInfoTime = routingInfoTime;
        this.compileTime = compileTime;
        this.beginCompileTimestamp = beginCompileTimestamp;
        this.endCompileTimestamp = endCompileTimestamp;
        ++this.numPrepared;
        if (this.stats != null) {
            boolean isQN = this.statement.createQueryInfo();
            this.stats.incStat(5, isQN, parseTime);
            if (bindTime > 0L) {
                this.stats.incStat(6, isQN, bindTime);
                this.stats.incStat(7, isQN, optimizeTime);
                this.stats.incStat(8, isQN, routingInfoTime);
                this.stats.incStat(9, isQN, generateTime);
            }
            this.stats.incStat(10, isQN, compileTime);
            this.stats.incStat(0, isQN, 1L);
        }
    }

    @Override
    public void finish(LanguageConnectionContext lcc) {
        int count = this.inUseCount.decrementAndGet();
        if (this.cacheHolder != null) {
            return;
        }
        if (count != 0) {
            return;
        }
        if (this.isSubqueryPrepStmnt) {
            return;
        }
        try {
            this.makeInvalid(11, lcc);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)se);
        }
    }

    final void setConstantAction(ConstantAction constantAction) {
        this.executionConstants = constantAction;
    }

    @Override
    public final ConstantAction getConstantAction() {
        return this.executionConstants;
    }

    public final void setSavedObjects(Object[] objects) {
        this.savedObjects = objects;
    }

    @Override
    public final Object[] getSavedObjects() {
        return this.savedObjects;
    }

    @Override
    public final boolean isValid() {
        return (this.isInvalid.get() & 1) == 0;
    }

    public final boolean compilingStatement() {
        return (this.isInvalid.get() & 2) != 0;
    }

    public final void setCompilingStatement(boolean isCompiling) {
        block3: {
            while (true) {
                int invalidFlags;
                if (((invalidFlags = this.isInvalid.get()) & 2) != 0) {
                    if (isCompiling) {
                        return;
                    }
                    if (!this.isInvalid.compareAndSet(invalidFlags, invalidFlags & 0xFFFFFFFD)) continue;
                    return;
                }
                if (!isCompiling) break block3;
                if (this.isInvalid.compareAndSet(invalidFlags, invalidFlags | 2)) break;
            }
            return;
        }
    }

    @Override
    public void setValid() {
        int isInvalidFlags;
        while (((isInvalidFlags = this.isInvalid.get()) & 1) != 0) {
            if (!this.isInvalid.compareAndSet(isInvalidFlags, isInvalidFlags & 0xFFFFFFFE)) continue;
            return;
        }
    }

    @Override
    public void setSPSAction() {
        this.spsAction = true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 3: 
            case 5: {
                return;
            }
        }
        lcc.verifyNoOpenResultSets(this, p, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        if (SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("GenericPreparedStatement::makeInvalid called for GPS: " + this + ", compilingStatement: " + this.compilingStatement() + " ac: " + this.getActivationClass()));
        }
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            int invalidFlags;
            do {
                if (((invalidFlags = this.isInvalid.get()) & 2) != 0) return;
            } while (!this.isInvalid.compareAndSet(invalidFlags, invalidFlags | 3));
            this.qinfo = null;
            this.routingInfoObjects = null;
            this.activationClass = null;
        }
        try {
            DependencyManager dm = lcc.getDataDictionary().getDependencyManager();
            dm.clearDependencies(lcc, this);
            if (this.execStmtName == null) return;
            switch (action) {
                case 5: 
                case 23: {
                    DataDictionary dd = lcc.getDataDictionary();
                    SchemaDescriptor sd = dd.getSchemaDescriptor(this.execSchemaName, lcc.getTransactionCompile(), true);
                    SPSDescriptor spsd = dd.getSPSDescriptor(this.execStmtName, sd);
                    spsd.makeInvalid(action, lcc);
                    return;
                }
            }
            return;
        }
        finally {
            genericPreparedStatement = this;
            synchronized (genericPreparedStatement) {
                this.setCompilingStatement(false);
                this.notifyAll();
            }
        }
    }

    @Override
    public boolean isDescriptorPersistent() {
        return false;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return null;
    }

    @Override
    public String getObjectName() {
        return this.UUIDString;
    }

    @Override
    public UUID getObjectID() {
        return this.UUIDValue;
    }

    @Override
    public String getClassType() {
        return "PreparedStatement";
    }

    @Override
    public boolean referencesSessionSchema() {
        return this.referencesSessionSchema;
    }

    public boolean referencesSessionSchema(StatementNode qt) throws StandardException {
        this.referencesSessionSchema = qt.referencesSessionSchema();
        return this.referencesSessionSchema;
    }

    void completeCompile(StatementNode qt) throws StandardException {
        CursorInfo cursorInfo;
        this.paramTypeDescriptors = qt.getParameterTypes();
        this.origTypeCompilers = qt.getOriginalParameterTypeCompilers();
        if (this.targetTable != null) {
            this.targetTable = null;
            this.updateMode = 0;
            this.updateColumns = null;
            this.targetColumns = null;
        }
        this.resultDesc = qt.makeResultDescription();
        if (this.resultDesc != null && (cursorInfo = (CursorInfo)qt.getCursorInfo()) != null) {
            this.targetTable = cursorInfo.targetTable;
            this.targetColumns = cursorInfo.targetColumns;
            this.updateColumns = cursorInfo.updateColumns;
            this.updateMode = cursorInfo.updateMode;
        }
        this.makeValid();
    }

    void makeValid() {
        int invalidFlags;
        while (((invalidFlags = this.isInvalid.get()) & 1) != 0) {
            if (!this.isInvalid.compareAndSet(invalidFlags, invalidFlags & 0xFFFFFFFE)) continue;
            return;
        }
    }

    @Override
    public GeneratedClass getActivationClass() throws StandardException {
        return this.activationClass;
    }

    void setActivationClass(GeneratedClass ac) {
        int invalidFlags;
        this.activationClass = ac;
        while (!(((invalidFlags = this.isInvalid.get()) & 4) != 0 ? ac == null || this.isInvalid.compareAndSet(invalidFlags, invalidFlags & 0xFFFFFFFB) : ac != null || this.isInvalid.compareAndSet(invalidFlags, invalidFlags | 4))) {
        }
    }

    @Override
    public int getUpdateMode() {
        return this.updateMode;
    }

    @Override
    public ExecCursorTableReference getTargetTable() {
        SanityManager.ASSERT((this.targetTable != null ? 1 : 0) != 0, (String)"Not a cursor, no target table");
        return this.targetTable;
    }

    @Override
    public ResultColumnDescriptor[] getTargetColumns() {
        return this.targetColumns;
    }

    @Override
    public String[] getUpdateColumns() {
        return this.updateColumns;
    }

    @Override
    public Object getCursorInfo() {
        return new CursorInfo(this.updateMode, this.targetTable, this.targetColumns, this.updateColumns);
    }

    void setCursorInfo(CursorInfo cursorInfo) {
        if (cursorInfo != null) {
            this.updateMode = cursorInfo.updateMode;
            this.targetTable = cursorInfo.targetTable;
            this.targetColumns = cursorInfo.targetColumns;
            this.updateColumns = cursorInfo.updateColumns;
        }
    }

    ByteArray getByteCodeSaver() {
        return null;
    }

    @Override
    public boolean needsSavepoint() {
        return this.needsSavepoint;
    }

    void setNeedsSavepoint(boolean needsSavepoint) {
        this.needsSavepoint = needsSavepoint;
    }

    void setIsAtomic(boolean isAtomic) {
        this.isAtomic = isAtomic;
    }

    @Override
    public boolean isAtomic() {
        return this.isAtomic;
    }

    void setExecuteStatementNameAndSchema(String execStmtName, String execSchemaName) {
        this.execStmtName = execStmtName;
        this.execSchemaName = execSchemaName;
    }

    @Override
    public ExecPreparedStatement getClone() throws StandardException {
        GenericPreparedStatement clone = new GenericPreparedStatement(this.statement);
        clone.activationClass = this.getActivationClass();
        clone.resultDesc = this.resultDesc;
        clone.paramTypeDescriptors = this.paramTypeDescriptors;
        clone.dynamicTokenList = this.dynamicTokenList;
        clone.executionConstants = this.executionConstants;
        clone.UUIDString = this.UUIDString;
        clone.UUIDValue = this.UUIDValue;
        clone.savedObjects = this.savedObjects;
        clone.execStmtName = this.execStmtName;
        clone.execSchemaName = this.execSchemaName;
        clone.isAtomic = this.isAtomic;
        clone.sourceTxt = this.sourceTxt;
        clone.statementType = this.statementType;
        clone.targetTable = this.targetTable;
        clone.targetColumns = this.targetColumns;
        clone.updateColumns = this.updateColumns;
        clone.updateMode = this.updateMode;
        clone.needsSavepoint = this.needsSavepoint;
        clone.useOnlyPrimaryBuckets = this.useOnlyPrimaryBuckets;
        clone.queryHDFS = this.queryHDFS;
        clone.isCallableStatement = this.isCallableStatement;
        clone.origTypeCompilers = this.origTypeCompilers;
        clone.stats = this.stats;
        clone.qinfo = this.qinfo;
        if (clone.activationClass == null) {
            clone.isInvalid.set(4);
        }
        return clone;
    }

    public void setCacheHolder(Cacheable cacheHolder) {
        this.cacheHolder = cacheHolder;
        if (cacheHolder == null) {
            if (!this.isValid() || this.inUseCount.get() != 0) {
                return;
            }
            ContextManager cm = ContextService.getFactory().getCurrentContextManager();
            LanguageConnectionContext lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
            try {
                this.makeInvalid(11, lcc);
                GfxdManagementService.handleEvent(8, this.statement);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)se);
            }
        }
    }

    public String toString() {
        return this.getObjectName();
    }

    public boolean isStorable() {
        return false;
    }

    public final void setRequiredPermissionsList(List requiredPermissionsList) {
        this.requiredPermissionsList = requiredPermissionsList;
    }

    @Override
    public final List getRequiredPermissionsList() {
        return this.requiredPermissionsList;
    }

    @Override
    public final long getVersionCounter() {
        return this.versionCounter;
    }

    public final void incrementVersionCounter() {
        ++this.versionCounter;
    }

    public final boolean createQueryInfo() {
        return ((GenericStatement)this.statement).createQueryInfo();
    }

    public final void setLocalRegion(LocalRegion rgn) {
        this.localRegion = rgn;
    }

    public final LocalRegion getLocalRegion() {
        return this.localRegion;
    }

    public final PartitionedRegion getPartitionedRegion() {
        if (this.partitionedRegionForSingleHop == null) {
            this.partitionedRegionForSingleHop = (PartitionedRegion)(this.qinfo != null && this.qinfo.getRegion() instanceof PartitionedRegion ? this.qinfo.getRegion() : null);
        }
        return this.partitionedRegionForSingleHop;
    }

    @Override
    public final boolean isSubqueryPrepStatement() {
        return this.isSubqueryPrepStmnt;
    }

    @Override
    public final boolean isInsertAsSubselect() {
        return this.isInsertAsSubselect;
    }

    public final void setInsertAsSubselect(boolean flag) {
        this.isInsertAsSubselect = flag;
    }

    final void setProviderList(ProviderList apl) {
        this.dependencyProviders = apl;
    }

    @Override
    public final StatementStats getStatementStats() {
        return this.stats;
    }

    @Override
    public final void setStatementStats(StatementStats st) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)("GenericPreparedStatement#setStatementStats setting statistics object to " + st));
        }
        this.stats = st;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SingleHopInformation fillAndGetSingleHopInformation() {
        GfxdIndexManager sqlIM;
        String table = null;
        GfxdPartitionResolver resolver = null;
        AbstractRegion region = null;
        if (this.routingInfoObjects != null) {
            String schemaName = this.qinfo.getSchemaName();
            String tableName = this.qinfo.getTableName();
            if (schemaName == null || tableName == null) {
                SingleHopInformation shifn = new SingleHopInformation("");
                shifn.setResolverType(0);
                return shifn;
            }
            table = schemaName + "." + tableName;
            region = this.qinfo.getRegion();
            if (region != null && region.getDataPolicy().withPartitioning()) {
                resolver = (GfxdPartitionResolver)((PartitionedRegion)this.qinfo.getRegion()).getPartitionResolver();
            }
        }
        SingleHopInformation shifn = new SingleHopInformation(table);
        if (this.routingInfoObjects == null) {
            shifn.setResolverType(0);
            return shifn;
        }
        if (this.qinfo.isQuery(8, 16, 2, 1, 32) || this.qinfo.isOuterJoinSpecialCase()) {
            shifn.setHasAggregate();
        }
        if (region != null && this.qinfo != null && this.qinfo.isDelete() && (sqlIM = (GfxdIndexManager)((LocalRegion)region).getIndexUpdater()).getFKS() != null) {
            shifn.setResolverType(0);
            return shifn;
        }
        this.partitionedRegionForSingleHop = (PartitionedRegion)region;
        if (resolver == null) {
            shifn.setResolverType(0);
            return shifn;
        }
        try {
            resolver.setResolverInfoInSingleHopInfoObject(shifn);
            if (this.partitionedRegionForSingleHop.isHDFSReadWriteRegion()) {
                shifn.setHdfsRegionCase();
            }
        }
        catch (StandardException e) {
            throw new GemFireXDRuntimeException(e);
        }
        shifn.setRoutingObjectInfoSet(this.routingInfoObjects);
        return shifn;
    }

    public void setRoutingObjects(Set robjsRoutingInfoObjects) {
        this.routingInfoObjects = robjsRoutingInfoObjects;
    }

    public QueryInfo getQueryInfo() {
        return this.qinfo;
    }

    public void setQueryInfoObject(QueryInfo qi) {
        this.qinfo = qi;
    }

    public void setPartitionedRegion(String regionPath) {
        this.partitionedRegionForSingleHop = (PartitionedRegion)Misc.getRegionForTable(regionPath, false);
    }

    public void incSingleHopStats(LanguageConnectionContext lcc) {
        if (lcc != null && lcc.statsEnabled()) {
            this.stats.incStat(24, false, 1L);
        }
    }

    public void setParentPS(GenericPreparedStatement gps) {
        this.parentPS = gps;
        if (gps != null) {
            if (gps.childPS == null) {
                gps.childPS = new ArrayList();
            }
            gps.childPS.add(this);
        }
    }

    public GenericPreparedStatement getParentPS() {
        return this.parentPS;
    }

    public void setUseOnlyPrimaryBuckets(boolean b) {
        this.useOnlyPrimaryBuckets = true;
    }

    public void setQueryHDFS(boolean val) {
        this.queryHDFS = val;
    }

    public void setHasQueryHDFS(boolean val) {
        this.hasQueryHDFS = val;
    }

    public void setPutDML(boolean val) {
        this.isPutDML = val;
    }

    @Override
    public boolean isPutDML() {
        return this.isPutDML;
    }

    public boolean hasQueryHDFS() {
        return this.hasQueryHDFS;
    }

    public boolean getQueryHDFS() {
        return this.queryHDFS;
    }

    public void setIsCallableStatement(boolean v) {
        this.isCallableStatement = v;
    }

    @Override
    public boolean isCallableStatement() {
        return this.isCallableStatement;
    }

    public void setDynamicTokenList(ArrayList<Token> tokenList) {
        this.dynamicTokenList = tokenList;
    }

    public ArrayList<Token> getDynamicTokenList() {
        return this.dynamicTokenList;
    }
}

