/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassFormatOutput;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassMember;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCJava;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCLocalField;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCMethod;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCMethodDescriptor;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.CodeChunk;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.GClass;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.Type;
import java.io.IOException;

class BCClass
extends GClass {
    String limitMsg;
    protected ClassHolder classHold;
    protected String superClassName;
    protected String name;
    BCJava factory;
    final Type classType;

    @Override
    public LocalField addField(String javaType, String name, int modifiers) {
        Type type = this.factory.type(javaType);
        ClassMember field = this.classHold.addMember(name, type.vmName(), modifiers);
        int cpi = this.classHold.addFieldReference(field);
        return new BCLocalField(type, cpi);
    }

    @Override
    public ByteArray getClassBytecode() throws StandardException {
        if (this.bytecode != null) {
            return this.bytecode;
        }
        try {
            if (SanityManager.DEBUG_ON((String)"ClassLineNumbers")) {
                ClassFormatOutput sout = new ClassFormatOutput(2);
                int cpiUTF = this.classHold.addUtf8("GC.java");
                sout.putU2(cpiUTF);
                this.classHold.addAttribute("SourceFile", sout);
            }
            this.bytecode = this.classHold.getFileFormat();
        }
        catch (IOException ioe) {
            throw StandardException.newException("XBCM1.S", (Throwable)ioe, (Object)this.getFullName());
        }
        this.classHold = null;
        if (SanityManager.DEBUG_ON((String)"DumpClassFile")) {
            String systemHome = System.getProperty("gemfirexd.system.home", ".");
            this.writeClassFile(systemHome, false, null);
        }
        if (SanityManager.DEBUG_ON((String)"ByteCodeGenInstr")) {
            SanityManager.DEBUG((String)"ByteCodeGenInstr", (String)("GEN complete for class " + this.name));
        }
        if (this.limitMsg != null) {
            throw StandardException.newException("XBCM4.S", (Object)this.getFullName(), (Object)this.limitMsg);
        }
        return this.bytecode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MethodBuilder newMethodBuilder(int modifiers, String returnType, String methodName) {
        return this.newMethodBuilder(modifiers, returnType, methodName, null);
    }

    @Override
    public MethodBuilder newMethodBuilder(int modifiers, String returnType, String methodName, String[] parms) {
        SanityManager.ASSERT((returnType != null ? 1 : 0) != 0);
        BCMethod m = new BCMethod(this, returnType, methodName, modifiers, parms, this.factory);
        return m;
    }

    @Override
    public MethodBuilder newConstructorBuilder(int modifiers) {
        BCMethod m = new BCMethod(this, "void", "<init>", modifiers, null, this.factory);
        return m;
    }

    String getSuperClassName() {
        return this.superClassName;
    }

    ClassHolder modify() {
        return this.classHold;
    }

    BCClass(ClassFactory cf, String packageName, int classModifiers, String className, String superClassName, BCJava factory) {
        super(cf, packageName.concat(className));
        if (SanityManager.DEBUG_ON((String)"ByteCodeGenInstr")) {
            SanityManager.DEBUG((String)"ByteCodeGenInstr", (String)("GEN starting for class " + className));
        }
        this.name = className;
        if (superClassName == null) {
            superClassName = "java.lang.Object";
        }
        this.superClassName = superClassName;
        this.classType = factory.type(this.getFullName());
        this.classHold = new ClassHolder(this.qualifiedName, factory.type((String)superClassName).vmNameSimple, classModifiers);
        this.factory = factory;
    }

    ClassFactory getClassFactory() {
        return this.cf;
    }

    @Override
    public void newFieldWithAccessors(String getter, String setter, int methodModifers, boolean staticField, String type) {
        String vmType = this.factory.type(type).vmName();
        methodModifers |= 0x10;
        int fieldModifiers = 2;
        if (staticField) {
            fieldModifiers |= 8;
        }
        ClassMember field = this.classHold.addMember(getter, vmType, fieldModifiers);
        int cpi = this.classHold.addFieldReference(field);
        String sig = BCMethodDescriptor.get(BCMethodDescriptor.EMPTY, vmType, this.factory);
        ClassMember method = this.classHold.addMember(getter, sig, methodModifers);
        CodeChunk chunk = new CodeChunk(this);
        if (!staticField) {
            chunk.addInstr((short)42);
        }
        chunk.addInstrU2(staticField ? (short)178 : 180, cpi);
        short vmTypeId = BCJava.vmTypeId(vmType);
        chunk.addInstr(CodeChunk.RETURN_OPCODE[vmTypeId]);
        int typeWidth = Type.width(vmTypeId);
        chunk.complete(null, this.classHold, method, typeWidth, 1);
        String[] pda = new String[]{vmType};
        sig = new BCMethodDescriptor(pda, "V", this.factory).toString();
        method = this.classHold.addMember(setter, sig, methodModifers);
        chunk = new CodeChunk(this);
        if (!staticField) {
            chunk.addInstr((short)42);
        }
        chunk.addInstr((short)(CodeChunk.LOAD_VARIABLE_FAST[vmTypeId] + 1));
        chunk.addInstrU2(staticField ? (short)179 : 181, cpi);
        chunk.addInstr((short)177);
        chunk.complete(null, this.classHold, method, typeWidth + (staticField ? 0 : 1), 1 + typeWidth);
    }

    void addLimitExceeded(BCMethod mb, String limitName, int limit, int value) {
        StringBuilder sb = new StringBuilder();
        if (this.limitMsg != null) {
            sb.append(this.limitMsg);
            sb.append(", ");
        }
        sb.append("method:");
        sb.append(mb.getName());
        sb.append(" ");
        sb.append(limitName);
        sb.append(" (");
        sb.append(value);
        sb.append(" > ");
        sb.append(limit);
        sb.append(")");
        this.limitMsg = sb.toString();
    }

    void addLimitExceeded(String rawText) {
        this.limitMsg = this.limitMsg != null ? this.limitMsg + ", " + rawText : rawText;
    }
}

