/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBStreamControl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.shared.common.error.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;

public class LOBInputStream
extends InputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;
    private long updateCount;

    LOBInputStream(LOBStreamControl control, long position) {
        this.control = control;
        this.pos = position;
        this.updateCount = control.getUpdateCount();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            int ret = this.control.read(b, off, len, this.pos);
            if (ret != -1) {
                this.pos += (long)ret;
                return ret;
            }
            return -1;
        }
        catch (StandardException se) {
            String state = se.getSQLState();
            if (state.equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ076.S"))) {
                return -1;
            }
            if (state.equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(se.getMessage());
            }
            throw Util.newIOException(se);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            int ret = this.control.read(this.pos);
            if (ret != -1) {
                ++this.pos;
            }
            return ret;
        }
        catch (StandardException se) {
            throw Util.newIOException(se);
        }
    }

    boolean isObsolete() {
        return this.updateCount != this.control.getUpdateCount();
    }

    void reInitialize() {
        this.updateCount = this.control.getUpdateCount();
        this.pos = 0L;
    }

    long length() throws IOException {
        return this.control.getLength();
    }
}

