/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import java.util.Locale;

public class SnappyUtils {
    public static String STORAGE_SIZE_UNIT_ANY = "ANY";
    public static String STORAGE_SIZE_UNIT_B = "B";
    public static String STORAGE_SIZE_UNIT_KB = "KB";
    public static String STORAGE_SIZE_UNIT_MB = "MB";
    public static String STORAGE_SIZE_UNIT_GB = "GB";
    public static String STORAGE_SIZE_UNIT_TB = "TB";
    public static String STORAGE_SIZE_UNIT_PB = "PB";

    public static double bytesToGivenUnits(long size, String expectedUnit) {
        long PB = 0x4000000000000L;
        long TB = 0x10000000000L;
        long GB = 0x40000000L;
        long MB = 0x100000L;
        long KB = 1024L;
        double value = expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_PB) ? (double)size / (double)PB : (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_TB) ? (double)size / (double)TB : (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_GB) ? (double)size / (double)GB : (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_MB) ? (double)size / (double)MB : (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_KB) ? (double)size / (double)KB : (double)size))));
        return value;
    }

    public static String bytesToString(long size, String expectedUnit) {
        String unit;
        double value;
        long PB = 0x4000000000000L;
        long TB = 0x10000000000L;
        long GB = 0x40000000L;
        long MB = 0x100000L;
        long KB = 1024L;
        if (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_PB) || size >= 2L * PB && expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_ANY)) {
            value = (double)size / (double)PB;
            unit = STORAGE_SIZE_UNIT_PB;
        } else if (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_TB) || size >= 2L * TB && expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_ANY)) {
            value = (double)size / (double)TB;
            unit = STORAGE_SIZE_UNIT_TB;
        } else if (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_GB) || size >= 2L * GB && expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_ANY)) {
            value = (double)size / (double)GB;
            unit = STORAGE_SIZE_UNIT_GB;
        } else if (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_MB) || size >= 2L * MB && expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_ANY)) {
            value = (double)size / (double)MB;
            unit = STORAGE_SIZE_UNIT_MB;
        } else if (expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_KB) || size >= 2L * KB && expectedUnit.equalsIgnoreCase(STORAGE_SIZE_UNIT_ANY)) {
            value = (double)size / (double)KB;
            unit = STORAGE_SIZE_UNIT_KB;
        } else {
            value = size;
            unit = STORAGE_SIZE_UNIT_B;
        }
        return String.format(Locale.getDefault(), "%.1f %s", value, unit);
    }
}

