/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Properties;

public final class GfxdObjectSizer
implements ObjectSizer,
Declarable {
    public int sizeof(Object o) {
        try {
            if (o instanceof DataValueDescriptor) {
                return ((DataValueDescriptor)o).getLengthInBytes(null) + ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            Class<?> c = o.getClass();
            if (c == byte[][].class) {
                byte[][] v;
                int size = 0;
                for (byte[] b : v = (byte[][])o) {
                    if (b == null) continue;
                    size += b.length;
                    size += ReflectionSingleObjectSizer.OBJECT_SIZE;
                }
                size += v.length * ReflectionSingleObjectSizer.REFERENCE_SIZE;
                return size += ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (c == CompactCompositeRegionKey.class) {
                CompactCompositeRegionKey ccrk = (CompactCompositeRegionKey)o;
                byte[] kbytes = ccrk.getKeyBytes();
                int size = 0;
                if (kbytes != null) {
                    size = kbytes.length;
                }
                return size += ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (c == CompositeRegionKey.class) {
                CompositeRegionKey crk = (CompositeRegionKey)o;
                int size = 0;
                for (int index = 0; index < crk.nCols(); ++index) {
                    DataValueDescriptor dvd = crk.getKeyColumn(index);
                    size += dvd.getLengthInBytes(null);
                }
                size += crk.nCols() * ReflectionSingleObjectSizer.REFERENCE_SIZE;
                return size += ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (c == Long.class) {
                return 8 + ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (c == DataValueDescriptor[].class) {
                DataValueDescriptor[] dvdArr = (DataValueDescriptor[])o;
                int size = 0;
                for (DataValueDescriptor dvd : dvdArr) {
                    size += dvd.getLengthInBytes(null);
                    size += ReflectionSingleObjectSizer.OBJECT_SIZE;
                }
                size += dvdArr.length * ReflectionSingleObjectSizer.REFERENCE_SIZE;
                return size += ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (c == byte[].class) {
                return ((byte[])o).length + ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (Token.isInvalidOrRemoved((Object)o)) {
                return 0;
            }
            return CachedDeserializableFactory.calcMemSize((Object)o);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("GfxdObjectSizer failed", e);
        }
    }

    public String toString() {
        return "GfxdObjectSizer";
    }

    public void init(Properties props) {
    }
}

