/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.db;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.GFToSlf4jBridge;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PersistentOplogSet;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TLongHashSet;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.db.DatabaseContextImpl;
import com.pivotal.gemfirexd.internal.engine.db.StoreClassFactoryContext;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLQueueEntry;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.ReplayableConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServerImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.sql.execute.DistributionObserver;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.JarReader;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.FileInfoDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdDiskStoreDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.util.DoubleProperties;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarResource;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public final class FabricDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    public static final String PROPERTY_NAME = GfxdConstants.GFXD_PREFIX + "database-object";
    private static final String TEMP_DIR_PREFIX = "gemfirexdtemp_";
    private volatile boolean active;
    private AuthenticationServiceBase authenticationService;
    private AuthenticationServiceBase peerAuthenticationService;
    protected GemFireStore memStore;
    protected PropertyFactory pf;
    protected volatile ClassFactory cfDB;
    private GfxdDataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private LogFactory logFactory;
    private DataValueFactory dataValueFactory;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;
    private boolean disableStatementOptimization;
    private boolean runtimeStatisticsOn;
    private DirFile tempDir;
    private final boolean allowBootWithFailures = SystemProperties.getServerInstance().getBoolean("gemfirexd.datadictionary.allow-startup-errors", false);
    public static boolean skipIndexCheck = SystemProperties.getServerInstance().getBoolean("gemfirexd.datadictionary.skip-index-check", false);
    public static final boolean disallowMetastoreOnLocator = SystemProperties.getServerInstance().getBoolean("snappydata.DISALLOW_METASTORE_ON_LOCATOR", false);
    int previousLevel = Integer.MAX_VALUE;

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        return Monitor.isDesiredCreateType(startParams, this.getEngineType());
    }

    public boolean allowBootWithFailures() {
        return this.allowBootWithFailures;
    }

    @Override
    public synchronized void boot(boolean create, Properties startParams) throws StandardException {
        String localeID;
        if (this.active) {
            return;
        }
        create = true;
        boolean hadoopLoner = "true".equalsIgnoreCase(startParams.getProperty("hadoop.gemfirexd.loner.mode"));
        if (hadoopLoner) {
            ClassSize.setDummyCatalog();
        }
        InternalDistributedSystem.setHadoopGfxdLonerMode((boolean)hadoopLoner);
        ModuleFactory monitor = Monitor.getMonitor();
        if (startParams.getProperty("gemfirexd.__rt.storage.createWithNoLog") == null) {
            startParams.put("gemfirexd.__rt.storage.createWithNoLog", "true");
        }
        if ((localeID = startParams.getProperty("territory")) == null) {
            localeID = Locale.getDefault().toString();
        }
        Locale locale = monitor.setLocale(startParams, localeID);
        this.setLocale(locale);
        this.bootValidation(create, startParams);
        startParams.put(PROPERTY_NAME, this);
        this.dataValueFactory = (DataValueFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory", startParams);
        this.logFactory = (LogFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory", startParams);
        this.authenticationService = this.bootAuthenticationService(create, startParams);
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Failed to set the Authentication service for the database");
        this.bootStore(create, startParams);
        assert (this.pf != null && this.memStore != null);
        this.myUUID = this.makeDatabaseID(create, startParams);
        DoubleProperties allParams = new DoubleProperties(this.getAllDatabaseProperties(), startParams);
        this.pf.addPropertySetNotification(this);
        this.bootClassFactory(create, allParams);
        ClassPathLoader.setLatestToDefaultWithCustomLoader((boolean)Boolean.getBoolean("gemfire.excludeThreadContextClassLoader"), (ClassPathLoader.ClassLoaderInterface)this.getClassFactory());
        this.dd = (GfxdDataDictionary)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary", allParams);
        this.lcf = (LanguageConnectionFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory", allParams);
        this.lf = (LanguageFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory", allParams);
        this.bootResourceAdapter(create, allParams);
        if (create && this.lastToBoot && startParams.getProperty("gemfirexd.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.disableStatementOptimization = Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING));
        this.active = true;
        GfxdManagementService.handleEvent(2, this.memStore);
    }

    private void notifyRunning() {
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        if (service instanceof FabricServiceImpl) {
            ((FabricServiceImpl)service).notifyRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void postCreate(EngineConnection conn, Properties bootProps) throws StandardException {
        if (this.memStore.initialDDLReplayDone()) {
            this.notifyRunning();
            return;
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        LogWriter logger = cache.getLogger();
        EmbedConnection embedConn = (EmbedConnection)conn;
        List<GfxdSystemProcedureMessage> postMsgs = null;
        try {
            LanguageConnectionContext lcc = embedConn.getLanguageConnection();
            GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
            if (this.memStore.isSnappyStore()) {
                this.memStore.setGlobalCmdRgn(this.createSnappySpecificGlobalCmdRegion(!this.memStore.isDataDictionaryPersistent()));
            }
            UUIDFactory factory = this.dd.getUUIDFactory();
            this.addInternalDiskStore(cache.findDiskStore("GFXD-DD-DISKSTORE"), factory);
            this.addInternalDiskStore(this.memStore.getDefaultDiskStore(), factory);
            this.addInternalDiskStore(cache.findDiskStore("SNAPPY-INTERNAL-DELTA"), factory);
            GfxdManagementService.handleEvent(4, embedConn);
            boolean ddReadLockAcquired = false;
            try {
                int cnt = 0;
                while (!(ddReadLockAcquired = this.dd.lockForReadingNoThrow(null, 0x3FFFFFFFFFFFFFFFL))) {
                    if (cnt >= 12) {
                        throw StandardException.newException("XJ040.C", "Could not acquire readlock on datadictionary before ddl replay");
                    }
                    Thread.sleep(5000L);
                }
                logger.info("acquired dd read lock during post create");
                if (this.memStore.restrictedDDLStmtQueue()) {
                    this.memStore.getDDLQueueNoThrow().initializeQueue(this.dd);
                } else {
                    this.memStore.getDDLStmtQueue().initializeQueue(this.dd);
                }
                postMsgs = this.postCreateDDLReplay(embedConn, bootProps, lcc, tc, logger);
            }
            finally {
                if (ddReadLockAcquired) {
                    this.dd.unlockAfterReading(null);
                }
            }
            this.notifyRunning();
            String postScriptsPath = bootProps.getProperty("init-scripts");
            if (postScriptsPath != null && postScriptsPath.length() > 0) {
                String[] postScriptPaths = postScriptsPath.split(",");
                GemFireXDUtils.executeSQLScripts((Connection)embedConn, postScriptPaths, false, logger, null, null, false);
            }
            this.initializeCatalog();
        }
        catch (Throwable t) {
            StandardException se;
            SQLException sqle;
            try {
                if (logger != null) {
                    logger.warning("got throwable: " + t.getMessage() + " calling shut down", t);
                }
                Monitor.getMonitor().shutdown();
            }
            catch (CancelException tc) {
                // empty catch block
            }
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Failed to boot database", (Throwable)t);
            }
            Throwable checkEx = t;
            if (t instanceof GemFireXDRuntimeException) {
                checkEx = t.getCause();
            }
            if (checkEx instanceof SQLException && (sqle = (SQLException)checkEx).getSQLState() != null && sqle.getSQLState().startsWith("XBM")) {
                throw Misc.wrapSQLException(sqle, sqle);
            }
            if (checkEx instanceof StandardException && (se = (StandardException)checkEx).getSQLState() != null && se.getSQLState().startsWith("XBM")) {
                throw se;
            }
            throw StandardException.newException("XJ040.C", t, (Object)"gemfirexd");
        }
        for (GfxdSystemProcedureMessage msg : postMsgs) {
            if (msg.getSysProcMethod().isOffHeapMethod() && this.memStore.getGemFireCache().getOffHeapStore() == null) {
                if (!logger.severeEnabled()) continue;
                logger.severe("FabricDatabase: aborted initial replay for message " + msg + " method " + msg.getSysProcMethod().name());
                continue;
            }
            try {
                msg.execute();
            }
            catch (Exception ex) {
                if (logger.severeEnabled()) {
                    logger.severe("FabricDatabase: failed initial replay for message " + msg + " due to exception", (Throwable)ex);
                }
                throw StandardException.newException("XJ040.C", (Throwable)ex, (Object)"gemfirexd");
            }
        }
    }

    private Region createSnappySpecificGlobalCmdRegion(boolean isLead) throws IOException, ClassNotFoundException {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        AttributesFactory afact = new AttributesFactory();
        afact.setScope(Scope.DISTRIBUTED_ACK);
        if (!isLead) {
            afact.setInitialCapacity(1000);
            afact.setConcurrencyChecksEnabled(false);
            afact.setDiskSynchronous(true);
            afact.setDiskStoreName("GFXD-DD-DISKSTORE");
            afact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            afact.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        } else {
            afact.setDataPolicy(DataPolicy.REPLICATE);
        }
        InternalRegionArguments internalRegionArgs = new InternalRegionArguments();
        return cache.createVMRegion("__snappyglobalcmds__", afact.create(), internalRegionArgs);
    }

    private void addInternalDiskStore(DiskStoreImpl ds, UUIDFactory factory) throws StandardException {
        if (ds != null) {
            UUID id = factory.recreateUUID(ds.getName());
            GfxdDiskStoreDescriptor dsd = new GfxdDiskStoreDescriptor(this.dd, id, (DiskStore)ds, ds.getDiskDirs()[0].getAbsolutePath());
            this.dd.addDescriptor(dsd, null, 20, false, this.dd.getTransactionExecute());
        }
    }

    public void initializeCatalog() throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        HashSet<String> leadGroup = CallbackFactoryProvider.getClusterCallbacks().getLeaderGroup();
        boolean isLead = this.memStore.isSnappyStore() && leadGroup != null && leadGroup.size() > 0 && (ServerGroupUtils.isGroupMember(leadGroup) || Misc.getDistributedSystem().isLoner());
        Set<DistributedMember> servers = GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
        if (this.memStore.isSnappyStore() && (this.memStore.getMyVMKind() == GemFireStore.VMKind.DATASTORE || isLead)) {
            this.memStore.initExternalCatalog();
            if (isLead) {
                this.memStore.setExternalCatalogInit(cache.getDistributionManager().getFunctionExcecutor().submit(() -> {
                    GemFireStore.externalCatalogInitThread.set(Boolean.TRUE);
                    EmbedConnection embedConnection = null;
                    try {
                        GemFireXDUtils.waitForNodeInitialization();
                        embedConnection = GemFireXDUtils.createNewInternalConnection(false, -1L);
                        FabricDatabase.checkSnappyCatalogConsistency(embedConnection, true, false);
                        this.memStore.getDatabase().publishColumnStats();
                    }
                    catch (StandardException | SQLException e) {
                        throw new GemFireXDRuntimeException(e);
                    }
                    finally {
                        if (embedConnection != null) {
                            try {
                                embedConnection.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }));
            }
        }
    }

    private void publishColumnStats() {
        if (this.memStore.isSnappyStore() && (this.memStore.getMyVMKind() == GemFireStore.VMKind.DATASTORE || Misc.getDistributedSystem().isLoner())) {
            GemFireXDUtils.waitForNodeInitialization();
            CallbackFactoryProvider.getClusterCallbacks().publishColumnTableStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSnappyCatalogConsistency(EmbedConnection embedConn, boolean removeInconsistentEntries, boolean removeTablesWithData) throws StandardException, SQLException {
        HashMap<String, List<String>> gfDBTablesMap;
        Map<String, List<String>> hiveDBTablesMap;
        GemFireStore memStore = Misc.getMemStoreBooting();
        ExternalCatalog externalCatalog = memStore.getExternalCatalog(false);
        if (externalCatalog == null) {
            return;
        }
        LanguageConnectionContext lcc = embedConn.getLanguageConnection();
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        try {
            lcc.getDataDictionary().lockForReading(tc);
            hiveDBTablesMap = externalCatalog.getAllStoreTablesInCatalog();
            gfDBTablesMap = FabricDatabase.getAllGFXDTables();
        }
        finally {
            lcc.getDataDictionary().unlockAfterReading(tc);
        }
        gfDBTablesMap.remove(externalCatalog.catalogSchemaName());
        LinkedList internalColumnTablesList = new LinkedList();
        LinkedList<String> internalColumnTablesListPerSchema = new LinkedList<String>();
        for (Map.Entry e : gfDBTablesMap.entrySet()) {
            for (String t : (List)e.getValue()) {
                if (!CallbackFactoryProvider.getStoreCallbacks().isColumnTable((String)e.getKey() + "." + t)) continue;
                internalColumnTablesListPerSchema.add(t);
            }
            ((List)e.getValue()).removeAll(internalColumnTablesListPerSchema);
            internalColumnTablesList.addAll(internalColumnTablesListPerSchema);
            internalColumnTablesListPerSchema.clear();
        }
        HashSet<String> internalColumnTablesSet = new HashSet<String>(internalColumnTablesList);
        FabricDatabase.removeInconsistentDDEntries(embedConn, hiveDBTablesMap, gfDBTablesMap, internalColumnTablesSet, externalCatalog, removeInconsistentEntries, removeTablesWithData);
        FabricDatabase.removeInconsistentHiveEntries(hiveDBTablesMap, gfDBTablesMap, externalCatalog, removeInconsistentEntries, removeTablesWithData);
    }

    private static void removeInconsistentDDEntries(EmbedConnection embedConn, Map<String, List<String>> hiveDBTablesMap, Map<String, List<String>> gfDBTablesMap, Set<String> internalColumnTablesSet, ExternalCatalog externalCatalog, boolean removeInconsistentEntries, boolean removeTablesWithData) throws SQLException {
        for (Map.Entry<String, List<String>> storeEntry : gfDBTablesMap.entrySet()) {
            List<String> hiveTableList = hiveDBTablesMap.get(storeEntry.getKey());
            LinkedList<String> storeTablesList = new LinkedList<String>((Collection)storeEntry.getValue());
            if (hiveTableList != null && !hiveTableList.isEmpty()) {
                storeTablesList.removeAll(hiveTableList);
            }
            if (!storeTablesList.isEmpty()) {
                SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("Catalog inconsistency detected: following tables in datadictionary are not in Hive metastore: schema = " + storeEntry.getKey() + " tables = " + storeTablesList));
                if (removeInconsistentEntries) {
                    FabricDatabase.dropTables(embedConn, storeEntry.getKey(), storeTablesList, removeTablesWithData);
                } else {
                    SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)"Use system procedure SYS.REPAIR_CATALOG() to remove inconsistency");
                }
            }
            LinkedList<String> tablesMissingColumnBuffer = new LinkedList<String>();
            for (String storeTable : storeEntry.getValue()) {
                if (!externalCatalog.isColumnTable(storeEntry.getKey(), storeTable, false)) continue;
                String columnBatchTable = com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider.getStoreCallbacks().columnBatchTableName(storeEntry.getKey() + "." + storeTable);
                if (internalColumnTablesSet.contains(columnBatchTable = columnBatchTable.substring(columnBatchTable.indexOf(".") + 1))) continue;
                tablesMissingColumnBuffer.add(storeTable);
            }
            if (tablesMissingColumnBuffer.isEmpty()) continue;
            SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("Catalog inconsistency detected: following column tables do not have column buffer: schema = " + storeEntry.getKey() + " tables = " + tablesMissingColumnBuffer));
            if (removeInconsistentEntries) {
                FabricDatabase.dropTables(embedConn, storeEntry.getKey(), tablesMissingColumnBuffer, removeTablesWithData);
                FabricDatabase.removeTableFromHivestore(storeEntry.getKey(), tablesMissingColumnBuffer, externalCatalog);
                continue;
            }
            SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)"Use system procedure SYS.REPAIR_CATALOG() to remove inconsistency");
        }
    }

    private static void removeInconsistentHiveEntries(Map<String, List<String>> hiveDBTablesMap, Map<String, List<String>> gfDBTablesMap, ExternalCatalog externalCatalog, boolean removeInconsistentEntries, boolean removeTablesWithData) {
        for (Map.Entry<String, List<String>> hiveEntry : hiveDBTablesMap.entrySet()) {
            List<String> storeTableList = gfDBTablesMap.get(hiveEntry.getKey());
            LinkedList<String> hiveTableList = new LinkedList<String>((Collection)hiveEntry.getValue());
            if (storeTableList != null && !storeTableList.isEmpty()) {
                hiveTableList.removeAll(storeTableList);
            }
            if (hiveEntry.getKey().equalsIgnoreCase("SYSIBM")) {
                hiveTableList.remove("SYSDUMMY1");
            }
            if (hiveTableList.isEmpty()) continue;
            SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("Catalog inconsistency detected: following tables in Hive metastore are not in datadictionary: schema = " + hiveEntry.getKey() + " tables = " + hiveTableList));
            if (removeInconsistentEntries) {
                FabricDatabase.removeTableFromHivestore(hiveEntry.getKey(), hiveTableList, externalCatalog);
                continue;
            }
            SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)"Use system procedure SYS.REPAIR_CATALOG() to remove inconsistency");
        }
    }

    private static final void removeTableFromHivestore(String schema, List<String> tables, ExternalCatalog externalCatalog) {
        for (String table : tables) {
            SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("Removing table " + schema + "." + table + " from Hive metastore"));
            externalCatalog.removeTableIfExists(schema, table, false);
        }
    }

    private static final void dropTables(EmbedConnection embedConn, String schema, List<String> tables, boolean removeTablesWithData) throws SQLException {
        for (String table : tables) {
            try {
                Region rowTableRegion;
                String tableName = schema + "." + table;
                SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("FabricDatabase.dropTables  processing " + tableName));
                String columnBatchTableName = com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider.getStoreCallbacks().columnBatchTableName(tableName);
                boolean columnBatchTableExists = false;
                Region columnBuffer = Misc.getRegionForTable(columnBatchTableName, false);
                if (columnBuffer != null) {
                    boolean tableContainsData;
                    Region rowBuffer = Misc.getRegionForTable(tableName, false);
                    boolean bl = tableContainsData = columnBuffer.size() != 0 || rowBuffer != null && rowBuffer.size() != 0;
                    if (!tableContainsData || tableContainsData && removeTablesWithData) {
                        SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("Dropping table " + columnBatchTableName));
                        embedConn.createStatement().execute("DROP TABLE IF EXISTS " + columnBatchTableName);
                    } else {
                        columnBatchTableExists = true;
                        SanityManager.DEBUG_PRINT((String)"warning:CATALOG", (String)("Not dropping table " + columnBatchTableName + " as it is not empty"));
                    }
                }
                if (columnBatchTableExists || (rowTableRegion = Misc.getRegionForTable(tableName, false)) == null) continue;
                if (rowTableRegion.size() == 0 || removeTablesWithData) {
                    SanityManager.DEBUG_PRINT((String)"info", (String)("Dropping table " + tableName));
                    embedConn.createStatement().execute("DROP TABLE IF EXISTS " + tableName);
                    continue;
                }
                SanityManager.DEBUG_PRINT((String)"info", (String)("Not dropping table " + tableName + " as it is not empty"));
            }
            catch (SQLException se) {
                SanityManager.DEBUG_PRINT((String)"info", (String)"SQLException: ", (Throwable)se);
            }
        }
    }

    private static final HashMap<String, List<String>> getAllGFXDTables() {
        List<GemFireContainer> gfContainers = Misc.getMemStoreBooting().getAllContainers();
        HashMap<String, List<String>> gfDBTablesMap = new HashMap<String, List<String>>();
        for (GemFireContainer gc : gfContainers) {
            if (!gc.isApplicationTable()) continue;
            List<String> tableList = gfDBTablesMap.get(gc.getSchemaName());
            if (tableList == null) {
                tableList = new LinkedList<String>();
                gfDBTablesMap.put(gc.getSchemaName(), tableList);
            }
            tableList.add(gc.getTableName());
        }
        return gfDBTablesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GfxdSystemProcedureMessage> postCreateDDLReplay(EmbedConnection embedConn, Properties bootProps, LanguageConnectionContext lcc, GemFireTransaction tc, LogWriter logger) throws Exception {
        Object sync;
        GfxdDDLRegionQueue ddlStmtQueue = this.memStore.getDDLQueueNoThrow();
        String initSchema = lcc.getCurrentSchemaName();
        String lastCurrentSchema = initSchema != null ? initSchema : "APP";
        lcc.setIsConnectionForRemote(true);
        lcc.setIsConnectionForRemoteDDL(false);
        lcc.setSkipLocks(true);
        lcc.setQueryRoutingFlag(false);
        tc.resetActiveTXState(false);
        Object object = sync = this.memStore.getInitialDDLReplaySync();
        synchronized (object) {
            this.memStore.setInitialDDLReplayInProgress(true);
            sync.notifyAll();
        }
        this.memStore.getDistributionAdvisor().distributeNodeStatus(false);
        lcc.setIsConnectionForRemote(true);
        lcc.setSkipLocks(true);
        GfxdDDLQueueEntry qEntry = null;
        ArrayList<GemFireContainer> uninitializedContainers = new ArrayList<GemFireContainer>();
        LinkedHashSet<GemFireContainer> uninitializedTables = new LinkedHashSet<GemFireContainer>();
        Statement stmt = embedConn.createStatement();
        ArrayList<GfxdSystemProcedureMessage> postMessages = new ArrayList<GfxdSystemProcedureMessage>();
        try {
            GemFireContainer container;
            List<GfxdDDLQueueEntry> currentQueue;
            TLongHashSet processedIds;
            TLongHashSet tLongHashSet = processedIds = this.memStore.getProcessedDDLIDs();
            synchronized (tLongHashSet) {
                currentQueue = ddlStmtQueue.peekAndRemoveFromQueue(-1, -1);
                for (GfxdDDLQueueEntry entry : currentQueue) {
                    Object qVal = entry.getValue();
                    if (!(qVal instanceof ReplayableConflatable)) continue;
                    ((ReplayableConflatable)qVal).markExecuting();
                }
                Iterator<GfxdDDLQueueEntry> iter = currentQueue.iterator();
                while (iter.hasNext()) {
                    GfxdDDLQueueEntry entry;
                    entry = iter.next();
                    Long key = entry.getKey();
                    if (processedIds.add(key.longValue())) continue;
                    iter.remove();
                }
            }
            HashMap<DDLConflatable, DDLConflatable> skipRegionInit = new HashMap<DDLConflatable, DDLConflatable>();
            TObjectIntHashMap pre11TableSchemaVer = new TObjectIntHashMap();
            boolean traceConflation = GemFireXDUtils.TraceConflation | DistributionManager.VERBOSE | GemFireXDUtils.TraceIndex;
            List<GfxdDDLQueueEntry> preprocessedQueue = ddlStmtQueue.getPreprocessedDDLQueue(currentQueue, skipRegionInit, lastCurrentSchema, pre11TableSchemaVer, traceConflation);
            Iterator<GfxdDDLQueueEntry> iterator = preprocessedQueue.iterator();
            while (iterator.hasNext()) {
                block69: {
                    AbstractGfxdReplayableMessage msg;
                    GfxdDDLQueueEntry entry;
                    qEntry = entry = iterator.next();
                    Object qVal = qEntry.getValue();
                    if (logger.infoEnabled()) {
                        logger.info("FabricDatabase: starting initial replay for entry: " + qEntry);
                    }
                    LocalRegion.clearInitializingRegion();
                    if (qVal instanceof GfxdSystemProcedureMessage) {
                        msg = (GfxdSystemProcedureMessage)qVal;
                        if (((GfxdSystemProcedureMessage)msg).postprocess()) {
                            postMessages.add((GfxdSystemProcedureMessage)msg);
                            continue;
                        }
                        if (((GfxdSystemProcedureMessage)msg).getSysProcMethod().isOffHeapMethod() && this.memStore.getGemFireCache().getOffHeapStore() == null) {
                            if (!logger.severeEnabled()) continue;
                            logger.severe("FabricDatabase: aborted initial replay for message " + msg + " method " + ((GfxdSystemProcedureMessage)msg).getSysProcMethod().name());
                            continue;
                        }
                        try {
                            ((GfxdSystemProcedureMessage)msg).execute();
                            break block69;
                        }
                        catch (Exception ex) {
                            if (logger.severeEnabled()) {
                                logger.severe("FabricDatabase: failed initial replay for message " + msg + " due to exception", (Throwable)ex);
                            }
                            this.throwBootException(ex, embedConn);
                            continue;
                        }
                    }
                    if (qVal instanceof AbstractGfxdReplayableMessage) {
                        if (this.memStore.restrictedDDLStmtQueue()) continue;
                        msg = (AbstractGfxdReplayableMessage)qVal;
                        try {
                            msg.execute();
                            break block69;
                        }
                        catch (Exception ex) {
                            if (logger.severeEnabled()) {
                                logger.severe("FabricDatabase: failed initial replay for message " + msg + " due to exception", (Throwable)ex);
                            }
                            this.throwBootException(ex, embedConn);
                            continue;
                        }
                    }
                    Iterator conflatable = (DDLConflatable)qVal;
                    String schemaForTable = ((DDLConflatable)((Object)conflatable)).getSchemaForTableNoThrow();
                    if (this.memStore.restrictedDDLStmtQueue() && (disallowMetastoreOnLocator || schemaForTable == null || !Misc.isSnappyHiveMetaTable(schemaForTable))) continue;
                    String confTable = ((DDLConflatable)((Object)conflatable)).getRegionToConflate();
                    boolean isCreateTable = ((DDLConflatable)((Object)conflatable)).isCreateTable();
                    boolean skipInitialization = false;
                    int n = 0;
                    if (pre11TableSchemaVer.size() > 0 && (isCreateTable || ((DDLConflatable)((Object)conflatable)).isAlterTable())) {
                        n = pre11TableSchemaVer.get((Object)confTable);
                    }
                    if (isCreateTable || ((DDLConflatable)((Object)conflatable)).isCreateIndex() || ((DDLConflatable)((Object)conflatable)).isAlterTable()) {
                        skipInitialization = true;
                    }
                    String schema = this.executeDDL((DDLConflatable)((Object)conflatable), stmt, skipInitialization, embedConn, lastCurrentSchema, lcc, tc, logger);
                    if (isCreateTable && skipInitialization) {
                        uninitializedTables.add((GemFireContainer)Misc.getRegionForTableByPath(confTable, true).getUserAttribute());
                    }
                    if (n > 0 && (container = (GemFireContainer)Misc.getRegionForTableByPath(confTable, true).getUserAttribute()) != null && container.getCurrentSchemaVersion() == n) {
                        if (logger.infoEnabled()) {
                            logger.info("FabricDatabase: setting schema version for pre 1.1 data to " + n + " for table " + confTable);
                        }
                        container.initPre11SchemaVersionOnRecovery(this.dd, lcc);
                        pre11TableSchemaVer.remove((Object)confTable);
                    }
                    if (schema == null) continue;
                    lastCurrentSchema = schema;
                }
                if (!logger.infoEnabled()) continue;
                logger.info("FabricDatabase: successfully replayed entry having sequenceId=" + qEntry.getSequenceId());
            }
            if (this.previousLevel != Integer.MAX_VALUE) {
                GFToSlf4jBridge bridgeLogger = (GFToSlf4jBridge)logger;
                bridgeLogger.setLevel(this.previousLevel);
                this.previousLevel = Integer.MAX_VALUE;
            }
            this.memStore.setInitialDDLReplayPart1Done(true);
            for (GemFireContainer container2 : this.memStore.getAllContainers()) {
                LocalRegion region = container2.getRegion();
                if (region == null || uninitializedTables.contains(container2) || region.isInitialized() || region.isDestroyed()) continue;
                uninitializedContainers.add(container2);
            }
            for (GemFireContainer container2 : uninitializedTables) {
                LocalRegion lr = container2.getRegion();
                if (lr == null || lr.isDestroyed() || lr.isInitialized() || this.memStore.findConglomerate(container2.getId()) == null) continue;
                uninitializedContainers.add(container2);
            }
            for (GemFireContainer container2 : uninitializedContainers) {
                container2.preInitializeRegion();
            }
            GemFireCacheImpl cache = Misc.getGemFireCache();
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            THashMap accountingMap = null;
            if (observer != null && observer.needIndexRecoveryAccounting()) {
                accountingMap = new THashMap();
                for (DiskStoreImpl dsi : cache.listDiskStores()) {
                    dsi.TEST_INDEX_ACCOUNTING_MAP = accountingMap;
                }
                observer.setIndexRecoveryAccountingMap(accountingMap);
            }
            this.memStore.markIndexLoadBegin();
            for (DiskStoreImpl dsi : cache.listDiskStores()) {
                long start = 0L;
                if (logger.infoEnabled()) {
                    start = System.currentTimeMillis();
                    logger.info("FabricDatabase: waiting for index loading from " + dsi.getName());
                }
                dsi.waitForIndexRecoveryEnd(-1L);
                if (!logger.infoEnabled()) continue;
                long end = System.currentTimeMillis();
                logger.info(MessageFormat.format("FabricDatabase: Index loading completed for {0} in {1} ms", dsi.getName(), end - start));
            }
            if (!skipIndexCheck && this.memStore.isPersistIndexes() && this.memStore.getMyVMKind() == GemFireStore.VMKind.DATASTORE) {
                try {
                    this.checkRecoveredIndex(uninitializedContainers, logger, false);
                }
                catch (RuntimeException ex) {
                    logger.info("Runtime exception while doing checkRecoveredIndex ex: " + ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
            if (Thread.currentThread().getName().equals("ReconnectThread")) {
                for (GemFireContainer container3 : uninitializedContainers) {
                    if (logger.infoEnabled() && !Misc.isSnappyHiveMetaTable(container3.getSchemaName())) {
                        logger.info("FabricDatabase: start initializing container: " + container3);
                    }
                    container3.initializeRegion();
                    if (!logger.infoEnabled() || Misc.isSnappyHiveMetaTable(container3.getSchemaName())) continue;
                    logger.info("FabricDatabase: end initializing container: " + container3);
                }
            } else {
                ExecutorService execService = cache.getDistributionManager().getWaitingThreadPool();
                ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
                ArrayList<GemFireContainer> failed = new ArrayList<GemFireContainer>(1);
                for (GemFireContainer container4 : uninitializedContainers) {
                    if (logger.infoEnabled() && !Misc.isSnappyHiveMetaTable(container4.getSchemaName())) {
                        logger.info("FabricDatabase: start initializing container: " + container4);
                    }
                    FabricService fabricService = FabricServiceManager.currentFabricServiceInstance();
                    ReentrantLock lock = new ReentrantLock();
                    Future<Boolean> f = execService.submit(() -> {
                        boolean initialized = false;
                        try {
                            if (observer != null) {
                                observer.regionPreInitialized(container4);
                            }
                            container4.initializeRegion();
                            initialized = true;
                        }
                        finally {
                            if (service instanceof FabricServerImpl) {
                                ((FabricServerImpl)service).notifyTableInitialized(initialized, container4.getRegion().getFullPath());
                            }
                        }
                        return true;
                    });
                    if (fabricService instanceof FabricServerImpl) {
                        ((FabricServerImpl)fabricService).waitTableInitialized(f, container4.getRegion().getFullPath());
                        if (!((FabricServerImpl)fabricService).isInitializedOrWait()) {
                            try {
                                f.get();
                            }
                            catch (ExecutionException failure) {
                                if (logger.warningEnabled()) {
                                    logger.warning("FabricDatabase: error in initialization of container: " + container4 + ".", (Throwable)failure);
                                }
                                if (failure.getCause() instanceof StandardException) {
                                    throw (StandardException)failure.getCause();
                                }
                                throw failure;
                            }
                        }
                    }
                    results.add(f);
                    if (!logger.infoEnabled() || Misc.isSnappyHiveMetaTable(container4.getSchemaName())) continue;
                    logger.info("FabricDatabase: end initializing container: " + container4);
                }
                int index = 0;
                for (Future future : results) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException failure) {
                        container = uninitializedContainers.get(index);
                        if (logger.warningEnabled()) {
                            logger.warning("FabricDatabase: error in initialization of container: " + container + ". Will retry.", (Throwable)failure);
                        }
                        failed.add(container);
                    }
                    ++index;
                }
                if (!failed.isEmpty()) {
                    for (GemFireContainer gemFireContainer : failed) {
                        if (logger.infoEnabled() && !Misc.isSnappyHiveMetaTable(gemFireContainer.getSchemaName())) {
                            logger.info("FabricDatabase: start initializing container: " + gemFireContainer);
                        }
                        gemFireContainer.initializeRegion();
                        if (!logger.infoEnabled() || Misc.isSnappyHiveMetaTable(gemFireContainer.getSchemaName())) continue;
                        logger.info("FabricDatabase: end initializing container: " + gemFireContainer);
                    }
                }
            }
            ddlStmtQueue.clearQueue();
            String currentSchema = lcc.getCurrentSchemaName();
            if (currentSchema == null) {
                currentSchema = "APP";
            }
            this.memStore.postDDLReplayInitialization(tc);
            for (GemFireContainer container6 : uninitializedContainers) {
                if (GemFireXDUtils.TraceDDLReplay) {
                    logger.info("FabricDatabase: start initializing numRows for " + container6);
                }
                container6.initNumRows(container6.getRegion());
                if (!GemFireXDUtils.TraceDDLReplay) continue;
                logger.info("FabricDatabase: end initializing numRows for " + container6 + " initialized with total number of rows: " + container6.getNumRows());
            }
            if (!lastCurrentSchema.equals(currentSchema)) {
                FabricDatabase.setupDefaultSchema(this.dd, lcc, tc, currentSchema, true);
            }
            if (!this.memStore.isHadoopGfxdLonerMode()) {
                SystemProcedures.SET_EXPLAIN_SCHEMA(lcc);
            }
            lcc.setIsConnectionForRemote(false);
            lcc.setSkipLocks(false);
            Object object2 = sync;
            synchronized (object2) {
                this.memStore.setInitialDDLReplayInProgress(false);
                this.memStore.setInitialDDLReplayDone(true);
                sync.notifyAll();
            }
            if (logger.infoEnabled()) {
                logger.info("FabricDatabase: initial DDL replay completed.");
            }
            AuthenticationServiceBase.refreshAuthenticationServices(this, this.memStore, this.pf, bootProps);
            if (logger.infoEnabled()) {
                logger.info("FabricDatabase: Authentication recheck successful.");
            }
        }
        finally {
            stmt.close();
            this.memStore.setInitialDDLReplayInProgress(false);
            if (!ArrayUtils.objectEquals((Object)initSchema, (Object)lcc.getCurrentSchemaName())) {
                FabricDatabase.setupDefaultSchema(this.dd, lcc, tc, initSchema, true);
            }
        }
        return postMessages;
    }

    private void checkRecoveredIndex(ArrayList<GemFireContainer> uninitializedContainers, LogWriter logger, boolean throwErrorOnMismatch) {
        for (GemFireContainer container : uninitializedContainers) {
            GfxdIndexManager gim;
            LocalRegion region = container.getRegion();
            DataPolicy dp = region.getDataPolicy();
            if (dp != DataPolicy.PERSISTENT_PARTITION && dp != DataPolicy.PERSISTENT_REPLICATE || (gim = (GfxdIndexManager)region.getIndexUpdater()) == null || container.isGlobalIndex()) continue;
            int localRegionSize = this.getAndDumpLocalRegionSize(region, dp, logger, false, throwErrorOnMismatch);
            List<GemFireContainer> allIndexes = gim.getAllIndexes();
            for (GemFireContainer c : allIndexes) {
                if (!c.isLocalIndex()) continue;
                int indexSize = c.getIndexSize();
                if (indexSize != localRegionSize) {
                    if (!throwErrorOnMismatch) {
                        logger.warning("checkRecoveredIndex: for table: " + region.getName() + " number of local entries = " + localRegionSize + " and number of index entries in the index: " + c.getName() + " = " + c.getIndexSize());
                        localRegionSize = this.getRegionSizeByIterating(region, dp);
                        if (indexSize == localRegionSize) continue;
                        logger.info("FabricDatabase: index and region out of sync even after iterating. Recreating the indexes");
                        this.clearAllIndexes(uninitializedContainers);
                        this.recreateAllLocalIndexes(logger);
                        this.checkRecoveredIndex(uninitializedContainers, logger, true);
                        continue;
                    }
                    localRegionSize = this.getRegionSizeByIterating(region, dp);
                    if (indexSize == localRegionSize) continue;
                    logger.error("checkRecoveredIndex: for table: " + region.getName() + " number of local entries (after getRegionSizeByIterating) = " + localRegionSize + " and number of index entries in the index: " + c.getName() + " = " + c.getIndexSize());
                    this.dumpIndexAndRegion(region, dp, c, logger);
                    throw new IllegalStateException("Table data and indexes are not reconciling. Probably need to revoke the disk store");
                }
                if (!logger.fineEnabled()) continue;
                logger.fine("checkRecoveredIndex: local index: " + c.getName() + " and table: " + region.getName() + " with size: " + localRegionSize);
            }
        }
    }

    private int getRegionSizeByIterating(LocalRegion region, DataPolicy dp) {
        int sz;
        block4: {
            block3: {
                sz = 0;
                if (dp != DataPolicy.PERSISTENT_PARTITION) break block3;
                DiskStoreImpl ds = region.getDiskStore();
                Collection diskRegions = ds.getAllDiskRegions().values();
                String regionPath = region.getFullPath();
                int prId = ((PartitionedRegion)region).getPRId();
                long regionUUId = region.getRegionUUID();
                for (AbstractDiskRegion diskReg : diskRegions) {
                    RegionMap rmap;
                    long parentUUid = diskReg.getUUID();
                    if (parentUUid != regionUUId || diskReg.getName().contains("____") || (rmap = diskReg.getRecoveredEntryMap()) == null) continue;
                    Collection res = rmap != null ? rmap.regionEntriesInVM() : null;
                    for (RegionEntry re : res) {
                        if (re.getValueAsToken() == Token.TOMBSTONE) continue;
                        ++sz;
                    }
                }
                break block4;
            }
            RegionMap rmap = region.getRegionMap();
            if (rmap == null) break block4;
            Collection res = rmap.regionEntriesInVM();
            for (RegionEntry re : res) {
                if (re.getValueAsToken() == Token.TOMBSTONE) continue;
                ++sz;
            }
        }
        return sz;
    }

    private void dumpIndexAndRegion(LocalRegion region, DataPolicy dp, GemFireContainer index, LogWriter logger) {
        ((MemIndex)index.getConglomerate()).dumpIndex("Dumping all indexes");
        this.getAndDumpLocalRegionSize(region, dp, logger, true, false);
    }

    private void clearAllIndexes(ArrayList<GemFireContainer> uninitializedContainers) {
        for (GemFireContainer container : uninitializedContainers) {
            GfxdIndexManager gim;
            LocalRegion region = container.getRegion();
            DataPolicy dp = region.getDataPolicy();
            if (dp != DataPolicy.PERSISTENT_PARTITION && dp != DataPolicy.PERSISTENT_REPLICATE || (gim = (GfxdIndexManager)region.getIndexUpdater()) == null) continue;
            List<GemFireContainer> allIndexes = gim.getAllIndexes();
            for (GemFireContainer c : allIndexes) {
                if (!c.isLocalIndex()) continue;
                c.getSkipListMap().clear();
                c.resetInitialAccounting();
            }
        }
    }

    private void recreateAllLocalIndexes(LogWriter logger) {
        Collection diskStores = Misc.getGemFireCache().listDiskStores();
        for (DiskStoreImpl ds : diskStores) {
            PersistentOplogSet oplogSet = ds.getPersistentOplogSet(null);
            ds.resetIndexRecoveryState();
            ds.scheduleIndexRecovery((Set)oplogSet.getSortedOplogs(), true);
            logger.info("FabricDatabase: recreateAllLocalIndexes waiting for index re-creation for disk store: " + ds.getName());
            ds.waitForIndexRecoveryEnd(-1L);
            logger.info("FabricDatabase: recreateAllLocalIndexes index re-creation for disk store: " + ds.getName() + " ended");
        }
    }

    private int getAndDumpLocalRegionSize(LocalRegion region, DataPolicy dp, LogWriter logger, boolean dump, boolean throwErrorOnMismatch) {
        int sz = 0;
        if (dp == DataPolicy.PERSISTENT_PARTITION) {
            DiskStoreImpl ds = region.getDiskStore();
            Collection diskRegions = ds.getAllDiskRegions().values();
            String regionPath = region.getFullPath();
            int prId = ((PartitionedRegion)region).getPRId();
            long regionUUId = region.getRegionUUID();
            for (AbstractDiskRegion diskReg : diskRegions) {
                Collection res;
                long parentUUid = diskReg.getUUID();
                if (parentUUid != regionUUId || diskReg.getName().contains("____")) continue;
                RegionMap rmap = diskReg.getRecoveredEntryMap();
                Collection collection = res = rmap != null ? rmap.regionEntriesInVM() : null;
                if (!dump) {
                    sz += diskReg.getRecoveredEntryCount();
                    int invalidCnt = diskReg.getInvalidOrTombstoneEntryCount();
                    sz -= invalidCnt;
                    continue;
                }
                logger.info("Dumping key value for region: " + region.getName());
                if (rmap != null) {
                    for (RegionEntry re : res) {
                        logger.info("reKey=" + re.getKey() + " value=" + re._getValue());
                    }
                    continue;
                }
                logger.info("rmap is null");
            }
        } else {
            DiskRegion diskReg = region.getDiskRegion();
            if (!dump) {
                sz = diskReg.getRecoveredEntryCount();
                sz -= diskReg.getInvalidOrTombstoneEntryCount();
            } else {
                logger.info("Dumping key value for region: " + region.getName());
                RegionMap rmap = diskReg.getRecoveredEntryMap();
                if (rmap != null) {
                    Collection res = rmap.regionEntriesInVM();
                    for (RegionEntry re : res) {
                        logger.info("reKey=" + re.getKey() + " value=" + re._getValue());
                    }
                } else {
                    logger.info("rmap is null");
                }
            }
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (!throwErrorOnMismatch && observer != null && observer.testIndexRecreate()) {
            logger.info("Returning a wrong size as TEST_INDEX_RECREATE flag is true ");
            return sz + 10;
        }
        return sz;
    }

    @Override
    public void cleanupOnError(Throwable e) {
        AuthenticationServiceBase.cleanupOnError(this, this.memStore, this.pf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeDDL(DDLConflatable conflatable, Statement stmt, boolean skipRegionInitialization, EmbedConnection embedConn, String lastCurrentSchema, LanguageConnectionContext lcc, GemFireTransaction tc, LogWriter logger) throws Exception {
        String sqlText = conflatable.getValueToConflate();
        String currentSchema = conflatable.getCurrentSchema();
        if (currentSchema == null) {
            currentSchema = "APP";
        }
        if (!lastCurrentSchema.equals(currentSchema)) {
            GFToSlf4jBridge bridgeLogger;
            if (this.previousLevel == Integer.MAX_VALUE && Misc.isSnappyHiveMetaTable(currentSchema)) {
                bridgeLogger = (GFToSlf4jBridge)logger;
                int currentLevel = bridgeLogger.getLevel();
                if (currentLevel == 700 || currentLevel == 800) {
                    this.previousLevel = currentLevel;
                    bridgeLogger.setLevel(900);
                }
            } else if (this.previousLevel != Integer.MAX_VALUE && Misc.isSnappyHiveMetaTable(lastCurrentSchema)) {
                bridgeLogger = (GFToSlf4jBridge)logger;
                bridgeLogger.setLevel(this.previousLevel);
                this.previousLevel = Integer.MAX_VALUE;
            }
            SanityManager.DEBUG_PRINT((String)"info:TraceDDLReplay", (String)("Setting default schema to " + currentSchema));
            FabricDatabase.setupDefaultSchema(this.dd, lcc, tc, currentSchema, true);
            lastCurrentSchema = currentSchema;
        }
        if (GemFireXDUtils.TraceIndex && (conflatable.isCreateIndex() || conflatable.isCreateIndex())) {
            GfxdIndexManager.traceIndex("executeDDL::executing sqlText=%s and skipRegionInitialization=%s", sqlText, skipRegionInitialization);
        }
        try {
            try {
                lcc.setContextObject(conflatable.getAdditionalArgs());
                lcc.setSkipRegionInitialization(skipRegionInitialization);
                lcc.setDroppedFKConstraints(conflatable.getDroppedFKConstraints());
                lcc.setDefaultPersistent(conflatable.defaultPersistent());
                lcc.setPersistMetaStoreInDataDictionary(conflatable.persistMetaStoreInDataDictionary());
                tc.setDDLId(conflatable.getId());
                stmt.execute(sqlText);
                GfxdMessage.logWarnings(stmt, sqlText, "FabricDatabase: SQL warning in initial replay of DDL: ", logger);
            }
            finally {
                if (!embedConn.isClosed()) {
                    embedConn.commit();
                }
                lcc.setSkipRegionInitialization(false);
                lcc.setContextObject(null);
                lcc.setDroppedFKConstraints(null);
                lcc.setDefaultPersistent(false);
                lcc.setPersistMetaStoreInDataDictionary(true);
                tc.setDDLId(0L);
            }
        }
        catch (Exception ex) {
            boolean ignoreException = false;
            if (ex instanceof SQLException && ("X0Y68".equals(((SQLException)ex).getSQLState()) && conflatable.isCreateSchemaText() || "42X86".equals(((SQLException)ex).getSQLState()) && conflatable.isAlterTableDropFKConstraint())) {
                ignoreException = true;
            }
            if (ignoreException) {
                if (logger.fineEnabled()) {
                    logger.fine("FabricDatabase: ignored exception for DDL [" + sqlText + "]. Exception SQLState=" + ((SQLException)ex).getSQLState());
                }
            }
            if (logger.severeEnabled()) {
                logger.severe("FabricDatabase: failed initial replay for DDL [" + sqlText + "] due to exception" + (ex instanceof SQLException ? " with severity=" + ((SQLException)ex).getErrorCode() : ""), (Throwable)ex);
            }
            this.throwBootException(ex, embedConn);
            return null;
        }
        return lastCurrentSchema;
    }

    private void throwBootException(Exception ex, EmbedConnection embedConn) throws Exception {
        if (!this.allowBootWithFailures) {
            if (embedConn.isClosed()) {
                throw ex;
            }
            boolean ignoreException = false;
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (t instanceof DerbySQLException) {
                    if (((SQLException)t).getErrorCode() >= 20000) {
                        throw ex;
                    }
                    ignoreException = true;
                    continue;
                }
                if (!(t instanceof StandardException)) continue;
                if (((StandardException)t).getErrorCode() >= 20000) {
                    throw ex;
                }
                ignoreException = true;
            }
            if (!ignoreException) {
                throw ex;
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.active = false;
        this.tempDir.deleteAll();
        this.tempDir = null;
        this.runtimeStatisticsOn = false;
    }

    @Override
    public int getEngineType() {
        return 2;
    }

    @Override
    public boolean isReadOnly() {
        return this.memStore.isReadOnly();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String authToken, String drdaID, String dbname, long connectionID, boolean isRemote) throws StandardException {
        TransactionController tc = this.getConnectionTransaction(cm, connectionID);
        cm.setLocaleFinder(this);
        this.pushDbContext(cm);
        LanguageConnectionContext lctx = this.lcf.newLanguageConnectionContext(cm, tc, this.lf, this, user, authToken, drdaID, connectionID, isRemote, dbname);
        this.pushClassFactoryContext(cm, this.lcf.getClassFactory());
        ExecutionFactory ef = this.lcf.getExecutionFactory();
        ef.newExecutionContext(cm);
        lctx.initialize();
        SchemaDescriptor defaultSchema = lctx.getDefaultSchema();
        if (defaultSchema.getUUID() == null) {
            FabricDatabase.setupDefaultSchema(this.dd, lctx, tc, lctx.getAuthorizationId().replace('-', '_'), false);
        }
        lctx.internalCommitNoSync(5);
        return lctx;
    }

    private static String getSchemaOwner(String in_defaultSchema) {
        String owner = in_defaultSchema;
        GemFireStore ms = Misc.getMemStoreBootingNoThrow();
        if (ms != null && ms.isSnappyStore() && !ms.tableCreationAllowed() && Misc.isSecurityEnabled()) {
            owner = ms.getDatabase().getDataDictionary().getAuthorizationDatabaseOwner();
        }
        return owner;
    }

    public static void setupDefaultSchema(DataDictionary dd, LanguageConnectionContext lcc, TransactionController tc, String in_defaultSchema, boolean doInitialLookup) throws StandardException {
        SchemaDescriptor defaultSchema = null;
        if (doInitialLookup) {
            defaultSchema = dd.getSchemaDescriptor(in_defaultSchema, tc, false);
        }
        if (defaultSchema == null) {
            String schemaOwner = FabricDatabase.getSchemaOwner(in_defaultSchema);
            defaultSchema = new SchemaDescriptor(dd, in_defaultSchema, schemaOwner, dd.getUUIDFactory().createUUID(), false);
            try {
                dd.addDescriptor(defaultSchema, null, 3, false, tc);
            }
            catch (StandardException ex) {
                if ("X0Y68".equals(ex.getSQLState())) {
                    defaultSchema = dd.getSchemaDescriptor(in_defaultSchema, tc, true);
                }
                throw ex;
            }
        }
        lcc.setDefaultSchema(defaultSchema);
    }

    @Override
    public final GfxdDataDictionary getDataDictionary() {
        return this.dd;
    }

    public final DataValueFactory getDataValueFactory() {
        return this.dataValueFactory;
    }

    public final LogFactory getLogFactory() {
        return this.logFactory;
    }

    public final LanguageConnectionFactory getConnectionFactory() {
        return this.lcf;
    }

    public final ClassFactory getClassFactory() {
        return this.cfDB;
    }

    @Override
    public void pushDbContext(ContextManager cm) {
        new DatabaseContextImpl(cm, this);
    }

    @Override
    public final AuthenticationServiceBase getAuthenticationService() {
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Unexpected - There is no valid authentication service for the database!");
        return this.authenticationService;
    }

    public final AuthenticationServiceBase getPeerAuthenticationService() {
        SanityManager.ASSERT((this.peerAuthenticationService != null ? 1 : 0) != 0, (String)"Unexpected - There is no valid peer authentication service for the database!");
        return this.peerAuthenticationService;
    }

    @Override
    public void freeze() throws SQLException {
        try {
            this.memStore.freeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void unfreeze() throws SQLException {
        try {
            this.memStore.unfreeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backup(String backupDir, boolean wait) throws SQLException {
        try {
            this.memStore.backup(backupDir, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws SQLException {
        try {
            this.memStore.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws SQLException {
        try {
            this.memStore.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void checkpoint() throws SQLException {
        try {
            this.memStore.checkpoint();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public final Locale getLocale() {
        return this.databaseLocale;
    }

    @Override
    public final UUID getId() {
        return this.myUUID;
    }

    @Override
    public final Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw FabricDatabase.noLocale();
    }

    @Override
    public final DateFormat getDateFormat() throws StandardException {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        throw FabricDatabase.noLocale();
    }

    @Override
    public final DateFormat getTimeFormat() throws StandardException {
        if (this.timeFormat != null) {
            return this.timeFormat;
        }
        throw FabricDatabase.noLocale();
    }

    @Override
    public DateFormat getTimestampFormat() throws StandardException {
        if (this.timestampFormat != null) {
            return this.timestampFormat;
        }
        throw FabricDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S");
    }

    @Override
    public final void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
        this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
        this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
    }

    @Override
    public final boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean create, Properties startParams) throws StandardException {
        String upgradeID = null;
        UUID databaseID = (UUID)this.memStore.getProperty("gemfirexd.distributedsystemID");
        if (databaseID == null) {
            UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
            upgradeID = startParams.getProperty("gemfirexd.distributedsystemID");
            databaseID = upgradeID == null ? uuidFactory.createUUID() : uuidFactory.recreateUUID(upgradeID);
            this.memStore.setProperty("gemfirexd.distributedsystemID", databaseID, true);
        }
        if (upgradeID != null) {
            startParams.remove("gemfirexd.distributedsystemID");
        }
        return databaseID;
    }

    @Override
    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("gemfirexd.engineType")) {
            throw StandardException.newException("XCY02.S", (Object)key, (Object)value);
        }
        if ("gemfirexd.distributedsystem.statement-explain-mode".equals(key) || "gemfirexd.distributedsystem.statistics-summary-mode".equals(key) || "gemfirexd.distributedsystem.statement-statistics-mode".equals(key)) {
            return true;
        }
        if (!key.equals("gemfirexd.distributedsystem.classpath")) {
            return false;
        }
        String newClasspath = (String)((Object)value);
        String[][] dbcp = null;
        if (newClasspath != null) {
            dbcp = IdUtil.parseDbClassPath(newClasspath);
        }
        if (dbcp != null) {
            for (int ix = 0; ix < dbcp.length; ++ix) {
                SchemaDescriptor sd = this.dd.getSchemaDescriptor(dbcp[ix][0], null, false);
                FileInfoDescriptor fid = null;
                if (sd != null) {
                    fid = this.dd.getFileInfoDescriptor(sd, dbcp[ix][1]);
                }
                if (fid != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(dbcp[ix]));
            }
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if ("gemfirexd.distributedsystem.statement-explain-mode".equals(key) || "gemfirexd.distributedsystem.statistics-summary-mode".equals(key) || "gemfirexd.distributedsystem.statement-statistics-mode".equals(key)) {
            if (value != null) {
                DistributionObserver.setObserver();
            } else {
                DistributionObserver.unsetObserver();
            }
            return null;
        }
        if (!key.equals("gemfirexd.distributedsystem.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String newClasspath = (String)((Object)value);
            if (newClasspath == null) {
                newClasspath = "";
            }
            this.cfDB.notifyModifyClasspath(newClasspath);
        }
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.memStore.createFinished();
    }

    protected String getClasspath(Properties startParams) {
        String cp = PropertyUtil.getPropertyFromSet(startParams, "gemfirexd.distributedsystem.classpath");
        if (cp == null) {
            cp = PropertyUtil.getSystemProperty("gemfirexd.distributedsystem.classpath", "");
        }
        return cp;
    }

    protected void bootClassFactory(boolean create, Properties startParams) throws StandardException {
        String classpath = this.getClasspath(startParams);
        IdUtil.parseDbClassPath(classpath);
        startParams.put("gemfirexd.__rt.distributedsystem.classpath", classpath);
        this.cfDB = (ClassFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory", startParams);
    }

    protected TransactionController getConnectionTransaction(ContextManager cm, long connectionID) throws StandardException {
        return this.memStore.getTransaction(cm, connectionID);
    }

    protected AuthenticationServiceBase bootAuthenticationService(boolean create, Properties props) throws StandardException {
        this.peerAuthenticationService = (AuthenticationServiceBase)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "peer.authentication", props);
        AuthenticationServiceBase.setPeerAuthenticationService(this.peerAuthenticationService);
        return (AuthenticationServiceBase)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "authentication", props);
    }

    protected void bootValidation(boolean create, Properties startParams) throws StandardException {
        String tempDir = startParams.getProperty("gemfirexd.storage.tempDirectory", PropertyUtil.getSystemProperty("gemfirexd.storage.tempDirectory"));
        if (tempDir == null && (tempDir = startParams.getProperty("gemfirexd.system.home", PropertyUtil.getSystemProperty("gemfirexd.system.home"))) == null && (tempDir = startParams.getProperty("sys-disk-dir", PropertyUtil.getSystemProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP))) == null) {
            tempDir = PropertyUtil.getSystemProperty("java.io.tmpdir");
        }
        try {
            final String tDir = tempDir;
            this.tempDir = AccessController.doPrivileged(new PrivilegedExceptionAction<DirFile>(){

                @Override
                public DirFile run() throws IOException {
                    int retry = 0;
                    do {
                        int rl = PartitionedRegion.rand.nextInt(Integer.MAX_VALUE);
                        DirFile df = new DirFile(tDir, FabricDatabase.TEMP_DIR_PREFIX + Integer.toString(rl) + ".d");
                        df.deleteOnExit();
                        if (!df.mkdirs()) continue;
                        assert (df.canWrite());
                        return df;
                    } while (retry++ < 10);
                    throw new IOException("Temp Directory couldn't be created on " + tDir);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ioe = pae.getException();
            if (ioe instanceof IOException) {
                throw StandardException.newException("XSLAQ.D", ioe);
            }
            throw GemFireXDRuntimeException.newRuntimeException("PrivilegedActionException", pae.getException());
        }
        this.tempDir.deleteOnExit();
        this.pf = (PropertyFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory", startParams);
    }

    protected void bootStore(boolean create, Properties startParams) throws StandardException {
        try {
            this.memStore = (GemFireStore)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory", startParams);
        }
        catch (StandardException se) {
            this.cleanupOnError(se);
            throw se;
        }
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        return this.memStore.getProperties();
    }

    protected void bootResourceAdapter(boolean create, Properties allParams) {
        try {
            this.resourceAdapter = Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter", allParams);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager cm, ClassFactory cf) {
        new StoreClassFactoryContext(cm, cf, this.memStore, this);
    }

    @Override
    public StorageFile getJarFile(String schemaName, String sqlName) throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(schemaName, null, true);
        FileInfoDescriptor fid = this.dd.getFileInfoDescriptor(sd, sqlName);
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)sqlName, (Object)schemaName);
        }
        long generationId = fid.getGenerationId();
        GfxdJarResource fr = this.memStore.getJarFileHandler();
        String externalName = schemaName + "." + sqlName;
        return fr.getAsFile(externalName, generationId);
    }

    @Override
    public void failover(String dbname) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInSlaveMode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean disableStatementOptimizationToGenericPlan() {
        return this.disableStatementOptimization;
    }

    public void setdisableStatementOptimizationToGenericPlan() {
        this.disableStatementOptimization = true;
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopReplicationMaster() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        throw new UnsupportedOperationException();
    }

    public final DirFile getTempDir() {
        return this.tempDir;
    }

    @Override
    public final boolean getRuntimeStatistics() {
        return this.runtimeStatisticsOn;
    }

    public static final void __setRuntimeStatistics(LanguageConnectionContext lcc, boolean onOff) {
        if (onOff) {
            DistributionObserver.setObserver();
        }
        lcc.setRunTimeStatisticsMode(onOff, false);
        if (onOff) {
            Iterator<XPLAINTableDescriptor> it = XPLAINTableDescriptor.getRegisteredDescriptors();
            while (it.hasNext()) {
                XPLAINTableDescriptor t = it.next();
                lcc.setExplainStatement(t.getCatalogName(), t.getTableInsert());
            }
        }
        if (!onOff) {
            DistributionObserver.unsetObserver();
        }
    }
}

