/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PageBasicOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SetReservedSpaceOperation
extends PageBasicOperation {
    protected int doMeSlot;
    protected int recordId;
    protected int newValue;
    protected int oldValue;

    public SetReservedSpaceOperation(BasePage page, int slot, int recordId, int newValue, int oldValue) {
        super(page);
        this.doMeSlot = slot;
        this.recordId = recordId;
        this.newValue = newValue;
        this.oldValue = oldValue;
        SanityManager.ASSERT((oldValue > newValue ? 1 : 0) != 0);
    }

    public SetReservedSpaceOperation() {
    }

    @Override
    public int getTypeFormatId() {
        return 287;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.doMeSlot);
        CompressedNumber.writeInt(out, this.recordId);
        CompressedNumber.writeInt(out, this.newValue);
        CompressedNumber.writeInt(out, this.oldValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.doMeSlot = CompressedNumber.readInt(in);
        this.recordId = CompressedNumber.readInt(in);
        this.newValue = CompressedNumber.readInt(in);
        this.oldValue = CompressedNumber.readInt(in);
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        SanityManager.ASSERT((this.oldValue == this.page.getReservedCount(this.doMeSlot) ? 1 : 0) != 0);
        SanityManager.ASSERT((this.newValue < this.oldValue ? 1 : 0) != 0, (String)"cannot set reserved space to be bigger than before");
        this.page.setReservedSpace(instant, this.doMeSlot, this.newValue);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(this.recordId, 0);
        if (!this.getPageId().equals(undoPage.getPageId())) {
            SanityManager.THROWASSERT((String)("restoreMe cannot restore to a different page. doMe page:" + this.getPageId() + " undoPage:" + undoPage.getPageId()));
        }
        if (slot != this.doMeSlot) {
            SanityManager.THROWASSERT((String)("restoreMe cannot restore to a different slot. doMe slot:" + this.doMeSlot + " undoMe slot: " + slot + " recordId:" + this.recordId));
        }
        this.page.setReservedSpace(CLRinstant, slot, this.oldValue);
    }

    @Override
    public String toString() {
        return super.toString() + "Set Reserved space of recordId " + this.recordId + " from " + this.oldValue + " to " + this.newValue;
    }
}

