/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.types.BinarySQLHybridType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class GenericQualifier
implements Qualifier {
    private int columnId;
    private String columnName;
    private int operator;
    private GeneratedMethod orderableGetter;
    private Activation activation;
    private boolean orderedNulls;
    private boolean unknownRV;
    private boolean negateCompareResult;
    protected int variantType;
    private DataValueDescriptor orderableCache = null;

    public GenericQualifier(int columnId, String columnName, int operator, GeneratedMethod orderableGetter, Activation activation, boolean orderedNulls, boolean unknownRV, boolean negateCompareResult, int variantType) {
        this.columnId = columnId;
        this.columnName = columnName;
        this.operator = operator;
        this.orderableGetter = orderableGetter;
        this.activation = activation;
        this.orderedNulls = orderedNulls;
        this.unknownRV = unknownRV;
        this.negateCompareResult = negateCompareResult;
        this.variantType = variantType;
    }

    @Override
    public int getColumnId() {
        return this.columnId;
    }

    @Override
    public DataValueDescriptor getOrderable() throws StandardException {
        if (this.variantType != 0) {
            if (this.orderableCache == null) {
                this.orderableCache = (DataValueDescriptor)this.orderableGetter.invoke(this.activation);
            }
            return this.orderableCache;
        }
        return (DataValueDescriptor)this.orderableGetter.invoke(this.activation);
    }

    @Override
    public int getOperator() {
        return this.operator;
    }

    @Override
    public boolean negateCompareResult() {
        return this.negateCompareResult;
    }

    @Override
    public boolean getOrderedNulls() {
        return this.orderedNulls;
    }

    @Override
    public boolean getUnknownRV() {
        return this.unknownRV;
    }

    @Override
    public void clearOrderableCache() {
        if (this.variantType == 1 || this.variantType == 0) {
            this.orderableCache = null;
        }
    }

    @Override
    public void reinitialize() {
        if (this.variantType != 3) {
            this.orderableCache = null;
        }
    }

    public String toString() {
        return "columnId: " + this.columnId + "\noperator: " + this.operator + "\norderedNulls: " + this.orderedNulls + "\nunknownRV: " + this.unknownRV + "\nnegateCompareResult: " + this.negateCompareResult;
    }

    @Override
    public void alignOrderableCache(ColumnDescriptor columnDescriptor, GemFireContainer container) throws StandardException {
        if (this.variantType == 0) {
            return;
        }
        this.orderableCache = this.getOrderable();
        this.orderableCache = BinarySQLHybridType.getHybridType(this.orderableCache, columnDescriptor.getType(), container);
        if (GemFireXDUtils.TraceByteComparisonOptimization) {
            SanityManager.DEBUG_PRINT((String)"TraceByteCompareOptimization", (String)("GenericQualifire:alignOrderableCache: returning " + this.orderableCache.getClass().getSimpleName()));
        }
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }
}

