/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfoList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import java.util.ArrayList;

public abstract class GenericAggregateResultSet
extends NoPutResultSetImpl {
    protected GenericAggregator[] aggregates;
    protected GeneratedMethod rowAllocator;
    protected AggregatorInfoList aggInfoList;
    public final NoPutResultSet source;

    GenericAggregateResultSet(NoPutResultSet s, int aggregateItem, Activation a, GeneratedMethod ra, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean createAggregates) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.rowAllocator = ra;
        this.aggInfoList = (AggregatorInfoList)a.getSavedObject(aggregateItem);
        if (createAggregates) {
            this.aggregates = this.getSortAggregators(this.aggInfoList, false, a.getLanguageConnectionContext(), s);
        }
        this.printResultSetHierarchy();
    }

    protected final GenericAggregator[] getSortAggregators(AggregatorInfoList list, boolean eliminateDistincts, LanguageConnectionContext lcc, NoPutResultSet inputResultSet) throws StandardException {
        ClassFactory cf = lcc.getLanguageConnectionFactory().getClassFactory();
        int count = list.size();
        ArrayList<GenericAggregator> tmpAggregators = new ArrayList<GenericAggregator>(count);
        for (int i = 0; i < count; ++i) {
            AggregatorInfo aggInfo = (AggregatorInfo)list.elementAt(i);
            if (eliminateDistincts && aggInfo.isDistinct()) continue;
            tmpAggregators.add(new GenericAggregator(aggInfo, cf));
        }
        GenericAggregator[] aggregators = new GenericAggregator[tmpAggregators.size()];
        tmpAggregators.toArray(aggregators);
        return aggregators;
    }

    protected final ExecRow finishAggregation(ExecRow row) throws StandardException {
        int size = this.aggregates.length;
        if (row == null) {
            row = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        }
        this.setCurrentRow(row);
        boolean eliminatedNulls = false;
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            if (!currAggregate.finish(row)) continue;
            eliminatedNulls = true;
        }
        if (eliminatedNulls) {
            this.activation.addNullEliminatedWarning();
        }
        return row;
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        super.finish();
    }

    protected final ExecAggregator[] getExecAggregators(AggregatorInfoList list, boolean eliminateDistincts, LanguageConnectionContext lcc) throws StandardException {
        ArrayList<ExecAggregator> aggregatorList = new ArrayList<ExecAggregator>();
        ClassFactory cf = lcc.getLanguageConnectionFactory().getClassFactory();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            AggregatorInfo aggInfo = (AggregatorInfo)list.elementAt(i);
            if (eliminateDistincts && aggInfo.isDistinct()) continue;
            try {
                Class aggregatorClass = cf.loadApplicationClass(aggInfo.getAggregatorClassName());
                ExecAggregator agg = (ExecAggregator)aggregatorClass.newInstance();
                agg.setup(aggInfo.getAggregateName(), aggInfo);
                aggregatorList.add(agg);
                continue;
            }
            catch (Exception e) {
                throw StandardException.unexpectedUserException(e);
            }
        }
        return aggregatorList.toArray(new ExecAggregator[aggregatorList.size()]);
    }

    @Override
    public void resetStatistics() {
        this.source.resetStatistics();
        super.resetStatistics();
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

