/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DeleteCascadeResultSet
extends DeleteResultSet {
    public ResultSet[] dependentResultSets;
    private int noDependents = 0;
    private String resultSetId;
    private boolean mainNodeForTable = true;
    private boolean affectedRows = false;
    private int tempRowHolderId;

    DeleteCascadeResultSet(NoPutResultSet source, Activation activation, int constantActionItem, ResultSet[] dependentResultSets, String resultSetId) throws StandardException {
        super(source, constantActionItem == -1 ? activation.getConstantAction() : (ConstantAction)activation.getSavedObject(constantActionItem), activation);
        if (constantActionItem != -1) {
            this.resultDescription = this.constants.resultDescription;
        }
        this.cascadeDelete = true;
        this.resultSetId = resultSetId;
        if (dependentResultSets != null) {
            this.noDependents = dependentResultSets.length;
            this.dependentResultSets = dependentResultSets;
        }
    }

    @Override
    public void open() throws StandardException {
        try {
            this.setup();
            if (this.isMultipleDeletePathsExist()) {
                this.setRowHoldersTypeToUniqueStream();
                while (this.collectAffectedRows(false)) {
                }
            } else {
                this.collectAffectedRows(false);
            }
            if (!this.affectedRows) {
                this.activation.addWarning(StandardException.newNoRowFoundWarning());
            }
            this.runFkChecker(true);
            Hashtable mntHashTable = new Hashtable();
            this.mergeRowHolders(mntHashTable);
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rowChangerFinish();
        }
        finally {
            this.cleanUp(false);
            this.activation.clearParentResultSets();
        }
        this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
    }

    @Override
    protected void setup() throws StandardException {
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        super.setup();
        this.activation.setParentResultSet(this.rowHolder, this.resultSetId);
        Vector sVector = this.activation.getParentResultSet(this.resultSetId);
        this.tempRowHolderId = sVector.size() - 1;
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).setup();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).setup();
        }
    }

    boolean collectAffectedRows(boolean rowsFound) throws StandardException {
        if (super.collectAffectedRows()) {
            this.affectedRows = true;
            rowsFound = true;
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                if (!((UpdateResultSet)this.dependentResultSets[i]).collectAffectedRows()) continue;
                rowsFound = true;
                continue;
            }
            if (!((DeleteCascadeResultSet)this.dependentResultSets[i]).collectAffectedRows(rowsFound)) continue;
            rowsFound = true;
        }
        return rowsFound;
    }

    void fireBeforeTriggers(Hashtable msht) throws StandardException {
        if (!this.mainNodeForTable && !msht.containsKey(this.resultSetId)) {
            this.mainNodeForTable = true;
            msht.put(this.resultSetId, this.resultSetId);
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).fireBeforeTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).fireBeforeTriggers(msht);
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireBeforeTriggers();
        }
    }

    @Override
    void fireAfterTriggers() throws StandardException {
        for (int i = 0; i < this.noDependents && this.affectedRows; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).fireAfterTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).fireAfterTriggers();
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireAfterTriggers();
        }
    }

    @Override
    void deleteDeferredRows() throws StandardException {
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).updateDeferredRows();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).deleteDeferredRows();
        }
        if (this.mainNodeForTable) {
            super.deleteDeferredRows();
        }
    }

    @Override
    void runFkChecker(boolean restrictCheckOnly) throws StandardException {
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).runChecker(restrictCheckOnly);
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).runFkChecker(restrictCheckOnly);
        }
        if (this.mainNodeForTable) {
            super.runFkChecker(restrictCheckOnly);
        }
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        super.cleanUp(cleanupOnError);
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).cleanUp(cleanupOnError);
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).cleanUp(cleanupOnError);
        }
        this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
    }

    private void rowChangerFinish() throws StandardException {
        this.rc.finish();
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).rowChangerFinish();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).rowChangerFinish();
        }
    }

    private void mergeRowHolders(Hashtable msht) throws StandardException {
        if (msht.containsKey(this.resultSetId) || this.rowCount == 0) {
            this.mainNodeForTable = false;
        } else {
            this.mergeResultSets();
            this.mainNodeForTable = true;
            msht.put(this.resultSetId, this.resultSetId);
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                return;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).mergeRowHolders(msht);
        }
    }

    private void mergeResultSets() throws StandardException {
        Vector sVector = this.activation.getParentResultSet(this.resultSetId);
        int size = sVector.size();
        if (size > 1) {
            ExecRow row = null;
            int rowHolderId = 0;
            while (rowHolderId < size) {
                if (rowHolderId == this.tempRowHolderId) {
                    ++rowHolderId;
                    continue;
                }
                TemporaryRowHolder currentRowHolder = (TemporaryRowHolder)sVector.elementAt(rowHolderId);
                CursorResultSet rs = currentRowHolder.getResultSet();
                rs.open();
                while ((row = rs.getNextRow()) != null) {
                    this.rowHolder.insert(row);
                }
                rs.close(false);
                ++rowHolderId;
            }
        }
    }

    @Override
    public void finish() throws StandardException {
        super.finish();
        this.activation.clearParentResultSets();
    }

    private boolean isMultipleDeletePathsExist() {
        Hashtable parentResultSets = this.activation.getParentResultSets();
        Enumeration e = parentResultSets.keys();
        while (e.hasMoreElements()) {
            String rsId = (String)e.nextElement();
            Vector sVector = this.activation.getParentResultSet(rsId);
            int size = sVector.size();
            if (size <= 1) continue;
            return true;
        }
        return false;
    }

    private void setRowHoldersTypeToUniqueStream() {
        Hashtable parentResultSets = this.activation.getParentResultSets();
        Enumeration e = parentResultSets.keys();
        while (e.hasMoreElements()) {
            String rsId = (String)e.nextElement();
            Vector sVector = this.activation.getParentResultSet(rsId);
            int size = sVector.size();
            for (int rowHolderId = 0; rowHolderId < size; ++rowHolderId) {
                TemporaryRowHolder currentRowHolder = (TemporaryRowHolder)sVector.elementAt(rowHolderId);
                currentRowHolder.setRowHolderTypeToUniqueStream();
            }
        }
    }
}

