/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.DiskStoreCreateOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.collection.OpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreateDiskStoreConstantAction
extends DDLConstantAction {
    private final String diskStoreName;
    private final List<String> dirPaths;
    private final List<Integer> dirSizes;
    private final Map<?, ?> otherAttribs;
    public static final String REGION_PREFIX_FOR_CONFLATION = "__GFXD_INTERNAL_DISKSTORE_";

    CreateDiskStoreConstantAction(String diskStoreName, List<String> dirPaths, List<Integer> dirSizes, Map otherAttribs) {
        this.diskStoreName = diskStoreName;
        this.dirPaths = dirPaths;
        this.dirSizes = dirSizes;
        this.otherAttribs = otherAttribs;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return REGION_PREFIX_FOR_CONFLATION + this.diskStoreName;
    }

    public String toString() {
        return this.constructToString("CREATE DISKSTORE ", this.diskStoreName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        CreateDiskStoreConstantAction.executeConstantAction(this.diskStoreName, this.dirPaths, this.dirSizes, this.otherAttribs, activation);
        if (Misc.getMemStore().isSnappyStore()) {
            List<Integer> deltaSizes;
            List<String> deltaDirs;
            int numDirs = this.dirPaths.size();
            if (numDirs > 0) {
                deltaDirs = new ArrayList<String>(numDirs);
                for (String dirPath : this.dirPaths) {
                    deltaDirs.add(dirPath + File.separator + "snappy-internal-delta");
                }
                deltaSizes = this.dirSizes;
            } else {
                deltaDirs = Collections.singletonList("snappy-internal-delta");
                deltaSizes = Collections.singletonList(0);
            }
            LinkedHashMap deltaAttrs = new LinkedHashMap(this.otherAttribs);
            deltaAttrs.put("maxlogsize", 50);
            CreateDiskStoreConstantAction.executeConstantAction(this.diskStoreName + "-SNAPPY-DELTA", deltaDirs, deltaSizes, deltaAttrs, activation);
        }
    }

    private static void executeConstantAction(String diskStoreName, List<String> dirPaths, List<Integer> dirSizes, Map<?, ?> otherAttribs, Activation activation) throws StandardException {
        if (!GemFireStore.isFilenameValid(diskStoreName)) {
            throw StandardException.newException("0A000.S", "Disk Store name " + diskStoreName + " is not valid");
        }
        if (!ServerGroupUtils.isDataStore()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Skipping create diskstore for " + diskStoreName + " on JVM of kind " + GemFireXDUtils.getMyVMKind()));
            return;
        }
        DiskStoreFactory dsf = Misc.getGemFireCache().createDiskStoreFactory();
        GemFireStore store = Misc.getMemStore();
        int numDirs = dirPaths.size();
        StringBuilder dirPathsAndSizes = new StringBuilder();
        if (numDirs > 0) {
            File[] dirs = new File[numDirs];
            int[] nArray = new int[numDirs];
            boolean[] dirCreated = new boolean[numDirs];
            Arrays.fill(dirCreated, false);
            OpenHashSet ht = new OpenHashSet(numDirs);
            boolean foundExplicitSize = false;
            for (int i = 0; i < numDirs; ++i) {
                String canonicalPath;
                String fileStr = dirPaths.get(i);
                try {
                    dirs[i] = GemFireStore.createPersistentDir(store.getBasePersistenceDir(), fileStr).toFile();
                    dirPathsAndSizes.append(dirs[i].toString());
                    dirCreated[i] = true;
                }
                catch (DiskAccessException dae) {
                    throw StandardException.newException("XSDA4.S", dae);
                }
                try {
                    canonicalPath = dirs[i].getCanonicalPath();
                }
                catch (IOException ie) {
                    throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception while accessing the directory " + dirs[i].toString(), ie);
                }
                if (!ht.add((Object)canonicalPath)) {
                    for (int k = 0; k <= i; ++k) {
                        if (!dirCreated[k]) continue;
                        dirs[k].delete();
                    }
                    throw StandardException.newException("X0Z19.S", canonicalPath);
                }
                int temp = dirSizes.get(i);
                if (temp > 0) {
                    nArray[i] = temp;
                    dirPathsAndSizes.append("(");
                    dirPathsAndSizes.append(temp);
                    dirPathsAndSizes.append(")");
                    foundExplicitSize = true;
                }
                dirPathsAndSizes.append(",");
            }
            dirPathsAndSizes.deleteCharAt(dirPathsAndSizes.length() - 1);
            if (foundExplicitSize) {
                dsf.setDiskDirsAndSizes(dirs, nArray);
            } else {
                dsf.setDiskDirs(dirs);
            }
        } else {
            Path defaultDir = GemFireStore.createPersistentDir(store.getBasePersistenceDir(), null);
            File[] fileArray = new File[]{defaultDir.toFile()};
            dirPathsAndSizes.append(fileArray[0].getAbsolutePath());
            dsf.setDiskDirs(fileArray);
        }
        for (Map.Entry entry : otherAttribs.entrySet()) {
            String key = (String)entry.getKey();
            Object vn = entry.getValue();
            try {
                String val;
                NumericConstantNode ncn;
                if (key.equalsIgnoreCase("maxlogsize")) {
                    if (vn instanceof NumericConstantNode) {
                        ncn = (NumericConstantNode)vn;
                        dsf.setMaxOplogSize(ncn.getValue().getLong());
                        continue;
                    }
                    dsf.setMaxOplogSize(((Number)vn).longValue());
                    continue;
                }
                if (key.equalsIgnoreCase("compactionthreshold")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setCompactionThreshold(ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("timeinterval")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setTimeInterval((long)ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("writebuffersize")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setWriteBufferSize(ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("queuesize")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setQueueSize(ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("autocompact")) {
                    val = (String)vn;
                    if (val.equalsIgnoreCase("true")) {
                        dsf.setAutoCompact(Boolean.TRUE.booleanValue());
                        continue;
                    }
                    if (!val.equalsIgnoreCase("false")) continue;
                    dsf.setAutoCompact(Boolean.FALSE.booleanValue());
                    continue;
                }
                if (!key.equalsIgnoreCase("allowforcecompaction")) continue;
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    dsf.setAllowForceCompaction(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (!val.equalsIgnoreCase("false")) continue;
                dsf.setAllowForceCompaction(Boolean.FALSE.booleanValue());
            }
            catch (IllegalArgumentException e) {
                throw StandardException.newException("0A000.S", "Value for " + key + " was not valid");
            }
        }
        DiskStoreCreateOperation startOp = new DiskStoreCreateOperation(dsf, diskStoreName, dirPathsAndSizes.toString());
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        GemFireTransaction gft = (GemFireTransaction)languageConnectionContext.getTransactionExecute();
        gft.logAndDo(startOp);
    }
}

