/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;

public class HasCorrelatedCRsVisitor
extends VisitorAdaptor {
    private boolean hasCorrelatedCRs;

    @Override
    public Visitable visit(Visitable node) {
        if (node instanceof ColumnReference) {
            if (((ColumnReference)node).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (node instanceof VirtualColumnNode) {
            if (((VirtualColumnNode)node).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (node instanceof MethodCallNode && (((MethodCallNode)node).getMethodName().equals("getTriggerExecutionContext") || ((MethodCallNode)node).getMethodName().equals("TriggerOldTransitionRows") || ((MethodCallNode)node).getMethodName().equals("TriggerNewTransitionRows"))) {
            this.hasCorrelatedCRs = true;
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasCorrelatedCRs;
    }

    @Override
    public boolean skipChildren(Visitable v) {
        return false;
    }

    public boolean hasCorrelatedCRs() {
        return this.hasCorrelatedCRs;
    }

    public void setHasCorrelatedCRs(boolean value) {
        this.hasCorrelatedCRs = value;
    }

    @Override
    public boolean supportsDeltaMerge() {
        return true;
    }

    @Override
    public boolean initForDeltaState() {
        return true;
    }

    @Override
    public Object getAndResetDeltaState() {
        return this.hasCorrelatedCRs;
    }

    @Override
    public Visitable mergeDeltaState(Object delta, Visitable node) {
        if (!this.hasCorrelatedCRs) {
            this.hasCorrelatedCRs = (Boolean)delta;
        }
        return node;
    }
}

