/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class SYSALIASESRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "SYSALIASES";
    public static final int SYSALIASES_COLUMN_COUNT = 10;
    public static final int SYSALIASES_ALIASID = 1;
    public static final int SYSALIASES_ALIAS = 2;
    public static final int SYSALIASES_SCHEMAID = 3;
    public static final int SYSALIASES_JAVACLASSNAME = 4;
    public static final int SYSALIASES_ALIASTYPE = 5;
    public static final int SYSALIASES_NAMESPACE = 6;
    public static final int SYSALIASES_SYSTEMALIAS = 7;
    public static final int SYSALIASES_ALIASINFO = 8;
    public static final int SYSALIASES_SPECIFIC_NAME = 9;
    public static final int SYSALIASES_SCHEMANAME = 10;
    protected static final int SYSALIASES_INDEX1_ID = 0;
    protected static final int SYSALIASES_INDEX2_ID = 1;
    protected static final int SYSALIASES_INDEX3_ID = 2;
    private static final boolean[] uniqueness = null;
    private static int[][] indexColumnPositions = new int[][]{{3, 2, 6}, {1}, {3, 9}};
    private static final String[] uuids = new String[]{"c013800d-00d7-ddbd-08ce-000a0a411400", "c013800d-00d7-ddbd-75d4-000a0a411400", "c013800d-00d7-ddbe-b99d-000a0a411400", "c013800d-00d7-ddbe-c4e1-000a0a411400", "c013800d-00d7-ddbe-34ae-000a0a411400"};

    SYSALIASESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(10, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String schemaID = null;
        String javaClassName = null;
        String sAliasType = null;
        String aliasID = null;
        String aliasName = null;
        String specificName = null;
        char cAliasType = 'P';
        char cNameSpace = 'P';
        boolean systemAlias = false;
        AliasInfo aliasInfo = null;
        if (td != null) {
            AliasDescriptor ad = (AliasDescriptor)td;
            aliasID = ad.getUUID().toString();
            aliasName = ad.getDescriptorName();
            schemaID = ad.getSchemaUUID().toString();
            javaClassName = ad.getJavaClassName();
            cAliasType = ad.getAliasType();
            cNameSpace = ad.getNameSpace();
            systemAlias = ad.getSystemAlias();
            aliasInfo = ad.getAliasInfo();
            specificName = ad.getSpecificName();
            char[] charArray = new char[]{cAliasType};
            sAliasType = new String(charArray);
            switch (cAliasType) {
                case 'A': 
                case 'F': 
                case 'P': 
                case 'R': 
                case 'S': {
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)("Unexpected value (" + cAliasType + ") for aliasType"));
                }
            }
        }
        ExecRow row = this.getExecutionFactory().getValueRow(10);
        row.setColumn(1, new SQLChar(aliasID));
        row.setColumn(2, new SQLVarchar(aliasName));
        row.setColumn(3, new SQLChar(schemaID));
        row.setColumn(4, this.dvf.getLongvarcharDataValue(javaClassName));
        row.setColumn(5, new SQLChar(sAliasType));
        String sNameSpace = new String(new char[]{cNameSpace});
        row.setColumn(6, new SQLChar(sNameSpace));
        row.setColumn(7, this.dvf.getDataValue(systemAlias));
        row.setColumn(8, this.dvf.getDataValue(aliasInfo));
        row.setColumn(9, new SQLVarchar(specificName));
        String schemaName = null;
        if (td != null) {
            AliasDescriptor ad = (AliasDescriptor)td;
            DataDictionaryImpl dd = (DataDictionaryImpl)ad.getDataDictionary();
            TransactionController tc = dd.getTransactionExecute();
            schemaName = dd.getSchemaDescriptor(ad.getSchemaUUID(), tc).getSchemaName();
        }
        row.setColumn(10, new SQLVarchar(schemaName));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 10 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSALIASES row");
        boolean systemAlias = false;
        AliasInfo aliasInfo = null;
        DataValueDescriptor col = row.getColumn(1);
        String aliasID = col.getString();
        UUID aliasUUID = this.getUUIDFactory().recreateUUID(aliasID);
        col = row.getColumn(2);
        String aliasName = col.getString();
        col = row.getColumn(3);
        UUID schemaUUID = col.isNull() ? null : this.getUUIDFactory().recreateUUID(col.getString());
        col = row.getColumn(4);
        String javaClassName = col.getString();
        col = row.getColumn(5);
        String sAliasType = col.getString();
        SanityManager.ASSERT((sAliasType.length() == 1 ? 1 : 0) != 0, (String)"Fifth column (aliastype) type incorrect");
        switch (sAliasType.charAt(0)) {
            case 'A': 
            case 'F': 
            case 'P': 
            case 'R': 
            case 'S': {
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid type value '" + sAliasType + "' for  alias"));
            }
        }
        char cAliasType = sAliasType.charAt(0);
        col = row.getColumn(6);
        String sNameSpace = col.getString();
        SanityManager.ASSERT((sNameSpace.length() == 1 ? 1 : 0) != 0, (String)"Sixth column (namespace) type incorrect");
        switch (sNameSpace.charAt(0)) {
            case 'A': 
            case 'F': 
            case 'P': 
            case 'R': 
            case 'S': {
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid type value '" + sNameSpace + "' for  alias"));
            }
        }
        char cNameSpace = sNameSpace.charAt(0);
        col = row.getColumn(7);
        systemAlias = col.getBoolean();
        col = row.getColumn(8);
        aliasInfo = (AliasInfo)col.getObject();
        col = row.getColumn(9);
        String specificName = col.getString();
        return new AliasDescriptor(dd, aliasUUID, aliasName, schemaUUID, javaClassName, cAliasType, cNameSpace, systemAlias, aliasInfo, specificName);
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("ALIASID", false), SystemColumnImpl.getIdentifierColumn("ALIAS", false), SystemColumnImpl.getUUIDColumn("SCHEMAID", true), SystemColumnImpl.getColumn("JAVACLASSNAME", -1, false, 32700), SystemColumnImpl.getIndicatorColumn("ALIASTYPE"), SystemColumnImpl.getIndicatorColumn("NAMESPACE"), SystemColumnImpl.getColumn("SYSTEMALIAS", 16, false), SystemColumnImpl.getJavaColumn("ALIASINFO", "com.pivotal.gemfirexd.internal.catalog.AliasInfo", true), SystemColumnImpl.getIdentifierColumn("SPECIFICNAME", false), SystemColumnImpl.getIdentifierColumn("ALIASSCHEMANAME", false)};
    }
}

