/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.ClassBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FileUtil;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.services.reflect.JarLoader;
import com.pivotal.gemfirexd.internal.impl.services.reflect.LoadedGeneratedClass;
import com.pivotal.gemfirexd.internal.impl.services.reflect.UpdateLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.Properties;

abstract class DatabaseClasses
implements ClassFactory,
ModuleControl {
    private ClassInspector classInspector;
    private JavaFactory javaFactory;
    private UpdateLoader applicationLoader;

    DatabaseClasses() {
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.classInspector = new ClassInspector(this);
        String classpath = null;
        if (startParams != null) {
            classpath = startParams.getProperty("gemfirexd.__rt.distributedsystem.classpath");
        }
        if (classpath != null) {
            this.applicationLoader = new UpdateLoader(classpath, this, true, true);
        }
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory");
    }

    @Override
    public void stop() {
        if (this.applicationLoader != null) {
            this.applicationLoader.close();
        }
        InternalDataSerializer.flushClassCache();
    }

    @Override
    public final GeneratedClass loadGeneratedClass(String fullyQualifiedName, ByteArray classDump) throws StandardException {
        try {
            return this.loadGeneratedClassFromData(fullyQualifiedName, classDump);
        }
        catch (LinkageError le) {
            DatabaseClasses.WriteClassFile(fullyQualifiedName, classDump, le);
            throw StandardException.newException("XBCM1.S", (Throwable)le, (Object)fullyQualifiedName);
        }
        catch (Error e) {
            if (SystemFailure.isJVMFailureError((Error)e)) {
                DatabaseClasses.WriteClassFile(fullyQualifiedName, classDump, e);
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            throw e;
        }
    }

    private static void WriteClassFile(String fullyQualifiedName, ByteArray bytecode, Throwable t) {
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        String filename = fullyQualifiedName.substring(lastDot + 1, fullyQualifiedName.length()).concat(".class");
        Object env = Monitor.getMonitor().getEnvironment();
        File dir = env instanceof File ? (File)env : null;
        File classFile = FileUtil.newFile(dir, filename);
        HeaderPrintWriter errorStream = Monitor.getStream();
        try {
            FileOutputStream fis = new FileOutputStream(classFile);
            fis.write(bytecode.getArray(), bytecode.getOffset(), bytecode.getLength());
            fis.flush();
            if (t != null) {
                errorStream.printlnWithHeader(MessageService.getTextMessage("C000", fullyQualifiedName, classFile, t));
            }
            fis.close();
        }
        catch (IOException e) {
            SanityManager.THROWASSERT((String)"Unable to write .class file");
        }
    }

    @Override
    public ClassInspector getClassInspector() {
        return this.classInspector;
    }

    @Override
    public final Class loadApplicationClass(String className) throws ClassNotFoundException {
        Throwable loadError;
        if (className.startsWith("com.pivotal.gemfirexd.internal.")) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            try {
                return this.loadClassNotInDatabaseJar(className);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.applicationLoader == null) {
                    throw cnfe;
                }
                GemFireStore memStore = GemFireStore.getBootingInstance();
                if (memStore == null || !memStore.initialDDLReplayInProgress() && !memStore.initialDDLReplayDone()) {
                    throw cnfe;
                }
                Class c = this.applicationLoader.loadClass(className, true);
                if (c == null) {
                    throw cnfe;
                }
                return c;
            }
        }
        catch (SecurityException se) {
            loadError = se;
        }
        catch (LinkageError le) {
            loadError = le;
        }
        throw new ClassNotFoundException(className + " : " + loadError.getMessage());
    }

    abstract Class loadClassNotInDatabaseJar(String var1) throws ClassNotFoundException;

    @Override
    public final Class loadApplicationClass(ObjectStreamClass classDescriptor) throws ClassNotFoundException {
        return this.loadApplicationClass(classDescriptor.getName());
    }

    @Override
    public final Class loadClassFromDB(String name) throws ClassNotFoundException {
        ClassNotFoundException cnfe = new ClassNotFoundException(name);
        if (this.applicationLoader == null) {
            throw cnfe;
        }
        GemFireStore memStore = GemFireStore.getBootingInstance();
        if (memStore == null || !memStore.initialDDLReplayInProgress() && !memStore.initialDDLReplayDone()) {
            throw cnfe;
        }
        Class c = this.applicationLoader.loadClass(name, true);
        if (c == null) {
            throw cnfe;
        }
        return c;
    }

    @Override
    public boolean isApplicationClass(Class theClass) {
        return theClass.getClassLoader() instanceof JarLoader;
    }

    @Override
    public void notifyModifyJar(boolean reload) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyJar(reload);
        }
    }

    @Override
    public void notifyModifyClasspath(String classpath) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(classpath);
        }
    }

    @Override
    public void notifyModifyClasspath(String name, int jar_op_type) {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(name, jar_op_type);
        }
    }

    @Override
    public void releaseUpdateLoaderLock() {
        if (this.applicationLoader != null) {
            this.applicationLoader.releaseUpdateLoaderLock();
        }
    }

    @Override
    public JarLoader closeJarLoader(String schemaName, String sqlName) {
        if (this.applicationLoader != null) {
            return this.applicationLoader.close(schemaName, sqlName);
        }
        return null;
    }

    @Override
    public int getClassLoaderVersion() {
        if (this.applicationLoader != null) {
            return this.applicationLoader.getClassLoaderVersion();
        }
        return -1;
    }

    public ByteArray buildSpecificFactory(String className, String factoryName) throws StandardException {
        ClassBuilder cb = this.javaFactory.newClassBuilder(this, "com.pivotal.gemfirexd.internal.exe.", 17, factoryName, "com.pivotal.gemfirexd.internal.impl.services.reflect.GCInstanceFactory");
        MethodBuilder constructor = cb.newConstructorBuilder(1);
        constructor.callSuper();
        constructor.methodReturn();
        constructor.complete();
        constructor = null;
        MethodBuilder noArg = cb.newMethodBuilder(1, "com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedByteCode", "getNewInstance");
        noArg.pushNewStart(className);
        noArg.pushNewComplete(0);
        noArg.methodReturn();
        noArg.complete();
        noArg = null;
        return cb.getClassBytecode();
    }

    abstract LoadedGeneratedClass loadGeneratedClassFromData(String var1, ByteArray var2);
}

