/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.cache;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.cache.BackgroundCleaner;
import com.pivotal.gemfirexd.internal.impl.services.cache.CacheEntry;
import com.pivotal.gemfirexd.internal.impl.services.cache.ConcurrentCache;
import com.pivotal.gemfirexd.internal.impl.services.cache.ReplacementPolicy;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class ClockPolicy
implements ReplacementPolicy {
    private static final int MIN_ITEMS_TO_CHECK = 20;
    private static final float MAX_ROTATION = 0.2f;
    private static final float PART_OF_CLOCK_FOR_SHRINK = 0.1f;
    private final ConcurrentCache cacheManager;
    private final int maxSize;
    private final ArrayList<Holder> clock;
    private int hand;
    private final AtomicInteger freeEntries = new AtomicInteger();
    private final AtomicBoolean isShrinking = new AtomicBoolean();

    ClockPolicy(ConcurrentCache cacheManager, int initialSize, int maxSize) {
        this.cacheManager = cacheManager;
        this.maxSize = maxSize;
        this.clock = new ArrayList(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertEntry(CacheEntry entry) throws StandardException {
        Holder h;
        int size;
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            size = this.clock.size();
            if (size < this.maxSize && this.freeEntries.get() == 0) {
                this.clock.add(new Holder(entry));
                return;
            }
        }
        if (size > this.maxSize) {
            BackgroundCleaner cleaner = this.cacheManager.getBackgroundCleaner();
            if (cleaner != null) {
                cleaner.scheduleShrink();
            } else {
                this.doShrink();
            }
        }
        if ((h = this.rotateClock(entry, size >= this.maxSize)) == null) {
            ArrayList<Holder> arrayList2 = this.clock;
            synchronized (arrayList2) {
                this.clock.add(new Holder(entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder moveHand() {
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            if (this.clock.isEmpty()) {
                return null;
            }
            if (this.hand >= this.clock.size()) {
                this.hand = 0;
            }
            return this.clock.get(this.hand++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder rotateClock(CacheEntry entry, boolean allowEvictions) throws StandardException {
        int itemsToCheck = 0;
        if (allowEvictions) {
            ArrayList<Holder> arrayList = this.clock;
            synchronized (arrayList) {
                itemsToCheck = Math.max(20, (int)((float)this.clock.size() * 0.2f));
            }
        }
        while (itemsToCheck-- > 0 || this.freeEntries.get() > 0) {
            Cacheable dirty;
            Holder h = this.moveHand();
            if (h == null) {
                return null;
            }
            CacheEntry e = h.getEntry();
            if (e == null) {
                if (!h.takeIfFree(entry)) continue;
                return h;
            }
            if (!allowEvictions) continue;
            e.lock();
            try {
                if (!this.isEvictable(e, h, true)) continue;
                Cacheable c = e.getCacheable();
                if (!c.isDirty()) {
                    Holder holder = h;
                    synchronized (holder) {
                        h.switchEntry(entry);
                        this.cacheManager.evictEntry(c.getIdentity());
                        c.clearIdentity();
                    }
                    holder = h;
                    return holder;
                }
                BackgroundCleaner cleaner = this.cacheManager.getBackgroundCleaner();
                if (cleaner != null && cleaner.scheduleClean(e)) continue;
                e.keep(false);
                dirty = c;
            }
            finally {
                e.unlock();
                continue;
            }
            this.cacheManager.cleanAndUnkeepEntry(e, dirty);
        }
        return null;
    }

    private boolean isEvictable(CacheEntry e, Holder h, boolean clearRecentlyUsedFlag) {
        if (h.getEntry() != e) {
            return false;
        }
        if (e.isKept()) {
            return false;
        }
        SanityManager.ASSERT((boolean)e.isValid(), (String)"Holder contains invalid entry");
        SanityManager.ASSERT((!h.isEvicted() ? 1 : 0) != 0, (String)"Holder is evicted");
        if (h.recentlyUsed) {
            if (clearRecentlyUsedFlag) {
                h.recentlyUsed = false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHolder(int pos, Holder h) {
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            Holder removed = this.clock.remove(pos);
            SanityManager.ASSERT((removed == h ? 1 : 0) != 0, (String)"Wrong Holder removed");
        }
    }

    @Override
    public void doShrink() {
        if (this.isShrinking.compareAndSet(false, true)) {
            try {
                this.shrinkMe();
            }
            finally {
                this.isShrinking.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkMe() {
        int pos;
        SanityManager.ASSERT((boolean)this.isShrinking.get(), (String)"Called shrinkMe() without ensuring exclusive access");
        int maxLooks = Math.max(1, (int)((float)this.maxSize * 0.1f));
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            pos = this.hand;
        }
        while (maxLooks-- > 0) {
            Holder h;
            int size;
            ArrayList<Holder> arrayList2 = this.clock;
            synchronized (arrayList2) {
                size = this.clock.size();
                if (pos >= size) {
                    pos = 0;
                }
                h = this.clock.get(pos);
            }
            int index = pos++;
            if (size <= this.maxSize) break;
            CacheEntry e = h.getEntry();
            if (e == null) {
                if (!h.evictIfFree()) continue;
                this.removeHolder(index, h);
                pos = index;
                continue;
            }
            e.lock();
            try {
                Cacheable c;
                if (!this.isEvictable(e, h, false) || (c = e.getCacheable()).isDirty()) continue;
                Holder holder = h;
                synchronized (holder) {
                    h.setEvicted();
                    this.cacheManager.evictEntry(c.getIdentity());
                    this.removeHolder(index, h);
                    c.clearIdentity();
                }
                pos = index;
            }
            finally {
                e.unlock();
            }
        }
    }

    private class Holder
    implements ReplacementPolicy.Callback {
        boolean recentlyUsed;
        private CacheEntry entry;
        private Cacheable freedCacheable;
        private boolean evicted;

        Holder(CacheEntry e) {
            this.entry = e;
            e.setCallback(this);
        }

        @Override
        public void access() {
            this.recentlyUsed = true;
        }

        @Override
        public synchronized void free() {
            this.freedCacheable = this.entry.getCacheable();
            this.entry = null;
            this.recentlyUsed = false;
            int free = ClockPolicy.this.freeEntries.incrementAndGet();
            if (free <= 0) {
                SanityManager.ASSERT((free > 0 ? 1 : 0) != 0, (String)("freeEntries should be greater than 0, but is " + free));
            }
        }

        synchronized boolean takeIfFree(CacheEntry e) {
            if (this.entry == null && !this.evicted) {
                int free = ClockPolicy.this.freeEntries.decrementAndGet();
                if (free < 0) {
                    SanityManager.ASSERT((free >= 0 ? 1 : 0) != 0, (String)("freeEntries is negative: " + free));
                }
                e.setCacheable(this.freedCacheable);
                e.setCallback(this);
                this.entry = e;
                this.freedCacheable = null;
                return true;
            }
            return false;
        }

        synchronized CacheEntry getEntry() {
            return this.entry;
        }

        synchronized void switchEntry(CacheEntry e) {
            e.setCallback(this);
            e.setCacheable(this.entry.getCacheable());
            this.entry = e;
        }

        synchronized boolean evictIfFree() {
            if (this.entry == null && !this.evicted) {
                int free = ClockPolicy.this.freeEntries.decrementAndGet();
                if (free < 0) {
                    SanityManager.ASSERT((free >= 0 ? 1 : 0) != 0, (String)("freeEntries is negative: " + free));
                }
                this.evicted = true;
                return true;
            }
            return false;
        }

        synchronized void setEvicted() {
            SanityManager.ASSERT((!this.evicted ? 1 : 0) != 0, (String)"Already evicted");
            this.evicted = true;
            this.entry = null;
        }

        synchronized boolean isEvicted() {
            return this.evicted;
        }
    }
}

