/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCMethodDescriptor;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.Type;

class VMTypeIdCacheable
implements Cacheable {
    private Object descriptor;
    private Object key;

    VMTypeIdCacheable() {
    }

    @Override
    public void clearIdentity() {
    }

    @Override
    public Object getIdentity() {
        return this.key;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) {
        SanityManager.THROWASSERT((String)"VMTypeIdCacheable.create() called!");
        return this;
    }

    @Override
    public Cacheable setIdentity(Object key) {
        this.key = key;
        if (key instanceof String) {
            String javaName = (String)key;
            String vmName = ClassHolder.convertToInternalDescriptor(javaName);
            this.descriptor = new Type(javaName, vmName);
        } else {
            this.descriptor = ((BCMethodDescriptor)key).buildMethodDescriptor();
        }
        return this;
    }

    @Override
    public void clean(boolean remove) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    Object descriptor() {
        return this.descriptor;
    }
}

